/*
 * Decompiled with CFR 0.152.
 */
package solver;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import solver.SudokuSolver;

public class SudokuSolverFactory {
    private static final SudokuSolver defaultSolver = new SudokuSolver();
    private static List<SolverInstance> instances = new ArrayList<SolverInstance>();
    private static final Thread thread = new Thread(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Thread thread = thread;
                synchronized (thread) {
                    defaultSolver.getStepFinder().cleanUp();
                    Iterator iterator = instances.iterator();
                    while (iterator.hasNext()) {
                        SolverInstance act = (SolverInstance)iterator.next();
                        if (!act.inUse && System.currentTimeMillis() - act.lastUsedAt > 300000L) {
                            iterator.remove();
                            continue;
                        }
                        act.instance.getStepFinder().cleanUp();
                    }
                }
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    });
    private static final long SOLVER_TIMEOUT = 300000L;

    private SudokuSolverFactory() {
    }

    public static SudokuSolver getDefaultSolverInstance() {
        return defaultSolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SudokuSolver getInstance() {
        SudokuSolver ret = null;
        Thread thread = SudokuSolverFactory.thread;
        synchronized (thread) {
            for (SolverInstance act : instances) {
                if (act.inUse) continue;
                act.inUse = true;
                ret = act.instance;
                break;
            }
            if (ret == null) {
                ret = new SudokuSolver();
                instances.add(new SolverInstance(ret));
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void giveBack(SudokuSolver solver) {
        Thread thread = SudokuSolverFactory.thread;
        synchronized (thread) {
            for (SolverInstance act : instances) {
                if (act.instance != solver) continue;
                act.inUse = false;
                act.lastUsedAt = System.currentTimeMillis();
                break;
            }
        }
    }

    static {
        thread.start();
    }

    private static class SolverInstance {
        SudokuSolver instance = null;
        boolean inUse = true;
        long lastUsedAt = -1L;

        private SolverInstance(SudokuSolver instance) {
            this.instance = instance;
        }
    }
}

