/*
 * Decompiled with CFR 0.152.
 */
package sudoku;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import solver.SudokuSolver;
import sudoku.DifficultyType;
import sudoku.Options;

public class SolverProgressDialog
extends JDialog
implements Runnable {
    private static final long serialVersionUID = 1L;
    private SudokuSolver solver = null;
    private Thread thread = null;
    private boolean solved = false;
    private JProgressBar candsProgressBar;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel unsolvedCandsLabel;
    private JLabel unsolvedCellsLabel;

    public SolverProgressDialog(Frame parent, boolean modal, SudokuSolver solver) {
        super(parent, modal);
        this.solver = solver;
        this.initComponents();
        this.candsProgressBar.setValue(0);
        this.thread = new Thread(this);
        this.thread.start();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.unsolvedCellsLabel = new JLabel();
        this.jLabel3 = new JLabel();
        this.unsolvedCandsLabel = new JLabel();
        this.candsProgressBar = new JProgressBar();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("intl/SolverProgressDialog");
        this.setTitle(bundle.getString("SolverProgressDialog.title"));
        this.setModal(true);
        this.jLabel1.setText(bundle.getString("SolverProgressDialog.jLabel1.text"));
        this.unsolvedCellsLabel.setText("81");
        this.jLabel3.setText(bundle.getString("SolverProgressDialog.jLabel3.text"));
        this.unsolvedCandsLabel.setText("729");
        this.candsProgressBar.setMaximum(729);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.candsProgressBar, -1, 273, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unsolvedCellsLabel).addGap(18, 18, 18).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unsolvedCandsLabel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.unsolvedCellsLabel).addComponent(this.jLabel3).addComponent(this.unsolvedCandsLabel)).addGap(18, 18, 18).addComponent(this.candsProgressBar, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    @Override
    public void run() {
        this.solved = this.solver.solve(Options.getInstance().getDifficultyLevels()[DifficultyType.EXTREME.ordinal()], null, false, this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SolverProgressDialog.this.setVisible(false);
            }
        });
    }

    public void initializeProgressState(int unsolvedCandidates) {
        int dummy = this.candsProgressBar.getMaximum() - unsolvedCandidates;
        this.candsProgressBar.setMinimum(dummy);
        this.candsProgressBar.setValue(dummy);
    }

    public void setProgressState(final int unsolvedCells, final int unsolvedCandidates) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SolverProgressDialog.this.unsolvedCellsLabel.setText(Integer.toString(unsolvedCells));
                SolverProgressDialog.this.unsolvedCandsLabel.setText(Integer.toString(unsolvedCandidates));
                SolverProgressDialog.this.candsProgressBar.setValue(SolverProgressDialog.this.candsProgressBar.getMaximum() - unsolvedCandidates);
            }
        });
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SolverProgressDialog dialog = new SolverProgressDialog((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public Thread getThread() {
        return this.thread;
    }

    public boolean isSolved() {
        return this.solved;
    }
}

