/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HSQLClientConnection;
import org.hsqldb.HTTPClientConnection;
import org.hsqldb.HsqlException;
import org.hsqldb.Result;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.Util;
import org.hsqldb.jdbc.jdbcCallableStatement;
import org.hsqldb.jdbc.jdbcDatabaseMetaData;
import org.hsqldb.jdbc.jdbcPreparedStatement;
import org.hsqldb.jdbc.jdbcSavepoint;
import org.hsqldb.jdbc.jdbcStatement;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.HsqlProperties;

public class jdbcConnection
implements Connection {
    HsqlProperties connProperties;
    SessionInterface sessionProxy;
    boolean isInternal;
    protected boolean isNetConn;
    boolean isClosed;
    private SQLWarning rootWarning;
    private Object rootWarning_mutex = new Object();

    @Override
    public synchronized Statement createStatement() throws SQLException {
        this.checkClosed();
        jdbcStatement jdbcStatement2 = new jdbcStatement(this, 1003);
        return jdbcStatement2;
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkClosed();
        try {
            jdbcPreparedStatement jdbcPreparedStatement2 = new jdbcPreparedStatement(this, string, 1003);
            return jdbcPreparedStatement2;
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.checkClosed();
        try {
            jdbcCallableStatement jdbcCallableStatement2 = new jdbcCallableStatement(this, string, 1003);
            return jdbcCallableStatement2;
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized String nativeSQL(String string) throws SQLException {
        this.checkClosed();
        if (string == null || string.length() == 0 || string.indexOf(123) == -1) {
            return string;
        }
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        stringBuffer.append(string);
        block6: for (int i = 0; i < n2; ++i) {
            char c = stringBuffer.charAt(i);
            switch (n) {
                case 0: {
                    if (c == '\'') {
                        n = 1;
                        continue block6;
                    }
                    if (c == '\"') {
                        n = 2;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    i = this.onStartEscapeSequence(string, stringBuffer, i);
                    ++n3;
                    n = 3;
                    continue block6;
                }
                case 1: 
                case 4: {
                    if (c != '\'') continue block6;
                    --n;
                    continue block6;
                }
                case 2: 
                case 5: {
                    if (c != '\"') continue block6;
                    n -= 2;
                    continue block6;
                }
                case 3: {
                    if (c == '\'') {
                        n = 4;
                        continue block6;
                    }
                    if (c == '\"') {
                        n = 5;
                        continue block6;
                    }
                    if (c == '}') {
                        stringBuffer.setCharAt(i, ' ');
                        n = --n3 == 0 ? 0 : 3;
                        continue block6;
                    }
                    if (c != '{') continue block6;
                    i = this.onStartEscapeSequence(string, stringBuffer, i);
                    ++n3;
                    n = 3;
                }
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setAutoCommit(bl);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.isAutoCommit();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void commit() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.commit();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void rollback() throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.rollback();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.isInternal || this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (this.sessionProxy != null) {
            this.sessionProxy.close();
        }
        this.sessionProxy = null;
        this.rootWarning = null;
        this.connProperties = null;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new jdbcDatabaseMetaData(this);
    }

    @Override
    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.checkClosed();
        try {
            this.sessionProxy.setReadOnly(bl);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized boolean isReadOnly() throws SQLException {
        try {
            return this.sessionProxy.isReadOnly();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void setCatalog(String string) throws SQLException {
        this.checkClosed();
    }

    @Override
    public synchronized String getCatalog() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw Util.invalidArgument();
            }
        }
        try {
            this.sessionProxy.setIsolation(n);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        try {
            return this.sessionProxy.getIsolation();
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (!this.isNetConn) {
                HsqlException[] hsqlExceptionArray = ((Session)this.sessionProxy).getAndClearWarnings();
                for (int i = 0; i < hsqlExceptionArray.length; ++i) {
                    SQLWarning sQLWarning = Util.sqlWarning(hsqlExceptionArray[i]);
                    this.addWarning(sQLWarning);
                }
            }
            return this.rootWarning;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void clearWarnings() throws SQLException {
        this.checkClosed();
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = null;
        }
    }

    @Override
    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        return new jdbcStatement(this, n);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        try {
            return new jdbcPreparedStatement(this, string, n);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        try {
            return new jdbcCallableStatement(this, string, n);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public synchronized Map getTypeMap() throws SQLException {
        this.checkClosed();
        return new HashMap();
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public synchronized void setHoldability(int n) throws SQLException {
        this.checkClosed();
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                String string = "ResultSet holdability: " + n;
                throw Util.sqlException(20, string);
            }
            default: {
                throw Util.invalidArgument();
            }
        }
    }

    @Override
    public synchronized int getHoldability() throws SQLException {
        this.checkClosed();
        return 1;
    }

    @Override
    public synchronized Savepoint setSavepoint() throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        this.checkClosed();
        if (string == null) {
            String string2 = "name is null";
            throw Util.sqlException(62, string2);
        }
        Result result = Result.newSetSavepointRequest(string);
        try {
            this.sessionProxy.execute(result);
        }
        catch (HsqlException hsqlException) {
            Util.throwError(hsqlException);
        }
        return new jdbcSavepoint(string, this);
    }

    @Override
    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            String string = "savepoint is null";
            throw Util.sqlException(62, string);
        }
        try {
            if (this.sessionProxy.isAutoCommit()) {
                String string = "connection is autocommit";
                throw Util.sqlException(62, string);
            }
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
        if (!(savepoint instanceof jdbcSavepoint)) {
            throw Util.sqlException(62);
        }
        jdbcSavepoint jdbcSavepoint2 = (jdbcSavepoint)savepoint;
        if (this != jdbcSavepoint2.connection) {
            String string = savepoint + " was not issued on this connection";
            throw Util.sqlException(62, string);
        }
        Result result = Result.newRollbackToSavepointRequest(jdbcSavepoint2.name);
        try {
            Result result2 = this.sessionProxy.execute(result);
            if (result2.isError()) {
                Util.throwError(result2);
            }
        }
        catch (HsqlException hsqlException) {
            Util.throwError(hsqlException);
        }
    }

    @Override
    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkClosed();
        if (savepoint == null) {
            String string = "savepoint is null";
            throw Util.sqlException(62, string);
        }
        if (!(savepoint instanceof jdbcSavepoint)) {
            throw Util.sqlException(62);
        }
        jdbcSavepoint jdbcSavepoint2 = (jdbcSavepoint)savepoint;
        if (this != jdbcSavepoint2.connection) {
            String string = savepoint.getSavepointName() + " was not issued on this connection";
            throw Util.sqlException(62, string);
        }
        Result result = Result.newReleaseSavepointRequest(jdbcSavepoint2.name);
        try {
            Result result2 = this.sessionProxy.execute(result);
            if (result2.isError()) {
                Util.throwError(result2);
            }
        }
        catch (HsqlException hsqlException) {
            Util.throwError(hsqlException);
        }
    }

    @Override
    public synchronized Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        n3 = this.xlateRSHoldability(n3);
        return new jdbcStatement(this, n);
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        n3 = this.xlateRSHoldability(n3);
        try {
            return new jdbcPreparedStatement(this, string, n);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.checkClosed();
        n = this.xlateRSType(n);
        n2 = this.xlateRSConcurrency(n2);
        n3 = this.xlateRSHoldability(n3);
        try {
            return new jdbcCallableStatement(this, string, n);
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    @Override
    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkClosed();
        throw Util.notSupported();
    }

    public jdbcConnection(HsqlProperties hsqlProperties) throws SQLException {
        boolean bl;
        String string = hsqlProperties.getProperty("user");
        String string2 = hsqlProperties.getProperty("password");
        String string3 = hsqlProperties.getProperty("connection_type");
        String string4 = hsqlProperties.getProperty("host");
        int n = hsqlProperties.getIntegerProperty("port", 0);
        String string5 = hsqlProperties.getProperty("path");
        String string6 = hsqlProperties.getProperty("database");
        boolean bl2 = bl = string3 == "hsqls://" || string3 == "https://";
        if (string == null) {
            string = "SA";
        }
        if (string2 == null) {
            string2 = "";
        }
        string = string.toUpperCase(Locale.ENGLISH);
        string2 = string2.toUpperCase(Locale.ENGLISH);
        try {
            if (DatabaseURL.isInProcessDatabaseType(string3)) {
                this.sessionProxy = DatabaseManager.newSession(string3, string6, string, string2, hsqlProperties);
            } else if (string3 == "hsql://" || string3 == "hsqls://") {
                this.sessionProxy = new HSQLClientConnection(string4, n, string5, string6, bl, string, string2);
                this.isNetConn = true;
            } else if (string3 == "http://" || string3 == "https://") {
                this.sessionProxy = new HTTPClientConnection(string4, n, string5, string6, bl, string, string2);
                this.isNetConn = true;
            } else {
                throw Util.sqlException(62);
            }
            this.connProperties = hsqlProperties;
        }
        catch (HsqlException hsqlException) {
            throw Util.sqlException(hsqlException);
        }
    }

    public jdbcConnection(Session session) throws HsqlException {
        this.isInternal = true;
        this.sessionProxy = session;
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    synchronized String getURL() throws SQLException {
        this.checkClosed();
        if (this.isInternal) {
            return ((Session)this.sessionProxy).getInternalConnectionURL();
        }
        return this.connProperties.getProperty("url");
    }

    synchronized void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw Util.sqlException(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addWarning(SQLWarning sQLWarning) {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            if (this.rootWarning == null) {
                this.rootWarning = sQLWarning;
            } else {
                this.rootWarning.setNextWarning(sQLWarning);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearWarningsNoCheck() {
        Object object = this.rootWarning_mutex;
        synchronized (object) {
            this.rootWarning = null;
        }
    }

    int xlateRSType(int n) throws SQLException {
        switch (n) {
            case 1003: 
            case 1004: {
                return n;
            }
            case 1005: {
                String string = "TYPE_SCROLL_SENSITIVE => TYPE_SCROLL_SENSITIVE";
                SQLWarning sQLWarning = new SQLWarning(string, "SOO10", 62);
                this.addWarning(sQLWarning);
                return 1004;
            }
        }
        String string = "ResultSet type: " + n;
        throw Util.sqlException(62, string);
    }

    int xlateRSConcurrency(int n) throws SQLException {
        switch (n) {
            case 1007: {
                return n;
            }
            case 1008: {
                String string = "CONCUR_UPDATABLE => CONCUR_READ_ONLY";
                SQLWarning sQLWarning = new SQLWarning(string, "SOO10", 62);
                this.addWarning(sQLWarning);
                return 1007;
            }
        }
        String string = "ResultSet concurrency: " + n;
        throw Util.sqlException(62, string);
    }

    int xlateRSHoldability(int n) throws SQLException {
        switch (n) {
            case 1: {
                return n;
            }
            case 2: {
                String string = "CLOSE_CURSORS_AT_COMMIT => HOLD_CURSORS_OVER_COMMIT";
                SQLWarning sQLWarning = new SQLWarning(string, "SOO10", 62);
                this.addWarning(sQLWarning);
                return 1;
            }
        }
        String string = "ResultSet holdability: " + n;
        throw Util.sqlException(62, string);
    }

    public void reset() throws SQLException {
        try {
            this.sessionProxy.resetSession();
        }
        catch (HsqlException hsqlException) {
            throw new SQLException("Error resetting connection: " + hsqlException.getMessage());
        }
    }

    private int onStartEscapeSequence(String string, StringBuffer stringBuffer, int n) throws SQLException {
        stringBuffer.setCharAt(n++, ' ');
        n = StringUtil.skipSpaces(string, n);
        if (string.regionMatches(true, n, "fn ", 0, 3) || string.regionMatches(true, n, "oj ", 0, 3) || string.regionMatches(true, n, "ts ", 0, 3)) {
            stringBuffer.setCharAt(n++, ' ');
            stringBuffer.setCharAt(n++, ' ');
        } else if (string.regionMatches(true, n, "d ", 0, 2) || string.regionMatches(true, n, "t ", 0, 2)) {
            stringBuffer.setCharAt(n++, ' ');
        } else if (string.regionMatches(true, n, "call ", 0, 5)) {
            n += 4;
        } else if (string.regionMatches(true, n, "?= call ", 0, 8)) {
            stringBuffer.setCharAt(n++, ' ');
            stringBuffer.setCharAt(n++, ' ');
            n += 5;
        } else if (string.regionMatches(true, n, "escape ", 0, 7)) {
            n += 6;
        } else {
            throw new SQLException(Trace.getMessage(138, true, new Object[]{string.substring(--n)}), "S0010", 62);
        }
        return n;
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isValid(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(String string, String string2) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getClientInfo(String string) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Struct createStruct(String string, Object[] objectArray) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

