/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.util.Enumeration;
import org.hsqldb.Database;
import org.hsqldb.DatabaseURL;
import org.hsqldb.HsqlException;
import org.hsqldb.Trace;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.Set;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.store.ValuePool;

public class HsqlDatabaseProperties
extends HsqlProperties {
    private static String hsqldb_method_class_names = "hsqldb.method_class_names";
    private static HashSet accessibleJavaMethodNames;
    public static final int indexName = 0;
    public static final int indexAccess = 1;
    public static final int indexClass = 2;
    public static final int indexIsRange = 3;
    public static final int indexDefaultValue = 4;
    public static final int indexRangeLow = 5;
    public static final int indexRangeHigh = 6;
    public static final int indexValues = 7;
    public static final int indexLimit = 8;
    private static final int SET_PROPERTY = 0;
    private static final int SQL_PROPERTY = 1;
    private static final int FILE_PROPERTY = 2;
    public static final int FILES_NOT_MODIFIED = 0;
    public static final int FILES_MODIFIED = 1;
    public static final int FILES_NEW = 2;
    private static final String MODIFIED_NO = "no";
    private static final String MODIFIED_YES = "yes";
    private static final String MODIFIED_NEW = "no-new-files";
    private static HashMap meta;
    public static final String VERSION_STRING_1_7_0 = "1.7.0";
    public static final String VERSION_STRING_1_8_0 = "1.8.1";
    public static final String FIRST_COMPATIBLE_VERSION = "1.8.0";
    public static final String THIS_VERSION = "1.8.1";
    public static final String THIS_FULL_VERSION = "1.8.0.10";
    public static final String THIS_CACHE_VERSION = "1.7.0";
    public static final String PRODUCT_NAME = "HSQL Database Engine";
    public static final int MAJOR = 1;
    public static final int MINOR = 8;
    public static final int REVISION = 0;
    public static final String system_lockfile_poll_retries_property = "hsqldb.lockfile_poll_retries";
    public static final String system_max_char_or_varchar_display_size = "hsqldb.max_char_or_varchar_display_size";
    public static final String hsqldb_inc_backup = "hsqldb.incremental_backup";
    public static final String db_version = "version";
    private static final String db_readonly = "readonly";
    private static final String db_modified = "modified";
    private static final String runtime_gc_interval = "runtime.gc_interval";
    public static final String hsqldb_applog = "hsqldb.applog";
    public static final String hsqldb_cache_file_scale = "hsqldb.cache_file_scale";
    public static final String hsqldb_cache_free_count_scale = "hsqldb.cache_free_count_scale";
    public static final String hsqldb_cache_scale = "hsqldb.cache_scale";
    public static final String hsqldb_cache_size_scale = "hsqldb.cache_size_scale";
    public static final String hsqldb_cache_version = "hsqldb.cache_version";
    private static final String hsqldb_catalogs = "hsqldb.catalogs";
    public static final String hsqldb_compatible_version = "hsqldb.compatible_version";
    public static final String hsqldb_default_table_type = "hsqldb.default_table_type";
    public static final String hsqldb_defrag_limit = "hsqldb.defrag_limit";
    private static final String hsqldb_files_readonly = "hsqldb.files_readonly";
    public static final String hsqldb_lock_file = "hsqldb.lock_file";
    public static final String hsqldb_log_size = "hsqldb.log_size";
    public static final String hsqldb_nio_data_file = "hsqldb.nio_data_file";
    public static final String hsqldb_max_nio_scale = "hsqldb.max_nio_scale";
    public static final String hsqldb_raf_buffer_scale = "hsqldb.raf_buffer_scale";
    private static final String hsqldb_original_version = "hsqldb.original_version";
    public static final String hsqldb_script_format = "hsqldb.script_format";
    private static final String sql_compare_in_locale = "sql.compare_in_locale";
    private static final String sql_enforce_strict_size = "sql.enforce_strict_size";
    public static final String sql_tx_no_multi_write = "sql.tx_no_multi_rewrite";
    public static final String textdb_cache_scale = "textdb.cache_scale";
    public static final String textdb_cache_size_scale = "textdb.cache_size_scale";
    public static final String textdb_all_quoted = "textdb.all_quoted";
    public static final String textdb_allow_full_path = "textdb.allow_full_path";
    public static final String textdb_encoding = "textdb.encoding";
    public static final String textdb_ignore_first = "textdb.ignore_first";
    public static final String textdb_quoted = "textdb.quoted";
    public static final String textdb_fs = "textdb.fs";
    public static final String textdb_vs = "textdb.vs";
    public static final String textdb_lvs = "textdb.lvs";
    private Database database;

    public static boolean supportsJavaMethod(String string) {
        if (accessibleJavaMethodNames == null) {
            return true;
        }
        if (string.startsWith("org.hsqldb.Library.")) {
            return true;
        }
        if (string.startsWith("java.lang.Math.")) {
            return true;
        }
        if (accessibleJavaMethodNames.contains(string)) {
            return true;
        }
        Iterator iterator = accessibleJavaMethodNames.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            int n = string2.lastIndexOf(".*");
            if (n < 1 || !string.startsWith(string2.substring(0, n + 1))) continue;
            return true;
        }
        return false;
    }

    public HsqlDatabaseProperties(Database database) {
        super(database.getPath(), database.getFileAccess(), database.isFilesInJar());
        this.database = database;
        this.setProperty(sql_enforce_strict_size, false);
        this.setProperty(db_version, "1.8.1");
        this.setProperty(hsqldb_compatible_version, FIRST_COMPATIBLE_VERSION);
        this.setProperty(hsqldb_cache_version, "1.7.0");
        this.setProperty(hsqldb_original_version, "1.8.1");
        this.setProperty(runtime_gc_interval, 0);
        this.setProperty(hsqldb_cache_file_scale, 1);
        this.setProperty(hsqldb_cache_size_scale, 8);
        this.setProperty(hsqldb_cache_scale, 14);
        this.setProperty(hsqldb_log_size, 200);
        this.setProperty(hsqldb_script_format, 0);
        this.setProperty(db_readonly, false);
        this.setProperty(db_modified, MODIFIED_NEW);
        this.setProperty(hsqldb_nio_data_file, true);
        this.setProperty(hsqldb_inc_backup, false);
        this.setProperty(hsqldb_lock_file, true);
        this.setProperty(hsqldb_default_table_type, "memory");
        if (database.isStoredFileAccess()) {
            this.setProperty(hsqldb_default_table_type, "cached");
            this.setProperty(hsqldb_cache_scale, 13);
            this.setProperty(hsqldb_log_size, 10);
            this.setProperty(sql_enforce_strict_size, true);
            this.setProperty(hsqldb_nio_data_file, false);
            this.setProperty(hsqldb_lock_file, true);
        }
    }

    @Override
    public boolean load() throws HsqlException {
        boolean bl;
        if (!DatabaseURL.isFileBasedDatabaseType(this.database.getType())) {
            return true;
        }
        try {
            bl = super.load();
        }
        catch (Exception exception) {
            throw Trace.error(29, 116, new Object[]{this.fileName, exception});
        }
        if (!bl) {
            return false;
        }
        this.filterLoadedProperties();
        String string = this.getProperty(hsqldb_compatible_version);
        int n = string.substring(0, 5).compareTo("1.8.1");
        if (n > 0) {
            throw Trace.error(30);
        }
        string = this.getProperty(db_version);
        if (string.charAt(2) == '6') {
            this.setProperty(hsqldb_cache_version, "1.6.0");
        }
        JavaSystem.gcFrequency = this.getIntegerProperty(runtime_gc_interval, 0);
        return true;
    }

    public void setDatabaseVariables() {
        if (this.isPropertyTrue(db_readonly)) {
            this.database.setReadOnly();
        }
        if (this.isPropertyTrue(hsqldb_files_readonly)) {
            this.database.setFilesReadOnly();
        }
        this.database.sqlEnforceStrictSize = this.isPropertyTrue(sql_enforce_strict_size);
        if (this.isPropertyTrue(sql_compare_in_locale)) {
            this.stringProps.remove(sql_compare_in_locale);
            this.database.collation.setCollationAsLocale();
        }
        this.database.txManager.setReWriteProtection(this.isPropertyTrue(sql_tx_no_multi_write));
        this.database.setMetaDirty(false);
    }

    @Override
    public void save() throws HsqlException {
        if (!DatabaseURL.isFileBasedDatabaseType(this.database.getType()) || this.database.isFilesReadOnly() || this.database.isFilesInJar()) {
            return;
        }
        try {
            super.save(this.fileName + ".properties" + ".new");
            this.fa.renameElement(this.fileName + ".properties" + ".new", this.fileName + ".properties");
        }
        catch (Exception exception) {
            this.database.logger.appLog.logContext(1, "failed");
            throw Trace.error(29, 116, new Object[]{this.fileName, exception});
        }
    }

    void filterLoadedProperties() {
        Enumeration<?> enumeration = this.stringProps.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            boolean bl = meta.containsKey(string);
            if (bl) continue;
            this.stringProps.remove(string);
        }
    }

    public void setURLProperties(HsqlProperties hsqlProperties) {
        if (hsqlProperties != null) {
            Enumeration enumeration = hsqlProperties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                Object[] objectArray = (Object[])meta.get(string);
                if (objectArray == null || !db_readonly.equals(string) && (Integer)objectArray[1] != 0) continue;
                this.setProperty(string, hsqlProperties.getProperty(string));
            }
        }
    }

    public Set getUserDefinedPropertyData() {
        HashSet hashSet = new HashSet();
        Iterator iterator = meta.values().iterator();
        while (iterator.hasNext()) {
            Object[] objectArray = (Object[])iterator.next();
            if ((Integer)objectArray[1] != 0) continue;
            hashSet.add(objectArray);
        }
        return hashSet;
    }

    public boolean isUserDefinedProperty(String string) {
        Object[] objectArray = (Object[])meta.get(string);
        return objectArray != null && (Integer)objectArray[1] == 0;
    }

    public boolean isBoolean(String string) {
        Object[] objectArray = (Object[])meta.get(string);
        return objectArray != null && objectArray[2].equals("boolean") && (Integer)objectArray[1] == 0;
    }

    public boolean isIntegral(String string) {
        Object[] objectArray = (Object[])meta.get(string);
        return objectArray != null && objectArray[2].equals("int") && (Integer)objectArray[1] == 0;
    }

    public boolean isString(String string) {
        Object[] objectArray = (Object[])meta.get(string);
        return objectArray != null && objectArray[2].equals("java.lang.String") && (Integer)objectArray[1] == 0;
    }

    public String setDatabaseProperty(String string, String string2) throws HsqlException {
        Object[] objectArray = (Object[])meta.get(string);
        string2 = super.setProperty(string, string2);
        return string2;
    }

    public int getDefaultWriteDelay() {
        if (this.database.isStoredFileAccess()) {
            return 2000;
        }
        return 10000;
    }

    public void setDBModified(int n) throws HsqlException {
        String string = MODIFIED_NO;
        if (n == 1) {
            string = MODIFIED_YES;
        } else if (n == 2) {
            string = MODIFIED_NEW;
        }
        this.setProperty(db_modified, string);
        this.save();
    }

    public int getDBModified() throws HsqlException {
        String string = this.getProperty(db_modified);
        if (MODIFIED_YES.equals(string)) {
            return 1;
        }
        if (MODIFIED_NEW.equals(string)) {
            return 2;
        }
        return 0;
    }

    private static Object[] getMeta(String string, int n, String string2) {
        Object[] objectArray = new Object[8];
        objectArray[0] = string;
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = "java.lang.String";
        objectArray[4] = string2;
        return objectArray;
    }

    private static Object[] getMeta(String string, int n, boolean bl) {
        Object[] objectArray = new Object[8];
        objectArray[0] = string;
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = "boolean";
        objectArray[4] = bl ? Boolean.TRUE : Boolean.FALSE;
        return objectArray;
    }

    private static Object[] getMeta(String string, int n, int n2, byte[] byArray) {
        Object[] objectArray = new Object[8];
        objectArray[0] = string;
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = "int";
        objectArray[4] = ValuePool.getInt(n2);
        objectArray[7] = byArray;
        return objectArray;
    }

    private static Object[] getMeta(String string, int n, int n2, int n3, int n4) {
        Object[] objectArray = new Object[8];
        objectArray[0] = string;
        objectArray[1] = ValuePool.getInt(n);
        objectArray[2] = "int";
        objectArray[4] = ValuePool.getInt(n2);
        objectArray[3] = Boolean.TRUE;
        objectArray[5] = ValuePool.getInt(n3);
        objectArray[6] = ValuePool.getInt(n4);
        return objectArray;
    }

    static {
        try {
            String string = System.getProperty(hsqldb_method_class_names);
            if (string != null) {
                accessibleJavaMethodNames = new HashSet();
                String[] stringArray = StringUtil.split(string, ";");
                for (int i = 0; i < stringArray.length; ++i) {
                    accessibleJavaMethodNames.add(stringArray[i]);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        meta = new HashMap();
        meta.put(hsqldb_inc_backup, HsqlDatabaseProperties.getMeta(hsqldb_inc_backup, 1, false));
        meta.put(db_version, HsqlDatabaseProperties.getMeta(db_version, 2, null));
        meta.put(hsqldb_compatible_version, HsqlDatabaseProperties.getMeta(hsqldb_compatible_version, 2, null));
        meta.put(hsqldb_cache_version, HsqlDatabaseProperties.getMeta(hsqldb_cache_version, 2, null));
        meta.put(hsqldb_original_version, HsqlDatabaseProperties.getMeta(hsqldb_original_version, 2, null));
        meta.put(db_modified, HsqlDatabaseProperties.getMeta(db_modified, 2, null));
        meta.put(hsqldb_default_table_type, HsqlDatabaseProperties.getMeta(hsqldb_default_table_type, 0, "memory"));
        meta.put(textdb_fs, HsqlDatabaseProperties.getMeta(textdb_fs, 0, ","));
        meta.put(textdb_vs, HsqlDatabaseProperties.getMeta(textdb_vs, 0, null));
        meta.put(textdb_lvs, HsqlDatabaseProperties.getMeta(textdb_lvs, 0, null));
        meta.put(textdb_encoding, HsqlDatabaseProperties.getMeta(textdb_encoding, 0, null));
        meta.put(db_readonly, HsqlDatabaseProperties.getMeta(db_readonly, 2, false));
        meta.put(hsqldb_files_readonly, HsqlDatabaseProperties.getMeta(hsqldb_files_readonly, 2, false));
        meta.put(textdb_allow_full_path, HsqlDatabaseProperties.getMeta(textdb_allow_full_path, 2, false));
        meta.put(hsqldb_lock_file, HsqlDatabaseProperties.getMeta(hsqldb_lock_file, 0, true));
        meta.put(hsqldb_nio_data_file, HsqlDatabaseProperties.getMeta(hsqldb_nio_data_file, 0, false));
        meta.put(hsqldb_catalogs, HsqlDatabaseProperties.getMeta(hsqldb_catalogs, 0, false));
        meta.put(sql_enforce_strict_size, HsqlDatabaseProperties.getMeta(sql_enforce_strict_size, 0, false));
        meta.put(sql_tx_no_multi_write, HsqlDatabaseProperties.getMeta(sql_tx_no_multi_write, 0, false));
        meta.put(textdb_quoted, HsqlDatabaseProperties.getMeta(textdb_quoted, 0, false));
        meta.put(textdb_all_quoted, HsqlDatabaseProperties.getMeta(textdb_all_quoted, 0, false));
        meta.put(textdb_ignore_first, HsqlDatabaseProperties.getMeta(textdb_ignore_first, 0, false));
        meta.put(hsqldb_applog, HsqlDatabaseProperties.getMeta(hsqldb_applog, 0, 0, new byte[]{0, 1, 2}));
        meta.put(hsqldb_cache_file_scale, HsqlDatabaseProperties.getMeta(hsqldb_cache_file_scale, 0, 1, new byte[]{1, 8}));
        meta.put(hsqldb_script_format, HsqlDatabaseProperties.getMeta(hsqldb_script_format, 0, 0, new byte[]{0, 1, 3}));
        meta.put(hsqldb_log_size, HsqlDatabaseProperties.getMeta(hsqldb_log_size, 1, 0, 0, 16000));
        meta.put(hsqldb_defrag_limit, HsqlDatabaseProperties.getMeta(hsqldb_defrag_limit, 1, 200, 0, 16000));
        meta.put(runtime_gc_interval, HsqlDatabaseProperties.getMeta(runtime_gc_interval, 0, 0, 0, 1000000));
        meta.put(hsqldb_cache_free_count_scale, HsqlDatabaseProperties.getMeta(hsqldb_cache_free_count_scale, 0, 9, 6, 12));
        meta.put(hsqldb_cache_scale, HsqlDatabaseProperties.getMeta(hsqldb_cache_scale, 0, 14, 8, 18));
        meta.put(hsqldb_cache_size_scale, HsqlDatabaseProperties.getMeta(hsqldb_cache_size_scale, 0, 10, 6, 20));
        meta.put(hsqldb_max_nio_scale, HsqlDatabaseProperties.getMeta(hsqldb_max_nio_scale, 0, 28, 24, 31));
        meta.put(hsqldb_raf_buffer_scale, HsqlDatabaseProperties.getMeta(hsqldb_raf_buffer_scale, 0, 12, 8, 13));
        meta.put(textdb_cache_scale, HsqlDatabaseProperties.getMeta(textdb_cache_scale, 0, 10, 8, 16));
        meta.put(textdb_cache_size_scale, HsqlDatabaseProperties.getMeta(textdb_cache_size_scale, 0, 10, 6, 20));
    }
}

