/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.XPUtils;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.Painter;
import com.jidesoft.plaf.eclipse.Eclipse3xMetalUtils;
import com.jidesoft.plaf.eclipse.Eclipse3xWindowsUtils;
import com.jidesoft.plaf.eclipse.EclipseMetalUtils;
import com.jidesoft.plaf.eclipse.EclipseWindowsUtils;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.jidesoft.plaf.office2003.Office2003WindowsUtils;
import com.jidesoft.plaf.office2007.Office2007WindowsUtils;
import com.jidesoft.plaf.vsnet.VsnetMetalUtils;
import com.jidesoft.plaf.vsnet.VsnetWindowsUtils;
import com.jidesoft.plaf.xerto.XertoMetalUtils;
import com.jidesoft.plaf.xerto.XertoPainter;
import com.jidesoft.plaf.xerto.XertoWindowsUtils;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ProductNames;
import com.jidesoft.utils.SecurityUtils;
import com.jidesoft.utils.SystemInfo;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class LookAndFeelFactory
implements ProductNames {
    public static final String WINDOWS_CLASSIC_LNF = "com.sun.java.swing.plaf.windows.WindowsClassicLookAndFeel";
    public static final String WINDOWS_LNF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    public static final String METAL_LNF = "javax.swing.plaf.metal.MetalLookAndFeel";
    public static final String SYNTH_LNF = "javax.swing.plaf.synth.SynthLookAndFeel";
    public static final String AQUA_LNF = "apple.laf.AquaLookAndFeel";
    public static final String AQUA_LNF_6 = "com.apple.laf.AquaLookAndFeel";
    public static final String QUAQUA_LNF = "ch.randelshofer.quaqua.QuaquaLookAndFeel";
    public static final String ALLOY_LNF = "com.incors.plaf.alloy.AlloyLookAndFeel";
    public static final String SYNTHETICA_LNF = "de.javasoft.plaf.synthetica.SyntheticaLookAndFeel";
    public static final String SYNTHETICA_LNF_PREFIX = "de.javasoft.plaf.synthetica.Synthetica";
    public static final String PLASTIC3D_LNF = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    @Deprecated
    public static final String PLASTIC3D_LNF_1_3 = "com.jgoodies.looks.plastic.Plastic3DLookAndFeel";
    public static final String PLASTICXP_LNF = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    public static final String TONIC_LNF = "com.digitprop.tonic.TonicLookAndFeel";
    public static final String A03_LNF = "a03.swing.plaf.A03LookAndFeel";
    public static final String PGS_LNF = "com.pagosoft.plaf.PgsLookAndFeel";
    public static final String GTK_LNF = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final String MOTIF_LNF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    public static final String BIZ_LNF = "de.centigrade.bizlaf.BizLookAndFeel";
    public static final String NIMBUS_LNF_NAME = "NimbusLookAndFeel";
    public static final int VSNET_STYLE_WITHOUT_MENU = 0;
    public static final int VSNET_STYLE = 1;
    public static final int ECLIPSE_STYLE = 2;
    public static final int OFFICE2003_STYLE = 3;
    public static final int XERTO_STYLE = 4;
    public static final int XERTO_STYLE_WITHOUT_MENU = 6;
    public static final int ECLIPSE3X_STYLE = 5;
    public static final int OFFICE2007_STYLE = 7;
    public static final int EXTENSION_STYLE_VSNET_WITHOUT_MENU = 0;
    public static final int EXTENSION_STYLE_VSNET = 1;
    public static final int EXTENSION_STYLE_ECLIPSE = 2;
    public static final int EXTENSION_STYLE_OFFICE2003 = 3;
    public static final int EXTENSION_STYLE_XERTO = 4;
    public static final int EXTENSION_STYLE_ECLIPSE3X = 5;
    public static final int EXTENSION_STYLE_XERTO_WITHOUT_MENU = 6;
    public static final int EXTENSION_STYLE_OFFICE2007 = 7;
    @Deprecated
    public static final int EXTENSION_STYLE_OFFICE2003_WITHOUT_MENU = 8;
    @Deprecated
    public static final int EXTENSION_STYLE_OFFICE2007_WITHOUT_MENU = 9;
    public static final int EXTENSION_STYLE_ECLIPSE_WITHOUT_MENU = 10;
    public static final int EXTENSION_STYLE_ECLIPSE3X_WITHOUT_MENU = 11;
    private static int _style = -1;
    private static int _defaultStyle = -1;
    private static LookAndFeel _lookAndFeel;
    private static PropertyChangeListener _listener;
    public static final String JIDE_EXTENSION_INSTALLED = "jidesoft.extensionInstalled";
    public static final String JIDE_STYLE_INSTALLED = "jidesoft.extensionStyle";
    private static List<UIDefaultsCustomizer> _uiDefaultsCustomizers;
    private static List<UIDefaultsInitializer> _uiDefaultsInitializers;
    private static Map<String, String> _installedLookAndFeels;
    private static boolean _loadLookAndFeelClass;
    public static final String LAF_INSTALLED = "installed";
    public static final String LAF_NOT_INSTALLED = "not installed";
    private static Map<String, String> _defaultInitializers;
    private static Map<String, String> _defaultCustomizers;
    private static int _productsUsed;

    protected LookAndFeelFactory() {
    }

    public static int getDefaultStyle() {
        if (_defaultStyle == -1) {
            String defaultStyle = SecurityUtils.getProperty("jide.defaultStyle", "-1");
            try {
                _defaultStyle = Integer.parseInt(defaultStyle);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (_defaultStyle == -1) {
                int suggestedStyle;
                try {
                    suggestedStyle = SystemInfo.isWindowsVistaAbove() && UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && SystemInfo.isJdk6Above() ? 7 : (XPUtils.isXPStyleOn() && UIManager.getLookAndFeel() instanceof WindowsLookAndFeel ? 3 : ((LookAndFeelFactory.getProductsUsed() & 0x10) == 0 ? 0 : 1));
                }
                catch (UnsupportedOperationException e) {
                    suggestedStyle = (LookAndFeelFactory.getProductsUsed() & 0x10) == 0 ? 0 : 1;
                }
                return suggestedStyle;
            }
        }
        return _defaultStyle;
    }

    public static void setDefaultStyle(int defaultStyle) {
        _defaultStyle = defaultStyle;
    }

    public static void installJideExtension() {
        LookAndFeelFactory.installJideExtension(_style == -1 ? LookAndFeelFactory.getDefaultStyle() : _style);
    }

    public static void installJideExtension(int style) {
        LookAndFeelFactory.installJideExtension(UIManager.getLookAndFeelDefaults(), UIManager.getLookAndFeel(), style);
    }

    public static boolean isJideExtensionInstalled() {
        return UIDefaultsLookup.getBoolean(JIDE_EXTENSION_INSTALLED);
    }

    public static void installJideExtension(UIDefaults uiDefaults, LookAndFeel lnf, int style) {
        UIDefaultsCustomizer[] customizers;
        UIDefaultsInitializer[] initializers;
        if (LookAndFeelFactory.isJideExtensionInstalled() && _style == style && _lookAndFeel == lnf) {
            return;
        }
        LookAndFeelFactory.workAroundSwingIssues();
        if (_listener == null) {
            _listener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if ("lookAndFeel".equals(evt.getPropertyName())) {
                        _style = -1;
                    }
                }
            };
        }
        UIManager.removePropertyChangeListener(_listener);
        UIManager.addPropertyChangeListener(_listener);
        _style = style;
        uiDefaults.put(JIDE_STYLE_INSTALLED, (Object)_style);
        _lookAndFeel = lnf;
        for (UIDefaultsInitializer initializer : initializers = LookAndFeelFactory.getUIDefaultsInitializers()) {
            if (initializer == null) continue;
            initializer.initialize(uiDefaults);
        }
        LookAndFeelFactory.initialize(lnf.getClass().getName(), uiDefaults);
        if (lnf.getClass().getName().equals(ALLOY_LNF) && LookAndFeelFactory.isAlloyLnfInstalled() || lnf.getClass().getName().equals("com.jgoodies.looks.plastic.Plastic3DLookAndFeel") && LookAndFeelFactory.isPlastic3DLnfInstalled() || lnf.getClass().getName().equals(PLASTICXP_LNF) && LookAndFeelFactory.isPlasticXPLnfInstalled() || lnf.getClass().getName().equals(PGS_LNF) && LookAndFeelFactory.isPgsLnfInstalled() || lnf.getClass().getName().equals(TONIC_LNF) && LookAndFeelFactory.isTonicLnfInstalled()) {
            switch (style) {
                case 7: 
                case 9: {
                    VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2007WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2007WindowsUtils.initClassDefaults(uiDefaults, false);
                    break;
                }
                case 3: 
                case 8: {
                    VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2003WindowsUtils.initClassDefaults(uiDefaults, false);
                    break;
                }
                case 0: 
                case 1: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    Painter gripperPainter = new Painter(){

                        public void paint(JComponent c, Graphics g, Rectangle rect, int orientation, int state) {
                            Office2003Painter.getInstance().paintGripper(c, g, rect, orientation, state);
                        }
                    };
                    uiDefaults.put("Gripper.painter", gripperPainter);
                    uiDefaults.put("JideTabbedPane.gripperPainter", gripperPainter);
                    uiDefaults.put("JideTabbedPane.defaultTabShape", (Object)4);
                    uiDefaults.put("JideTabbedPane.selectedTabTextForeground", UIDefaultsLookup.getColor("controlText"));
                    uiDefaults.put("JideTabbedPane.unselectedTabTextForeground", UIDefaultsLookup.getColor("controlText"));
                    uiDefaults.put("JideTabbedPane.foreground", UIDefaultsLookup.getColor("controlText"));
                    uiDefaults.put("JideTabbedPane.light", UIDefaultsLookup.getColor("control"));
                    uiDefaults.put("JideSplitPaneDivider.gripperPainter", gripperPainter);
                    int products = LookAndFeelFactory.getProductsUsed();
                    if ((products & 1) == 0) break;
                    ImageIcon titleButtonImage = IconsFactory.getImageIcon(VsnetWindowsUtils.class, "icons/title_buttons_windows.gif");
                    int titleButtonSize = 10;
                    uiDefaults.put("DockableFrameUI", "com.jidesoft.plaf.vsnet.VsnetDockableFrameUI");
                    uiDefaults.put("DockableFrameTitlePane.hideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 0, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.unfloatIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 10, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.floatIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 20, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.autohideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 30, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.stopAutohideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 40, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.hideAutohideIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 50, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.maximizeIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 60, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.restoreIcon", IconsFactory.getIcon(null, titleButtonImage, 0, 70, 10, 10));
                    uiDefaults.put("DockableFrameTitlePane.buttonGap", (Object)4);
                    uiDefaults.put("DockableFrame.titleBorder", new BorderUIResource(BorderFactory.createEmptyBorder(1, 0, 2, 0)));
                    uiDefaults.put("DockableFrame.border", new BorderUIResource(BorderFactory.createEmptyBorder(2, 0, 0, 0)));
                    uiDefaults.put("DockableFrameTitlePane.gripperPainter", gripperPainter);
                    break;
                }
                case 2: 
                case 10: {
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 5: 
                case 11: {
                    Eclipse3xMetalUtils.initComponentDefaults(uiDefaults);
                    Eclipse3xMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: 
                case 6: {
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                }
            }
            if (style == 4 || style == 6) {
                UIDefaultsLookup.put(uiDefaults, "Theme.painter", XertoPainter.getInstance());
            } else {
                UIDefaultsLookup.put(uiDefaults, "Theme.painter", BasicPainter.getInstance());
            }
        } else if (lnf.getClass().getName().equals(MetalLookAndFeel.class.getName())) {
            switch (style) {
                case 1: 
                case 3: 
                case 7: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 2: {
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xMetalUtils.initComponentDefaults(uiDefaults);
                    Eclipse3xMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 0: 
                case 8: 
                case 9: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: 
                case 6: {
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
            }
        } else if (lnf instanceof MetalLookAndFeel) {
            switch (style) {
                case 0: 
                case 1: 
                case 3: 
                case 7: 
                case 8: 
                case 9: {
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 2: 
                case 10: {
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 5: 
                case 11: {
                    Eclipse3xMetalUtils.initClassDefaults(uiDefaults);
                    Eclipse3xMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 4: 
                case 6: {
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                }
            }
        } else if (lnf instanceof WindowsLookAndFeel) {
            switch (style) {
                case 7: {
                    VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    VsnetWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2007WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2007WindowsUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 9: {
                    VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                    VsnetWindowsUtils.initClassDefaults(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2007WindowsUtils.initComponentDefaults(uiDefaults);
                    Office2007WindowsUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 3: {
                    VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    VsnetWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    Office2003WindowsUtils.initClassDefaults(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 8: {
                    VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                    VsnetWindowsUtils.initClassDefaults(uiDefaults);
                    Office2003WindowsUtils.initClassDefaults(uiDefaults);
                    Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 2: {
                    EclipseWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    EclipseWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 10: {
                    EclipseWindowsUtils.initClassDefaults(uiDefaults);
                    EclipseWindowsUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 5: {
                    Eclipse3xWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    Eclipse3xWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 11: {
                    Eclipse3xWindowsUtils.initClassDefaults(uiDefaults);
                    Eclipse3xWindowsUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 1: {
                    VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    VsnetWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 0: {
                    VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                    VsnetWindowsUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: {
                    XertoWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                    XertoWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                    break;
                }
                case 6: {
                    XertoWindowsUtils.initComponentDefaults(uiDefaults);
                    XertoWindowsUtils.initClassDefaults(uiDefaults);
                }
            }
        } else if (LookAndFeelFactory.isAquaLnfInstalled() && (LookAndFeelFactory.isLnfInUse(AQUA_LNF_6) || LookAndFeelFactory.isLnfInUse(AQUA_LNF)) || LookAndFeelFactory.isQuaquaLnfInstalled() && LookAndFeelFactory.isLnfInUse(QUAQUA_LNF)) {
            try {
                Class<?> aquaJideUtils = LookAndFeelFactory.getUIManagerClassLoader().loadClass("com.jidesoft.plaf.aqua.AquaJideUtils");
                aquaJideUtils.getMethod("initComponentDefaults", UIDefaults.class).invoke(null, uiDefaults);
                aquaJideUtils.getMethod("initClassDefaults", UIDefaults.class).invoke(null, uiDefaults);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                JideSwingUtilities.throwInvocationTargetException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        } else {
            switch (style) {
                case 7: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                        Office2007WindowsUtils.initComponentDefaults(uiDefaults);
                        Office2007WindowsUtils.initClassDefaults(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 9: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                        Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                        Office2007WindowsUtils.initComponentDefaults(uiDefaults);
                        Office2007WindowsUtils.initClassDefaults(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 3: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                        Office2003WindowsUtils.initClassDefaults(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 8: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                        Office2003WindowsUtils.initComponentDefaults(uiDefaults);
                        Office2003WindowsUtils.initClassDefaults(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 2: {
                    if (SystemInfo.isWindows()) {
                        EclipseWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                        EclipseWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        break;
                    }
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 10: {
                    if (SystemInfo.isWindows()) {
                        EclipseWindowsUtils.initClassDefaults(uiDefaults);
                        EclipseWindowsUtils.initComponentDefaults(uiDefaults);
                        break;
                    }
                    EclipseMetalUtils.initClassDefaults(uiDefaults);
                    EclipseMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 5: {
                    if (SystemInfo.isWindows()) {
                        Eclipse3xWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                        Eclipse3xWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        break;
                    }
                    Eclipse3xMetalUtils.initClassDefaults(uiDefaults);
                    Eclipse3xMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 11: {
                    if (SystemInfo.isWindows()) {
                        Eclipse3xWindowsUtils.initClassDefaults(uiDefaults);
                        Eclipse3xWindowsUtils.initComponentDefaults(uiDefaults);
                        break;
                    }
                    Eclipse3xMetalUtils.initClassDefaults(uiDefaults);
                    Eclipse3xMetalUtils.initComponentDefaults(uiDefaults);
                    break;
                }
                case 1: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                        VsnetWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 0: {
                    if (SystemInfo.isWindows()) {
                        VsnetWindowsUtils.initClassDefaults(uiDefaults);
                        VsnetWindowsUtils.initComponentDefaults(uiDefaults);
                        break;
                    }
                    VsnetMetalUtils.initComponentDefaults(uiDefaults);
                    VsnetMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 4: {
                    if (SystemInfo.isWindows()) {
                        XertoWindowsUtils.initClassDefaultsWithMenu(uiDefaults);
                        XertoWindowsUtils.initComponentDefaultsWithMenu(uiDefaults);
                        break;
                    }
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                    break;
                }
                case 6: {
                    if (SystemInfo.isWindows()) {
                        XertoWindowsUtils.initClassDefaults(uiDefaults);
                        XertoWindowsUtils.initComponentDefaults(uiDefaults);
                        break;
                    }
                    XertoMetalUtils.initComponentDefaults(uiDefaults);
                    XertoMetalUtils.initClassDefaults(uiDefaults);
                }
            }
        }
        uiDefaults.put(JIDE_EXTENSION_INSTALLED, Boolean.TRUE);
        LookAndFeelFactory.customize(lnf.getClass().getName(), uiDefaults);
        for (UIDefaultsCustomizer customizer : customizers = LookAndFeelFactory.getUIDefaultsCustomizers()) {
            if (customizer == null) continue;
            customizer.customize(uiDefaults);
        }
    }

    private static void workAroundSwingIssues() {
        Object o = UIManager.get("PopupMenu.selectedWindowInputMapBindings.RightToLeft");
        if (o instanceof Object[]) {
            Object[] mapArray;
            for (Object item : mapArray = (Object[])o) {
                if (!"DOWN".equals(item)) continue;
                return;
            }
            Object[] newMapArray = new Object[mapArray.length + 14];
            System.arraycopy(mapArray, 0, newMapArray, 0, mapArray.length);
            int i = mapArray.length;
            newMapArray[i++] = "DOWN";
            newMapArray[i++] = "selectNext";
            newMapArray[i++] = "UP";
            newMapArray[i++] = "selectPrevious";
            newMapArray[i++] = "KP_DOWN";
            newMapArray[i++] = "selectNext";
            newMapArray[i++] = "KP_UP";
            newMapArray[i++] = "selectPrevious";
            newMapArray[i++] = "ENTER";
            newMapArray[i++] = "return";
            newMapArray[i++] = "SPACE";
            newMapArray[i++] = "return";
            newMapArray[i++] = "ESCAPE";
            newMapArray[i] = "cancel";
            UIManager.put("PopupMenu.selectedWindowInputMapBindings.RightToLeft", newMapArray);
        }
    }

    public static void registerDefaultInitializer(String lnfClassName, String initializerClassName) {
        if (_defaultInitializers == null) {
            _defaultInitializers = new HashMap<String, String>();
        }
        _defaultInitializers.put(lnfClassName, initializerClassName);
    }

    public static void unregisterDefaultInitializer(String lnfClassName) {
        if (_defaultInitializers != null) {
            _defaultInitializers.remove(lnfClassName);
        }
    }

    public static void clearDefaultInitializers() {
        if (_defaultInitializers != null) {
            _defaultInitializers.clear();
        }
    }

    public static void registerDefaultCustomizer(String lnfClassName, String customizerClassName) {
        if (_defaultCustomizers == null) {
            _defaultCustomizers = new HashMap<String, String>();
        }
        _defaultCustomizers.put(lnfClassName, customizerClassName);
    }

    public static void unregisterDefaultCustomizer(String lnfClassName) {
        if (_defaultCustomizers != null) {
            _defaultCustomizers.remove(lnfClassName);
        }
    }

    public static void clearDefaultCustomizers() {
        if (_defaultCustomizers != null) {
            _defaultCustomizers.clear();
        }
    }

    private static void initialize(String lnfClassName, UIDefaults uiDefaults) {
        String initializer;
        Vector<String> lookup = new Vector<String>();
        Vector<String> classLookup = new Vector<String>();
        classLookup.insertElementAt(lnfClassName, 0);
        String lnf = LookAndFeelFactory.guessLookAndFeelName(lnfClassName);
        if (lnf != null && lnf.trim().length() > 0) {
            lookup.insertElementAt(lnf, 0);
        }
        try {
            Class<?> superclass;
            Class<?> clazz = Class.forName(lnfClassName);
            while (clazz != null && (superclass = clazz.getSuperclass()) != null && LookAndFeel.class.isAssignableFrom(superclass)) {
                lnfClassName = superclass.getName();
                classLookup.insertElementAt(lnfClassName, 0);
                lnf = LookAndFeelFactory.guessLookAndFeelName(lnfClassName);
                if (lnf != null && lnf.trim().length() > 0) {
                    lookup.insertElementAt(lnf, 0);
                }
                clazz = superclass;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        for (String s : classLookup) {
            initializer = LookAndFeelFactory.findDefaultInitializer(s);
            if (initializer == null) continue;
            LookAndFeelFactory.invokeInitialize(uiDefaults, initializer);
        }
        for (String s : lookup) {
            initializer = LookAndFeelFactory.getDefaultInitializer(s);
            if (initializer == null) continue;
            LookAndFeelFactory.invokeInitialize(uiDefaults, initializer);
        }
    }

    private static void invokeInitialize(UIDefaults uiDefaults, String initializer) {
        try {
            Class<?> clazz = Class.forName(initializer);
            Object o = clazz.newInstance();
            Method method = o.getClass().getMethod("initialize", UIDefaults.class);
            method.invoke(o, uiDefaults);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static String getDefaultInitializer(String lnf) {
        return "com.jidesoft.plaf." + lnf.toLowerCase() + "." + lnf + "Initializer";
    }

    private static String findDefaultInitializer(String lnfClassName) {
        String s;
        if (_defaultInitializers != null && (s = _defaultInitializers.get(lnfClassName)) != null) {
            return s;
        }
        return null;
    }

    private static void customize(String lnfClassName, UIDefaults uiDefaults) {
        String customizer;
        Vector<String> lookup = new Vector<String>();
        Vector<String> classLookup = new Vector<String>();
        classLookup.insertElementAt(lnfClassName, 0);
        String lnf = LookAndFeelFactory.guessLookAndFeelName(lnfClassName);
        if (lnf != null && lnf.trim().length() > 0) {
            lookup.insertElementAt(lnf, 0);
        }
        try {
            Class<?> superclass;
            Class<?> clazz = Class.forName(lnfClassName);
            while (clazz != null && (superclass = clazz.getSuperclass()) != null && LookAndFeel.class.isAssignableFrom(superclass)) {
                lnfClassName = superclass.getName();
                classLookup.insertElementAt(lnfClassName, 0);
                lnf = LookAndFeelFactory.guessLookAndFeelName(lnfClassName);
                if (lnf != null && lnf.trim().length() > 0) {
                    lookup.insertElementAt(lnf, 0);
                }
                clazz = superclass;
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        for (String s : classLookup) {
            customizer = LookAndFeelFactory.findDefaultCustomizer(s);
            if (customizer == null) continue;
            LookAndFeelFactory.invokeCustomize(uiDefaults, customizer);
        }
        for (String s : lookup) {
            customizer = LookAndFeelFactory.getDefaultCustomizer(s);
            if (customizer == null) continue;
            LookAndFeelFactory.invokeCustomize(uiDefaults, customizer);
        }
    }

    private static void invokeCustomize(UIDefaults uiDefaults, String customizer) {
        try {
            Class<?> clazz = Class.forName(customizer);
            Object o = clazz.newInstance();
            Method method = o.getClass().getMethod("customize", UIDefaults.class);
            method.invoke(o, uiDefaults);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    private static String getDefaultCustomizer(String lnf) {
        return "com.jidesoft.plaf." + lnf.toLowerCase() + "." + lnf + "Customizer";
    }

    private static String findDefaultCustomizer(String lnfClassName) {
        String s;
        if (_defaultCustomizers != null && (s = _defaultCustomizers.get(lnfClassName)) != null) {
            return s;
        }
        return null;
    }

    private static String guessLookAndFeelName(String lnfClassName) {
        int start = lnfClassName.lastIndexOf(".") + 1;
        if (lnfClassName.endsWith("LookAndFeel")) {
            return lnfClassName.substring(start, lnfClassName.length() - "LookAndFeel".length());
        }
        return null;
    }

    public static boolean isLnfInstalled(String lnfName) {
        String installed = _installedLookAndFeels.get(lnfName);
        if (installed != null) {
            return LAF_INSTALLED.equals(installed);
        }
        return LookAndFeelFactory.isLoadLookAndFeelClass() && LookAndFeelFactory.loadLnfClass(lnfName) != null;
    }

    public static ClassLoader getUIManagerClassLoader() {
        Object cl = UIManager.get("ClassLoader");
        if (cl instanceof ClassLoader) {
            return (ClassLoader)cl;
        }
        ClassLoader classLoader = LookAndFeelFactory.class.getClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    public static boolean isLnfInUse(String lnf) {
        return (!_installedLookAndFeels.containsKey(lnf) || _installedLookAndFeels.get(lnf) != null && !_installedLookAndFeels.get(lnf).equals(LAF_NOT_INSTALLED)) && LookAndFeelFactory.isAssignableFrom(lnf, UIManager.getLookAndFeel().getClass());
    }

    public static void setLnfInstalled(String lnfName, boolean installed) {
        _installedLookAndFeels.put(lnfName, installed ? LAF_INSTALLED : LAF_NOT_INSTALLED);
    }

    private static Class loadLnfClass(String lnfName) {
        try {
            Class<?> clazz = LookAndFeelFactory.getUIManagerClassLoader().loadClass(lnfName);
            HashMap<String, String> map = new HashMap<String, String>(_installedLookAndFeels);
            map.put(lnfName, LAF_INSTALLED);
            _installedLookAndFeels = map;
            return clazz;
        }
        catch (ClassNotFoundException e) {
            HashMap<String, String> map = new HashMap<String, String>(_installedLookAndFeels);
            map.put(lnfName, LAF_NOT_INSTALLED);
            _installedLookAndFeels = map;
            return null;
        }
    }

    private static boolean isAssignableFrom(String lnfName, Class cls) {
        if (lnfName.equals(cls.getName())) {
            return true;
        }
        Class cl = LookAndFeelFactory.loadLnfClass(lnfName);
        return cl != null && cl.isAssignableFrom(cls);
    }

    public static boolean isAquaLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(AQUA_LNF_6) || LookAndFeelFactory.isLnfInstalled(AQUA_LNF);
    }

    public static boolean isQuaquaLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(QUAQUA_LNF);
    }

    public static boolean isAlloyLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(ALLOY_LNF);
    }

    public static boolean isBizlafLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(BIZ_LNF);
    }

    public static boolean isGTKLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(GTK_LNF);
    }

    public static boolean isPlastic3DLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
    }

    @Deprecated
    public static boolean isPlastic3D13LnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled("com.jgoodies.looks.plastic.Plastic3DLookAndFeel");
    }

    public static boolean isPlasticXPLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(PLASTICXP_LNF);
    }

    public static boolean isTonicLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(TONIC_LNF);
    }

    public static boolean isA03LnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(A03_LNF);
    }

    public static boolean isPgsLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(PGS_LNF);
    }

    public static boolean isSyntheticaLnfInstalled() {
        return LookAndFeelFactory.isLnfInstalled(SYNTHETICA_LNF);
    }

    public static boolean isNimbusLnfInstalled() {
        UIManager.LookAndFeelInfo[] infos;
        for (UIManager.LookAndFeelInfo info : infos = UIManager.getInstalledLookAndFeels()) {
            if (info.getClassName().indexOf(NIMBUS_LNF_NAME) == -1) continue;
            return true;
        }
        return false;
    }

    public static void installDefaultLookAndFeelAndExtension() {
        LookAndFeelFactory.installDefaultLookAndFeel();
        LookAndFeelFactory.installJideExtension();
    }

    public static void installDefaultLookAndFeel() {
        try {
            String lnfName = SecurityUtils.getProperty("swing.defaultlaf", null);
            if (lnfName == null) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(lnfName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static LookAndFeel getLookAndFeel() {
        return _lookAndFeel;
    }

    public static int getStyle() {
        return _style;
    }

    public static UIDefaultsCustomizer[] getUIDefaultsCustomizers() {
        return _uiDefaultsCustomizers.toArray(new UIDefaultsCustomizer[_uiDefaultsCustomizers.size()]);
    }

    public static void addUIDefaultsCustomizer(UIDefaultsCustomizer uiDefaultsCustomizer) {
        if (!_uiDefaultsCustomizers.contains(uiDefaultsCustomizer)) {
            _uiDefaultsCustomizers.add(uiDefaultsCustomizer);
        }
    }

    public static void removeUIDefaultsCustomizer(UIDefaultsCustomizer uiDefaultsCustomizer) {
        _uiDefaultsCustomizers.remove(uiDefaultsCustomizer);
    }

    public static UIDefaultsInitializer[] getUIDefaultsInitializers() {
        return _uiDefaultsInitializers.toArray(new UIDefaultsInitializer[_uiDefaultsInitializers.size()]);
    }

    public static void addUIDefaultsInitializer(UIDefaultsInitializer uiDefaultsInitializer) {
        if (!_uiDefaultsInitializers.contains(uiDefaultsInitializer)) {
            _uiDefaultsInitializers.add(uiDefaultsInitializer);
        }
    }

    public static void removeUIDefaultsInitializer(UIDefaultsInitializer uiDefaultsInitializer) {
        _uiDefaultsInitializers.remove(uiDefaultsInitializer);
    }

    public static void verifyDefaults(UIDefaults table, Object[] keyValueList) {
        int max = keyValueList.length;
        for (int i = 0; i < max; i += 2) {
            Object value = keyValueList[i + 1];
            if (value == null) {
                System.out.println("The value for " + keyValueList[i] + " is null");
                continue;
            }
            Object oldValue = table.get(keyValueList[i]);
            if (oldValue == null) continue;
            System.out.println("The value for " + keyValueList[i] + " exists which is " + oldValue);
        }
    }

    public static void putDefaults(UIDefaults table, Object[] keyValueArray) {
        int max = keyValueArray.length;
        for (int i = 0; i < max; i += 2) {
            Object value = keyValueArray[i + 1];
            if (value == null) {
                table.remove(keyValueArray[i]);
                continue;
            }
            if (table.get(keyValueArray[i]) != null) continue;
            table.put(keyValueArray[i], value);
        }
    }

    public static void overwriteDefaults(UIDefaults table, Object[] keyValueArray) {
        int max = keyValueArray.length;
        for (int i = 0; i < max; i += 2) {
            Object value = keyValueArray[i + 1];
            if (value == null) {
                table.remove(keyValueArray[i]);
                continue;
            }
            table.put(keyValueArray[i], value);
        }
    }

    public static int getProductsUsed() {
        if (_productsUsed == -1) {
            _productsUsed = 0;
            try {
                Class.forName("com.jidesoft.docking.Product");
                _productsUsed |= 1;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.action.Product");
                _productsUsed |= 0x10;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.document.Product");
                _productsUsed |= 2;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.grid.Product");
                _productsUsed |= 4;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.wizard.Product");
                _productsUsed |= 8;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.pivot.Product");
                _productsUsed |= 0x20;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.shortcut.Product");
                _productsUsed |= 0x40;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.editor.Product");
                _productsUsed |= 0x80;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.rss.Product");
                _productsUsed |= 0x100;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.treemap.Product");
                _productsUsed |= 0x8000;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.chart.Product");
                _productsUsed |= 0x1000;
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                Class.forName("com.jidesoft.diff.Product");
                _productsUsed |= 0x4000;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return _productsUsed;
    }

    public static void setProductsUsed(int productsUsed) {
        _productsUsed = productsUsed;
    }

    public static boolean isCurrentLnfDecorated() {
        return !LookAndFeelFactory.isLnfInstalled(SYNTHETICA_LNF) || !LookAndFeelFactory.isLnfInUse(SYNTHETICA_LNF);
    }

    public static boolean isLoadLookAndFeelClass() {
        return _loadLookAndFeelClass;
    }

    public static void setLoadLookAndFeelClass(boolean loadLookAndFeelClass) {
        _loadLookAndFeelClass = loadLookAndFeelClass;
    }

    public static void main(String[] args) {
    }

    static {
        _uiDefaultsCustomizers = new Vector<UIDefaultsCustomizer>();
        _uiDefaultsInitializers = new Vector<UIDefaultsInitializer>();
        _installedLookAndFeels = new HashMap<String, String>();
        _loadLookAndFeelClass = true;
        _productsUsed = -1;
    }

    public static interface UIDefaultsInitializer {
        public void initialize(UIDefaults var1);
    }

    public static interface UIDefaultsCustomizer {
        public void customize(UIDefaults var1);
    }
}

