/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;

final class JetrisScoreKeeper
extends JDialog
implements LocationSizeListener {
    private final byte SLOTS = (byte)10;
    private JetrisHighScore[] highScores = new JetrisHighScore[10];
    JTable highScoreTable;
    private int x;
    private int y;
    private int width;
    private int height;
    static /* synthetic */ Class class$java$lang$Object;

    JetrisScoreKeeper() {
        this.setModal(false);
        this.setTitle("Jetris Highscores");
        this.addComponentListener(new JetrisComponentListener());
        this.addWindowListener(new JetrisWindowListener());
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.highScores = this.readHighScores();
        this.highScoreTable = new JTable(new HighScoresTableModel(this.highScores));
        this.highScoreTable.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = JetrisScoreKeeper.class$("java.lang.Object")) : class$java$lang$Object, new HighScoreRenderer());
        this.highScoreTable.setBackground(Color.black);
        this.highScoreTable.setShowVerticalLines(false);
        this.highScoreTable.setShowHorizontalLines(false);
        JScrollPane jScrollPane = new JScrollPane(this.highScoreTable);
        JButton jButton = new JButton();
        jButton.setAction(Actions.highScoresAction);
        jButton.setText("Close");
        jButton.setMnemonic(79);
        this.getRootPane().setDefaultButton(jButton);
        this.getContentPane().setLayout(gridBagLayout);
        Jetris.setConstraints(gridBagConstraints, 0, 0, 1, 1, 100, 100, 5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        this.getContentPane().add(jScrollPane);
        Jetris.setConstraints(gridBagConstraints, 0, 1, 1, 1, 100, 0, 5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        this.getContentPane().add(jButton);
        this.x = Jetris.getConfig().readKey("highscoresxpos", 0);
        this.y = Jetris.getConfig().readKey("highscoresypos", 0);
        this.width = Jetris.getConfig().readKey("highscoreswidth", 0);
        this.height = Jetris.getConfig().readKey("highscoresheight", 0);
        if (this.width > 0 && this.height > 0) {
            this.setBounds(this.x, this.y, this.width, this.height);
        } else {
            this.pack();
            this.setLocation(this.x, this.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JetrisHighScore[] readHighScores() {
        try {
            try {
                FileInputStream fileInputStream = new FileInputStream(Jetris.getConfig().getConfigDir() + "scores.dat");
                ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
                int n = 0;
                while (n < 10) {
                    this.highScores[n] = (JetrisHighScore)objectInputStream.readObject();
                    n = (byte)(n + 1);
                }
                fileInputStream.close();
                objectInputStream.close();
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                Object var5_6 = null;
                return this.highScores;
            }
            Object var5_5 = null;
            return this.highScores;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            return this.highScores;
        }
    }

    private void writeHighScores() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(Jetris.getConfig().getConfigDir() + "scores.dat");
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            int n = 0;
            while (n < 10) {
                objectOutputStream.writeObject(this.highScores[n]);
                n = (byte)(n + 1);
            }
            fileOutputStream.close();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
        }
    }

    protected byte isHighScore(int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < 10) {
            if (this.highScores[n3] == null || n >= this.highScores[n3].getScore()) {
                n2 = n3;
                break;
            }
            n3 = (byte)(n3 + 1);
        }
        return (byte)n2;
    }

    protected void addHighScore(JetrisHighScore jetrisHighScore, byte by) {
        byte by2 = 9;
        while (by2 > by) {
            this.highScores[by2] = this.highScores[by2 - 1];
            by2 = (byte)(by2 - 1);
        }
        this.highScores[by] = jetrisHighScore;
        if (this.isVisible()) {
            this.highScoreTable.repaint();
            this.highScoreTable.setRowSelectionInterval(by, by);
        }
        this.writeHighScores();
    }

    public void setX(int n) {
        this.x = n;
    }

    public void setY(int n) {
        this.y = n;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void writeConfig() {
        Jetris.getConfig().writeKey("highscoresxpos", this.x);
        Jetris.getConfig().writeKey("highscoresypos", this.y);
        Jetris.getConfig().writeKey("highscoreswidth", this.width);
        Jetris.getConfig().writeKey("highscoresheight", this.height);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

