/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class Place
extends Panel
implements Runnable {
    public int compId;
    public AllObjects ao;
    public int BallColor;
    public int state;
    int minSize = 10;
    int boxSize = 44;
    int normalSize = 32;
    Thread process;
    int iter;
    int direction = 1;
    int pos;
    Graphics offScr;
    Image BackBuffer;

    public Place(int id) {
        this.compId = id;
        this.enableEvents(16L);
        this.setSize(new Dimension(44, 44));
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paintAll(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (this.ao == null) {
            return;
        }
        if (this.BackBuffer == null) {
            this.BackBuffer = this.createImage(44, 44);
        }
        if (this.offScr == null) {
            this.offScr = this.BackBuffer.getGraphics();
        }
        this.offScr.drawImage(this.ao.EmptyBox, 0, 0, this);
        switch (this.state) {
            case 1: {
                int s1 = (this.boxSize - this.minSize) / 2;
                this.offScr.drawImage(this.ao.getBall(this.BallColor, 21), 2, 2, this);
                break;
            }
            case 2: {
                this.offScr.drawImage(this.ao.getBall(this.BallColor, 0), 2, 2, this);
                break;
            }
            case 3: {
                this.offScr.drawImage(this.ao.getBall(this.BallColor, this.pos), 2, 2, this);
                break;
            }
        }
        g.drawImage(this.BackBuffer, 0, 0, this);
    }

    public Dimension getPreferredSize() {
        return new Dimension(44, 44);
    }

    public void run() {
        Thread me = Thread.currentThread();
        while (this.process == me) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
            this.repaint();
            this.iter += this.direction;
            if (this.iter == -3 || this.iter == 3) {
                this.direction = -this.direction;
            }
            if (this.iter > 0) {
                this.pos = 4 - this.iter;
            }
            if (this.iter < 0) {
                this.pos = -this.iter + 3;
            }
            if (this.iter != 0) continue;
            this.pos = 0;
        }
    }

    public void start() {
        this.state = 3;
        this.iter = 1;
        this.direction = 1;
        this.process = new Thread(this);
        this.process.start();
    }

    public void stop() {
        if (this.state == 3) {
            this.process = null;
            this.state = 2;
            this.repaint();
        }
    }

    public void processMouseEvent(MouseEvent evt) {
        switch (evt.getID()) {
            case 502: {
                this.mouseReleased(evt);
                break;
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
        Lines98 l98 = (Lines98)this.ao.parentFrame;
        switch (this.state) {
            case 0: 
            case 1: {
                l98.processMouseEvent(this, 0, this.state);
                break;
            }
            case 2: {
                this.start();
                l98.processMouseEvent(this, 2, this.state);
                break;
            }
            case 3: {
                this.stop();
                l98.processMouseEvent(this, 3, this.state);
                break;
            }
        }
    }

    public void placeBall(int color, int st) {
        this.state = st;
        this.BallColor = color;
        this.repaint();
    }

    public static Point getPlace(int num) {
        if (num < 0 || num >= 81) {
            return null;
        }
        return new Point(num % 9, num / 9);
    }

    public static int getPlace(int w, int h) {
        if (w < 0 || w > 8) {
            return -1;
        }
        if (h < 0 || h > 8) {
            return -1;
        }
        return h * 9 + w;
    }

    public static void main(String[] args) {
        Point p = Place.getPlace(0);
        System.out.println("0 = " + p.x + "," + p.y);
        p = Place.getPlace(8);
        System.out.println("8 = " + p.x + "," + p.y);
        p = Place.getPlace(9);
        System.out.println("9 = " + p.x + "," + p.y);
    }
}

