/*
 * Decompiled with CFR 0.152.
 */
package org.demarchi.jpeces.peces;

import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import java.util.StringTokenizer;
import org.demarchi.jpeces.comuns.Configuracio;
import org.demarchi.jpeces.comuns.Constants;
import org.demarchi.jpeces.peces.Peca;

public class ConjuntDePeces
extends Observable
implements Observer,
Constants {
    public Peca[] arrayPeces;
    private int rotacioQuadrant;
    private double rotacioAngleInicial;
    private boolean visible = true;
    public double escala = 55.0;
    private Color colorPeces = Color.WHITE;
    private Configuracio configuracioConjuntPeces;
    public int tTangram;

    public ConjuntDePeces(Configuracio config, Container contenidor, Observer observador, double pescala, Color pColorPeces) {
        this.colorPeces = pColorPeces;
        this.configuracioConjuntPeces = config;
        this.tTangram = this.configuracioConjuntPeces.configuracioJoc.tipusTangram;
        this.CreaConjunt(this.configuracioConjuntPeces.configuracioJoc.tipusTangram, contenidor, observador, null, pescala);
    }

    public ConjuntDePeces(int tipusTangram, Container contenidor, Observer observador, double pescala) {
        this.tTangram = tipusTangram;
        this.CreaConjunt(tipusTangram, contenidor, observador, null, pescala);
    }

    public ConjuntDePeces(Configuracio config, Container contenidor, Observer observador, String dades, double pescala, Color pColorPeces) {
        this.colorPeces = pColorPeces;
        this.configuracioConjuntPeces = config;
        this.CreaConjunt(this.configuracioConjuntPeces.configuracioJoc.tipusTangram, contenidor, observador, dades, pescala);
    }

    private void CreaConjunt(int tipusTangram, Container contenidor, Observer observador, String dades, double pescala) {
        this.escala = pescala;
        this.addObserver(observador);
        switch (tipusTangram) {
            case 14: {
                this.arrayPeces = new Peca[3];
                break;
            }
            case 19: {
                this.arrayPeces = new Peca[4];
                break;
            }
            case 30: {
                this.arrayPeces = new Peca[4];
                break;
            }
            case 2: 
            case 25: 
            case 27: 
            case 36: {
                this.arrayPeces = new Peca[5];
                break;
            }
            case 3: 
            case 15: 
            case 23: {
                this.arrayPeces = new Peca[6];
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 21: 
            case 24: 
            case 26: {
                this.arrayPeces = new Peca[7];
                break;
            }
            case 7: 
            case 22: 
            case 34: 
            case 37: 
            case 38: {
                this.arrayPeces = new Peca[8];
                break;
            }
            case 8: 
            case 16: 
            case 17: 
            case 28: {
                this.arrayPeces = new Peca[9];
                break;
            }
            case 9: 
            case 20: 
            case 29: 
            case 33: {
                this.arrayPeces = new Peca[10];
                break;
            }
            case 10: 
            case 32: {
                this.arrayPeces = new Peca[11];
                break;
            }
            case 11: 
            case 35: {
                this.arrayPeces = new Peca[12];
                break;
            }
            case 12: {
                this.arrayPeces = new Peca[13];
                break;
            }
            case 13: 
            case 18: 
            case 31: {
                this.arrayPeces = new Peca[14];
                break;
            }
            case 39: {
                this.arrayPeces = new Peca[16];
                break;
            }
            default: {
                this.arrayPeces = new Peca[7];
                tipusTangram = 1;
            }
        }
        if (dades == null) {
            this.creaJocPeces(tipusTangram, contenidor, this.escala);
        } else {
            this.colocaPeces(dades, contenidor);
        }
    }

    public boolean rotaPeca(int indexPecaSeleccionada, int ratoli_x, int ratoli_y, Rectangle tamany) {
        if (this.configuracioConjuntPeces.configuracioJoc.nivellJoc >= 3) {
            Point ratoli = new Point(ratoli_x, ratoli_y);
            double angleGirActual = this.arrayPeces[indexPecaSeleccionada].angleRadi(this.arrayPeces[indexPecaSeleccionada].centrePeca(), ratoli);
            double angleGir = this.rotacioAngleInicial - angleGirActual;
            this.rotacioAngleInicial = angleGirActual;
            return this.arrayPeces[indexPecaSeleccionada].rotaPeca(Math.toRadians(angleGir), tamany);
        }
        return this.arrayPeces[indexPecaSeleccionada].rotaPeca(Math.toRadians(this.configuracioConjuntPeces.configuracioJoc.angleRotacio * this.anglePuntCentrePeca(ratoli_x, ratoli_y, indexPecaSeleccionada)), tamany);
    }

    public boolean mouPeca(int indexPecaSeleccionada, int ratoli_x, int ratoli_y, Rectangle tamany) {
        boolean moguda = false;
        moguda = this.arrayPeces[indexPecaSeleccionada].mouPeca(ratoli_x, ratoli_y, tamany);
        return moguda;
    }

    public Point aferraPeca() {
        Polygon[] poli = new Polygon[this.arrayPeces.length];
        Point desplacament = new Point(0, 0);
        for (int i = 0; i <= poli.length - 1; ++i) {
            poli[i] = this.arrayPeces[i].emetPoligon(1.0);
        }
        double distanciaActual = 10000.0;
        for (int i = 0; i <= poli[poli.length - 1].npoints - 1; ++i) {
            for (int j = 0; j <= poli.length - 2; ++j) {
                for (int k = 0; k <= poli[j].npoints - 1; ++k) {
                    double distancia = 1000.0;
                    distancia = Math.sqrt(Math.pow(poli[poli.length - 1].xpoints[i] - poli[j].xpoints[k], 2.0) + Math.pow(poli[poli.length - 1].ypoints[i] - poli[j].ypoints[k], 2.0));
                    if (!(distancia <= 5.0 & distanciaActual > distancia)) continue;
                    distanciaActual = distancia;
                    desplacament.x = poli[j].xpoints[k] - poli[poli.length - 1].xpoints[i];
                    desplacament.y = poli[j].ypoints[k] - poli[poli.length - 1].ypoints[i];
                }
            }
        }
        return desplacament;
    }

    public int seleccionaPeca(int x, int y) {
        int index = -1;
        index = this.hihaPeca(x, y, this.arrayPeces);
        if (index > -1 & index < this.arrayPeces.length - 1) {
            index = this.recolocaArrayPeces(index);
        }
        return index;
    }

    public int recolocaArrayPeces(int indexPeca) {
        Peca pecaSeleccionada = this.arrayPeces[indexPeca];
        for (int i = indexPeca + 1; i <= this.arrayPeces.length - 1; ++i) {
            this.arrayPeces[i - 1] = this.arrayPeces[i];
        }
        this.arrayPeces[this.arrayPeces.length - 1] = pecaSeleccionada;
        indexPeca = this.arrayPeces.length - 1;
        return indexPeca;
    }

    private int hihaPeca(int x, int y, Peca[] arrayPeces) {
        int index = -1;
        for (int i = arrayPeces.length - 1; i >= 0; --i) {
            if (!arrayPeces[i].puntInteriorPeca(x, y)) continue;
            index = i;
            break;
        }
        return index;
    }

    public void recolocaConjuntPeces(ConjuntDePeces conjunt, Container contenidor) {
        Point vertexSupEsqParam = this.vertexSuperiorEsquerra(conjunt.arrayPeces);
        Point vertexSupEsq = this.vertexSuperiorEsquerra(this.arrayPeces);
        Rectangle tamany = contenidor.getBounds();
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            conjunt.arrayPeces[i].mouPeca(vertexSupEsq.x - vertexSupEsqParam.x, vertexSupEsq.y - vertexSupEsqParam.y, tamany);
        }
    }

    public void recolocaConjuntPeces(ConjuntDePeces conjunt) {
        Point vertexSupEsqParam = this.vertexSuperiorEsquerra(conjunt.arrayPeces);
        Point vertexSupEsq = this.vertexSuperiorEsquerra(this.arrayPeces);
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            conjunt.arrayPeces[i].mouPecaSenseLimits(vertexSupEsq.x - vertexSupEsqParam.x, vertexSupEsq.y - vertexSupEsqParam.y);
        }
    }

    public void recolocaConjuntPeces(Container contenidor) {
        Rectangle tamany = contenidor.getBounds();
        Random c = new Random();
        int x = c.nextInt(500);
        int y = c.nextInt(300);
        Point vertexSupEsq = this.vertexSuperiorEsquerra(this.arrayPeces);
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            this.arrayPeces[i].mouPecaSenseLimits(x - vertexSupEsq.x, y - vertexSupEsq.y);
        }
    }

    public void centraFiguraPanell(Container contenidor) {
        Point vectorPosicio = new Point();
        Point centreFigura = new Point();
        Point centrePanell = new Point();
        Point vertexSuperiorEsquerra = this.vertexSuperiorEsquerra(this.arrayPeces);
        Point vertexInferiorDreta = this.vertexInferiorDreta(this.arrayPeces);
        centreFigura.x = Math.round((vertexSuperiorEsquerra.x + vertexInferiorDreta.x) / 2);
        centreFigura.y = Math.round((vertexSuperiorEsquerra.y + vertexInferiorDreta.y) / 2);
        Rectangle tamany = contenidor.getBounds();
        centrePanell.x = Math.round(tamany.width / 2);
        centrePanell.y = Math.round(tamany.height / 2);
        vectorPosicio.x = centrePanell.x - centreFigura.x;
        vectorPosicio.y = centrePanell.y - centreFigura.y;
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            this.arrayPeces[i].colocaPeca(this.arrayPeces[i].posicio_X + vectorPosicio.x, this.arrayPeces[i].posicio_Y + vectorPosicio.y);
        }
    }

    public Point vertexSuperiorEsquerra(Peca[] arrayDePeces) {
        int i;
        Point vertexSuperiorEsquerra = new Point(10000, 10000);
        Polygon[] poligons = new Polygon[arrayDePeces.length];
        for (i = 0; i <= arrayDePeces.length - 1; ++i) {
            poligons[i] = arrayDePeces[i].emetPoligon(1.01);
        }
        for (i = 0; i <= poligons.length - 1; ++i) {
            for (int j = 0; j <= poligons[i].npoints - 1; ++j) {
                vertexSuperiorEsquerra.x = Math.min(poligons[i].xpoints[j], vertexSuperiorEsquerra.x);
                vertexSuperiorEsquerra.y = Math.min(poligons[i].ypoints[j], vertexSuperiorEsquerra.y);
            }
        }
        return vertexSuperiorEsquerra;
    }

    public Point vertexInferiorDreta(Peca[] arrayDePeces) {
        int i;
        Point vertexInferiorDreta = new Point(0, 0);
        Polygon[] poligons = new Polygon[arrayDePeces.length];
        for (i = 0; i <= arrayDePeces.length - 1; ++i) {
            poligons[i] = arrayDePeces[i].emetPoligon(1.0);
        }
        for (i = 0; i <= poligons.length - 1; ++i) {
            for (int j = 0; j <= poligons[i].npoints - 1; ++j) {
                vertexInferiorDreta.x = Math.max(poligons[i].xpoints[j], vertexInferiorDreta.x);
                vertexInferiorDreta.y = Math.max(poligons[i].ypoints[j], vertexInferiorDreta.y);
            }
        }
        return vertexInferiorDreta;
    }

    public String coordenadesFigura() {
        Point vertexSuperiorEsquerra = this.vertexSuperiorEsquerra(this.arrayPeces);
        String coordenadesFigura = this.escala + " ";
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            coordenadesFigura = coordenadesFigura + this.arrayPeces[i].cadenaPropietatsPeca(vertexSuperiorEsquerra);
        }
        return coordenadesFigura;
    }

    public void simetriaVertical(Container contenidor) {
        this.centraFiguraPanell(contenidor);
        int valor = Math.round(contenidor.getWidth() / 2);
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            this.arrayPeces[i].colocaPeca(2 * valor - this.arrayPeces[i].posicio_X, this.arrayPeces[i].posicio_Y);
            this.arrayPeces[i].simetriaPeca();
        }
        this.centraFiguraPanell(contenidor);
    }

    public void simetriaHoritzontal(Container contenidor) {
        this.centraFiguraPanell(contenidor);
        int valor = Math.round(contenidor.getHeight() / 2);
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            this.arrayPeces[i].colocaPeca(this.arrayPeces[i].posicio_X, 2 * valor - this.arrayPeces[i].posicio_Y);
            this.arrayPeces[i].rotaPeca(Math.PI);
            this.arrayPeces[i].simetriaPeca();
        }
    }

    public void iniciRotacioPeca(int coordRatoli_x, int coordRatoli_y, int indexPecaSeleccionada) {
        if (this.configuracioConjuntPeces.configuracioJoc.nivellJoc < 3) {
            this.rotacioQuadrant = 0;
            this.rotacioAngleInicial = this.anglePuntCentrePeca(coordRatoli_x, coordRatoli_y, indexPecaSeleccionada);
        } else {
            Point ratoli = new Point(coordRatoli_x, coordRatoli_y);
            this.rotacioAngleInicial = this.arrayPeces[indexPecaSeleccionada].angleRadi(this.arrayPeces[indexPecaSeleccionada].centrePeca(), ratoli);
        }
    }

    private double anglePuntCentrePeca(int x, int y, int peca) {
        Point centrePeca = this.arrayPeces[peca].centrePeca();
        double angleRotacio = this.rotacioAngleInicial;
        double angle = 0.0;
        double rotacio = 0.0;
        if (x >= centrePeca.x & y <= centrePeca.y) {
            if (this.rotacioQuadrant == 1) {
                angle = Math.atan2(centrePeca.y - y, x - centrePeca.x);
                rotacio = Math.signum(angle - this.rotacioAngleInicial);
                this.rotacioAngleInicial = angle;
            } else if (1 - this.rotacioQuadrant >= -2) {
                rotacio = -1.0;
                this.rotacioAngleInicial = Math.atan2(centrePeca.y - y, x - centrePeca.x);
            } else if (this.rotacioQuadrant == 4) {
                rotacio = 1.0;
                this.rotacioAngleInicial = Math.atan2(centrePeca.y - y, x - centrePeca.x);
            }
            this.rotacioQuadrant = 1;
        } else if (x < centrePeca.x & y <= centrePeca.y) {
            if (this.rotacioQuadrant == 2) {
                angle = Math.atan2(centrePeca.y - y, x - centrePeca.x);
                rotacio = Math.signum(angle - this.rotacioAngleInicial);
                this.rotacioAngleInicial = angle;
            } else if (this.rotacioQuadrant == 1) {
                rotacio = 1.0;
                this.rotacioAngleInicial = 1.5707963267948966 + Math.atan2(centrePeca.y - y, centrePeca.x - x);
            } else if (2 - this.rotacioQuadrant >= -2) {
                rotacio = -1.0;
                this.rotacioAngleInicial = 1.5707963267948966 + Math.atan2(centrePeca.y - y, centrePeca.x - x);
            }
            this.rotacioQuadrant = 2;
        } else if (x < centrePeca.x & y >= centrePeca.y) {
            if (this.rotacioQuadrant == 3) {
                angle = Math.atan2(centrePeca.y - y, x - centrePeca.x);
                rotacio = Math.signum(angle - this.rotacioAngleInicial);
                this.rotacioAngleInicial = angle;
            } else if (this.rotacioQuadrant == 4) {
                rotacio = -1.0;
                this.rotacioAngleInicial = 1.5707963267948966 + Math.atan2(centrePeca.y - y, centrePeca.x - x);
            } else if (3 - this.rotacioQuadrant >= 1) {
                rotacio = 1.0;
                this.rotacioAngleInicial = 1.5707963267948966 + Math.atan2(centrePeca.y - y, centrePeca.x - x);
            }
            this.rotacioQuadrant = 3;
        } else {
            if (this.rotacioQuadrant == 4) {
                angle = Math.PI * 2 + Math.atan2(centrePeca.y - y, x - centrePeca.x);
                rotacio = Math.signum(angle - this.rotacioAngleInicial);
                this.rotacioAngleInicial = angle;
            } else if (this.rotacioQuadrant == 1) {
                rotacio = -1.0;
                this.rotacioAngleInicial = 1.5707963267948966 + Math.atan2(centrePeca.y - y, centrePeca.x - x);
            } else if (4 - this.rotacioQuadrant >= 1) {
                rotacio = 1.0;
                this.rotacioAngleInicial = 1.5707963267948966 + Math.atan2(centrePeca.y - y, centrePeca.x - x);
            }
            this.rotacioQuadrant = 4;
        }
        return -rotacio;
    }

    public void estableixVisible(boolean valor) {
        this.visible = valor;
        this.aCanviat();
    }

    public boolean emetVisible() {
        return this.visible;
    }

    public void creaJocPeces(int tipus, Container contenidor, double escala) {
        switch (tipus) {
            case 19: {
                this.arrayPeces[0] = new Peca(56, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(58, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(59, contenidor, this, escala);
                break;
            }
            case 30: {
                this.arrayPeces[0] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(85, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(85, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(86, contenidor, this, escala);
                break;
            }
            case 27: {
                this.arrayPeces[0] = new Peca(78, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(74, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(75, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(76, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(77, contenidor, this, escala);
                break;
            }
            case 25: {
                this.arrayPeces[0] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(13, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(16, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(12, contenidor, this, escala);
                break;
            }
            case 23: {
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(5, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(70, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(71, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(72, contenidor, this, escala);
                break;
            }
            case 21: {
                this.arrayPeces[0] = new Peca(21, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(21, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(24, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(24, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(64, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(65, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(66, contenidor, this, escala);
                break;
            }
            case 24: {
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(5, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(70, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(13, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(73, contenidor, this, escala);
                break;
            }
            case 26: {
                this.arrayPeces[0] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(13, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(12, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(5, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(5, contenidor, this, escala);
                break;
            }
            case 1: {
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(4, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(4, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(5, contenidor, this, escala);
                break;
            }
            case 2: {
                this.arrayPeces[0] = new Peca(7, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(4, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(6, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(6, contenidor, this, escala);
                break;
            }
            case 3: {
                this.arrayPeces[0] = new Peca(10, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(11, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(8, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(9, contenidor, this, escala);
                break;
            }
            case 4: {
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(8, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(12, contenidor, this, escala);
                break;
            }
            case 5: {
                this.arrayPeces[0] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(13, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(14, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(15, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(15, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(16, contenidor, this, escala);
                break;
            }
            case 6: {
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(5, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(13, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(17, contenidor, this, escala);
                break;
            }
            case 7: {
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(13, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(14, contenidor, this, escala);
                break;
            }
            case 22: {
                this.arrayPeces[0] = new Peca(22, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(64, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(65, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(67, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(67, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(67, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(68, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(69, contenidor, this, escala);
                break;
            }
            case 8: {
                this.arrayPeces[0] = new Peca(18, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(18, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(18, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(19, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(19, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(19, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(19, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(20, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(20, contenidor, this, escala);
                break;
            }
            case 28: {
                escala = 1.5 * escala;
                this.arrayPeces[0] = new Peca(79, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(79, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(80, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(80, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(81, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(82, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(83, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(84, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(84, contenidor, this, escala);
                break;
            }
            case 9: {
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(17, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(21, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(21, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(22, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(22, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(23, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(23, contenidor, this, escala);
                break;
            }
            case 29: {
                this.arrayPeces[0] = new Peca(74, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(74, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(74, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(74, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(74, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(76, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(76, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(76, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(76, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(76, contenidor, this, escala);
                break;
            }
            case 33: {
                this.arrayPeces[0] = new Peca(15, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(15, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(15, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(15, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(3, contenidor, this, escala);
                break;
            }
            case 20: {
                this.arrayPeces[0] = new Peca(60, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(60, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(60, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(60, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(61, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(61, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(62, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(62, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(63, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(63, contenidor, this, escala);
                break;
            }
            case 10: {
                this.arrayPeces[0] = new Peca(23, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(23, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(23, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(22, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(22, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(22, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(22, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(24, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(24, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(25, contenidor, this, escala);
                this.arrayPeces[10] = new Peca(25, contenidor, this, escala);
                break;
            }
            case 11: {
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(13, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(15, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(26, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(26, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(26, contenidor, this, escala);
                this.arrayPeces[10] = new Peca(27, contenidor, this, escala);
                this.arrayPeces[11] = new Peca(27, contenidor, this, escala);
                break;
            }
            case 12: {
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[10] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[11] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[12] = new Peca(2, contenidor, this, escala);
                break;
            }
            case 13: {
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(4, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(4, contenidor, this, escala);
                this.arrayPeces[10] = new Peca(4, contenidor, this, escala);
                this.arrayPeces[11] = new Peca(4, contenidor, this, escala);
                this.arrayPeces[12] = new Peca(5, contenidor, this, escala);
                this.arrayPeces[13] = new Peca(5, contenidor, this, escala);
                break;
            }
            case 14: {
                this.arrayPeces[0] = new Peca(28, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(29, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(30, contenidor, this, escala);
                break;
            }
            case 15: {
                this.arrayPeces[0] = new Peca(31, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(32, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(33, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(34, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(35, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(36, contenidor, this, escala);
                break;
            }
            case 16: {
                this.arrayPeces[0] = new Peca(37, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(37, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(38, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(38, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(39, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(39, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(40, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(40, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(41, contenidor, this, escala);
                break;
            }
            case 17: {
                this.arrayPeces[0] = new Peca(42, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(42, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(42, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(43, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(43, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(13, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(5, contenidor, this, escala);
                break;
            }
            case 32: {
                this.arrayPeces[0] = new Peca(54, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(45, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(46, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(47, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(48, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(46, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(76, contenidor, this, 1.175 * escala);
                this.arrayPeces[7] = new Peca(90, contenidor, this, 1.175 * escala);
                this.arrayPeces[8] = new Peca(53, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(45, contenidor, this, escala);
                this.arrayPeces[10] = new Peca(48, contenidor, this, escala);
                break;
            }
            case 18: {
                this.arrayPeces[0] = new Peca(44, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(45, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(46, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(47, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(48, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(49, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(50, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(51, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(52, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(45, contenidor, this, escala);
                this.arrayPeces[10] = new Peca(48, contenidor, this, escala);
                this.arrayPeces[11] = new Peca(53, contenidor, this, escala);
                this.arrayPeces[12] = new Peca(54, contenidor, this, escala);
                this.arrayPeces[13] = new Peca(55, contenidor, this, escala);
                break;
            }
            case 31: {
                escala = 0.9 * escala;
                this.arrayPeces[0] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(74, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(87, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(88, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(89, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(90, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(90, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(91, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(91, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(91, contenidor, this, escala);
                this.arrayPeces[10] = new Peca(92, contenidor, this, escala);
                this.arrayPeces[11] = new Peca(93, contenidor, this, escala);
                this.arrayPeces[12] = new Peca(94, contenidor, this, escala);
                this.arrayPeces[13] = new Peca(95, contenidor, this, escala);
                break;
            }
            case 34: {
                this.arrayPeces[0] = new Peca(31, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(32, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(34, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(35, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(36, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(21, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(100, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(57, contenidor, this, escala);
                break;
            }
            case 35: {
                escala = 1.5 * escala;
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(13, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(15, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(26, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(96, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(96, contenidor, this, escala);
                this.arrayPeces[10] = new Peca(97, contenidor, this, escala);
                this.arrayPeces[11] = new Peca(97, contenidor, this, escala);
                break;
            }
            case 36: {
                this.arrayPeces[0] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(16, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(4, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(98, contenidor, this, escala);
                break;
            }
            case 37: {
                this.arrayPeces[0] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(13, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(14, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(15, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(15, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(99, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(99, contenidor, this, escala);
                break;
            }
            case 38: {
                escala = 1.3 * escala;
                this.arrayPeces[0] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(13, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(12, contenidor, this, escala);
                break;
            }
            case 39: {
                escala = 1.0 * escala;
                this.arrayPeces[0] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[7] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[8] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[9] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[10] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[11] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[12] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[13] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[14] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[15] = new Peca(2, contenidor, this, escala);
                break;
            }
            default: {
                this.arrayPeces[0] = new Peca(1, contenidor, this, escala);
                this.arrayPeces[1] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[2] = new Peca(2, contenidor, this, escala);
                this.arrayPeces[3] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[4] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[5] = new Peca(3, contenidor, this, escala);
                this.arrayPeces[6] = new Peca(7, contenidor, this, escala);
            }
        }
        this.aCanviat();
    }

    public void colocaPeces(String dades, Container contenidor) {
        if (dades != null) {
            StringTokenizer st = new StringTokenizer(dades);
            double pescala = Double.parseDouble(st.nextToken());
            pescala /= this.escala;
            for (int i = this.arrayPeces.length - 1; i >= 0; --i) {
                int tipusPeca = Integer.parseInt(st.nextToken());
                int posX = (int)Math.round(Double.parseDouble(st.nextToken()) / pescala);
                int posY = (int)Math.round(Double.parseDouble(st.nextToken()) / pescala);
                double angle = -Double.parseDouble(st.nextToken());
                int simetria = Integer.parseInt(st.nextToken());
                if (this.tTangram == 28) {
                    this.arrayPeces[i] = new Peca(tipusPeca, posX, posY, angle, simetria, this, true, this.escala * 1.5);
                    continue;
                }
                if (this.tTangram == 32) {
                    if (tipusPeca == 76 || tipusPeca == 90) {
                        this.arrayPeces[i] = new Peca(tipusPeca, posX, posY, angle, simetria, this, true, this.escala * 1.175);
                        continue;
                    }
                    this.arrayPeces[i] = new Peca(tipusPeca, posX, posY, angle, simetria, this, true, this.escala);
                    continue;
                }
                this.arrayPeces[i] = this.tTangram == 31 ? new Peca(tipusPeca, posX, posY, angle, simetria, this, true, this.escala * 0.9) : (this.tTangram == 35 ? new Peca(tipusPeca, posX, posY, angle, simetria, this, true, this.escala * 1.5) : (this.tTangram == 38 ? new Peca(tipusPeca, posX, posY, angle, simetria, this, true, this.escala * 1.3) : new Peca(tipusPeca, posX, posY, angle, simetria, this, true, this.escala)));
            }
        }
        this.colorPecesConjunt(this.colorPeces);
        this.centraFiguraPanell(contenidor);
        this.visible = true;
    }

    public void colocaPecesAtzar(Container contenidor) {
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            this.arrayPeces[i].colocaPecaAtzar(contenidor);
        }
    }

    public void colorPecesConjunt(Color colorPeces) {
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            this.arrayPeces[i].estableixColorPeca(colorPeces);
            this.arrayPeces[i].estableixColorCostats(colorPeces);
        }
    }

    public void colorAtzarPecesConjunt() {
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            this.arrayPeces[i].colorsPerDefecte();
            this.arrayPeces[i].estableixColorCostats(this.arrayPeces[i].emetColorPeca());
        }
    }

    public void colorPecesLimits(Color colorPeces) {
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            this.arrayPeces[i].estableixColorCostats(colorPeces);
        }
    }

    public void figuraResolta() {
        for (int i = 0; i <= this.arrayPeces.length - 1; ++i) {
            this.colorPecesConjunt(Color.GREEN);
        }
    }

    public void aCanviat() {
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void update(Observable o, Object arg) {
        this.aCanviat();
    }
}

