/*
 * Decompiled with CFR 0.152.
 */
package org.demarchi.jpeces.peces;

import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.Rectangle2D;
import java.util.Observable;
import java.util.Observer;
import java.util.Random;
import org.demarchi.jpeces.comuns.Constants;

public class Peca
extends Observable
implements Constants,
Cloneable {
    private int numeroVertex = 4;
    public int tipusPeca = 1;
    private double[] modulsVertex;
    public double[] anglesVertex;
    public boolean ambArc = false;
    public double centreArc = 0.0;
    public double angleCentreArc = 0.0;
    public double radiArc = 0.0;
    public Point iniciFinalArc = new Point();
    public double angleInicial;
    public double angleRotacio = 0.0;
    public boolean simetriaBool;
    public int posicio_X = 0;
    public int posicio_Y = 0;
    private double escala = 55.0;
    private double escalaStomachion = 1.1;
    private int escalaBasica = 1;
    private Color colorPeca;
    private Color colorCostats;
    private final double a = 3.236068;
    private final double b = 2.5440393;
    private final double c = 2.0;
    private final double d = 1.5723027;
    private final double e = 1.236068;
    private final double o = 2.0 - Math.sqrt(2.0);

    public Peca() {
        this.creaPeca(1);
    }

    public Peca(int tipusPeca) {
        this.creaPeca(tipusPeca);
    }

    public Peca(int tipusPeca, Container contenidor, Observer observador, double pescala) {
        this.escala = pescala;
        this.creaPeca(tipusPeca);
        this.colocaPecaAtzar(contenidor);
        this.colorsPerDefecte();
        this.addObserver(observador);
    }

    public Peca(int tipusPeca, int posicio_X, int posicio_Y, double angle, int simetria, Observer observador, boolean montaFigura, double pescala) {
        this.escala = pescala;
        this.creaPeca(tipusPeca);
        this.colocaPeca(posicio_X, posicio_Y);
        if (montaFigura && simetria == 1) {
            this.simetriaPeca();
        }
        this.estableixAngleRotacio(-angle);
        if (!montaFigura && simetria == 1) {
            this.simetriaPeca();
        }
        this.colorsPerDefecte();
        this.addObserver(observador);
    }

    public void colorsPerDefecte() {
        Random num = new Random();
        Color col = new Color(num.nextInt(255) + 1, num.nextInt(255) + 1, num.nextInt(255) + 1);
        this.estableixColorPeca(col);
    }

    public Polygon emetPoligon(double reduccio) {
        int[] vertex_x = new int[this.numeroVertex];
        int[] vertex_y = new int[this.numeroVertex];
        for (int i = 0; i <= this.numeroVertex - 1; ++i) {
            vertex_x[i] = (int)Math.round(reduccio * this.escala * this.modulsVertex[i] * Math.cos(this.normalitzaAngle(this.anglesVertex[i]))) + this.posicio_X;
            vertex_y[i] = (int)Math.round(reduccio * this.escala * this.modulsVertex[i] * Math.sin(this.normalitzaAngle(this.anglesVertex[i]))) + this.posicio_Y;
        }
        Polygon poligonPeca = new Polygon(vertex_x, vertex_y, this.numeroVertex);
        return poligonPeca;
    }

    public void estableixTipusPeca(int tipus) {
        this.tipusPeca = tipus;
        this.creaPeca(this.tipusPeca);
    }

    public void colocaPeca(int coord_X, int coord_Y) {
        this.posicio_X = coord_X;
        this.posicio_Y = coord_Y;
    }

    public void colocaPecaAtzar(Container contenidor) {
        Rectangle tamany = contenidor.getBounds();
        Random cpa = new Random();
        this.colocaPeca(cpa.nextInt(tamany.width), cpa.nextInt(tamany.height));
        this.reiniciaAnglesVertex();
        this.estableixAngleRotacio(-this.normalitzaAngle((double)(cpa.nextInt(3) + 1) * Math.PI / 4.0));
        while (!this.pecaEnLimits(tamany)) {
            this.colocaPeca(cpa.nextInt(tamany.width), cpa.nextInt(tamany.height));
            this.estableixAngleRotacio(-this.normalitzaAngle((double)(cpa.nextInt(3) + 1) * Math.PI / 4.0));
        }
    }

    public boolean mouPeca(int moviment_X, int moviment_Y, Rectangle tamany) {
        int posAnterior_X = this.posicio_X;
        int posAnterior_Y = this.posicio_Y;
        this.posicio_X += moviment_X;
        this.posicio_Y += moviment_Y;
        if (this.pecaEnLimits(tamany)) {
            this.aCanviat();
            return true;
        }
        this.posicio_X = posAnterior_X;
        this.posicio_Y = posAnterior_Y;
        return false;
    }

    public void mouPecaSenseLimits(int moviment_X, int moviment_Y) {
        this.posicio_X += moviment_X;
        this.posicio_Y += moviment_Y;
        this.aCanviat();
    }

    public void estableixAngleRotacio(double angle) {
        this.angleRotacio = -angle;
        this.actualitzaAnglesVertex(angle);
        this.aCanviat();
    }

    public boolean rotaPeca(double angle, Rectangle tamany) {
        double angleAnterior = this.angleRotacio;
        this.angleRotacio -= angle;
        this.actualitzaAnglesVertex(angle);
        if (this.pecaEnLimits(tamany)) {
            this.aCanviat();
            return true;
        }
        this.angleRotacio = angleAnterior;
        this.actualitzaAnglesVertex(-angle);
        return false;
    }

    public void rotaPeca(double angle) {
        this.angleRotacio -= angle;
        this.actualitzaAnglesVertex(angle);
    }

    private boolean pecaEnLimits(Rectangle tamany) {
        Polygon pecaMoguda = this.emetPoligon(1.0);
        Rectangle dimPeca = pecaMoguda.getBounds();
        return tamany.x <= dimPeca.x + tamany.x & tamany.y <= dimPeca.y + tamany.y & tamany.x + tamany.width >= dimPeca.x + dimPeca.width + tamany.x & tamany.y + tamany.height >= dimPeca.y + dimPeca.height + tamany.y;
    }

    public void reiniciaAnglesVertex() {
        this.simetriaBool = false;
        this.anglesInicialsPeca(this.tipusPeca);
        this.angleRotacio = 0.0;
    }

    private void actualitzaAnglesVertex(double angle) {
        for (int i = 0; i <= this.numeroVertex - 1; ++i) {
            this.anglesVertex[i] = this.normalitzaAngle(this.anglesVertex[i] + angle);
        }
        if (this.ambArc) {
            this.angleCentreArc = this.normalitzaAngle(this.angleCentreArc + angle);
        }
    }

    public void canviaSimetriaPeca() {
        this.simetriaBool = !this.simetriaBool;
    }

    public void simetriaPeca() {
        for (int i = 0; i <= this.numeroVertex - 1; ++i) {
            this.anglesVertex[i] = this.anglesVertex[i] <= Math.PI & this.anglesVertex[i] >= 0.0 ? Math.PI - this.anglesVertex[i] : Math.PI * 3 - this.anglesVertex[i];
        }
        this.angleInicial = this.angleInicial <= Math.PI & this.angleInicial >= 0.0 ? Math.PI - this.angleInicial : Math.PI * 3 - this.angleInicial;
        if (this.ambArc) {
            this.angleCentreArc = this.angleCentreArc <= Math.PI & this.angleCentreArc >= 0.0 ? Math.PI - this.angleCentreArc : Math.PI * 3 - this.angleCentreArc;
        }
        this.simetriaBool = !this.simetriaBool;
        this.aCanviat();
    }

    public boolean puntInteriorPeca(int punt_x, int punt_y) {
        boolean retorn = false;
        Polygon poligon = this.emetPoligon(1.0);
        retorn = poligon.contains(punt_x, punt_y);
        if (this.ambArc & !retorn) {
            Arc2D.Double arc = this.emetArcPeca(1.0);
            retorn = arc.contains(punt_x, punt_y);
        }
        return retorn;
    }

    public double normalitzaAngle(double angle) {
        if (angle < 0.0) {
            angle += Math.PI * 2;
        }
        return angle %= Math.PI * 2;
    }

    public Point centrePeca() {
        Point centre = new Point();
        Polygon peca = this.emetPoligon(1.0);
        switch (peca.npoints) {
            case 3: {
                centre.x = (peca.xpoints[0] + peca.xpoints[1] + peca.xpoints[2]) / 3;
                centre.y = (peca.ypoints[0] + peca.ypoints[1] + peca.ypoints[2]) / 3;
                break;
            }
            case 4: {
                centre.x = (peca.xpoints[0] + peca.xpoints[2]) / 2;
                centre.y = (peca.ypoints[0] + peca.ypoints[2]) / 2;
                break;
            }
            default: {
                Rectangle rect = peca.getBounds();
                centre.x = rect.x + Math.round(rect.width / 2);
                centre.y = rect.y + Math.round(rect.height / 2);
            }
        }
        return centre;
    }

    public Point coordenadesCentreArc(double reduccio) {
        Point punt = new Point();
        punt.x = (int)Math.round(reduccio * this.escala * this.centreArc * Math.cos(this.normalitzaAngle(this.angleCentreArc))) + this.posicio_X;
        punt.y = (int)Math.round(reduccio * this.escala * this.centreArc * Math.sin(this.normalitzaAngle(this.angleCentreArc))) + this.posicio_Y;
        return punt;
    }

    public void estableixEscala(double escala_int) {
        this.escala = escala_int;
    }

    public double emetEscala() {
        return this.escala;
    }

    public void estableixColorPeca(Color color) {
        this.colorPeca = color;
    }

    public Color emetColorPeca() {
        return this.colorPeca;
    }

    public int emetColorPeca_int() {
        return this.colorPeca.getRGB();
    }

    public void estableixColorPeca(int color) {
        this.colorPeca = new Color(color);
    }

    public void estableixColorCostats(Color color) {
        this.colorCostats = color;
    }

    public Color emetColorCostats() {
        return this.colorCostats;
    }

    public int emetColorCostats_int() {
        return this.colorCostats.getRGB();
    }

    public void estableixColorCostats(int color) {
        this.colorCostats = new Color(color);
    }

    public void aCanviat() {
        this.setChanged();
        this.notifyObservers();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException excep) {
            return this;
        }
    }

    public String cadenaPropietatsPeca(Point vertexSuperiorEsquerra) {
        String cadena = this.tipusPeca + " ";
        cadena = cadena + (this.posicio_X - vertexSuperiorEsquerra.x) + " " + (this.posicio_Y - vertexSuperiorEsquerra.y) + " ";
        cadena = cadena + (this.anglesVertex[0] - this.angleInicial) + " ";
        cadena = this.simetriaBool ? cadena + "1 " : cadena + "0 ";
        return cadena;
    }

    private void creaPeca(int tipusPeca) {
        this.angleRotacio = 0.0;
        switch (tipusPeca) {
            case 69: {
                this.numeroVertex = 2;
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 23: 
            case 27: 
            case 31: 
            case 32: 
            case 36: 
            case 40: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 64: 
            case 65: 
            case 73: 
            case 76: 
            case 78: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 97: 
            case 99: 
            case 100: {
                this.numeroVertex = 4;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 10: 
            case 11: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 67: 
            case 68: 
            case 74: 
            case 75: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 89: 
            case 90: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                this.numeroVertex = 3;
                break;
            }
            case 16: 
            case 53: 
            case 59: 
            case 66: 
            case 70: 
            case 71: 
            case 92: 
            case 98: {
                this.numeroVertex = 5;
                break;
            }
            case 35: 
            case 72: 
            case 77: {
                this.numeroVertex = 6;
                break;
            }
            default: {
                this.numeroVertex = 4;
                tipusPeca = 1;
                this.simetriaBool = false;
            }
        }
        this.modulsVertex = new double[this.numeroVertex];
        this.anglesVertex = new double[this.numeroVertex];
        this.creaPeces(tipusPeca);
    }

    public void creaPeces(int tPeca) {
        this.tipusPeca = tPeca;
        this.simetriaBool = false;
        switch (tPeca) {
            case 56: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(2.25);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(2.25);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt((13.0 - 8.0 * Math.sqrt(2.0)) / 4.0);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(2.25);
                break;
            }
            case 58: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.75);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.75);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt((7.0 - 4.0 * Math.sqrt(2.0)) / 4.0);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(0.75);
                break;
            }
            case 59: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(2.25);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt((13.0 - 8.0 * Math.sqrt(2.0)) / 4.0);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(1.25);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt((5.0 - 2.0 * Math.sqrt(2.0)) / 4.0);
                this.modulsVertex[4] = (double)this.escalaBasica * Math.sqrt(2.25);
                break;
            }
            case 85: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.625);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.625);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(1.125);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(1.625);
                break;
            }
            case 86: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(2.25);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.25);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(2.25);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(1.25);
                break;
            }
            case 74: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.2777777777777778);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.9444444444444444);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.4444444444444444);
                break;
            }
            case 75: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.3888888888888888);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(4.722222222222222);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(2.2222222222222223);
                break;
            }
            case 78: {
                this.modulsVertex[0] = 1.0;
                this.modulsVertex[1] = 1.0;
                this.modulsVertex[2] = 1.0;
                this.modulsVertex[3] = 1.0;
                break;
            }
            case 76: {
                this.modulsVertex[0] = 1.0;
                this.modulsVertex[1] = 1.0;
                this.modulsVertex[2] = Math.sqrt(2.0) / 2.0;
                this.modulsVertex[3] = 1.0;
                break;
            }
            case 77: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.7);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(3.7);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(2.5);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(0.1);
                this.modulsVertex[4] = (double)this.escalaBasica * Math.sqrt(2.9);
                this.modulsVertex[5] = (double)this.escalaBasica * Math.sqrt(3.2);
                break;
            }
            case 70: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.78);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.58);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.58);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(1.78);
                this.modulsVertex[4] = (double)this.escalaBasica * Math.sqrt(0.18);
                break;
            }
            case 71: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.78);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.58);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.58);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(2.18);
                this.modulsVertex[4] = (double)this.escalaBasica * Math.sqrt(0.18);
                break;
            }
            case 72: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.78);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.58);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.58);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(2.18);
                this.modulsVertex[4] = (double)this.escalaBasica * Math.sqrt(1.78);
                this.modulsVertex[5] = (double)this.escalaBasica * Math.sqrt(0.18);
                break;
            }
            case 64: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.25);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.25);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt((5.0 - 2.0 * Math.sqrt(3.0)) / 4.0);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt((5.0 - 2.0 * Math.sqrt(3.0)) / 4.0);
                break;
            }
            case 65: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.75);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.75);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(1.75);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(0.75);
                break;
            }
            case 66: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.3333333333333333);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.3333333333333333);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(2.3333333333333335);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(0.3333333333333333);
                this.modulsVertex[4] = (double)this.escalaBasica * Math.sqrt(1.3333333333333333);
                break;
            }
            case 73: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(2.125);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(2.125);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.625);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(0.625);
                break;
            }
            case 1: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(0.5);
                break;
            }
            case 2: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.5555555555555556);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.2222222222222222);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.5555555555555556);
                break;
            }
            case 3: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(2.0) * Math.sqrt(0.5555555555555556);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(2.0) * Math.sqrt(0.2222222222222222);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(2.0) * Math.sqrt(0.5555555555555556);
                break;
            }
            case 4: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(2.2222222222222223);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.8888888888888888);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(2.2222222222222223);
                break;
            }
            case 5: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.25);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.25);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.25);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(1.25);
                break;
            }
            case 6: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.0);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(2.5);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(2.5);
                break;
            }
            case 7: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(2.5);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(2.5);
                break;
            }
            case 9: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.4444444444444444);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(2.2222222222222223);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.4444444444444444);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(2.2222222222222223);
                break;
            }
            case 8: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.0);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.0);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(1.0);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(1.0);
                break;
            }
            case 10: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.5061728395061729);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.19753086419753085);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.5061728395061729);
                break;
            }
            case 11: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.9753086419753085);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.7901234567901234);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(1.9753086419753085);
                break;
            }
            case 12: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(2.5);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(2.5);
                break;
            }
            case 13: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.25);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.25);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.25);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(1.25);
                break;
            }
            case 14: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(2.5);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(2.5);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(2.5);
                break;
            }
            case 16: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.625);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.125);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.625);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(1.625);
                this.modulsVertex[4] = (double)this.escalaBasica * Math.sqrt(1.625);
                break;
            }
            case 15: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.625);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.625);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.125);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(0.625);
                break;
            }
            case 17: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(2.5);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(2.5);
                break;
            }
            case 18: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.6666666666666666);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.6666666666666666);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.6666666666666666);
                break;
            }
            case 19: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.7222222222222222);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.2222222222222222);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.3888888888888889);
                break;
            }
            case 20: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.5);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(1.5);
                break;
            }
            case 21: 
            case 33: {
                this.tipusPeca = 21;
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.3333333333333333);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.3333333333333333);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(1.3333333333333333);
                break;
            }
            case 22: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.34);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.34);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.34);
                break;
            }
            case 23: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.25);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.75);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.25);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(0.75);
                break;
            }
            case 24: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.4444444444444444);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.4444444444444444);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.7777777777777778);
                break;
            }
            case 25: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.1111111111111111);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.7777777777777778);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.7777777777777778);
                break;
            }
            case 26: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.2777777777777778);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.1111111111111111);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.2777777777777778);
                break;
            }
            case 27: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.3125);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.3125);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(1.0625);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(1.0625);
                break;
            }
            case 28: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt((Math.pow(2.5440393, 2.0) + 4.0 * Math.pow(2.0, 2.0)) / 9.0);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt((Math.pow(2.5440393, 2.0) + Math.pow(2.0, 2.0)) / 9.0);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt((Math.pow(2.0, 2.0) + 4.0 * Math.pow(2.5440393, 2.0)) / 9.0);
                break;
            }
            case 29: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt((Math.pow(2.0, 2.0) + 4.0 * Math.pow(1.5723027, 2.0)) / 9.0);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt((Math.pow(2.0, 2.0) + Math.pow(1.5723027, 2.0)) / 9.0);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt((Math.pow(1.5723027, 2.0) + 4.0 * Math.pow(2.0, 2.0)) / 9.0);
                break;
            }
            case 30: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt((Math.pow(1.5723027, 2.0) + 4.0 * Math.pow(1.236068, 2.0)) / 9.0);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt((Math.pow(1.5723027, 2.0) + Math.pow(1.236068, 2.0)) / 9.0);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt((Math.pow(1.236068, 2.0) + 4.0 * Math.pow(1.5723027, 2.0)) / 9.0);
                break;
            }
            case 31: {
                this.modulsVertex[0] = (double)(this.escalaBasica * 2) * Math.sqrt(0.25);
                this.modulsVertex[1] = (double)(this.escalaBasica * 2) * Math.sqrt(0.75);
                this.modulsVertex[2] = (double)(this.escalaBasica * 2) * Math.sqrt(0.25);
                this.modulsVertex[3] = (double)(this.escalaBasica * 2) * Math.sqrt(0.75);
                break;
            }
            case 32: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.25);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.75);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.25);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(0.75);
                break;
            }
            case 34: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.34);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.34);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.34);
                break;
            }
            case 35: {
                this.modulsVertex[0] = (double)(this.escalaBasica * 2) * 0.5;
                this.modulsVertex[1] = (double)(this.escalaBasica * 2) * 0.5;
                this.modulsVertex[2] = (double)(this.escalaBasica * 2) * 0.5;
                this.modulsVertex[3] = (double)(this.escalaBasica * 2) * 0.5;
                this.modulsVertex[4] = (double)(this.escalaBasica * 2) * 0.5;
                this.modulsVertex[5] = (double)(this.escalaBasica * 2) * 0.5;
                break;
            }
            case 36: {
                this.modulsVertex[0] = (double)(this.escalaBasica * 2) * Math.sqrt(0.109375);
                this.modulsVertex[1] = (double)(this.escalaBasica * 2) * Math.sqrt(0.109375);
                this.modulsVertex[2] = (double)(this.escalaBasica * 2) * Math.sqrt(0.296875);
                this.modulsVertex[3] = (double)(this.escalaBasica * 2) * Math.sqrt(0.296875);
                break;
            }
            case 60: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.5555555555555556);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.8888888888888888);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.8888888888888888);
                break;
            }
            case 61: {
                this.ambArc = true;
                this.iniciFinalArc.x = 0;
                this.iniciFinalArc.y = 2;
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.4444444444444444);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.7777777777777778);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(1.7777777777777777);
                this.centreArc = (double)this.escalaBasica * Math.sqrt(3.111111111111111);
                break;
            }
            case 62: {
                this.ambArc = true;
                this.iniciFinalArc.x = 0;
                this.iniciFinalArc.y = 2;
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt((20.0 - 8.0 * Math.sqrt(3.0)) / 9.0);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt((11.0 + 4.0 * Math.sqrt(3.0)) / 9.0);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt((20.0 - 8.0 * Math.sqrt(3.0)) / 9.0);
                this.centreArc = (double)this.escalaBasica * Math.sqrt((8.0 + 4.0 * Math.sqrt(3.0)) / 9.0);
                break;
            }
            case 63: {
                this.ambArc = true;
                this.iniciFinalArc.x = 0;
                this.iniciFinalArc.y = 2;
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(2.0);
                this.modulsVertex[1] = 1.0;
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(2.05);
                this.centreArc = (double)this.escalaBasica * Math.sqrt(2.0);
                break;
            }
            case 67: {
                this.ambArc = true;
                this.iniciFinalArc.x = 2;
                this.iniciFinalArc.y = 0;
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.8125);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.375);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.8125);
                this.centreArc = Math.sqrt(1.25);
                break;
            }
            case 68: {
                this.ambArc = true;
                this.iniciFinalArc.x = 2;
                this.iniciFinalArc.y = 0;
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.8125);
                this.modulsVertex[1] = 0.25;
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.8125);
                this.centreArc = Math.sqrt(1.5625);
                break;
            }
            case 69: {
                this.ambArc = true;
                this.iniciFinalArc.x = 1;
                this.iniciFinalArc.y = 0;
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(2.4375);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(2.4375);
                this.centreArc = (double)this.escalaBasica * 0.65 * Math.sqrt(3.9375);
                break;
            }
            case 37: {
                this.ambArc = true;
                this.iniciFinalArc.x = 0;
                this.iniciFinalArc.y = 2;
                this.modulsVertex[0] = (double)this.escalaBasica * 1.5 * Math.sqrt((2.0 + 4.0 * Math.pow(this.o, 2.0)) / 9.0);
                this.modulsVertex[1] = (double)this.escalaBasica * 1.5 * Math.sqrt((2.0 + Math.pow(this.o, 2.0)) / 9.0);
                this.modulsVertex[2] = (double)this.escalaBasica * 1.5 * Math.sqrt((8.0 + Math.pow(this.o, 2.0)) / 9.0);
                this.centreArc = (double)this.escalaBasica * 1.5 * Math.sqrt((20.0 + 6.0 * Math.sqrt(2.0) * this.o + Math.pow(this.o, 2.0)) / 9.0);
                break;
            }
            case 38: {
                this.ambArc = true;
                this.iniciFinalArc.x = 0;
                this.iniciFinalArc.y = 2;
                this.modulsVertex[0] = (double)this.escalaBasica * 1.5 * Math.sqrt((20.0 - 8.0 * Math.sqrt(2.0)) * Math.pow(this.o, 2.0) / 36.0);
                this.modulsVertex[1] = (double)this.escalaBasica * 1.5 * Math.sqrt((8.0 + 4.0 * Math.sqrt(2.0)) * Math.pow(this.o, 2.0) / 36.0);
                this.modulsVertex[2] = (double)this.escalaBasica * 1.5 * Math.sqrt((20.0 - 8.0 * Math.sqrt(2.0)) * Math.pow(this.o, 2.0) / 36.0);
                this.centreArc = this.modulsVertex[1];
                break;
            }
            case 39: {
                this.ambArc = false;
                this.modulsVertex[0] = (double)this.escalaBasica * 1.5 * Math.sqrt(0.5555555555555556);
                this.modulsVertex[1] = (double)this.escalaBasica * 1.5 * Math.sqrt(0.2222222222222222);
                this.modulsVertex[2] = (double)this.escalaBasica * 1.5 * Math.sqrt(0.5555555555555556);
                break;
            }
            case 41: {
                this.ambArc = false;
                this.modulsVertex[0] = (double)this.escalaBasica * 0.8 * Math.sqrt(2.0 * Math.sqrt(2.0) / 3.0 - 0.6666666666666666);
                this.modulsVertex[1] = (double)this.escalaBasica * 1.5 * Math.sqrt(-20.0 * Math.sqrt(2.0) / 9.0 + 3.3333333333333335);
                this.modulsVertex[2] = (double)this.escalaBasica * 1.5 * Math.sqrt(-20.0 * Math.sqrt(2.0) / 9.0 + 3.3333333333333335);
                break;
            }
            case 40: {
                this.ambArc = true;
                this.iniciFinalArc.x = 0;
                this.iniciFinalArc.y = 3;
                this.modulsVertex[0] = (double)this.escalaBasica * 1.5 * Math.sqrt(1.25 - Math.sqrt(2.0) / 2.0);
                this.modulsVertex[1] = (double)this.escalaBasica * 1.5 * Math.sqrt(2.25 - 3.0 * Math.sqrt(2.0) / 2.0);
                this.modulsVertex[2] = (double)this.escalaBasica * 1.5 * Math.sqrt(2.25 - 3.0 * Math.sqrt(2.0) / 2.0);
                this.modulsVertex[3] = (double)this.escalaBasica * 1.5 * Math.sqrt(1.25 - Math.sqrt(2.0) / 2.0);
                this.centreArc = (double)this.escalaBasica * 1.5 * 0.5;
                break;
            }
            case 42: {
                this.ambArc = true;
                this.iniciFinalArc.x = 0;
                this.iniciFinalArc.y = 2;
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.5777777777777778);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.2222222222222222);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.5777777777777778);
                this.centreArc = this.modulsVertex[1];
                break;
            }
            case 43: {
                this.ambArc = true;
                this.iniciFinalArc.x = 0;
                this.iniciFinalArc.y = 2;
                this.modulsVertex[0] = (double)this.escalaBasica * (1.0 / this.o) * Math.sqrt((20.0 - 8.0 * Math.sqrt(2.0)) * Math.pow(this.o, 2.0) / 36.0);
                this.modulsVertex[1] = (double)this.escalaBasica * (1.0 / this.o) * Math.sqrt((8.0 + 4.0 * Math.sqrt(2.0)) * Math.pow(this.o, 2.0) / 36.0);
                this.modulsVertex[2] = (double)this.escalaBasica * (1.0 / this.o) * Math.sqrt((20.0 - 8.0 * Math.sqrt(2.0)) * Math.pow(this.o, 2.0) / 36.0);
                this.centreArc = this.modulsVertex[1];
                break;
            }
            case 79: {
                this.modulsVertex[0] = Math.sqrt(0.4375);
                this.modulsVertex[1] = Math.sqrt(0.4375);
                this.modulsVertex[2] = Math.sqrt(0.1875);
                break;
            }
            case 80: {
                this.modulsVertex[0] = 1.5 * Math.sqrt(0.4375);
                this.modulsVertex[1] = 1.5 * Math.sqrt(0.4375);
                this.modulsVertex[2] = 1.5 * Math.sqrt(0.1875);
                break;
            }
            case 81: {
                this.modulsVertex[0] = Math.sqrt(0.1111111111111111);
                this.modulsVertex[1] = Math.sqrt(0.3611111111111111);
                this.modulsVertex[2] = Math.sqrt(0.19444444444444445);
                break;
            }
            case 82: {
                this.modulsVertex[0] = 0.6666666666666666;
                this.modulsVertex[1] = Math.sqrt(1.4444444444444444);
                this.modulsVertex[2] = Math.sqrt(0.7777777777777778);
                break;
            }
            case 83: {
                this.modulsVertex[0] = Math.sqrt(0.3333333333333333);
                this.modulsVertex[1] = Math.sqrt(1.0833333333333333);
                this.modulsVertex[2] = Math.sqrt(0.5833333333333334);
                break;
            }
            case 84: {
                this.modulsVertex[0] = Math.sqrt(0.296875);
                this.modulsVertex[1] = Math.sqrt(0.296875);
                this.modulsVertex[2] = Math.sqrt(0.109375);
                this.modulsVertex[3] = Math.sqrt(0.109375);
                break;
            }
            case 44: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.1909722222222222);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.09027777777777778);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.2777777777777778);
                break;
            }
            case 45: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.4722222222222222);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.5555555555555556);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.8055555555555556);
                break;
            }
            case 46: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.5);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.3125);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(1.0625);
                break;
            }
            case 47: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.4722222222222222);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.20833333333333334);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(1.0347222222222223);
                break;
            }
            case 48: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.1388888888888889);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.4722222222222222);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.7222222222222222);
                break;
            }
            case 49: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.05555555555555555);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.4513888888888889);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.7013888888888888);
                break;
            }
            case 50: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.4513888888888889);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.2847222222222222);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.2222222222222222);
                break;
            }
            case 51: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.5555555555555556);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(1.3888888888888888);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(3.388888888888889);
                break;
            }
            case 52: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.5);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(1.0);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(2.5);
                break;
            }
            case 53: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(1.015625);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.390625);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(1.140625);
                this.modulsVertex[3] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(1.140625);
                this.modulsVertex[4] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.390625);
                break;
            }
            case 54: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.390625);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(1.015625);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.390625);
                this.modulsVertex[3] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(1.140625);
                break;
            }
            case 55: {
                this.modulsVertex[0] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.625);
                this.modulsVertex[1] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(0.625);
                this.modulsVertex[2] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(1.125);
                this.modulsVertex[3] = (double)this.escalaBasica * this.escalaStomachion * Math.sqrt(1.125);
                break;
            }
            case 87: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(2.5);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(2.5);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(2.0);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(2.0) / 2.0;
                break;
            }
            case 88: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.3888888888888888);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.7222222222222222);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.9444444444444444);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(0.7222222222222222);
                break;
            }
            case 89: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.49382716049382713);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.8271604938271604);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.6419753086419753);
                break;
            }
            case 90: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.6790123456790123);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(2.567901234567901);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.49382716049382713);
                break;
            }
            case 91: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.7160493827160493);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.49382716049382713);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.41975308641975306);
                break;
            }
            case 92: {
                this.modulsVertex[0] = 1.0;
                this.modulsVertex[1] = 1.0;
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(1.4444444444444444);
                this.modulsVertex[3] = 1.0;
                this.modulsVertex[4] = 1.0;
                break;
            }
            case 93: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.41975308641975306);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.6419753086419753);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.12345679012345678);
                break;
            }
            case 94: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(1.308641975308642);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(3.0864197530864197);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.7901234567901234);
                break;
            }
            case 95: {
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.8888888888888888);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(1.1111111111111112);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(2.888888888888889);
                break;
            }
            case 100: {
                this.modulsVertex[0] = (double)this.escalaBasica * 1.5612495;
                this.modulsVertex[1] = (double)this.escalaBasica * 2.046338193;
                this.modulsVertex[2] = (double)this.escalaBasica * 2.046338193;
                this.modulsVertex[3] = (double)this.escalaBasica * 1.5612495;
                break;
            }
            case 57: {
                this.modulsVertex[0] = (double)this.escalaBasica * 1.0897247;
                this.modulsVertex[1] = (double)this.escalaBasica * 1.5612495;
                this.modulsVertex[2] = (double)this.escalaBasica * 1.5612495;
                this.modulsVertex[3] = (double)this.escalaBasica * 1.0897247;
                break;
            }
            case 96: {
                this.modulsVertex[0] = (double)this.escalaBasica * 0.1666666;
                this.modulsVertex[1] = (double)this.escalaBasica * 0.2635231;
                this.modulsVertex[2] = (double)this.escalaBasica * 0.2635231;
                break;
            }
            case 97: {
                this.modulsVertex[0] = (double)this.escalaBasica * 0.4506939;
                this.modulsVertex[1] = (double)this.escalaBasica * 1.0680005;
                this.modulsVertex[2] = (double)this.escalaBasica * 1.0680005;
                this.modulsVertex[3] = (double)this.escalaBasica * 0.4506939;
                break;
            }
            case 98: {
                this.modulsVertex[0] = (double)this.escalaBasica * 1.118034;
                this.modulsVertex[1] = (double)this.escalaBasica * 1.8027756;
                this.modulsVertex[2] = (double)this.escalaBasica * 1.118034;
                this.modulsVertex[3] = (double)this.escalaBasica * 0.5;
                this.modulsVertex[4] = (double)this.escalaBasica * 1.5;
                break;
            }
            case 99: {
                this.modulsVertex[0] = (double)this.escalaBasica * 0.7905694;
                this.modulsVertex[1] = (double)this.escalaBasica * 1.457738;
                this.modulsVertex[2] = (double)this.escalaBasica * 0.7905694;
                this.modulsVertex[3] = (double)this.escalaBasica * 0.7905694;
                break;
            }
            default: {
                this.numeroVertex = 4;
                this.tipusPeca = 1;
                this.simetriaBool = false;
                this.modulsVertex[0] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[1] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[2] = (double)this.escalaBasica * Math.sqrt(0.5);
                this.modulsVertex[3] = (double)this.escalaBasica * Math.sqrt(0.5);
            }
        }
        this.anglesInicialsPeca(this.tipusPeca);
    }

    public void anglesInicialsPeca(int tPeca) {
        switch (tPeca) {
            case 1: {
                this.angleInicial = Math.atan(1.0);
                this.anglesVertex[0] = Math.atan(1.0);
                this.anglesVertex[1] = Math.atan(1.0) + 1.5707963267948966;
                this.anglesVertex[2] = Math.atan(1.0) + Math.PI;
                this.anglesVertex[3] = Math.atan(1.0) + 4.71238898038469;
                break;
            }
            case 2: 
            case 10: 
            case 11: 
            case 26: {
                this.angleInicial = Math.atan(0.5);
                this.anglesVertex[0] = Math.atan(0.5);
                this.anglesVertex[1] = Math.atan(-1.0) + Math.PI;
                this.anglesVertex[2] = Math.atan(2.0) + Math.PI;
                break;
            }
            case 3: 
            case 39: {
                this.angleInicial = Math.atan(0.5);
                this.anglesVertex[0] = Math.atan(0.5);
                this.anglesVertex[1] = Math.atan(-1.0) + Math.PI;
                this.anglesVertex[2] = Math.atan(2.0) + Math.PI;
                break;
            }
            case 4: {
                this.angleInicial = Math.atan(0.5);
                this.anglesVertex[0] = Math.atan(0.5);
                this.anglesVertex[1] = Math.atan(-1.0) + Math.PI;
                this.anglesVertex[2] = Math.atan(2.0) + Math.PI;
                break;
            }
            case 5: {
                this.angleInicial = 1.5707963267948966;
                this.anglesVertex[0] = 1.5707963267948966;
                this.anglesVertex[1] = Math.atan(-0.5) + Math.PI;
                this.anglesVertex[2] = 4.71238898038469;
                this.anglesVertex[3] = Math.PI * 2 + Math.atan(-0.5);
                break;
            }
            case 6: {
                this.angleInicial = 1.5707963267948966;
                this.anglesVertex[0] = 1.5707963267948966;
                this.anglesVertex[1] = Math.atan(-0.3333333333333333);
                this.anglesVertex[2] = Math.atan(0.3333333333333333) + Math.PI;
                break;
            }
            case 7: {
                this.angleInicial = 1.5707963267948966;
                this.anglesVertex[0] = 1.5707963267948966;
                this.anglesVertex[1] = Math.atan(-0.5) + Math.PI;
                this.anglesVertex[2] = 4.71238898038469;
                this.anglesVertex[3] = Math.PI * 2 + Math.atan(-0.5);
                break;
            }
            case 9: 
            case 12: {
                this.angleInicial = 1.5707963267948966;
                this.anglesVertex[0] = 1.5707963267948966;
                this.anglesVertex[1] = Math.atan(-0.5) + Math.PI;
                this.anglesVertex[2] = 4.71238898038469;
                this.anglesVertex[3] = Math.PI * 2 + Math.atan(-0.5);
                break;
            }
            case 13: {
                this.angleInicial = Math.atan(0.5);
                this.anglesVertex[0] = Math.atan(0.5);
                this.anglesVertex[1] = Math.PI - Math.atan(0.5);
                this.anglesVertex[2] = 4.71238898038469;
                this.anglesVertex[3] = Math.PI * 2 - Math.atan(0.5);
                break;
            }
            case 14: {
                this.angleInicial = Math.atan(0.3333333333333333) - Math.PI;
                this.anglesVertex[0] = Math.atan(0.3333333333333333) - Math.PI;
                this.anglesVertex[1] = Math.PI - Math.atan(0.3333333333333333) - Math.PI;
                this.anglesVertex[2] = 0.7853981633974483;
                this.anglesVertex[3] = Math.PI * 2 - Math.atan(0.3333333333333333) - Math.PI;
                break;
            }
            case 16: {
                this.angleInicial = Math.atan(Math.sqrt(1.0) / 2.0);
                this.anglesVertex[0] = Math.atan(Math.sqrt(1.0) / 2.0);
                this.anglesVertex[1] = 1.5707963267948966;
                this.anglesVertex[2] = Math.PI - Math.atan(0.5);
                this.anglesVertex[3] = Math.atan(1.5) + Math.PI;
                this.anglesVertex[4] = Math.PI * 2 - Math.atan(1.5);
                break;
            }
            case 15: {
                this.angleInicial = Math.atan(0.5);
                this.anglesVertex[0] = Math.atan(0.5);
                this.anglesVertex[1] = Math.PI - Math.atan(0.5);
                this.anglesVertex[2] = 4.71238898038469;
                this.anglesVertex[3] = Math.PI * 2 - Math.atan(0.5);
                break;
            }
            case 17: {
                this.angleInicial = 0.7853981633974483;
                this.anglesVertex[0] = 0.7853981633974483;
                this.anglesVertex[1] = 2.356194490192345;
                this.anglesVertex[2] = Math.PI + Math.atan(0.3333333333333333);
                this.anglesVertex[3] = Math.PI * 2 - Math.atan(0.3333333333333333);
                break;
            }
            case 18: 
            case 21: 
            case 22: 
            case 33: 
            case 34: {
                this.angleInicial = 1.5707963267948966;
                this.anglesVertex[0] = 1.5707963267948966;
                this.anglesVertex[1] = Math.PI + Math.atan(Math.sqrt(3.0) / 3.0);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(Math.sqrt(3.0) / 3.0);
                break;
            }
            case 19: {
                this.angleInicial = 1.5707963267948966 + Math.atan(Math.sqrt(3.0) / 6.0);
                this.anglesVertex[0] = 1.5707963267948966 + Math.atan(Math.sqrt(3.0) / 6.0);
                this.anglesVertex[1] = Math.PI + Math.atan(Math.sqrt(3.0));
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(Math.sqrt(3.0) / 2.0);
                break;
            }
            case 20: 
            case 23: 
            case 31: 
            case 32: {
                this.angleInicial = Math.atan(Math.sqrt(3.0) / 3.0) + 1.5707963267948966;
                this.anglesVertex[0] = Math.atan(Math.sqrt(3.0) / 3.0) + 1.5707963267948966;
                this.anglesVertex[1] = Math.PI + Math.atan(Math.sqrt(3.0) / 3.0);
                this.anglesVertex[2] = 4.71238898038469 + Math.atan(Math.sqrt(3.0) / 3.0);
                this.anglesVertex[3] = Math.atan(Math.sqrt(3.0) / 3.0);
                break;
            }
            case 24: {
                this.angleInicial = 1.5707963267948966 + Math.atan(Math.sqrt(3.0) / 6.0);
                this.anglesVertex[0] = 1.5707963267948966 + Math.atan(Math.sqrt(3.0) / 6.0);
                this.anglesVertex[1] = Math.PI + Math.atan(Math.sqrt(3.0));
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(Math.sqrt(3.0) / 2.0);
                break;
            }
            case 25: {
                this.angleInicial = 1.5707963267948966;
                this.anglesVertex[0] = 1.5707963267948966;
                this.anglesVertex[1] = Math.PI + Math.atan(Math.sqrt(3.0) / 9.0);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(Math.sqrt(3.0) / 9.0);
                break;
            }
            case 27: {
                this.angleInicial = Math.atan(0.5);
                this.anglesVertex[0] = Math.atan(0.5);
                this.anglesVertex[1] = 1.5707963267948966 + Math.atan(2.0);
                this.anglesVertex[2] = Math.PI + Math.atan(0.25);
                this.anglesVertex[3] = Math.PI * 2 - Math.atan(0.25);
                break;
            }
            case 28: {
                this.angleInicial = Math.PI - Math.atan(1.5723027549142028);
                this.anglesVertex[0] = Math.PI - Math.atan(1.5723027549142028);
                this.anglesVertex[1] = Math.PI + Math.atan(0.7861513774571014);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.3930756887285507);
                break;
            }
            case 29: {
                this.angleInicial = Math.PI - Math.atan(1.5723027);
                this.anglesVertex[0] = Math.PI - Math.atan(1.5723027);
                this.anglesVertex[1] = Math.PI + Math.atan(0.78615135);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.393075675);
                break;
            }
            case 30: {
                this.angleInicial = Math.PI - Math.atan(1.5723028396504055);
                this.anglesVertex[0] = Math.PI - Math.atan(1.5723028396504055);
                this.anglesVertex[1] = Math.PI + Math.atan(0.7861514198252028);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.3930757099126014);
                break;
            }
            case 35: {
                this.angleInicial = 1.0471975511965976;
                this.anglesVertex[0] = 1.0471975511965976;
                this.anglesVertex[1] = 2.0943951023931953;
                this.anglesVertex[2] = Math.PI;
                this.anglesVertex[3] = 4.1887902047863905;
                this.anglesVertex[4] = 5.235987755982989;
                this.anglesVertex[5] = 0.0;
                break;
            }
            case 36: {
                this.angleInicial = Math.atan(Math.sqrt(3.0) / 2.0);
                this.anglesVertex[0] = Math.atan(Math.sqrt(3.0) / 2.0);
                this.anglesVertex[1] = Math.PI - Math.atan(Math.sqrt(3.0) / 2.0);
                this.anglesVertex[2] = Math.PI + Math.atan(Math.sqrt(3.0) / 4.0);
                this.anglesVertex[3] = Math.PI * 2 - Math.atan(Math.sqrt(3.0) / 4.0);
                break;
            }
            case 37: {
                this.angleInicial = Math.PI - Math.atan(this.o * Math.sqrt(2.0));
                this.anglesVertex[0] = Math.PI - Math.atan(this.o * Math.sqrt(2.0));
                this.anglesVertex[1] = Math.atan(this.o * Math.sqrt(2.0) / 2.0) + Math.PI;
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(this.o * Math.sqrt(2.0) / 4.0);
                this.angleCentreArc = Math.atan((3.0 * Math.sqrt(2.0) + this.o) / Math.sqrt(2.0)) + Math.PI;
                break;
            }
            case 38: {
                this.angleInicial = Math.PI - Math.atan((4.0 - Math.sqrt(2.0)) / Math.sqrt(2.0));
                this.anglesVertex[0] = Math.PI - Math.atan((4.0 - Math.sqrt(2.0)) / Math.sqrt(2.0));
                this.anglesVertex[1] = Math.atan((2.0 + Math.sqrt(2.0)) / Math.sqrt(2.0)) + Math.PI;
                this.anglesVertex[2] = Math.atan((-1.0 + Math.sqrt(2.0)) / Math.sqrt(2.0));
                this.angleCentreArc = this.anglesVertex[1];
                break;
            }
            case 40: {
                this.angleInicial = Math.PI - Math.atan(1.0 - Math.sqrt(2.0) / 2.0);
                this.anglesVertex[0] = Math.PI - Math.atan(1.0 - Math.sqrt(2.0) / 2.0);
                this.anglesVertex[1] = Math.PI + Math.atan(Math.sqrt(2.0) / 2.0);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(Math.sqrt(2.0) / 2.0);
                this.anglesVertex[3] = Math.atan(1.0 - Math.sqrt(2.0) / 2.0);
                this.angleCentreArc = 4.71238898038469;
                break;
            }
            case 41: {
                this.angleInicial = 1.5707963267948966;
                this.anglesVertex[0] = 1.5707963267948966;
                this.anglesVertex[1] = Math.atan(0.3333333333333333) + Math.PI;
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.3333333333333333);
                break;
            }
            case 42: {
                this.angleInicial = Math.atan(0.5);
                this.anglesVertex[0] = Math.atan(0.5);
                this.anglesVertex[1] = Math.atan(-1.0) + Math.PI;
                this.anglesVertex[2] = Math.atan(2.0) + Math.PI;
                this.angleCentreArc = this.anglesVertex[1];
                break;
            }
            case 43: {
                this.angleInicial = Math.PI - Math.atan((4.0 - Math.sqrt(2.0)) / Math.sqrt(2.0));
                this.anglesVertex[0] = Math.PI - Math.atan((4.0 - Math.sqrt(2.0)) / Math.sqrt(2.0));
                this.anglesVertex[1] = Math.atan((2.0 + Math.sqrt(2.0)) / Math.sqrt(2.0)) + Math.PI;
                this.anglesVertex[2] = Math.atan((-1.0 + Math.sqrt(2.0)) / Math.sqrt(2.0));
                this.angleCentreArc = this.anglesVertex[1];
                break;
            }
            case 44: {
                this.angleInicial = Math.PI - Math.atan(1.45);
                this.anglesVertex[0] = Math.PI - Math.atan(1.45);
                this.anglesVertex[1] = Math.PI + Math.atan(0.6666666666666666);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.3333333333333333);
                break;
            }
            case 45: {
                this.angleInicial = Math.PI - Math.atan(4.0);
                this.anglesVertex[0] = Math.PI - Math.atan(4.0);
                this.anglesVertex[1] = Math.PI + Math.atan(0.5);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.4);
                break;
            }
            case 46: {
                this.angleInicial = Math.PI - Math.atan(1.0);
                this.anglesVertex[0] = Math.PI - Math.atan(1.0);
                this.anglesVertex[1] = Math.PI + Math.atan(0.5);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.25);
                break;
            }
            case 47: {
                this.angleInicial = Math.PI - Math.atan(4.0);
                this.anglesVertex[0] = Math.PI - Math.atan(4.0);
                this.anglesVertex[1] = Math.PI - Math.atan(0.4);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(1.4285714285714286);
                break;
            }
            case 48: {
                this.angleInicial = Math.PI - Math.atan(2.0);
                this.anglesVertex[0] = Math.PI - Math.atan(2.0);
                this.anglesVertex[1] = Math.PI + Math.atan(0.25);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.2);
                break;
            }
            case 49: {
                this.angleInicial = Math.PI - Math.atan(1.0);
                this.anglesVertex[0] = Math.PI - Math.atan(1.0);
                this.anglesVertex[1] = Math.PI + Math.atan(0.125);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.1);
                break;
            }
            case 50: {
                this.angleInicial = Math.atan(8.0);
                this.anglesVertex[0] = Math.atan(8.0);
                this.anglesVertex[1] = Math.PI + Math.atan(0.8);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(1.0);
                break;
            }
            case 51: {
                this.angleInicial = Math.PI - Math.atan(0.5);
                this.anglesVertex[0] = Math.PI - Math.atan(0.5);
                this.anglesVertex[1] = Math.PI + Math.atan(0.14285714285714285);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.09090909090909091);
                break;
            }
            case 52: {
                this.angleInicial = Math.PI - Math.atan(1.0);
                this.anglesVertex[0] = Math.PI - Math.atan(1.0);
                this.anglesVertex[1] = Math.PI;
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.3333333333333333);
                break;
            }
            case 53: {
                this.angleInicial = Math.PI - Math.atan(8.0);
                this.anglesVertex[0] = Math.PI - Math.atan(8.0);
                this.anglesVertex[1] = Math.PI - Math.atan(1.3333333333333333);
                this.anglesVertex[2] = Math.PI + Math.atan(2.6666666666666665);
                this.anglesVertex[3] = Math.PI * 2 - Math.atan(2.6666666666666665);
                this.anglesVertex[4] = Math.atan(1.3333333333333333);
                break;
            }
            case 54: {
                this.angleInicial = Math.PI - Math.atan(0.75);
                this.anglesVertex[0] = Math.PI - Math.atan(0.75);
                this.anglesVertex[1] = Math.PI - Math.atan(0.125);
                this.anglesVertex[2] = Math.PI + Math.atan(0.75);
                this.anglesVertex[3] = Math.PI * 2 - Math.atan(0.375);
                break;
            }
            case 55: {
                this.angleInicial = 1.5707963267948966;
                this.anglesVertex[0] = 1.5707963267948966;
                this.anglesVertex[1] = Math.PI - Math.atan(0.3333333333333333);
                this.anglesVertex[2] = Math.PI + Math.atan(1.0);
                this.anglesVertex[3] = Math.PI * 2 - Math.atan(1.0);
                break;
            }
            case 56: {
                this.angleInicial = Math.PI - Math.atan(2.0 * Math.sqrt(2.0));
                this.anglesVertex[0] = Math.PI - Math.atan(2.0 * Math.sqrt(2.0));
                this.anglesVertex[1] = Math.atan(2.0 * Math.sqrt(2.0));
                this.anglesVertex[2] = Math.PI * 2 + Math.atan(2.0 - 2.0 * Math.sqrt(2.0));
                this.anglesVertex[3] = Math.PI + Math.atan(2.0 * Math.sqrt(2.0));
                break;
            }
            case 58: {
                this.angleInicial = Math.PI - Math.atan(Math.sqrt(2.0));
                this.anglesVertex[0] = Math.PI - Math.atan(Math.sqrt(2.0));
                this.anglesVertex[1] = Math.atan(Math.sqrt(2.0));
                this.anglesVertex[2] = -Math.atan(Math.sqrt(2.0) - 2.0);
                this.anglesVertex[3] = Math.PI + Math.atan(Math.sqrt(2.0));
                break;
            }
            case 59: {
                this.angleInicial = Math.PI - Math.atan(2.0 * Math.sqrt(2.0));
                this.anglesVertex[0] = Math.PI - Math.atan(2.0 * Math.sqrt(2.0));
                this.anglesVertex[1] = Math.PI * 2 + Math.atan(2.0 * Math.sqrt(2.0) - 2.0);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(2.0);
                this.anglesVertex[3] = Math.PI * 2 - Math.atan(Math.sqrt(2.0) / (Math.sqrt(2.0) - 1.0));
                this.anglesVertex[4] = Math.PI + Math.atan(2.0 * Math.sqrt(2.0));
                break;
            }
            case 85: {
                this.angleInicial = Math.PI - Math.atan(0.6666666666666666);
                this.anglesVertex[0] = Math.PI - Math.atan(0.6666666666666666);
                this.anglesVertex[1] = Math.atan(2.0);
                this.anglesVertex[2] = 0.0;
                this.anglesVertex[3] = Math.PI + Math.atan(0.6666666666666666);
                break;
            }
            case 86: {
                this.angleInicial = 2.356194490192345;
                this.anglesVertex[0] = 2.356194490192345;
                this.anglesVertex[1] = Math.atan(3.0);
                this.anglesVertex[2] = 5.497787143782138;
                this.anglesVertex[3] = Math.PI + Math.atan(0.3333333333333333);
                break;
            }
            case 74: 
            case 75: {
                this.angleInicial = Math.PI - Math.atan(0.5);
                this.anglesVertex[0] = Math.PI - Math.atan(0.5);
                this.anglesVertex[1] = Math.atan(0.25);
                this.anglesVertex[2] = Math.PI + Math.atan(1.0);
                break;
            }
            case 78: {
                this.angleInicial = 2.356194490192345;
                this.anglesVertex[0] = 2.356194490192345;
                this.anglesVertex[1] = 0.7853981633974483;
                this.anglesVertex[2] = 5.497787143782138;
                this.anglesVertex[3] = 3.9269908169872414;
                break;
            }
            case 76: {
                this.angleInicial = 2.356194490192345;
                this.anglesVertex[0] = 2.356194490192345;
                this.anglesVertex[1] = 0.7853981633974483;
                this.anglesVertex[2] = 0.0;
                this.anglesVertex[3] = 3.9269908169872414;
                break;
            }
            case 77: {
                this.angleInicial = Math.PI - Math.atan(0.25);
                this.anglesVertex[0] = Math.PI - Math.atan(0.25);
                this.anglesVertex[1] = Math.atan(0.16666666666666666);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.75);
                this.anglesVertex[3] = 4.71238898038469;
                this.anglesVertex[4] = Math.PI + Math.atan(2.5);
                this.anglesVertex[5] = Math.PI + Math.atan(1.0);
                break;
            }
            case 70: {
                this.angleInicial = Math.PI - Math.atan(0.625);
                this.anglesVertex[0] = Math.PI - Math.atan(0.625);
                this.anglesVertex[1] = Math.atan(2.5);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(2.5);
                this.anglesVertex[3] = Math.PI + Math.atan(0.625);
                this.anglesVertex[4] = Math.PI;
                break;
            }
            case 71: {
                this.angleInicial = Math.PI - Math.atan(0.625);
                this.anglesVertex[0] = Math.PI - Math.atan(0.625);
                this.anglesVertex[1] = Math.atan(2.5);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(2.5);
                this.anglesVertex[3] = Math.PI + Math.atan(3.3333333333333335);
                this.anglesVertex[4] = Math.PI;
                break;
            }
            case 72: {
                this.angleInicial = Math.PI - Math.atan(0.625);
                this.anglesVertex[0] = Math.PI - Math.atan(0.625);
                this.anglesVertex[1] = Math.atan(2.5);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(2.5);
                this.anglesVertex[3] = Math.PI + Math.atan(3.3333333333333335);
                this.anglesVertex[4] = Math.PI + Math.atan(0.625);
                this.anglesVertex[5] = Math.PI;
                break;
            }
            case 64: {
                this.angleInicial = Math.PI - Math.atan(0.5);
                this.anglesVertex[0] = Math.PI - Math.atan(0.5);
                this.anglesVertex[1] = Math.atan(0.5);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(Math.sqrt(3.0) - 1.0);
                this.anglesVertex[3] = Math.PI + Math.atan(Math.sqrt(3.0) - 1.0);
                break;
            }
            case 65: {
                this.angleInicial = Math.PI - Math.atan(Math.sqrt(3.0) / 5.0);
                this.anglesVertex[0] = Math.PI - Math.atan(Math.sqrt(3.0) / 5.0);
                this.anglesVertex[1] = Math.atan(Math.sqrt(3.0) / 3.0);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(Math.sqrt(3.0) / 5.0);
                this.anglesVertex[3] = Math.PI + Math.atan(Math.sqrt(3.0) / 3.0);
                break;
            }
            case 66: {
                this.angleInicial = Math.PI - Math.atan(Math.sqrt(3.0) / 3.0);
                this.anglesVertex[0] = Math.PI - Math.atan(Math.sqrt(3.0) / 3.0);
                this.anglesVertex[1] = Math.atan(Math.sqrt(3.0) / 3.0);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(Math.sqrt(3.0) / 9.0);
                this.anglesVertex[3] = Math.PI * 2 - Math.atan(Math.sqrt(3.0) / 3.0);
                this.anglesVertex[4] = 4.71238898038469;
                break;
            }
            case 73: {
                this.angleInicial = Math.PI - Math.atan(0.25);
                this.anglesVertex[0] = Math.PI - Math.atan(0.25);
                this.anglesVertex[1] = Math.atan(0.25);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(0.5);
                this.anglesVertex[3] = Math.PI + Math.atan(0.5);
                break;
            }
            case 60: {
                this.angleInicial = Math.PI - Math.atan(0.5);
                this.anglesVertex[0] = Math.PI - Math.atan(0.5);
                this.anglesVertex[1] = Math.atan(0.25);
                this.anglesVertex[2] = Math.PI + Math.atan(1.0);
                break;
            }
            case 61: {
                this.angleInicial = Math.PI - Math.atan(1.0 / Math.sqrt(3.0));
                this.anglesVertex[0] = Math.PI - Math.atan(1.0 / Math.sqrt(3.0));
                this.anglesVertex[1] = Math.PI + Math.atan(2.0 / Math.sqrt(3.0));
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(1.0 / Math.sqrt(3.0));
                this.angleCentreArc = Math.PI + Math.atan(5.0 / Math.sqrt(3.0));
                break;
            }
            case 62: {
                this.angleInicial = Math.atan(1.0 / (Math.sqrt(3.0) - 1.0));
                this.anglesVertex[0] = Math.atan(1.0 / (Math.sqrt(3.0) - 1.0));
                this.anglesVertex[1] = Math.PI - Math.atan(2.0 / (Math.sqrt(3.0) + 2.0));
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(1.0 / (4.0 - Math.sqrt(3.0)));
                this.angleCentreArc = Math.PI + Math.atan(1.0 / (Math.sqrt(3.0) + 2.0));
                break;
            }
            case 63: {
                this.angleInicial = Math.PI - Math.atan(1.0);
                this.anglesVertex[0] = Math.PI - Math.atan(1.0);
                this.anglesVertex[1] = Math.PI;
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(1.0);
                this.angleCentreArc = Math.PI + Math.atan(1.0);
                break;
            }
            case 67: {
                this.angleInicial = Math.PI - Math.atan(2.0 * Math.sqrt(3.0));
                this.anglesVertex[0] = Math.PI - Math.atan(2.0 * Math.sqrt(3.0));
                this.anglesVertex[1] = Math.atan(2.0 * Math.sqrt(3.0) / 3.0);
                this.anglesVertex[2] = Math.PI + Math.atan(2.0 * Math.sqrt(3.0));
                this.angleCentreArc = 0.0;
                break;
            }
            case 68: {
                this.angleInicial = Math.PI - Math.atan(2.0 * Math.sqrt(3.0));
                this.anglesVertex[0] = Math.PI - Math.atan(2.0 * Math.sqrt(3.0));
                this.anglesVertex[1] = 0.0;
                this.anglesVertex[2] = Math.PI + Math.atan(2.0 * Math.sqrt(3.0));
                this.angleCentreArc = 0.0;
                break;
            }
            case 69: {
                this.angleInicial = Math.PI - Math.atan(Math.sqrt(3.0) / 6.0);
                this.anglesVertex[0] = Math.PI - Math.atan(Math.sqrt(3.0) / 6.0);
                this.anglesVertex[1] = Math.atan(Math.sqrt(3.0) / 6.0);
                this.angleCentreArc = 1.5707963267948966;
                break;
            }
            case 79: 
            case 80: {
                this.angleInicial = Math.PI - Math.atan(Math.sqrt(3.0) / 2.0);
                this.anglesVertex[0] = Math.PI - Math.atan(Math.sqrt(3.0) / 2.0);
                this.anglesVertex[1] = Math.atan(Math.sqrt(3.0) / 2.0);
                this.anglesVertex[2] = 4.71238898038469;
                break;
            }
            case 81: {
                this.angleInicial = Math.PI - Math.atan(1.0 / Math.sqrt(3.0));
                this.anglesVertex[0] = Math.PI - Math.atan(1.0 / Math.sqrt(3.0));
                this.anglesVertex[1] = Math.atan(1.0 / (Math.sqrt(3.0) * 2.0));
                this.anglesVertex[2] = Math.PI + Math.atan(2.0 / Math.sqrt(3.0));
                break;
            }
            case 82: {
                this.angleInicial = Math.PI - Math.atan(1.0 / Math.sqrt(3.0));
                this.anglesVertex[0] = Math.PI - Math.atan(1.0 / Math.sqrt(3.0));
                this.anglesVertex[1] = Math.atan(1.0 / (Math.sqrt(3.0) * 2.0));
                this.anglesVertex[2] = Math.PI + Math.atan(2.0 / Math.sqrt(3.0));
                break;
            }
            case 83: {
                this.angleInicial = Math.PI - Math.atan(Math.sqrt(3.0) / 3.0);
                this.anglesVertex[0] = Math.PI - Math.atan(Math.sqrt(3.0) / 3.0);
                this.anglesVertex[1] = Math.atan(Math.sqrt(3.0) / 6.0);
                this.anglesVertex[2] = Math.PI + Math.atan(2.0 * Math.sqrt(3.0) / 3.0);
                break;
            }
            case 84: {
                this.angleInicial = Math.PI - Math.atan(Math.sqrt(3.0) / 4.0);
                this.anglesVertex[0] = Math.PI - Math.atan(Math.sqrt(3.0) / 4.0);
                this.anglesVertex[1] = Math.atan(Math.sqrt(3.0) / 4.0);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(Math.sqrt(3.0) / 2.0);
                this.anglesVertex[3] = Math.PI + Math.atan(Math.sqrt(3.0) / 2.0);
                break;
            }
            case 87: {
                this.angleInicial = Math.PI - Math.atan(0.5);
                this.anglesVertex[0] = Math.PI - Math.atan(0.5);
                this.anglesVertex[1] = Math.atan(0.5);
                this.anglesVertex[2] = 0.0;
                this.anglesVertex[3] = 4.71238898038469;
                break;
            }
            case 88: {
                this.angleInicial = Math.PI - Math.atan(1.3333333333333333);
                this.anglesVertex[0] = Math.PI - Math.atan(1.3333333333333333);
                this.anglesVertex[1] = Math.PI * 2 - Math.atan(0.6666666666666666);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(4.0);
                this.anglesVertex[3] = Math.PI + Math.atan(0.6666666666666666);
                break;
            }
            case 89: {
                this.angleInicial = Math.PI - Math.atan(0.3333333333333333);
                this.anglesVertex[0] = Math.PI - Math.atan(0.3333333333333333);
                this.anglesVertex[1] = Math.atan(0.16666666666666666);
                this.anglesVertex[2] = Math.PI + Math.atan(0.6666666666666666);
                break;
            }
            case 90: {
                this.angleInicial = Math.PI - Math.atan(0.25);
                this.anglesVertex[0] = Math.PI - Math.atan(0.25);
                this.anglesVertex[1] = Math.atan(0.2);
                this.anglesVertex[2] = Math.PI + Math.atan(2.0);
                break;
            }
            case 91: {
                this.angleInicial = Math.PI - Math.atan(0.4);
                this.anglesVertex[0] = Math.PI - Math.atan(0.4);
                this.anglesVertex[1] = Math.atan(0.5);
                this.anglesVertex[2] = Math.PI * 2 - Math.atan(4.0);
                break;
            }
            case 92: {
                this.angleInicial = 2.356194490192345;
                this.anglesVertex[0] = 2.356194490192345;
                this.anglesVertex[1] = 0.7853981633974483;
                this.anglesVertex[2] = Math.atan(0.2);
                this.anglesVertex[3] = 5.497787143782138;
                this.anglesVertex[4] = 3.9269908169872414;
                break;
            }
            case 93: {
                this.angleInicial = Math.PI - Math.atan(0.25);
                this.anglesVertex[0] = Math.PI - Math.atan(0.25);
                this.anglesVertex[1] = Math.atan(0.2);
                this.anglesVertex[2] = Math.PI + Math.atan(2.0);
                break;
            }
            case 94: {
                this.angleInicial = Math.PI - Math.atan(0.2857142857142857);
                this.anglesVertex[0] = Math.PI - Math.atan(0.2857142857142857);
                this.anglesVertex[1] = Math.atan(0.18181818181818182);
                this.anglesVertex[2] = 3.9269908169872414;
                break;
            }
            case 95: {
                this.angleInicial = 1.5707963267948966;
                this.anglesVertex[0] = 1.5707963267948966;
                this.anglesVertex[1] = Math.atan(0.5);
                this.anglesVertex[2] = Math.PI + Math.atan(1.5);
                break;
            }
            case 100: {
                this.angleInicial = 0.281034902;
                this.anglesVertex[0] = 0.281034902;
                this.anglesVertex[1] = 6.0699698;
                this.anglesVertex[2] = 3.3548082;
                this.anglesVertex[3] = 2.8605578;
                break;
            }
            case 57: {
                this.angleInicial = 0.4086378;
                this.anglesVertex[0] = 0.4086378;
                this.anglesVertex[1] = 6.0021504;
                this.anglesVertex[2] = 3.4226276;
                this.anglesVertex[3] = 2.7329548;
                break;
            }
            case 96: {
                this.angleInicial = 1.5707963;
                this.anglesVertex[0] = 1.5707963;
                this.anglesVertex[1] = 5.9614348;
                this.anglesVertex[2] = 3.4633432;
                break;
            }
            case 97: {
                this.angleInicial = 0.9827937;
                this.anglesVertex[0] = 0.9827937;
                this.anglesVertex[1] = 5.9244146;
                this.anglesVertex[2] = 3.5003633;
                this.anglesVertex[3] = 2.1587989;
                break;
            }
            case 98: {
                this.angleInicial = 2.0344439;
                this.anglesVertex[0] = 2.0344439;
                this.anglesVertex[1] = 5.6951827;
                this.anglesVertex[2] = 4.2487454;
                this.anglesVertex[3] = 3.1415927;
                this.anglesVertex[4] = 3.1415927;
                break;
            }
            case 99: {
                this.angleInicial = 0.4636476;
                this.anglesVertex[0] = 0.4636476;
                this.anglesVertex[1] = 6.0382066;
                this.anglesVertex[2] = 3.6052403;
                this.anglesVertex[3] = 2.6779451;
                break;
            }
            default: {
                this.angleInicial = Math.atan(1.0);
                this.anglesVertex[0] = Math.atan(1.0);
                this.anglesVertex[1] = Math.atan(1.0) + 1.5707963267948966;
                this.anglesVertex[2] = Math.atan(1.0) + Math.PI;
                this.anglesVertex[3] = Math.atan(1.0) + 4.71238898038469;
            }
        }
    }

    public Arc2D.Double emetArcPeca(Double escala) {
        Polygon poli = this.emetPoligon(escala);
        Point centre = this.coordenadesCentreArc(escala);
        Point iniciArc = new Point(poli.xpoints[this.iniciFinalArc.x], poli.ypoints[this.iniciFinalArc.x]);
        Point finalArc = new Point(poli.xpoints[this.iniciFinalArc.y], poli.ypoints[this.iniciFinalArc.y]);
        Point vec_radi = new Point(poli.xpoints[this.iniciFinalArc.x] - centre.x, poli.ypoints[this.iniciFinalArc.x] - centre.y);
        double radi = this.modulVector(vec_radi);
        double anglePelRadi = 0.0;
        double anglePelArc = 0.0;
        if (this.simetriaBool) {
            anglePelRadi = this.angleRadi(centre, finalArc);
            anglePelArc = this.angleArc(centre, finalArc, iniciArc);
        } else {
            anglePelRadi = this.angleRadi(centre, iniciArc);
            anglePelArc = this.angleArc(centre, iniciArc, finalArc);
        }
        return new Arc2D.Double(new Rectangle2D.Double((double)centre.x - radi, (double)centre.y - radi, 2.0 * radi, 2.0 * radi), anglePelRadi, anglePelArc, 0);
    }

    public Rectangle2D.Double emetRectangleArc(Double escala) {
        Polygon poli = this.emetPoligon(escala);
        Point centre = this.coordenadesCentreArc(escala);
        Point iniciArc = new Point(poli.xpoints[this.iniciFinalArc.x], poli.ypoints[this.iniciFinalArc.x]);
        Point finalArc = new Point(poli.xpoints[this.iniciFinalArc.y], poli.ypoints[this.iniciFinalArc.y]);
        Point vec_radi = new Point(poli.xpoints[this.iniciFinalArc.x] - centre.x, poli.ypoints[this.iniciFinalArc.x] - centre.y);
        double radi = this.modulVector(vec_radi);
        double anglePelRadi = 0.0;
        double anglePelArc = 0.0;
        if (this.simetriaBool) {
            anglePelRadi = this.angleRadi(centre, finalArc);
            anglePelArc = this.angleArc(centre, finalArc, iniciArc);
        } else {
            anglePelRadi = this.angleRadi(centre, iniciArc);
            anglePelArc = this.angleArc(centre, iniciArc, finalArc);
        }
        return new Rectangle2D.Double((double)centre.x - radi, (double)centre.y - radi, 2.0 * radi, 2.0 * radi);
    }

    private double angleArc(Point centre, Point inici, Point p_final) {
        return this.normalitzaAngleGraus(this.angleRadi(centre, p_final) - this.angleRadi(centre, inici));
    }

    public Point coordenadesIniciArc(Double escala) {
        Polygon poli = this.emetPoligon(escala);
        Point iniciArc = new Point(poli.xpoints[this.iniciFinalArc.x], poli.ypoints[this.iniciFinalArc.x]);
        return iniciArc;
    }

    public Point coordenadesFinalArc(Double escala) {
        Polygon poli = this.emetPoligon(escala);
        Point finalArc = new Point(poli.xpoints[this.iniciFinalArc.y], poli.ypoints[this.iniciFinalArc.y]);
        return finalArc;
    }

    public double normalitzaAngleGraus(double angle) {
        if (angle < 0.0) {
            angle += 360.0;
        }
        return angle %= 360.0;
    }

    public double angleRadi(Point centre, Point inici) {
        int quadrant = 1;
        Point vec_centre_inici = new Point(inici.x - centre.x, inici.y - centre.y);
        if (vec_centre_inici.x >= 0 & vec_centre_inici.y >= 0) {
            quadrant = 4;
        } else if (vec_centre_inici.x < 0 & vec_centre_inici.y >= 0) {
            quadrant = 3;
        } else if (vec_centre_inici.x < 0 & vec_centre_inici.y < 0) {
            quadrant = 2;
        } else if (vec_centre_inici.x >= 0 & vec_centre_inici.y < 0) {
            quadrant = 1;
        }
        double angle = Math.atan2(vec_centre_inici.x, vec_centre_inici.y);
        switch (quadrant) {
            case 1: {
                angle -= 1.5707963267948966;
                break;
            }
            case 2: {
                angle = 4.71238898038469 + angle;
                break;
            }
            case 3: {
                angle = 4.71238898038469 + angle;
                break;
            }
            case 4: {
                angle = 4.71238898038469 + angle;
            }
        }
        return Math.toDegrees(angle);
    }

    private double modulVector(Point vector) {
        return Math.sqrt(Math.pow(vector.x, 2.0) + Math.pow(vector.y, 2.0));
    }
}

