/*  Saper Game.
    Copyright (C) 2007 - Pawel Bednarek
    <bednarek.pawel@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> 
 */

package saper;

import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import settings.Settings;
/**
 * @author wrobel.cwirek@wp.pl
 */
public class SaperAutoPlayerSettingsDialog extends JDialog {

	private javax.swing.JPanel jContentPane = null;
	private JPanel jPanel = null;
	private JPanel jPanel1 = null;
	private JButton jButton = null;
	private JButton jButton1 = null;
	private JLabel jLabel1 = null;
	JTextField jTextField1 = null;
	JCheckBox jCheckBox = null;
    SaperAutoPlayer player = null;
	/**
	 * This is the default constructor
	 */
	public SaperAutoPlayerSettingsDialog() {
		super();
		initialize();
	}
    
    public SaperAutoPlayerSettingsDialog(JFrame parent, SaperAutoPlayer player){
        super(parent,true);
        this.player = player;
        initialize();
    }
    
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
		this.setTitle("Robot settings");
		this.setSize(300,200);
		this.setContentPane(getJContentPane());
        pack();
	}
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane() {
		if(this.jContentPane == null) {
			this.jContentPane = new javax.swing.JPanel();
			this.jContentPane.setLayout(new java.awt.BorderLayout());
			this.jContentPane.add(getJPanel(), java.awt.BorderLayout.CENTER);
			this.jContentPane.add(getJPanel1(), java.awt.BorderLayout.SOUTH);
		}
		return this.jContentPane;
	}
	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getJPanel() {
		if (this.jPanel == null) {
			this.jLabel1 = new JLabel();
			GridLayout gridLayout1 = new GridLayout();
			this.jPanel = new JPanel();
			this.jPanel.setLayout(gridLayout1);
			gridLayout1.setRows(3);
			gridLayout1.setColumns(1);
			this.jLabel1.setText("Delay");
			this.jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
			this.jPanel.add(this.jLabel1, null);
			this.jPanel.add(getJTextField1(), null);
			this.jPanel.add(getJCheckBox(), null);
		}
		return this.jPanel;
	}
	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getJPanel1() {
		if (this.jPanel1 == null) {
			this.jPanel1 = new JPanel();
			this.jPanel1.add(getJButton(), null);
			this.jPanel1.add(getJButton1(), null);
		}
		return this.jPanel1;
	}
	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getJButton() {
		if (this.jButton == null) {
			this.jButton = new JButton();
			this.jButton.setText("Ok");
			this.jButton.setPreferredSize(new java.awt.Dimension(90,20));
			this.jButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
					if(SaperAutoPlayerSettingsDialog.this.player != null){
                        Settings settings = Settings.getSettings(SaperFrame.SETTINGS_NAME);
                        try {
                            int sleep = Integer.parseInt(SaperAutoPlayerSettingsDialog.this.jTextField1.getText());
                            if(sleep >= 0){
                                SaperAutoPlayerSettingsDialog.this.player.sleepTime = sleep;
                                settings.setProperty(SaperAutoPlayer.SETTINGS_SLEEP, new Integer(sleep).toString());
                            }
                        } catch (NumberFormatException ex) {
                            //
                        }
                        SaperAutoPlayerSettingsDialog.this.player.random = SaperAutoPlayerSettingsDialog.this.jCheckBox.isSelected();
                        settings.setProperty(SaperAutoPlayer.SETTINGS_AUTO, Boolean.valueOf(SaperAutoPlayerSettingsDialog.this.jCheckBox.isSelected()).toString());
                    }
                    SaperAutoPlayerSettingsDialog.this.dispose();
				}
			});
		}
		return this.jButton;
	}
	/**
	 * This method initializes jButton1	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getJButton1() {
		if (this.jButton1 == null) {
			this.jButton1 = new JButton();
			this.jButton1.setText("Cancel");
			this.jButton1.setPreferredSize(new java.awt.Dimension(90,20));
			this.jButton1.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
					SaperAutoPlayerSettingsDialog.this.dispose();
				}
			});
		}
		return this.jButton1;
	}
	/**
	 * This method initializes jTextField1	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	private JTextField getJTextField1() {
		if (this.jTextField1 == null) {
			this.jTextField1 = new JTextField();
            this.jTextField1.setText(
//                    Integer.toString(player == null ? 100 : player.sleepTime)
                    Integer.toString(this.player.sleepTime)
            );
		}
		return this.jTextField1;
	}
	/**
	 * This method initializes jCheckBox	
	 * 	
	 * @return javax.swing.JCheckBox	
	 */    
	private JCheckBox getJCheckBox() {
		if (this.jCheckBox == null) {
			this.jCheckBox = new JCheckBox();
			this.jCheckBox.setText("Select randomly");
            //jCheckBox.setSelected(player == null ? false : player.random);
            this.jCheckBox.setSelected(this.player.random);
			this.jCheckBox.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
		}
		return this.jCheckBox;
	}
       }
