/*  Saper Game.
    Copyright (C) 2007 - Pawel Bednarek
    <bednarek.pawel@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> 
 */
package saper;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.BevelBorder;

public class SaperInfoPanel extends JPanel implements SaperGameListener {

	private double originalDiff = 0;
	private String originalDiffStr = null;
	private int totalFileds = 0;
	private int totalFieldsUncovered = 0;
	
	private JLabel label = new JLabel(); 
	
	public SaperInfoPanel() {
        this.setPreferredSize(new Dimension(10,20));
        this.setLayout(new BorderLayout());
        this.label.setBorder(BorderFactory.createBevelBorder(BevelBorder.LOWERED));
        this.add(this.label, BorderLayout.CENTER);
	}

	private void update(SaperGameEvent gameEvent, boolean one) {
		if(one) {
			List l = gameEvent.getFields();
			SaperPoint sp = (SaperPoint) l.get(0);
			if(sp.status == SaperGame.FIELD_ENABLED || sp.status == Integer.MIN_VALUE) {
				this.totalFieldsUncovered--;
			} else {
				this.totalFieldsUncovered++;
			}
		} else {
			this.totalFieldsUncovered += gameEvent.getFields().size();
		}
		
		double uncoverPercentage = this.totalFieldsUncovered / (double) this.totalFileds * 100;
		int fieldsLeft = this.totalFileds - this.totalFieldsUncovered;
		int minesLeft = gameEvent.getGame().getMinesLeft();
		double curentDiff = minesLeft != 0 ? fieldsLeft / (double)(minesLeft) : 0;
		
		StringBuffer sb = new StringBuffer(100);
		sb.append("Fileds left/original = ").append(fieldsLeft).append("/").append(this.totalFileds);
		sb.append("     Fields uncovered = ").append(format(uncoverPercentage));
		sb.append("%    Current/orginal difficulty = ").append(format(curentDiff));
		sb.append("/").append(this.originalDiffStr);
		
		this.label.setText(sb.toString());
		
	}
	
	private String format(double d){
		String s = Double.toString(d);
		int dotIndex = s.indexOf(".");
		if(dotIndex >= 0) {
			dotIndex += 4;
			if(s.length() < dotIndex) dotIndex = s.length();
			return s.substring(0, dotIndex);
		}
		return s;
	}
	
	public void gameFieldMineStatusChanged(SaperGameEvent event) {
		update(event, true);
	}

	public void gameFieldsUncovered(SaperGameEvent event) {
		update(event, false);
	}

	public void gameLost(SaperGameEvent event) {
		//
	}

	public void gameStarted(SaperGameEvent event) {
		this.totalFileds = event.getGame().getHeight() * event.getGame().getWidth();
		this.originalDiff = this.totalFileds / (double) (event.getGame().getMines());
		this.originalDiffStr = format(this.originalDiff);
	}

	public void gameVictory(SaperGameEvent event) {
		//
	}
	
}
