/*  Saper Game.
    Copyright (C) 2007 - Pawel Bednarek
    <bednarek.pawel@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> 
 */
package saper;

import javax.swing.JDialog;

import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JButton;
import javax.swing.SwingConstants;

import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

import settings.Settings;

import java.awt.FlowLayout;
import java.text.DecimalFormat;
/**
 * @author wrobel.cwirek@wp.pl
 */
public class SaperOwnSettings extends JDialog implements DocumentListener {

    SaperFrame saperFrame = null;
    
	private javax.swing.JPanel jContentPane = null;
	private JPanel jPanel = null;
	private JButton jButton = null;
	private JButton jButton1 = null;
	private JPanel jPanel1 = null;
	private JLabel jLabel = null;
	private JTextField jTextField = null;
	private JLabel jLabel1 = null;
	private JTextField jTextField1 = null;
	private JLabel jLabel2 = null;
	private JTextField jTextField2 = null;
	private JPanel jPanel2 = null;
	private JPanel jPanel3 = null;
	private JPanel jPanel4 = null;
	private JLabel jLabel3 = null;
	private JLabel jLabel4 = null;
	private JLabel jLabel5 = null;
	private JLabel jLabel6 = null;
	JCheckBox jCheckBox = null;
	
	private DecimalFormat decimalFormat = null;  //  @jve:decl-index=0:visual-constraint="450,116"
	/**
	 * This is the default constructor
	 */
	public SaperOwnSettings() {
		super();
		initialize();
	}
    
    public SaperOwnSettings(SaperFrame frame){
        super(frame,true);
        setSaperFrame(frame);
        initialize();
    }
    
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
		this.setTitle("Settings:");
		this.setResizable(false);
		this.setSize(300, 280);
		this.setContentPane(getJContentPane());
        pack();
	}
	/**
	 * This method initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private javax.swing.JPanel getJContentPane() {
		if(this.jContentPane == null) {
			this.jContentPane = new javax.swing.JPanel();
			this.jContentPane.setLayout(new java.awt.BorderLayout());
			this.jContentPane.add(getJPanel(), java.awt.BorderLayout.SOUTH);
			this.jContentPane.add(getJPanel1(), java.awt.BorderLayout.CENTER);
		}
		return this.jContentPane;
	}
	/**
	 * This method initializes jPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getJPanel() {
		if (this.jPanel == null) {
			this.jPanel = new JPanel();
			this.jPanel.add(getJButton(), null);
			this.jPanel.add(getJButton1(), null);
		}
		return this.jPanel;
	}
	/**
	 * This method initializes jButton	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getJButton() {
		if (this.jButton == null) {
			this.jButton = new JButton();
			this.jButton.setText("OK");
			this.jButton.setPreferredSize(new java.awt.Dimension(90,20));
			this.jButton.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
					int w = getValueFrom(SaperOwnSettings.this.getJTextField());
                    int h = getValueFrom(SaperOwnSettings.this.getJTextField1());
                    int m = getValueFrom(SaperOwnSettings.this.getJTextField2());
                    if(w <=0 || h <=0 || m <=0 || w * h <= m) JOptionPane.showMessageDialog(SaperOwnSettings.this,"Insert correct data");
                    else {
                        Settings.getSettings(SaperFrame.SETTINGS_NAME).setProperty(SaperGame.SETTINGS_TIP, Boolean.toString(SaperOwnSettings.this.jCheckBox.isSelected()));
                        SaperOwnSettings.this.saperFrame.startGame(w,h,m);
                        SaperOwnSettings.this.dispose();
                    }
				}
			});
		}
		return this.jButton;
	}
    
	/**
	 * This method initializes jButton1	
	 * 	
	 * @return javax.swing.JButton	
	 */    
	private JButton getJButton1() {
		if (this.jButton1 == null) {
			this.jButton1 = new JButton();
			this.jButton1.setText("Cancel");
			this.jButton1.setPreferredSize(new java.awt.Dimension(90,20));
			this.jButton1.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {    
					SaperOwnSettings.this.dispose();
				}
			});
		}
		return this.jButton1;
	}
	/**
	 * This method initializes jPanel1	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getJPanel1() {
		if (this.jPanel1 == null) {
			this.jLabel6 = new JLabel();
			this.jLabel5 = new JLabel();
			this.jLabel4 = new JLabel();
			this.jLabel3 = new JLabel();
			this.jLabel2 = new JLabel();
			this.jLabel1 = new JLabel();
			this.jLabel = new JLabel();
			GridLayout gridLayout1 = new GridLayout();
			this.jPanel1 = new JPanel();
			this.jPanel1.setLayout(gridLayout1);
			gridLayout1.setRows(11);
			gridLayout1.setColumns(1);
			gridLayout1.setHgap(2);
			gridLayout1.setVgap(2);
			this.jLabel.setText("Height");
			this.jLabel.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
			this.jLabel1.setText("Width");
			this.jLabel1.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
			this.jLabel2.setText("Mines count");
			this.jLabel2.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
			this.jLabel3.setText(" Beginer : " + getDecimalFormat().format(9 * 9 / 10.0));
			this.jLabel4.setText(" Advanced : " + getDecimalFormat().format(16 * 16 / 40.0));
			this.jLabel5.setText(" Expert : " + getDecimalFormat().format(16 * 30 / 99.0));
			this.jLabel6.setText("");
			
			this.jPanel1.add(this.jLabel, null);
			this.jPanel1.add(getJPanel2(), null);
			this.jPanel1.add(this.jLabel1, null);
			this.jPanel1.add(getJPanel3(), null);
			this.jPanel1.add(this.jLabel2, null);
			this.jPanel1.add(getJPanel4(), null);
			this.jPanel1.add(this.jLabel3, null);
			this.jPanel1.add(this.jLabel4, null);
			this.jPanel1.add(this.jLabel5, null);
			this.jPanel1.add(this.jLabel6, null);
			this.jPanel1.add(getCheckBox(), null);
		}
		return this.jPanel1;
	}
	private JCheckBox getCheckBox(){
		if( this.jCheckBox == null) {
			this.jCheckBox = new JCheckBox("Begin help");
			String value = Settings.getSettings(SaperFrame.SETTINGS_NAME).getProperty(SaperGame.SETTINGS_TIP, "true");
			boolean bValue = Boolean.valueOf(value).booleanValue();
			this.jCheckBox.setSelected(bValue);
		}
		return this.jCheckBox;
	}
	/**
	 * This method initializes jTextField	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	JTextField getJTextField() {
		if (this.jTextField == null) {
			this.jTextField = new JTextField();
            this.jTextField.getDocument().addDocumentListener(this);
			this.jTextField.setPreferredSize(new java.awt.Dimension(100,20));
			this.jTextField.setText(getFromSettings(SaperGame.SETTINGS_WIDTH,9));
			this.jTextField.setHorizontalAlignment(SwingConstants.CENTER);
		}
		return this.jTextField;
	}
	/**
	 * This method initializes jTextField1	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	JTextField getJTextField1() {
		if (this.jTextField1 == null) {
			this.jTextField1 = new JTextField();
            this.jTextField1.getDocument().addDocumentListener(this);
			this.jTextField1.setPreferredSize(new java.awt.Dimension(100,20));
            this.jTextField1.setText(getFromSettings(SaperGame.SETTINGS_HEIGHT,9));
			this.jTextField1.setHorizontalAlignment(SwingConstants.CENTER);
		}
		return this.jTextField1;
	}
	/**
	 * This method initializes jTextField2	
	 * 	
	 * @return javax.swing.JTextField	
	 */    
	JTextField getJTextField2() {
		if (this.jTextField2 == null) {
			this.jTextField2 = new JTextField();
            this.jTextField2.getDocument().addDocumentListener(this);
			this.jTextField2.setPreferredSize(new java.awt.Dimension(100,20));
            this.jTextField2.setText(getFromSettings(SaperGame.SETTINGS_MINES,10));
			this.jTextField2.setHorizontalAlignment(SwingConstants.CENTER);
		}
		return this.jTextField2;
	}
	/**
	 * This method initializes jPanel2	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getJPanel2() {
		if (this.jPanel2 == null) {
			FlowLayout flowLayout2 = new FlowLayout();
			this.jPanel2 = new JPanel();
			this.jPanel2.setLayout(flowLayout2);
			flowLayout2.setHgap(0);
			flowLayout2.setVgap(0);
			this.jPanel2.add(getJTextField(), null);
		}
		return this.jPanel2;
	}
	/**
	 * This method initializes jPanel3	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getJPanel3() {
		if (this.jPanel3 == null) {
			FlowLayout flowLayout3 = new FlowLayout();
			this.jPanel3 = new JPanel();
			this.jPanel3.setLayout(flowLayout3);
			flowLayout3.setHgap(0);
			flowLayout3.setVgap(0);
			this.jPanel3.add(getJTextField1(), null);
		}
		return this.jPanel3;
	}
	/**
	 * This method initializes jPanel4	
	 * 	
	 * @return javax.swing.JPanel	
	 */    
	private JPanel getJPanel4() {
		if (this.jPanel4 == null) {
			FlowLayout flowLayout4 = new FlowLayout();
			this.jPanel4 = new JPanel();
			this.jPanel4.setLayout(flowLayout4);
			flowLayout4.setHgap(0);
			flowLayout4.setVgap(0);
			this.jPanel4.add(getJTextField2(), null);
		}
		return this.jPanel4;
	}
    
    SaperFrame getSaperFrame() {
        return this.saperFrame;
    }
    void setSaperFrame(SaperFrame saperFrame) {
        this.saperFrame = saperFrame;
    }
	/**
	 * This method initializes decimalFormat	
	 * 	
	 * @return java.text.DecimalFormat	
	 */    
	private DecimalFormat getDecimalFormat() {
		if (this.decimalFormat == null) {
			this.decimalFormat = new DecimalFormat("0.#####");
		}
		return this.decimalFormat;
	}

    /* (non-Javadoc)
     * @see javax.swing.event.DocumentListener#insertUpdate(javax.swing.event.DocumentEvent)
     */
    public void insertUpdate(DocumentEvent e) {
        translate();
    }

    /* (non-Javadoc)
     * @see javax.swing.event.DocumentListener#removeUpdate(javax.swing.event.DocumentEvent)
     */
    public void removeUpdate(DocumentEvent e) {
        translate();
    }

    /* (non-Javadoc)
     * @see javax.swing.event.DocumentListener#changedUpdate(javax.swing.event.DocumentEvent)
     */
    public void changedUpdate(DocumentEvent e) {
        translate();
    }
    
    private void translate(){
        int w = getValueFrom(SaperOwnSettings.this.getJTextField());
        int h = getValueFrom(SaperOwnSettings.this.getJTextField1());
        int m = getValueFrom(SaperOwnSettings.this.getJTextField2());
        if(w > 0 && h > 0 && m > 0 && w * h > m){
            this.jLabel6.setText("Curent : " + getDecimalFormat().format(w * h / (double) m));
        } else {
            this.jLabel6.setText("Curent : -");
        }
    }
    
    int getValueFrom(JTextField text){
        int out = -1;
        try {
            out = Integer.parseInt(text.getText());
        } catch (NumberFormatException e){
            //
        }
        return out;
    }

    String getFromSettings(String key, int def){
        Settings settings = Settings.getSettings(SaperFrame.SETTINGS_NAME);
        String out = settings.getProperty(key, new Integer(def).toString());
        return out;
    }
    
           }  //  @jve:decl-index=0:visual-constraint="19,15"
