/*  Saper Game.
    Copyright (C) 2007 - Pawel Bednarek
    <bednarek.pawel@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/> 
 */
package saper;

import java.awt.Point;
import java.util.Comparator;

class SaperPoint extends Point {

    public static Comparator PointsComparator = new Comparator() {
        public int compare(Object o1, Object o2) {
            Point p1 = (Point) o1;
            Point p2 = (Point) o2;
            
            if(p1.x > p2.x) {
                return -1;
            } else if(p1.x == p2.x){
                if(p1.y > p2.y){
                    return -1;
                } else if(p1.y == p2.y) {
                    return 0;
                }
            }
            return 1;

        }
    };
    
    public final int status;
    
    public SaperPoint(int x, int y, int status) {
        this.x = x;
        this.y = y;
        this.status = status;
    }

}
