/*
 * Decompiled with CFR 0.152.
 */
package puzzle.model;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import puzzle.model.Record;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecordsModel {
    private String moveRecordsFilePath;
    private String timeRecordsFilePath;
    private List<Record> moveRecords;
    private List<Record> timeRecords;

    public RecordsModel(String moveRecordsFilePath, String timeRecordsFilePath) {
        this.moveRecordsFilePath = moveRecordsFilePath;
        this.timeRecordsFilePath = timeRecordsFilePath;
        this.moveRecords = new ArrayList<Record>();
        this.timeRecords = new ArrayList<Record>();
        this.generateRecords();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateRecords() {
        InputStreamReader fr = null;
        BufferedReader br = null;
        String[] paths = new String[]{this.moveRecordsFilePath, this.timeRecordsFilePath};
        List[] records = new List[]{this.moveRecords, this.timeRecords};
        try {
            for (int i = 0; i < paths.length; ++i) {
                String line;
                fr = new FileReader(paths[i]);
                br = new BufferedReader(fr);
                while ((line = br.readLine()) != null && !line.isEmpty()) {
                    String[] elements = line.split(",");
                    Record record = new Record(elements[0], Double.parseDouble(elements[1].trim()));
                    records[i].add(record);
                }
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        finally {
            try {
                fr.close();
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
    }

    public List<Record> getAllMoveRecords() {
        return this.moveRecords;
    }

    public List<Record> getAllTimeRecords() {
        return this.timeRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearRecords() {
        OutputStreamWriter fw = null;
        PrintWriter pw = null;
        try {
            fw = new FileWriter(this.moveRecordsFilePath, false);
            pw = new PrintWriter(fw);
            pw.println();
            fw = new FileWriter(this.timeRecordsFilePath, false);
            pw = new PrintWriter(fw);
            pw.println();
            this.moveRecords.clear();
            this.timeRecords.clear();
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
    }

    public Record tryRecord(String name, double result, String type) {
        String recordsFilePath;
        List<Record> recordsList;
        if (type.equals("move")) {
            recordsList = this.moveRecords;
            recordsFilePath = this.moveRecordsFilePath;
        } else {
            recordsList = this.timeRecords;
            recordsFilePath = this.timeRecordsFilePath;
        }
        Record newRecord = this.checkForNewRecord(name, result, recordsList);
        if (newRecord != null) {
            this.saveRecord(recordsList, recordsFilePath);
        }
        return newRecord;
    }

    private Record checkForNewRecord(String name, double result, List<Record> recordsList) {
        Record newRecord = null;
        for (Record currentRec : recordsList) {
            if (!(result <= currentRec.getResult())) continue;
            newRecord = new Record(name, result);
            recordsList.add(recordsList.indexOf(currentRec), newRecord);
            if (recordsList.size() <= 10) break;
            recordsList.remove(10);
            break;
        }
        if (newRecord == null && recordsList.size() < 10) {
            newRecord = new Record(name, result);
            recordsList.add(newRecord);
        }
        return newRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveRecord(List<Record> recordsList, String recordsFilePath) {
        OutputStreamWriter fw = null;
        PrintWriter pw = null;
        try {
            fw = new FileWriter(recordsFilePath, false);
            pw = new PrintWriter(fw);
            pw.println();
            fw = new FileWriter(recordsFilePath, true);
            pw = new PrintWriter(fw);
            for (Record currentRec : recordsList) {
                String name = currentRec.getName();
                double moves = currentRec.getResult();
                String nextRecord = name + "," + moves;
                pw.print(nextRecord);
                pw.println();
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(e.getMessage());
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException ioe) {
                System.out.println(ioe.getMessage());
            }
        }
    }
}

