package puzzle.model;


import java.io.File;
import java.io.IOException;
import java.util.List;


// This is a front model class for both MoveRecord and TimeRecord domains.
public class PuzzleModel {

    private String difficultiesFilePath;
    private String moveRecordsDirectoryPath;
    private String timeRecordsDirectoryPath;
    
    public PuzzleModel(String difficultiesFilePath, 
            String moveRecordsDirectoryPath, String timeRecordsDirectoryPath){
        
        this.difficultiesFilePath = difficultiesFilePath;
        this.moveRecordsDirectoryPath = moveRecordsDirectoryPath;
        this.timeRecordsDirectoryPath = timeRecordsDirectoryPath;       
        
    }

    
    // Returns up to 10 best records in a number of moves as na array list.
    public List<Record> getAllMoveRecords(String recordsFileName) {
        
        String moveRecordsFilePath = moveRecordsDirectoryPath + recordsFileName;
        String timeRecordsFilePath = timeRecordsDirectoryPath + recordsFileName;        
        
        RecordsModel rm = new RecordsModel(moveRecordsFilePath, timeRecordsFilePath);
        return rm.getAllMoveRecords();
        
    }
    

    // Returns up to 10 best records in shortest time taken as na array list.
    public List<Record> getAllTimeRecords(String recordsFileName) {
        
        String moveRecordsFilePath = moveRecordsDirectoryPath + recordsFileName;
        String timeRecordsFilePath = timeRecordsDirectoryPath + recordsFileName; 
        
        RecordsModel rm = new RecordsModel(moveRecordsFilePath, timeRecordsFilePath);
        return rm.getAllTimeRecords();
        
    }
    
    
    // Clears records lists.
    // Deletes records from txt files.
    public void clearRecords(String recordsFileName){
        
        String moveRecordsFilePath = moveRecordsDirectoryPath + recordsFileName;
        String timeRecordsFilePath = timeRecordsDirectoryPath + recordsFileName; 
        
        RecordsModel rm = new RecordsModel(moveRecordsFilePath, timeRecordsFilePath);
        rm.clearRecords();
        
    }
    
    
    // Checks for a new record for a selected photo and difficulty.
    // If there is one adds it to the records lists.
    // Also saves it in a records file.
    public Record tryRecord(String recordsFileName, String name, double result, String type) {
        
        String moveRecordsFilePath = moveRecordsDirectoryPath + recordsFileName;
        String timeRecordsFilePath = timeRecordsDirectoryPath + recordsFileName; 
        
        RecordsModel rm = new RecordsModel(moveRecordsFilePath, timeRecordsFilePath);
        return rm.tryRecord(name, result, type);
        
    }   
    
    
    // Returns a list of all photo objects.
    public List<Photo> getAllPhotos() { 
        PhotoModel pm = new PhotoModel(difficultiesFilePath);
        return pm.getAllPhotos(); 
    }
    
    
    // Returns a single photo object.
    public Photo getPhoto(String name) {
        PhotoModel pm = new PhotoModel(difficultiesFilePath);
        return pm.getPhoto(name);         
    }
    
    
    // Adds/Deletes/Replaces a difficulty for a selected photo.
    public List<String> changeDifficulty(String name, String newDifficulty, String oldDifficulty) {
        
        PhotoModel pm = new PhotoModel(difficultiesFilePath);
        List<String> labels = pm.changeDifficulty(name, newDifficulty, oldDifficulty);
        
        if ( !labels.isEmpty() ) {
        
            // Delete existing records files for a removed difficulty.
            if (oldDifficulty != null) {
                manageRecordsFiles(name, oldDifficulty, false);    
            }
            
            // Create new records files for a newly added difficulty.
            if (newDifficulty != null) {                
                manageRecordsFiles(name, newDifficulty, true);
            }
            
        }
        
        return labels;
        
    }       
          
        
    // Creates or deletes records files.
    private void manageRecordsFiles(String imageName, String level, boolean create) {
        
        String recordsFileName = imageName + "_" + level + ".txt";
                        
        String moveRecordsFilePath = moveRecordsDirectoryPath + recordsFileName;
        String timeRecordsFilePath = timeRecordsDirectoryPath + recordsFileName;
            
        File moveRecordsFile = new File(moveRecordsFilePath);
        File timeRecordsFile = new File(timeRecordsFilePath);
        
        try {
            if (create==true) {
                moveRecordsFile.createNewFile();
                timeRecordsFile.createNewFile();
            } else {
                moveRecordsFile.delete();
                timeRecordsFile.delete();    
            }
        } catch (IOException ioe) {
            System.out.println("Error while Creating a file" + ioe);
        }
        
    }


}
