/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private static final String BUNDLE_NAME = "biogenesis/messages/messages";
    private static Locale currentLocale = Locale.getDefault();
    private static ResourceBundle appResourceBundle = ResourceBundle.getBundle("biogenesis/messages/messages", currentLocale);
    private static final String[] supportedLocalesNames = new String[3];
    private static final String[] supportedLocalesCodes = new String[]{"ca", "en", "es"};
    private static final int DEFAULT_LOCALE_INDEX = 1;

    public static Integer getMnemonic(String key) {
        try {
            return appResourceBundle.getString(String.valueOf(key) + "_MNEMONIC").codePointAt(0);
        }
        catch (MissingResourceException e) {
            return key.codePointAt(0);
        }
    }

    public static String getString(String key) {
        try {
            return appResourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return String.valueOf('!') + key + '!';
        }
    }

    public static String getString(String key, String param1) {
        return Messages.getString(key).replace("$1", param1);
    }

    public static String getString(String key, String param1, String param2) {
        return Messages.getString(key, param1).replace("$2", param2);
    }

    public static String getString(String key, String[] params) {
        String string = Messages.getString(key);
        int i = 1;
        while (i <= params.length) {
            String replacedString = "$" + i;
            string = string.replace(replacedString, params[i - 1]);
            ++i;
        }
        return string;
    }

    public static String[] getSupportedLocalesNames() {
        String[] names = new String[supportedLocalesNames.length];
        int i = 0;
        while (i < names.length) {
            names[i] = supportedLocalesNames[i];
            ++i;
        }
        return names;
    }

    public static void setLocale(int index) {
        currentLocale = new Locale(supportedLocalesCodes[index]);
        appResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, currentLocale);
        Messages.changeLocale();
    }

    public static void setLocale(String language) {
        currentLocale = new Locale(language);
        appResourceBundle = ResourceBundle.getBundle(BUNDLE_NAME, currentLocale);
        Messages.changeLocale();
    }

    public static String getLanguage() {
        return currentLocale.getLanguage();
    }

    public static Locale getLocale() {
        return currentLocale;
    }

    public static int getLocaleIndex() {
        int i = 0;
        while (i < supportedLocalesCodes.length) {
            if (currentLocale.getLanguage().equals(supportedLocalesCodes[i])) {
                return i;
            }
            ++i;
        }
        return 1;
    }

    protected static void changeLocale() {
        Messages.supportedLocalesNames[0] = Messages.getString("T_CATALAN");
        Messages.supportedLocalesNames[1] = Messages.getString("T_ENGLISH");
        Messages.supportedLocalesNames[2] = Messages.getString("T_SPANISH");
    }
}

