/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.ExLine2DDouble;
import biogenesis.GeneticCode;
import biogenesis.OutCorridor;
import biogenesis.Utils;
import biogenesis.Vector2D;
import biogenesis.VisibleWorld;
import biogenesis.World;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class Organism
extends Rectangle {
    private static final long serialVersionUID = 700L;
    protected GeneticCode _geneticCode;
    protected GeneticCode _infectedGeneticCode = null;
    protected int _nChildren;
    protected World _world;
    protected transient VisibleWorld _visibleWorld;
    protected int _parentID;
    protected int _ID;
    protected int _generation;
    protected int _nTotalChildren = 0;
    protected int _nTotalKills = 0;
    protected int _nTotalInfected = 0;
    protected int[] _startPointX;
    protected int[] _startPointY;
    protected int[] _endPointX;
    protected int[] _endPointY;
    protected double[] _m1;
    protected double[] _m2;
    protected double[] _m;
    protected int _centerX;
    protected int _centerY;
    protected double _dCenterX;
    protected double _dCenterY;
    protected Color[] _segColor;
    protected int _segments;
    protected int _growthRatio;
    protected double _mass = 0.0;
    protected double _I = 0.0;
    protected double _energy;
    protected Rectangle _sizeRect = new Rectangle();
    protected double _theta;
    protected double _lastTheta = -1.0;
    protected int[] x1;
    protected int[] y1;
    protected int[] x2;
    protected int[] y2;
    protected double dx = 0.0;
    protected double dy = 0.0;
    protected double dtheta = 0.0;
    protected int _age = 0;
    protected Color _color;
    protected int _framesColor = 0;
    protected int _timeToReproduce = 0;
    protected int hasGrown;
    protected boolean hasMoved = true;
    protected Rectangle lastFrame = new Rectangle();
    protected boolean alive = true;
    private static transient Vector2D v = new Vector2D();
    private static final int NOCOLOR = -1;
    private static final int GREEN = 0;
    private static final int RED = 1;
    private static final int CYAN = 2;
    private static final int BLUE = 3;
    private static final int MAGENTA = 4;
    private static final int PINK = 5;
    private static final int ORANGE = 6;
    private static final int WHITE = 7;
    private static final int GRAY = 8;
    private static final int YELLOW = 9;
    private static final int BROWN = 10;

    public boolean isAlive() {
        return this.alive;
    }

    public double getEnergy() {
        return this._energy;
    }

    public int getID() {
        return this._ID;
    }

    public int getParentID() {
        return this._parentID;
    }

    public int getGeneration() {
        return this._generation;
    }

    public int getAge() {
        return this._age;
    }

    public int getTotalChildren() {
        return this._nTotalChildren;
    }

    public int getTotalKills() {
        return this._nTotalKills;
    }

    public int getTotalInfected() {
        return this._nTotalInfected;
    }

    public GeneticCode getGeneticCode() {
        return this._geneticCode;
    }

    public double getMass() {
        return this._mass;
    }

    public Organism(World world) {
        this._world = world;
        this._visibleWorld = world._visibleWorld;
        this._theta = Utils.random.nextDouble() * Math.PI * 2.0;
    }

    public Organism(World world, GeneticCode geneticCode) {
        this._world = world;
        this._visibleWorld = world._visibleWorld;
        this._theta = Utils.random.nextDouble() * Math.PI * 2.0;
        this._geneticCode = geneticCode;
    }

    protected void create() {
        this._segments = this._geneticCode.getNGenes() * this._geneticCode.getSymmetry();
        this._segColor = new Color[this._segments];
        int i = 0;
        while (i < this._segments) {
            this._segColor[i] = this._geneticCode.getGene(i % this._geneticCode.getNGenes()).getColor();
            ++i;
        }
        this._startPointX = new int[this._segments];
        this._startPointY = new int[this._segments];
        this._endPointX = new int[this._segments];
        this._endPointY = new int[this._segments];
        this._m1 = new double[this._segments];
        this._m2 = new double[this._segments];
        this._m = new double[this._segments];
        this.x1 = new int[this._segments];
        this.y1 = new int[this._segments];
        this.x2 = new int[this._segments];
        this.y2 = new int[this._segments];
    }

    public boolean randomCreate() {
        this._geneticCode = new GeneticCode();
        this._parentID = -1;
        this._generation = 1;
        this._growthRatio = 16;
        this._energy = Math.min((double)Utils.INITIAL_ENERGY, this._world.getCO2());
        this._world.decreaseCO2(this._energy);
        this._world.addO2(this._energy);
        this.create();
        this.symmetric();
        return this.placeRandom();
    }

    public boolean inherit(Organism parent, boolean first) {
        boolean ok = true;
        GeneticCode inheritGeneticCode = parent._infectedGeneticCode != null ? parent._infectedGeneticCode : parent._geneticCode;
        this._geneticCode = new GeneticCode(inheritGeneticCode);
        this._parentID = parent.getID();
        this._generation = parent.getGeneration() + 1;
        this._growthRatio = 16;
        this._energy = Math.min((double)inheritGeneticCode._reproduceEnergy / (double)(parent._nChildren + 1), parent._energy);
        if (first || parent._energy >= this._energy + Utils.YELLOW_ENERGY_CONSUMPTION) {
            this.create();
            this.symmetric();
            ok = this.placeNear(parent);
            if (ok && !first) {
                parent.useEnergy(Utils.YELLOW_ENERGY_CONSUMPTION);
            }
        } else {
            ok = false;
        }
        return ok;
    }

    public boolean pasteOrganism(int posx, int posy) {
        this._parentID = -1;
        this._generation = 1;
        this._growthRatio = 16;
        this.create();
        this.symmetric();
        this._centerX = posx;
        this._dCenterX = this._centerX;
        this._centerY = posy;
        this._dCenterY = this._centerY;
        this.calculateBounds(true);
        if (this.isInsideWorld() && this._world.fastCheckHit(this) == null) {
            this._ID = this._world.getNewId();
            this._energy = Math.min((double)Utils.INITIAL_ENERGY, this._world.getCO2());
            this._world.decreaseCO2(this._energy);
            this._world.addO2(this._energy);
            return true;
        }
        return false;
    }

    public void symmetric() {
        int segment = 0;
        int symmetry = this._geneticCode.getSymmetry();
        int mirror = this._geneticCode.getMirror();
        int sequence = this._segments / symmetry;
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        int i = 0;
        while (i < symmetry) {
            int j = 0;
            while (j < sequence) {
                v.setModulus(this._geneticCode.getGene(j).getLength() / Utils.scale[this._growthRatio - 1]);
                if (j == 0) {
                    this._startPointX[segment] = 0;
                    this._startPointY[segment] = 0;
                    if (mirror == 0 || i % 2 == 0) {
                        v.setTheta(this._geneticCode.getGene(j).getTheta() + (double)(i * 2) * Math.PI / (double)symmetry);
                    } else {
                        v.setTheta(this._geneticCode.getGene(j).getTheta() + (double)((i - 1) * 2) * Math.PI / (double)symmetry);
                        v.invertX();
                    }
                } else {
                    this._startPointX[segment] = this._endPointX[segment - 1];
                    this._startPointY[segment] = this._endPointY[segment - 1];
                    if (mirror == 0 || i % 2 == 0) {
                        v.addDegree(this._geneticCode.getGene(j).getTheta());
                    } else {
                        v.addDegree(-this._geneticCode.getGene(j).getTheta());
                    }
                }
                this._endPointX[segment] = (int)Math.round(v.getX() + (double)this._startPointX[segment]);
                this._endPointY[segment] = (int)Math.round(v.getY() + (double)this._startPointY[segment]);
                left = Math.min(left, this._endPointX[segment]);
                right = Math.max(right, this._endPointX[segment]);
                top = Math.min(top, this._endPointY[segment]);
                bottom = Math.max(bottom, this._endPointY[segment]);
                ++j;
                ++segment;
            }
            ++i;
        }
        this._sizeRect.setBounds(left, top, right - left + 1, bottom - top + 1);
        int centerX = left + right >> 1;
        int centerY = top + bottom >> 1;
        this._mass = 0.0;
        this._I = 0.0;
        i = 0;
        while (i < this._segments) {
            int n = i;
            this._startPointX[n] = this._startPointX[n] - centerX;
            int n2 = i;
            this._startPointY[n2] = this._startPointY[n2] - centerY;
            int n3 = i;
            this._endPointX[n3] = this._endPointX[n3] - centerX;
            int n4 = i;
            this._endPointY[n4] = this._endPointY[n4] - centerY;
            this._m1[i] = Math.sqrt(this._startPointX[i] * this._startPointX[i] + this._startPointY[i] * this._startPointY[i]);
            this._m2[i] = Math.sqrt(this._endPointX[i] * this._endPointX[i] + this._endPointY[i] * this._endPointY[i]);
            this._m[i] = Math.sqrt(Math.pow(this._endPointX[i] - this._startPointX[i], 2.0) + Math.pow(this._endPointY[i] - this._startPointY[i], 2.0));
            this._mass += this._m[i];
            double cx = (double)(this._startPointX[i] + this._endPointX[i]) / 2.0;
            double cy = (double)(this._startPointY[i] + this._endPointY[i]) / 2.0;
            this._I += Math.pow(this._m[i], 3.0) / 12.0 + this._m[i] * cx * cx + cy * cy;
            ++i;
        }
    }

    private boolean placeRandom() {
        int i = 12;
        while (i > 0) {
            Point origin = new Point(Utils.random.nextInt(this._world.getWidth() - this._sizeRect.width), Utils.random.nextInt(this._world.getHeight() - this._sizeRect.height));
            this.setBounds(origin.x, origin.y, this._sizeRect.width, this._sizeRect.height);
            this._centerX = origin.x + (this._sizeRect.width >> 1);
            this._dCenterX = this._centerX;
            this._centerY = origin.y + (this._sizeRect.height >> 1);
            this._dCenterY = this._centerY;
            if (this._world.fastCheckHit(this) == null) {
                this._ID = this._world.getNewId();
                return true;
            }
            --i;
        }
        return false;
    }

    private boolean placeNear(Organism parent) {
        int nPos = Utils.random.nextInt(8);
        int nSide = 0;
        while (nSide < 8) {
            this._dCenterX = parent._dCenterX + (double)((parent.width / 2 + this.width / 2 + 1) * Utils.side[nPos][0]);
            this._dCenterY = parent._dCenterY + (double)((parent.height / 2 + this.height / 2 + 1) * Utils.side[nPos][1]);
            this._centerX = (int)this._dCenterX;
            this._centerY = (int)this._dCenterY;
            this.calculateBounds(true);
            if (this.isInsideWorld() && this._world.fastCheckHit(this) == null) {
                if (parent._geneticCode.getDisperseChildren()) {
                    this.dx = Utils.side[nPos][0];
                    this.dy = Utils.side[nPos][1];
                } else {
                    this.dx = parent.dx;
                    this.dy = parent.dy;
                }
                this._ID = this._world.getNewId();
                parent._energy -= this._energy;
                return true;
            }
            nPos = (nPos + 1) % 8;
            ++nSide;
        }
        return false;
    }

    public void draw(Graphics g) {
        if (this._framesColor > 0) {
            g.setColor(this._color);
            --this._framesColor;
            int i = 0;
            while (i < this._segments) {
                g.drawLine(this.x1[i] + this._centerX, this.y1[i] + this._centerY, this.x2[i] + this._centerX, this.y2[i] + this._centerY);
                ++i;
            }
        } else if (this.alive) {
            int i = 0;
            while (i < this._segments) {
                g.setColor(this._segColor[i]);
                g.drawLine(this.x1[i] + this._centerX, this.y1[i] + this._centerY, this.x2[i] + this._centerX, this.y2[i] + this._centerY);
                ++i;
            }
        } else {
            g.setColor(Utils.ColorBROWN);
            int i = 0;
            while (i < this._segments) {
                g.drawLine(this.x1[i] + this._centerX, this.y1[i] + this._centerY, this.x2[i] + this._centerX, this.y2[i] + this._centerY);
                ++i;
            }
        }
    }

    public void calculateBounds(boolean force) {
        double left = Double.MAX_VALUE;
        double right = Double.MIN_VALUE;
        double top = Double.MAX_VALUE;
        double bottom = Double.MIN_VALUE;
        int i = this._segments - 1;
        while (i >= 0) {
            if (this._lastTheta != this._theta || force) {
                double theta = this._theta + Math.atan2(this._startPointY[i], this._startPointX[i]);
                this.x1[i] = (int)(this._m1[i] * Math.cos(theta));
                this.y1[i] = (int)(this._m1[i] * Math.sin(theta));
                theta = this._theta + Math.atan2(this._endPointY[i], this._endPointX[i]);
                this.x2[i] = (int)(this._m2[i] * Math.cos(theta));
                this.y2[i] = (int)(this._m2[i] * Math.sin(theta));
            }
            left = Utils.min(left, (double)this.x1[i] + this._dCenterX, (double)this.x2[i] + this._dCenterX);
            right = Utils.max(right, (double)this.x1[i] + this._dCenterX, (double)this.x2[i] + this._dCenterX);
            top = Utils.min(top, (double)this.y1[i] + this._dCenterY, (double)this.y2[i] + this._dCenterY);
            bottom = Utils.max(bottom, (double)this.y1[i] + this._dCenterY, (double)this.y2[i] + this._dCenterY);
            --i;
        }
        this.setBounds((int)left, (int)top, (int)(right - left + 1.0) + 1, (int)(bottom - top + 1.0) + 1);
        this._lastTheta = this._theta;
    }

    private void grow() {
        if (this._growthRatio > 1 && (this._age & 7) == 7 && this.alive && this._energy >= this._mass / 10.0) {
            --this._growthRatio;
            double m = this._mass;
            double I = this._I;
            this.symmetric();
            m = Math.sqrt(m / this._mass);
            this.dx *= m;
            this.dy *= m;
            this.dtheta *= Math.sqrt(I / this._I);
            this.hasGrown = 1;
        } else if (this._growthRatio < 15 && this._energy < this._mass / 12.0) {
            ++this._growthRatio;
            double m = this._mass;
            double I = this._I;
            this.symmetric();
            m = Math.sqrt(m / this._mass);
            this.dx *= m;
            this.dy *= m;
            this.dtheta *= Math.sqrt(I / this._I);
            this.hasGrown = -1;
        } else {
            this.hasGrown = 0;
        }
    }

    public void reproduce() {
        int i = 0;
        while (i < Utils.between(this._nChildren, 1, 8)) {
            Organism newOrg = new Organism(this._world);
            if (newOrg.inherit(this, i == 0)) {
                ++this._nTotalChildren;
                this._world.addOrganism(newOrg, this);
                this._infectedGeneticCode = null;
            }
            this._timeToReproduce = 20;
            ++i;
        }
    }

    public boolean move() {
        boolean collision = false;
        this.hasMoved = false;
        this.lastFrame.setBounds(this);
        if (Math.abs(this.dx) < 1.0E-7) {
            this.dx = 0.0;
        }
        if (Math.abs(this.dy) < 1.0E-7) {
            this.dy = 0.0;
        }
        if (Math.abs(this.dtheta) < 1.0E-7) {
            this.dtheta = 0.0;
        }
        this.segmentsFrameEffects();
        this.rubbingFramesEffects();
        this.grow();
        double dxbak = this.dx;
        double dybak = this.dy;
        double dthetabak = this.dtheta;
        this.offset(this.dx, this.dy, this.dtheta);
        this.calculateBounds(this.hasGrown != 0);
        if (this.hasGrown != 0 || this.dx != 0.0 || this.dy != 0.0 || this.dtheta != 0.0) {
            OutCorridor c;
            this.hasMoved = true;
            boolean bl = collision = !this.isInsideWorld();
            if (this.alive && (c = this._world.checkHitCorridor(this)) != null && c.canSendOrganism() && c.sendOrganism(this)) {
                return false;
            }
            if (this._world.checkHit(this) != null) {
                collision = true;
            }
            if (collision) {
                this.hasMoved = false;
                this.offset(-dxbak, -dybak, -dthetabak);
                if (this.hasGrown != 0) {
                    this._growthRatio += this.hasGrown;
                    this.symmetric();
                }
                this.calculateBounds(this.hasGrown != 0);
            }
        }
        if (this._timeToReproduce > 0) {
            --this._timeToReproduce;
        }
        if (this._energy > (double)this._geneticCode.getReproduceEnergy() + Utils.YELLOW_ENERGY_CONSUMPTION * (double)(this._nChildren - 1) && this._growthRatio == 1 && this._timeToReproduce == 0 && this.alive) {
            this.reproduce();
        }
        if (this._energy > (double)(2 * this._geneticCode.getReproduceEnergy())) {
            this.useEnergy(this._energy - (double)(2 * this._geneticCode.getReproduceEnergy()));
        }
        this.breath();
        return this._energy > 1.0E-7;
    }

    public boolean useEnergy(double q) {
        if (this._energy < q) {
            return false;
        }
        double respiration = this._world.respiration(q);
        this._energy -= respiration;
        return !(respiration < q);
    }

    public void breath() {
        if (this.alive) {
            ++this._age;
            boolean canBreath = this.useEnergy(Math.min(this._mass / (double)Utils.SEGMENT_COST_DIVISOR, this._energy));
            if (this._age >> 8 > this._geneticCode.getMaxAge() || !canBreath) {
                this.die(null);
            } else if (this._energy <= 1.0E-7) {
                this.alive = false;
                this._world.decreasePopulation();
                this._world.organismHasDied(this, null);
            }
        } else {
            this.useEnergy(Math.min(this._energy, Utils.DECAY_ENERGY));
        }
    }

    public void die(Organism killingOrganism) {
        this.alive = false;
        this.hasMoved = true;
        int i = 0;
        while (i < this._segments) {
            this._segColor[i] = Utils.ColorBROWN;
            ++i;
        }
        this._world.decreasePopulation();
        if (killingOrganism != null) {
            ++killingOrganism._nTotalKills;
        }
        this._world.organismHasDied(this, killingOrganism);
    }

    public void infectedBy(GeneticCode infectingCode) {
        this._infectedGeneticCode = infectingCode;
        this._world.organismHasBeenInfected(this, null);
    }

    public void infectedBy(Organism infectingOrganism) {
        ++infectingOrganism._nTotalInfected;
        this._infectedGeneticCode = infectingOrganism.getGeneticCode();
        this._world.organismHasBeenInfected(this, infectingOrganism);
    }

    private final void touchMove(Organism org, Point2D.Double p, Line2D l, boolean thisOrganism) {
        double rapx = p.x - this._dCenterX;
        double rapy = p.y - this._dCenterY;
        double rbpx = p.x - org._dCenterX;
        double rbpy = p.y - org._dCenterY;
        double vap1x = this.dx - this.dtheta * rapy + (double)this.hasGrown * rapx / 10.0;
        double vap1y = this.dy + this.dtheta * rapx + (double)this.hasGrown * rapy / 10.0;
        double vbp1x = org.dx - org.dtheta * rbpy;
        double vbp1y = org.dy + org.dtheta * rbpx;
        double vab1x = vap1x - vbp1x;
        double vab1y = vap1y - vbp1y;
        double nx = l.getY1() - l.getY2();
        double ny = l.getX2() - l.getX1();
        double modn = Math.sqrt(nx * nx + ny * ny);
        nx /= modn;
        ny /= modn;
        if (thisOrganism) {
            if ((p.x + nx - org._dCenterX) * (p.x + nx - org._dCenterX) + (p.y + ny - org._dCenterY) * (p.y + ny - org._dCenterY) < (p.x - nx - org._dCenterX) * (p.x - nx - org._dCenterX) + (p.y - ny - org._dCenterY) * (p.y - ny - org._dCenterY)) {
                nx = -nx;
                ny = -ny;
            }
        } else if ((p.x + nx - this._dCenterX) * (p.x + nx - this._dCenterX) + (p.y + ny - this._dCenterY) * (p.y + ny - this._dCenterY) > (p.x - nx - this._dCenterX) * (p.x - nx - this._dCenterX) + (p.y - ny - this._dCenterY) * (p.y - ny - this._dCenterY)) {
            nx = -nx;
            ny = -ny;
        }
        double j = -(1.0 + Utils.ELASTICITY) * (vab1x * nx + vab1y * ny) / (1.0 / this._mass + 1.0 / org._mass + Math.pow(rapx * ny - rapy * nx, 2.0) / this._I + Math.pow(rbpx * ny - rbpy * nx, 2.0) / org._I);
        this.dx = Utils.between(this.dx + j * nx / this._mass, -Utils.MAX_VEL, Utils.MAX_VEL);
        this.dy = Utils.between(this.dy + j * ny / this._mass, -Utils.MAX_VEL, Utils.MAX_VEL);
        org.dx = Utils.between(org.dx - j * nx / org._mass, -Utils.MAX_VEL, Utils.MAX_VEL);
        org.dy = Utils.between(org.dy - j * ny / org._mass, -Utils.MAX_VEL, Utils.MAX_VEL);
        this.dtheta = Utils.between(this.dtheta + j * (rapx * ny - rapy * nx) / this._I, -Utils.MAX_ROT, Utils.MAX_ROT);
        org.dtheta = Utils.between(org.dtheta - j * (rbpx * ny - rbpy * ny) / org._I, -Utils.MAX_ROT, Utils.MAX_ROT);
    }

    private final boolean isInsideWorld() {
        if (this.x < 0 || this.y < 0 || this.x + this.width >= this._world.getWidth() || this.y + this.height >= this._world.getHeight()) {
            if (this.x < 0 || this.x + this.width >= this._world.getWidth()) {
                this.dx = -this.dx;
            }
            if (this.y < 0 || this.y + this.height >= this._world.getHeight()) {
                this.dy = -this.dy;
            }
            this.dtheta = 0.0;
            return false;
        }
        return true;
    }

    private final void offset(double offsetx, double offsety, double offsettheta) {
        this._dCenterX += offsetx;
        this._dCenterY += offsety;
        this._theta += offsettheta;
        this._centerX = (int)this._dCenterX;
        this._centerY = (int)this._dCenterY;
    }

    public final boolean contact(Organism org) {
        ExLine2DDouble line = new ExLine2DDouble();
        ExLine2DDouble bline = new ExLine2DDouble();
        int i = this._segments - 1;
        while (i >= 0) {
            if (this._m[i] >= 1.0) {
                line.setLine(this.x1[i] + this._centerX, this.y1[i] + this._centerY, this.x2[i] + this._centerX, this.y2[i] + this._centerY);
                if (org.intersectsLine(line)) {
                    int j = org._segments - 1;
                    while (j >= 0) {
                        if (org._m[j] >= 1.0) {
                            bline.setLine(org.x1[j] + org._centerX, org.y1[j] + org._centerY, org.x2[j] + org._centerX, org.y2[j] + org._centerY);
                            if (this.intersectsLine(bline) && line.intersectsLine(bline)) {
                                this.touchEffects(org, i, j, true);
                                Point2D.Double intersec = line.getIntersection(bline);
                                double dl1 = intersec.distanceSq(line.getP1());
                                double dl2 = intersec.distanceSq(line.getP2());
                                double dbl1 = intersec.distanceSq(bline.getP1());
                                double dbl2 = intersec.distanceSq(bline.getP2());
                                if (Math.min(dl1, dl2) < Math.min(dbl1, dbl2)) {
                                    this.touchMove(org, intersec, bline, false);
                                } else {
                                    this.touchMove(org, intersec, line, true);
                                }
                                return true;
                            }
                        }
                        --j;
                    }
                }
            }
            --i;
        }
        return false;
    }

    private final void touchEffects(Organism org, int seg, int oseg, boolean firstCall) {
        if ((this._parentID == org._ID || this._ID == org._parentID) && org.alive) {
            return;
        }
        double takenEnergy = 0.0;
        block0 : switch (Organism.getTypeColor(this._segColor[seg])) {
            case 1: {
                switch (Organism.getTypeColor(org._segColor[oseg])) {
                    case 3: {
                        if (org.useEnergy(Utils.BLUE_ENERGY_CONSUMPTION)) {
                            org.setColor(Color.BLUE);
                            break;
                        }
                        if (!this.useEnergy(Utils.RED_ENERGY_CONSUMPTION)) break;
                        takenEnergy = Utils.between(this._m[seg] * Utils.ORGANIC_OBTAINED_ENERGY, 0.0, org._energy);
                        org.setColor(Color.YELLOW);
                        break;
                    }
                    case 1: {
                        if (!this.useEnergy(Utils.RED_ENERGY_CONSUMPTION)) break;
                        takenEnergy = Utils.between(this._m[seg] * Utils.ORGANIC_OBTAINED_ENERGY, 0.0, org._energy);
                        org.setColor(Color.RED);
                        break;
                    }
                    default: {
                        if (!this.useEnergy(Utils.RED_ENERGY_CONSUMPTION)) break;
                        takenEnergy = Utils.between(this._m[seg] * Utils.ORGANIC_OBTAINED_ENERGY, 0.0, org._energy);
                        org.setColor(Color.YELLOW);
                    }
                }
                org._energy -= takenEnergy;
                this._energy += takenEnergy;
                double CO2freed = takenEnergy * Utils.ORGANIC_SUBS_PRODUCED;
                this.useEnergy(CO2freed);
                this.setColor(Color.RED);
                break;
            }
            case 7: {
                switch (Organism.getTypeColor(org._segColor[oseg])) {
                    case 3: {
                        if (org.useEnergy(Utils.BLUE_ENERGY_CONSUMPTION)) {
                            this.setColor(Color.WHITE);
                            org.setColor(Color.BLUE);
                            break block0;
                        }
                        if (org._infectedGeneticCode == this._geneticCode || !this.useEnergy(Utils.WHITE_ENERGY_CONSUMPTION)) break block0;
                        org.infectedBy(this);
                        org.setColor(Color.YELLOW);
                        this.setColor(Color.WHITE);
                        break block0;
                    }
                    case 10: {
                        break block0;
                    }
                }
                if (org._infectedGeneticCode == this._geneticCode || !this.useEnergy(Utils.WHITE_ENERGY_CONSUMPTION)) break;
                org.infectedBy(this);
                org.setColor(Color.YELLOW);
                this.setColor(Color.WHITE);
                break;
            }
            case 8: {
                switch (Organism.getTypeColor(org._segColor[oseg])) {
                    case 3: {
                        if (org.useEnergy(Utils.BLUE_ENERGY_CONSUMPTION)) {
                            org.setColor(Color.BLUE);
                            this.setColor(Color.GRAY);
                            break block0;
                        }
                        if (!this.useEnergy(Utils.GRAY_ENERGY_CONSUMPTION)) break block0;
                        org.die(this);
                        this.setColor(Color.GRAY);
                        break block0;
                    }
                    case 10: {
                        break block0;
                    }
                }
                if (!this.useEnergy(Utils.GRAY_ENERGY_CONSUMPTION)) break;
                org.die(this);
                this.setColor(Color.GRAY);
            }
        }
        if (org.isAlive() && org._energy < 1.0E-7) {
            org.die(this);
        }
        if (firstCall) {
            org.touchEffects(this, oseg, seg, false);
        }
    }

    private final void rubbingFramesEffects() {
        this.dx *= Utils.RUBBING;
        if (Math.abs(this.dx) < 1.0E-7) {
            this.dx = 0.0;
        }
        this.dy *= Utils.RUBBING;
        if (Math.abs(this.dy) < 1.0E-7) {
            this.dy = 0.0;
        }
        this.dtheta *= Utils.RUBBING;
        if (Math.abs(this.dtheta) < 1.0E-7) {
            this.dtheta = 0.0;
        }
    }

    private final void segmentsFrameEffects() {
        if (this.alive) {
            double photosynthesis = 0.0;
            this._nChildren = 1;
            int i = this._segments - 1;
            while (i >= 0) {
                switch (Organism.getTypeColor(this._segColor[i])) {
                    case 2: {
                        if (Utils.random.nextInt(100) >= 8 || !this.useEnergy(Utils.CYAN_ENERGY_CONSUMPTION)) break;
                        this.dx = Utils.between(this.dx + 12.0 * (double)(this.x2[i] - this.x1[i]) / this._mass, -Utils.MAX_VEL, Utils.MAX_VEL);
                        this.dy = Utils.between(this.dy + 12.0 * (double)(this.y2[i] - this.y1[i]) / this._mass, -Utils.MAX_VEL, Utils.MAX_VEL);
                        this.dtheta = Utils.between(this.dtheta + (double)Utils.randomSign() * this._m[i] * Math.PI / this._I, -Utils.MAX_ROT, Utils.MAX_ROT);
                        break;
                    }
                    case 0: {
                        if (!this.useEnergy(Utils.GREEN_ENERGY_CONSUMPTION)) break;
                        photosynthesis += this._m[i];
                        break;
                    }
                    case 9: {
                        ++this._nChildren;
                    }
                }
                --i;
            }
            this._energy += this._world.photosynthesis(photosynthesis);
        }
    }

    private static final int getTypeColor(Color c) {
        if (c.equals(Color.RED) || c.equals(Utils.ColorDARK_RED)) {
            return 1;
        }
        if (c.equals(Color.GREEN) || c.equals(Utils.ColorDARK_GREEN)) {
            return 0;
        }
        if (c.equals(Color.CYAN) || c.equals(Utils.ColorDARK_CYAN)) {
            return 2;
        }
        if (c.equals(Color.BLUE) || c.equals(Utils.ColorDARK_BLUE)) {
            return 3;
        }
        if (c.equals(Color.MAGENTA) || c.equals(Utils.ColorDARK_MAGENTA)) {
            return 4;
        }
        if (c.equals(Color.PINK) || c.equals(Utils.ColorDARK_PINK)) {
            return 5;
        }
        if (c.equals(Color.ORANGE) || c.equals(Utils.ColorDARK_ORANGE)) {
            return 6;
        }
        if (c.equals(Color.WHITE) || c.equals(Utils.ColorDARK_WHITE)) {
            return 7;
        }
        if (c.equals(Color.GRAY) || c.equals(Utils.ColorDARK_GRAY)) {
            return 8;
        }
        if (c.equals(Color.YELLOW) || c.equals(Utils.ColorDARK_YELLOW)) {
            return 9;
        }
        if (c.equals(Utils.ColorBROWN)) {
            return 10;
        }
        return -1;
    }

    private final void setColor(Color c) {
        this._color = c;
        this._framesColor = 10;
    }

    public BufferedImage getImage() {
        BufferedImage image = new BufferedImage(this.width, this.height, 1);
        Graphics2D g = image.createGraphics();
        g.setBackground(Color.BLACK);
        g.clearRect(0, 0, this.width, this.height);
        int i = this._segments - 1;
        while (i >= 0) {
            g.setColor(this._segColor[i]);
            g.drawLine(this.x1[i] - this.x + this._centerX, this.y1[i] - this.y + this._centerY, this.x2[i] - this.x + this._centerX, this.y2[i] - this.y + this._centerY);
            --i;
        }
        return image;
    }
}

