/*
 * Decompiled with CFR 0.152.
 */
package biogenesis;

import biogenesis.Corridor;
import biogenesis.InCorridor;
import biogenesis.Organism;
import biogenesis.OutCorridor;
import biogenesis.StatisticsWindow;
import biogenesis.Utils;
import biogenesis.VisibleWorld;
import biogenesis.WorldStatistics;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class World
implements Serializable {
    private static final long serialVersionUID = 700L;
    protected int _width;
    protected int _height;
    protected List<Organism> _organisms;
    protected transient List<InCorridor> inCorridors;
    protected transient List<OutCorridor> outCorridors;
    protected int _population = 0;
    protected int NEXT_ID;
    protected transient VisibleWorld _visibleWorld;
    private int nFrames;
    protected double _O2;
    protected double _CO2;
    protected WorldStatistics worldStatistics;

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.inCorridors = Collections.synchronizedList(new ArrayList());
        this.outCorridors = Collections.synchronizedList(new ArrayList());
    }

    public StatisticsWindow createStatisticsWindow() {
        return new StatisticsWindow(this._visibleWorld._mainWindow, this.worldStatistics, this._organisms);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Organism findOrganismFromPosition(int x, int y) {
        Organism deadOrganism = null;
        List<Organism> list = this._organisms;
        synchronized (list) {
            for (Organism b : this._organisms) {
                if (!b.contains(x, y)) continue;
                if (b.isAlive()) {
                    return b;
                }
                deadOrganism = b;
            }
        }
        return deadOrganism;
    }

    public int getWidth() {
        return this._width;
    }

    public int getHeight() {
        return this._height;
    }

    public int getNewId() {
        return this.NEXT_ID++;
    }

    public long getTime() {
        return this.worldStatistics.getTime();
    }

    public int getNCorpses() {
        return this._organisms.size() - this._population;
    }

    public int getPopulation() {
        return this._population;
    }

    public void increasePopulation() {
        ++this._population;
        this.worldStatistics.eventPopulationIncrease(this._population);
    }

    public void decreasePopulation() {
        --this._population;
        this.worldStatistics.eventPopulationDecrease(this._population);
    }

    public double getO2() {
        return this._O2;
    }

    public double getCO2() {
        return this._CO2;
    }

    public void addO2(double q) {
        this._O2 += q;
    }

    public void addCO2(double q) {
        this._CO2 += q;
    }

    public void decreaseO2(double q) {
        this._O2 -= Math.min(q, this._O2);
    }

    public void decreaseCO2(double q) {
        this._CO2 -= Math.min(q, this._CO2);
    }

    public double respiration(double q) {
        double d = Math.min(q, this._O2);
        this._O2 -= d;
        this._CO2 += d;
        return d;
    }

    public double photosynthesis(double q) {
        q /= (double)Utils.GREEN_OBTAINED_ENERGY_DIVISOR;
        q = Utils.min(q, q * this._CO2 / (double)Utils.DRAIN_SUBS_DIVISOR, this._CO2);
        this._CO2 -= q;
        this._O2 += q;
        return q;
    }

    public World(VisibleWorld visibleWorld) {
        this._visibleWorld = visibleWorld;
        this._width = Utils.WORLD_WIDTH;
        this._height = Utils.WORLD_HEIGHT;
        this._organisms = Collections.synchronizedList(new ArrayList(Utils.ORGANISMS_VECTOR_SIZE));
        this.inCorridors = Collections.synchronizedList(new ArrayList());
        this.outCorridors = Collections.synchronizedList(new ArrayList());
        this.worldStatistics = new WorldStatistics();
    }

    public void init(VisibleWorld visibleWorld) {
        this._visibleWorld = visibleWorld;
        this._visibleWorld.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
    }

    public void genesis() {
        this.nFrames = 0;
        this._O2 = Utils.INITIAL_O2;
        this._CO2 = Utils.INITIAL_CO2;
        this.NEXT_ID = 0;
        this._population = 0;
        this._visibleWorld.setSelectedOrganism(null);
        this._organisms.clear();
        this._width = Utils.WORLD_WIDTH;
        this._height = Utils.WORLD_HEIGHT;
        this._visibleWorld.setPreferredSize(new Dimension(Utils.WORLD_WIDTH, Utils.WORLD_HEIGHT));
        this.worldStatistics = new WorldStatistics();
        int i = 0;
        while (i < Utils.INITIAL_ORGANISMS) {
            Organism b = new Organism(this);
            if (b.randomCreate()) {
                this.addOrganism(b, null);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disperseAll() {
        List<Organism> list = this._organisms;
        synchronized (list) {
            for (Organism b : this._organisms) {
                if (b.isAlive()) continue;
                b.useEnergy(b.getEnergy());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void killAll() {
        List<Organism> list = this._organisms;
        synchronized (list) {
            for (Organism org : this._organisms) {
                if (!org.isAlive()) continue;
                org.die(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(Graphics g) {
        List<Rectangle> list = this.inCorridors;
        synchronized (list) {
            for (Corridor corridor : this.inCorridors) {
                corridor.draw(g);
            }
        }
        list = this.outCorridors;
        synchronized (list) {
            for (Corridor corridor : this.outCorridors) {
                corridor.draw(g);
            }
        }
        list = this._organisms;
        synchronized (list) {
            for (Organism b : this._organisms) {
                b.draw(g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaintingRegion() {
        List<Rectangle> list = this.inCorridors;
        synchronized (list) {
            for (Corridor corridor : this.inCorridors) {
                this._visibleWorld.repaint(corridor);
            }
        }
        list = this.outCorridors;
        synchronized (list) {
            for (Corridor corridor : this.outCorridors) {
                this._visibleWorld.repaint(corridor);
                if (corridor.getTravellingOrganism() == null) continue;
                this._visibleWorld.repaint(corridor.getTravellingOrganism());
            }
        }
        list = this._organisms;
        synchronized (list) {
            for (Organism b : this._organisms) {
                if (!b.hasMoved) continue;
                this._visibleWorld.repaint(b.lastFrame);
                this._visibleWorld.repaint(b);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time() {
        List<Rectangle> list = this.inCorridors;
        synchronized (list) {
            for (InCorridor c : this.inCorridors) {
                c.frame();
            }
        }
        list = this._organisms;
        synchronized (list) {
            int l = this._organisms.size();
            int i = 0;
            while (i < l) {
                Organism b = this._organisms.get(i);
                if (!b.move()) {
                    this._visibleWorld.repaint(b);
                    this._organisms.remove(i);
                    if (this._visibleWorld.getSelectedOrganism() == b) {
                        this._visibleWorld.setSelectedOrganism(null);
                    }
                    --l;
                    --i;
                }
                ++i;
            }
        }
        if (this.nFrames++ % 20 == 0) {
            this._visibleWorld._mainWindow.getInfoPanel().recalculate();
        }
        if (this.nFrames % 256 == 0) {
            this.nFrames = 0;
            this.worldStatistics.eventTime(this._population, this._O2, this._CO2);
        }
    }

    public void addCorridors(InCorridor in, OutCorridor out) {
        this.inCorridors.add(in);
        this.outCorridors.add(out);
    }

    public void removeCorridors(InCorridor in, OutCorridor out) {
        this.inCorridors.remove(in);
        this.outCorridors.remove(out);
        in.width = in.width + 1;
        in.height = in.height + 1;
        out.width = out.width + 1;
        out.height = out.height + 1;
        this._visibleWorld.repaint(in);
        this._visibleWorld.repaint(out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutCorridor checkHitCorridor(Organism org) {
        List<OutCorridor> list = this.outCorridors;
        synchronized (list) {
            for (OutCorridor c : this.outCorridors) {
                if (!c.contains(org._centerX, org._centerY)) continue;
                return c;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Organism fastCheckHit(Organism b1) {
        List<Organism> list = this._organisms;
        synchronized (list) {
            for (Organism b : this._organisms) {
                if (b1 == b || !b1.intersects(b)) continue;
                return b1;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Organism checkHit(Organism org1) {
        List<Organism> list = this._organisms;
        synchronized (list) {
            for (Organism org : this._organisms) {
                if (org1 == org || !org1.intersects(org) || !org1.contact(org)) continue;
                return org1;
            }
        }
        return null;
    }

    public void addOrganism(Organism child, Organism parent) {
        this._organisms.add(child);
        if (parent == this._visibleWorld.getSelectedOrganism()) {
            this._visibleWorld._mainWindow.getInfoPanel().changeNChildren();
        }
        if (parent != null) {
            this.worldStatistics.eventOrganismBorn(child, parent);
        }
        this.worldStatistics.eventOrganismCreated();
        this.increasePopulation();
    }

    public void organismHasDied(Organism dyingOrganism, Organism killingOrganism) {
        this.worldStatistics.eventOrganismDie(dyingOrganism, killingOrganism);
        if (killingOrganism == this._visibleWorld.getSelectedOrganism()) {
            this._visibleWorld._mainWindow.getInfoPanel().changeNKills();
        }
        if (dyingOrganism == this._visibleWorld.getSelectedOrganism()) {
            this._visibleWorld.showDeadToolbar();
        }
    }

    public void organismHasBeenInfected(Organism infectedOrganism, Organism infectingOrganism) {
        this.worldStatistics.eventOrganismInfects(infectedOrganism, infectingOrganism);
        if (infectingOrganism == this._visibleWorld.getSelectedOrganism()) {
            this._visibleWorld._mainWindow.getInfoPanel().changeNInfected();
        }
    }
}

