/*
 * Decompiled with CFR 0.152.
 */
package datentyp;

public class Vector2d {
    private double a;
    private double b;

    public Vector2d() {
        this(0.0, 0.0);
    }

    public Vector2d(double a, double b) {
        this.a = a;
        this.b = b;
    }

    public double getA() {
        return this.a;
    }

    public void setA(double a) {
        this.a = a;
    }

    public double getB() {
        return this.b;
    }

    public void setB(double b) {
        this.b = b;
    }

    public Vector2d add(Vector2d v) {
        return new Vector2d(this.a + v.a, this.b + v.b);
    }

    public Vector2d sub(Vector2d v) {
        return new Vector2d(this.a - v.a, this.b - v.b);
    }

    public double times(Vector2d v) {
        return this.a * v.a + this.b * v.b;
    }

    public Vector2d mult(double a) {
        return new Vector2d(this.a * a, this.b * a);
    }

    public Vector2d div(double a) {
        return this.mult(1.0 / a);
    }

    public double length() {
        return Math.sqrt(this.a * this.a + this.b * this.b);
    }

    public Vector2d orthogonal() {
        return new Vector2d(-this.b, this.a);
    }

    public boolean isIn(Vector2d[] polygon) {
        for (int i = 0; i < polygon.length; ++i) {
            Vector2d u = polygon[(i + 1) % polygon.length].sub(polygon[i]);
            Vector2d o = u.orthogonal();
            Vector2d v = this.sub(polygon[i]);
            double a = v.times(o);
            if (!(a < 0.0)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "(" + this.a + "," + this.b + ")";
    }

    public static void main(String[] args) {
        Vector2d[] test = new Vector2d[]{new Vector2d(0.0, 0.0), new Vector2d(10.0, 0.0), new Vector2d(10.0, 10.0), new Vector2d(0.0, 10.0)};
        Vector2d v = new Vector2d(5.0, -5.0);
        System.out.println(v.isIn(test));
    }
}

