/*
 * Decompiled with CFR 0.152.
 */
package fachkonzept;

public class Console {
    private char[][] console;
    private int width;
    private int height;

    public Console() {
        this(8, 8);
    }

    public Console(int w, int h) {
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("Illegal Console size: " + w + " x " + h);
        }
        this.console = new char[h][w];
        this.width = w;
        this.height = h;
        this.clear();
    }

    public final void clear() {
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                this.console[y][x] = 32;
            }
        }
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public char getChar(int x, int y) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IndexOutOfBoundsException("Illegal Cursor Position For Console (" + this.width + " x " + this.height + "): " + x + ", " + y);
        }
        return this.console[y][x];
    }

    public void setChar(int x, int y, char c) {
        if (x < 0 || x >= this.width || y < 0 || y >= this.height) {
            throw new IndexOutOfBoundsException("Illegal Cursor Position For Console (" + this.width + " x " + this.height + "): " + x + ", " + y);
        }
        this.console[y][x] = c;
    }

    public String toString() {
        String e = "";
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                e = e + this.console[y][x] + " ";
            }
            e = e + "\n";
        }
        return e;
    }
}

