/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datentyp.Matrix3d;
import datentyp.Vector2d;
import datentyp.Vector3d;
import fachkonzept.Mode;
import fachkonzept.Plane;
import gui.Cube3dGuiTimer;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Observable;
import java.util.Observer;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import model.CubeModel;

public class Cube3dGui
extends JPanel
implements Observer {
    private CubeModel cubeModel;
    public static Color[] colors = new Color[]{Color.WHITE, Color.RED, Color.BLUE, Color.YELLOW, new Color(255, 160, 0), Color.GREEN};
    private Mode mode;
    private int count;
    private double dyOfs;
    private double dxOfs;
    private Cube3dGuiTimer cube3dGuiTimer;
    private Timer timer;

    public Cube3dGui() {
        this(new CubeModel());
    }

    public Cube3dGui(CubeModel cubeModel) {
        this.cubeModel = cubeModel;
        this.cubeModel.addObserver(this);
        this.mode = new Mode();
        this.count = 0;
        this.dxOfs = 20.0;
        this.dyOfs = 60.0;
        this.initComponents();
        this.cube3dGuiTimer = new Cube3dGuiTimer(this);
        this.timer = new Timer();
        this.timer.scheduleAtFixedRate((TimerTask)this.cube3dGuiTimer, 1L, 5L);
    }

    public int getCount() {
        return this.count;
    }

    public void incCount() {
        ++this.count;
        if (this.count >= 90) {
            this.cubeModel.step(this.mode);
            this.mode = this.cubeModel.hasNextProgramStep() ? this.cubeModel.getNextProgramStep() : new Mode();
            this.count = 0;
        }
        this.repaint();
    }

    public Mode.Modes getMode() {
        return this.mode.mode;
    }

    public int getModeRow() {
        return this.mode.modeRow;
    }

    public void setMode(Mode.Modes mode) {
        this.setMode(mode, -1);
    }

    public void setMode(Mode mode) {
        this.setMode(mode.mode, mode.modeRow);
    }

    public void setMode(Mode.Modes mode, int modeRow) {
        if (this.mode.mode != Mode.Modes.doNothing) {
            return;
        }
        this.count = 0;
        this.mode.mode = mode;
        this.mode.modeRow = modeRow;
        this.cubeModel.clearProgram();
    }

    public void runProgram(Mode[] program) {
        this.cubeModel.addProgram(program);
        if (this.mode.mode != Mode.Modes.doNothing) {
            return;
        }
        this.mode = this.cubeModel.getNextProgramStep();
        this.count = 0;
    }

    public boolean isProgramRunning() {
        return this.mode.mode != Mode.Modes.doNothing;
    }

    public void shuffle() {
        Mode[] shuffle = new Mode[25];
        for (int i = 0; i < 25; ++i) {
            shuffle[i] = Mode.random();
        }
        this.runProgram(shuffle);
    }

    public void solve() {
        Mode[] solution = this.cubeModel.getSolution();
        this.runProgram(solution);
    }

    public double getDxOfs() {
        return this.dxOfs;
    }

    public void setDxOfs(double dxOfs) {
        this.dxOfs = dxOfs;
        this.repaint();
    }

    public double getDyOfs() {
        return this.dyOfs;
    }

    public void setDyOfs(double dyOfs) {
        this.dyOfs = dyOfs;
        this.repaint();
    }

    public void update(Observable o, Object arg) {
        this.repaint();
    }

    public Matrix3d getXMatrix(double r) {
        double sinx = Math.sin(r / 180.0 * Math.PI);
        double cosx = Math.cos(r / 180.0 * Math.PI);
        return new Matrix3d(1.0, 0.0, 0.0, 0.0, cosx, -sinx, 0.0, sinx, cosx);
    }

    public Matrix3d getYMatrix(double r) {
        double sinx = Math.sin(r / 180.0 * Math.PI);
        double cosx = Math.cos(r / 180.0 * Math.PI);
        return new Matrix3d(cosx, 0.0, sinx, 0.0, 1.0, 0.0, -sinx, 0.0, cosx);
    }

    public Matrix3d getZMatrix(double r) {
        double sinx = Math.sin(r / 180.0 * Math.PI);
        double cosx = Math.cos(r / 180.0 * Math.PI);
        return new Matrix3d(cosx, -sinx, 0.0, sinx, cosx, 0.0, 0.0, 0.0, 1.0);
    }

    public Vector2d project(Vector3d v, Matrix3d camera, Vector3d ofs, double zoom) {
        Vector3d w = camera.mult(v).add(ofs);
        int size = this.getWidth() > this.getHeight() ? this.getHeight() : this.getWidth();
        return new Vector2d(w.getA() / (w.getC() + 1.0) * zoom * (double)size / 2.0 + (double)(this.getWidth() / 2), w.getB() / (w.getC() + 1.0) * zoom * (double)size / 2.0 + (double)(this.getHeight() / 2));
    }

    public Vector2d[] project(Vector3d[] v, Matrix3d camera, Vector3d ofs, double zoom) {
        Vector2d[] e = new Vector2d[v.length];
        for (int i = 0; i < v.length; ++i) {
            e[i] = this.project(v[i], camera, ofs, zoom);
        }
        return e;
    }

    public void drawLine(Graphics g, Vector2d a, Vector2d b) {
        g.drawLine((int)a.getA(), (int)a.getB(), (int)b.getA(), (int)b.getB());
    }

    public void drawPoly(Graphics g, Vector2d[] a) {
        int n = a.length;
        int[] xPoints = new int[n];
        int[] yPoints = new int[n];
        for (int i = 0; i < n; ++i) {
            xPoints[i] = (int)a[i].getA();
            yPoints[i] = (int)a[i].getB();
        }
        g.fillPolygon(xPoints, yPoints, n);
    }

    public void drawBlackPlane(Graphics g, Matrix3d camera, Vector3d u, Vector3d v, Vector3d p, Vector3d n) {
        Vector3d ofs = new Vector3d(0.0, 0.0, 3.0);
        double zoom = 5.0;
        Vector3d view = camera.mult(p.add(u.div(2.0)).add(v.div(2.0))).add(ofs);
        Vector3d n1 = camera.mult(n);
        if (n1.times(view) > 0.0) {
            return;
        }
        Vector3d[] rect3d = new Vector3d[]{p, p.add(u), p.add(u).add(v), p.add(v)};
        Vector2d[] rect2d = this.project(rect3d, camera, ofs, zoom);
        g.setColor(Color.BLACK);
        this.drawPoly(g, rect2d);
    }

    public void drawBlackColumn(Graphics g, Matrix3d camera, Vector3d u, Vector3d v, Vector3d p, Vector3d n, int column) {
        double f1;
        double f0;
        Vector3d ofs = new Vector3d(0.0, 0.0, 3.0);
        double zoom = 5.0;
        Vector3d view = camera.mult(p.add(u.div(2.0)).add(v.div(2.0))).add(ofs);
        Vector3d n1 = camera.mult(n);
        if (n1.times(view) > 0.0) {
            return;
        }
        switch (column) {
            case 0: {
                f0 = 0.0;
                f1 = 0.34;
                break;
            }
            case 1: {
                f0 = 0.34;
                f1 = 0.66;
                break;
            }
            default: {
                f0 = 0.66;
                f1 = 1.0;
            }
        }
        Vector3d[] rect3d = new Vector3d[]{p.add(u.mult(f0)), p.add(u.mult(f1)), p.add(u.mult(f1)).add(v), p.add(u.mult(f0)).add(v)};
        Vector2d[] rect2d = this.project(rect3d, camera, ofs, zoom);
        g.setColor(Color.BLACK);
        this.drawPoly(g, rect2d);
    }

    public void drawBlackRow(Graphics g, Matrix3d camera, Vector3d u, Vector3d v, Vector3d p, Vector3d n, int row) {
        double f1;
        double f0;
        Vector3d ofs = new Vector3d(0.0, 0.0, 3.0);
        double zoom = 5.0;
        Vector3d view = camera.mult(p.add(u.div(2.0)).add(v.div(2.0))).add(ofs);
        Vector3d n1 = camera.mult(n);
        if (n1.times(view) > 0.0) {
            return;
        }
        switch (row) {
            case 0: {
                f0 = 0.0;
                f1 = 0.34;
                break;
            }
            case 1: {
                f0 = 0.34;
                f1 = 0.66;
                break;
            }
            default: {
                f0 = 0.66;
                f1 = 1.0;
            }
        }
        Vector3d[] rect3d = new Vector3d[]{p.add(v.mult(f0)), p.add(v.mult(f0)).add(u), p.add(v.mult(f1)).add(u), p.add(v.mult(f1))};
        Vector2d[] rect2d = this.project(rect3d, camera, ofs, zoom);
        g.setColor(Color.BLACK);
        this.drawPoly(g, rect2d);
    }

    public void drawPlane(Graphics g, Plane plane, Matrix3d camera, Vector3d u, Vector3d v, Vector3d p, Vector3d n) {
        this.drawPlane(g, plane, camera, u, v, p, n, -1, -1);
    }

    public void drawPlane(Graphics g, Plane plane, Matrix3d camera, Vector3d u, Vector3d v, Vector3d p, Vector3d n, int column, int row) {
        Vector3d ofs = new Vector3d(0.0, 0.0, 3.0);
        double zoom = 5.0;
        Vector3d view = camera.mult(p.add(u.div(2.0)).add(v.div(2.0))).add(ofs);
        Vector3d n1 = camera.mult(n);
        if (n1.times(view) > 0.0) {
            return;
        }
        if (row >= 0) {
            this.drawBlackRow(g, camera, u, v, p, n, row);
        } else if (column >= 0) {
            this.drawBlackColumn(g, camera, u, v, p, n, column);
        } else {
            this.drawBlackPlane(g, camera, u, v, p, n);
        }
        int i0 = column < 0 ? 0 : column;
        int i1 = column < 0 ? 2 : column;
        int j0 = row < 0 ? 0 : row;
        int j1 = row < 0 ? 2 : row;
        for (int i = i0; i <= i1; ++i) {
            double x0 = (double)i * 0.32 + 0.04;
            for (int j = j0; j <= j1; ++j) {
                double y0 = (double)j * 0.32 + 0.04;
                Vector3d[] r3d = new Vector3d[]{p.add(u.mult(x0)).add(v.mult(y0)), p.add(u.mult(x0 + 0.28)).add(v.mult(y0)), p.add(u.mult(x0 + 0.28)).add(v.mult(y0 + 0.28)), p.add(u.mult(x0)).add(v.mult(y0 + 0.28))};
                Vector2d[] r2d = this.project(r3d, camera, ofs, zoom);
                g.setColor(colors[plane.getCell(i, j)]);
                this.drawPoly(g, r2d);
            }
        }
    }

    public void paint(Graphics g) {
        block28: {
            Matrix3d camera;
            block27: {
                Matrix3d rotation;
                super.paint(g);
                switch (this.mode.mode) {
                    case rotateCubeXRight: {
                        rotation = this.getXMatrix(-((double)this.count));
                        break;
                    }
                    case rotateCubeXLeft: {
                        rotation = this.getXMatrix(this.count);
                        break;
                    }
                    case rotateCubeYLeft: {
                        rotation = this.getYMatrix(-((double)this.count));
                        break;
                    }
                    case rotateCubeYRight: {
                        rotation = this.getYMatrix(this.count);
                        break;
                    }
                    case rotateCubeZLeft: {
                        rotation = this.getZMatrix(-((double)this.count));
                        break;
                    }
                    case rotateCubeZRight: {
                        rotation = this.getZMatrix(this.count);
                        break;
                    }
                    default: {
                        rotation = Matrix3d.getNormal();
                    }
                }
                camera = this.getXMatrix(this.dxOfs).mult(this.getYMatrix(this.dyOfs)).mult(rotation);
                if (this.mode.modeRow < 0) break block27;
                Matrix3d camera1 = this.getXMatrix(this.dxOfs).mult(this.getYMatrix(this.dyOfs));
                switch (this.mode.mode) {
                    case rotateCubeXRight: 
                    case rotateCubeXLeft: {
                        for (int i = 0; i < 3; ++i) {
                            double f;
                            Matrix3d c = i == this.mode.modeRow ? camera : camera1;
                            if (i == 0) {
                                this.drawPlane(g, this.cubeModel.getPlane(0), c, new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(-0.5, -0.5, 0.5), new Vector3d(-1.0, 0.0, 0.0));
                            } else {
                                f = i == 1 ? 0.34 : 0.66;
                                this.drawBlackPlane(g, c, new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(-0.5 + f, -0.5, 0.5), new Vector3d(-1.0, 0.0, 0.0));
                            }
                            this.drawPlane(g, this.cubeModel.getPlane(1), c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(-0.5, -0.5, -0.5), new Vector3d(0.0, 0.0, -1.0), i, -1);
                            if (i == 2) {
                                this.drawPlane(g, this.cubeModel.getPlane(2), c, new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, -0.5, -0.5), new Vector3d(1.0, 0.0, 0.0));
                            } else {
                                f = i == 0 ? 0.34 : 0.66;
                                this.drawBlackPlane(g, c, new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(-0.5 + f, -0.5, -0.5), new Vector3d(1.0, 0.0, 0.0));
                            }
                            this.drawPlane(g, this.cubeModel.getPlane(3), c, new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, -0.5, 0.5), new Vector3d(0.0, 0.0, 1.0), 2 - i, -1);
                            this.drawPlane(g, this.cubeModel.getPlane(4), c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(-0.5, 0.5, -0.5), new Vector3d(0.0, 1.0, 0.0), i, -1);
                            this.drawPlane(g, this.cubeModel.getPlane(5), c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(-0.5, -0.5, 0.5), new Vector3d(0.0, -1.0, 0.0), i, -1);
                        }
                        break block28;
                    }
                    case rotateCubeYLeft: 
                    case rotateCubeYRight: {
                        for (int i = 2; i >= 0; --i) {
                            double f;
                            Matrix3d c = i == this.mode.modeRow ? camera : camera1;
                            this.drawPlane(g, this.cubeModel.getPlane(0), c, new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(-0.5, -0.5, 0.5), new Vector3d(-1.0, 0.0, 0.0), -1, i);
                            this.drawPlane(g, this.cubeModel.getPlane(1), c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(-0.5, -0.5, -0.5), new Vector3d(0.0, 0.0, -1.0), -1, i);
                            this.drawPlane(g, this.cubeModel.getPlane(2), c, new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, -0.5, -0.5), new Vector3d(1.0, 0.0, 0.0), -1, i);
                            this.drawPlane(g, this.cubeModel.getPlane(3), c, new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, -0.5, 0.5), new Vector3d(0.0, 0.0, 1.0), -1, i);
                            if (i == 2) {
                                this.drawPlane(g, this.cubeModel.getPlane(4), c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(-0.5, 0.5, -0.5), new Vector3d(0.0, 1.0, 0.0));
                            } else {
                                f = i == 0 ? 0.34 : 0.66;
                                this.drawBlackPlane(g, c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(-0.5, -0.5 + f, -0.5), new Vector3d(0.0, 1.0, 0.0));
                            }
                            if (i == 0) {
                                this.drawPlane(g, this.cubeModel.getPlane(5), c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(-0.5, -0.5, 0.5), new Vector3d(0.0, -1.0, 0.0));
                                continue;
                            }
                            f = i == 1 ? 0.34 : 0.66;
                            this.drawBlackPlane(g, c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(-0.5, -0.5 + f, 0.5), new Vector3d(0.0, -1.0, 0.0));
                        }
                        break block28;
                    }
                    case rotateCubeZLeft: 
                    case rotateCubeZRight: {
                        for (int i = 2; i >= 0; --i) {
                            double f;
                            Matrix3d c = i == 2 - this.mode.modeRow ? camera : camera1;
                            this.drawPlane(g, this.cubeModel.getPlane(0), c, new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(-0.5, -0.5, 0.5), new Vector3d(-1.0, 0.0, 0.0), 2 - i, -1);
                            if (i == 0) {
                                this.drawPlane(g, this.cubeModel.getPlane(1), c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(-0.5, -0.5, -0.5), new Vector3d(0.0, 0.0, -1.0));
                            } else {
                                f = i == 1 ? 0.34 : 0.66;
                                this.drawBlackPlane(g, c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(-0.5, -0.5, -0.5 + f), new Vector3d(0.0, 0.0, -1.0));
                            }
                            this.drawPlane(g, this.cubeModel.getPlane(2), c, new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, -0.5, -0.5), new Vector3d(1.0, 0.0, 0.0), i, -1);
                            if (i == 2) {
                                this.drawPlane(g, this.cubeModel.getPlane(3), c, new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, -0.5, 0.5), new Vector3d(0.0, 0.0, 1.0));
                            } else {
                                f = i == 0 ? 0.34 : 0.66;
                                this.drawBlackPlane(g, c, new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, -0.5, -0.5 + f), new Vector3d(0.0, 0.0, 1.0));
                            }
                            this.drawPlane(g, this.cubeModel.getPlane(4), c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(-0.5, 0.5, -0.5), new Vector3d(0.0, 1.0, 0.0), -1, i);
                            this.drawPlane(g, this.cubeModel.getPlane(5), c, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(-0.5, -0.5, 0.5), new Vector3d(0.0, -1.0, 0.0), -1, 2 - i);
                        }
                        break;
                    }
                }
                break block28;
            }
            this.drawPlane(g, this.cubeModel.getPlane(0), camera, new Vector3d(0.0, 0.0, -1.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(-0.5, -0.5, 0.5), new Vector3d(-1.0, 0.0, 0.0));
            this.drawPlane(g, this.cubeModel.getPlane(1), camera, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(-0.5, -0.5, -0.5), new Vector3d(0.0, 0.0, -1.0));
            this.drawPlane(g, this.cubeModel.getPlane(2), camera, new Vector3d(0.0, 0.0, 1.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, -0.5, -0.5), new Vector3d(1.0, 0.0, 0.0));
            this.drawPlane(g, this.cubeModel.getPlane(3), camera, new Vector3d(-1.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, -0.5, 0.5), new Vector3d(0.0, 0.0, 1.0));
            this.drawPlane(g, this.cubeModel.getPlane(4), camera, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), new Vector3d(-0.5, 0.5, -0.5), new Vector3d(0.0, 1.0, 0.0));
            this.drawPlane(g, this.cubeModel.getPlane(5), camera, new Vector3d(1.0, 0.0, 0.0), new Vector3d(0.0, 0.0, -1.0), new Vector3d(-0.5, -0.5, 0.5), new Vector3d(0.0, -1.0, 0.0));
        }
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }
}

