/*
 * Decompiled with CFR 0.152.
 */
package gui;

import datentyp.Vector2d;
import fachkonzept.Mode;
import gui.Tooltip;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultiButton
extends JPanel {
    private Vector2d[][] buttons = new Vector2d[][]{{new Vector2d(25.0, 129.0), new Vector2d(72.0, 179.0), new Vector2d(41.0, 171.0)}, {new Vector2d(114.0, 18.0), new Vector2d(176.0, 21.0), new Vector2d(184.0, 39.0)}, {new Vector2d(184.0, 40.0), new Vector2d(198.0, 88.0), new Vector2d(175.0, 149.0)}, {new Vector2d(19.0, 30.0), new Vector2d(25.0, 128.0), new Vector2d(4.0, 68.0)}, {new Vector2d(73.0, 179.0), new Vector2d(174.0, 149.0), new Vector2d(127.0, 186.0)}, {new Vector2d(19.0, 29.0), new Vector2d(30.0, 11.0), new Vector2d(113.0, 18.0)}, {new Vector2d(25.0, 102.0), new Vector2d(38.0, 111.0), new Vector2d(39.0, 139.0), new Vector2d(27.0, 129.0)}, {new Vector2d(39.0, 112.0), new Vector2d(53.0, 124.0), new Vector2d(53.0, 153.0), new Vector2d(41.0, 141.0)}, {new Vector2d(54.0, 126.0), new Vector2d(70.0, 138.0), new Vector2d(71.0, 170.0), new Vector2d(55.0, 154.0)}, {new Vector2d(22.0, 36.0), new Vector2d(35.0, 42.0), new Vector2d(35.0, 73.0), new Vector2d(23.0, 65.0)}, {new Vector2d(35.0, 43.0), new Vector2d(50.0, 50.0), new Vector2d(51.0, 84.0), new Vector2d(37.0, 75.0)}, {new Vector2d(52.0, 52.0), new Vector2d(68.0, 60.0), new Vector2d(69.0, 96.0), new Vector2d(53.0, 85.0)}, {new Vector2d(77.0, 139.0), new Vector2d(108.0, 131.0), new Vector2d(107.0, 162.0), new Vector2d(77.0, 170.0)}, {new Vector2d(76.0, 101.0), new Vector2d(107.0, 95.0), new Vector2d(107.0, 127.0), new Vector2d(77.0, 134.0)}, {new Vector2d(76.0, 61.0), new Vector2d(107.0, 55.0), new Vector2d(107.0, 90.0), new Vector2d(76.0, 96.0)}, {new Vector2d(143.0, 122.0), new Vector2d(169.0, 116.0), new Vector2d(167.0, 145.0), new Vector2d(142.0, 152.0)}, {new Vector2d(144.0, 87.0), new Vector2d(171.0, 82.0), new Vector2d(169.0, 111.0), new Vector2d(143.0, 118.0)}, {new Vector2d(145.0, 49.0), new Vector2d(172.0, 45.0), new Vector2d(171.0, 79.0), new Vector2d(145.0, 83.0)}, {new Vector2d(57.0, 46.0), new Vector2d(87.0, 42.0), new Vector2d(105.0, 50.0), new Vector2d(74.0, 55.0)}, {new Vector2d(90.0, 41.0), new Vector2d(121.0, 37.0), new Vector2d(140.0, 45.0), new Vector2d(111.0, 49.0)}, {new Vector2d(124.0, 37.0), new Vector2d(150.0, 33.0), new Vector2d(170.0, 40.0), new Vector2d(144.0, 44.0)}, {new Vector2d(26.0, 31.0), new Vector2d(55.0, 27.0), new Vector2d(68.0, 33.0), new Vector2d(38.0, 37.0)}, {new Vector2d(57.0, 27.0), new Vector2d(85.0, 24.0), new Vector2d(99.0, 30.0), new Vector2d(71.0, 32.0)}, {new Vector2d(89.0, 24.0), new Vector2d(111.0, 21.0), new Vector2d(127.0, 25.0), new Vector2d(101.0, 29.0)}};
    private char[] hotKeys = new char[]{'I', 'i', 'o', 'O', 'p', 'P', 'W', 'S', 'X', 'w', 's', 'x', 'e', 'd', 'c', 'E', 'D', 'C', 'r', 'f', 'v', 'R', 'F', 'V'};
    private Mode[] modes = new Mode[]{new Mode(Mode.Modes.rotateCubeXLeft), new Mode(Mode.Modes.rotateCubeXRight), new Mode(Mode.Modes.rotateCubeYLeft), new Mode(Mode.Modes.rotateCubeYRight), new Mode(Mode.Modes.rotateCubeZRight), new Mode(Mode.Modes.rotateCubeZLeft), new Mode(Mode.Modes.rotateCubeXLeft, 0), new Mode(Mode.Modes.rotateCubeXLeft, 1), new Mode(Mode.Modes.rotateCubeXLeft, 2), new Mode(Mode.Modes.rotateCubeXRight, 0), new Mode(Mode.Modes.rotateCubeXRight, 1), new Mode(Mode.Modes.rotateCubeXRight, 2), new Mode(Mode.Modes.rotateCubeYRight, 2), new Mode(Mode.Modes.rotateCubeYRight, 1), new Mode(Mode.Modes.rotateCubeYRight, 0), new Mode(Mode.Modes.rotateCubeYLeft, 2), new Mode(Mode.Modes.rotateCubeYLeft, 1), new Mode(Mode.Modes.rotateCubeYLeft, 0), new Mode(Mode.Modes.rotateCubeZRight, 0), new Mode(Mode.Modes.rotateCubeZRight, 1), new Mode(Mode.Modes.rotateCubeZRight, 2), new Mode(Mode.Modes.rotateCubeZLeft, 0), new Mode(Mode.Modes.rotateCubeZLeft, 1), new Mode(Mode.Modes.rotateCubeZLeft, 2)};
    private int activeButton = -1;
    private Tooltip tooltip;
    private JLabel jLabel1;

    public MultiButton() {
        this.initComponents();
    }

    public void setTooltip(Tooltip tooltip) {
        this.tooltip = tooltip;
    }

    public void setActiveButton(int button) {
        if (button >= -1 && button < this.buttons.length) {
            this.activeButton = button;
            this.repaint();
        }
    }

    public int getActiveButton() {
        return this.activeButton;
    }

    public char getActiveKey() {
        return this.hotKeys[this.activeButton];
    }

    public Mode getMode() {
        if (this.activeButton == -1) {
            return new Mode(Mode.Modes.doNothing);
        }
        return this.modes[this.activeButton];
    }

    public Mode getMode(char key) {
        for (int i = 0; i < this.hotKeys.length; ++i) {
            if (this.hotKeys[i] != key) continue;
            return this.modes[i];
        }
        return new Mode();
    }

    public boolean changeHotKey(int keyToChange, char newKey) {
        if (keyToChange < 0 || keyToChange >= this.hotKeys.length) {
            return false;
        }
        for (int i = 0; i < this.hotKeys.length; ++i) {
            if (this.hotKeys[i] != newKey || i == keyToChange) continue;
            return false;
        }
        this.hotKeys[keyToChange] = newKey;
        return true;
    }

    public boolean hasHotKey(char key) {
        for (int i = 0; i < this.hotKeys.length; ++i) {
            if (this.hotKeys[i] != key) continue;
            return true;
        }
        return false;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.activeButton >= 0) {
            g.setColor(Color.BLACK);
            Vector2d m = new Vector2d();
            for (int i = 0; i < this.buttons[this.activeButton].length; ++i) {
                m = m.add(this.buttons[this.activeButton][i]);
            }
            m = m.div(this.buttons[this.activeButton].length);
            g.fillOval((int)m.getA() - 10 + this.jLabel1.getX(), (int)m.getB() - 10 + this.jLabel1.getY(), 20, 20);
        }
    }

    public int findButton(Vector2d v) {
        for (int i = 0; i < this.buttons.length; ++i) {
            if (!v.isIn(this.buttons[i])) continue;
            return i;
        }
        return -1;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/gui/multiButton_200.png")));
        this.jLabel1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                MultiButton.this.jLabel1MouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                MultiButton.this.jLabel1MouseExited(evt);
            }
        });
        this.jLabel1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                MultiButton.this.jLabel1MouseMoved(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void jLabel1MouseMoved(MouseEvent evt) {
        int b = this.findButton(new Vector2d(evt.getX(), evt.getY()));
        if (b != this.getActiveButton()) {
            this.setActiveButton(b);
            if (b >= 0) {
                this.tooltip.setAll(this.getX(), this.getY(), "" + this.hotKeys[b]);
            }
        }
    }

    private void jLabel1MouseExited(MouseEvent evt) {
        this.setActiveButton(-1);
    }

    private void jLabel1MouseClicked(MouseEvent evt) {
        this.processMouseEvent(evt);
    }
}

