/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.engine;

import java.util.Stack;
import micropolisj.engine.CityLocation;
import micropolisj.engine.Micropolis;

class TrafficGen {
    final Micropolis city;
    int mapX;
    int mapY;
    ZoneType sourceZone;
    int lastdir;
    Stack<CityLocation> positions = new Stack();
    static final int MAX_TRAFFIC_DISTANCE = 30;
    static final int[] PerimX = new int[]{-1, 0, 1, 2, 2, 2, 1, 0, -1, -2, -2, -2};
    static final int[] PerimY = new int[]{-2, -2, -2, -1, 0, 1, 2, 2, 2, 1, 0, -1};
    static final int[] DX = new int[]{0, 1, 0, -1};
    static final int[] DY = new int[]{-1, 0, 1, 0};

    public TrafficGen(Micropolis city) {
        this.city = city;
    }

    int makeTraffic() {
        if (this.findPerimeterRoad()) {
            if (this.tryDrive()) {
                this.setTrafficMem();
                return 1;
            }
            return 0;
        }
        return -1;
    }

    void setTrafficMem() {
        while (!this.positions.isEmpty()) {
            CityLocation pos = this.positions.pop();
            this.mapX = pos.x;
            this.mapY = pos.y;
            assert (this.city.testBounds(this.mapX, this.mapY));
            char tile = this.city.getTile(this.mapX, this.mapY);
            if (tile < '@' || tile >= '\u00d0') continue;
            this.city.addTraffic(this.mapX, this.mapY, 50);
        }
    }

    boolean findPerimeterRoad() {
        for (int z = 0; z < 12; ++z) {
            int tx = this.mapX + PerimX[z];
            int ty = this.mapY + PerimY[z];
            if (!this.roadTest(tx, ty)) continue;
            this.mapX = tx;
            this.mapY = ty;
            return true;
        }
        return false;
    }

    boolean roadTest(int tx, int ty) {
        if (!this.city.testBounds(tx, ty)) {
            return false;
        }
        char c = this.city.getTile(tx, ty);
        if (c < '@') {
            return false;
        }
        if (c > '\u00ee') {
            return false;
        }
        return c < '\u00d0' || c >= '\u00de';
    }

    boolean tryDrive() {
        this.lastdir = 5;
        this.positions.clear();
        for (int z = 0; z < 30; ++z) {
            if (this.tryGo(z)) {
                if (!this.driveDone()) continue;
                return true;
            }
            if (!this.positions.isEmpty()) {
                this.positions.pop();
                z += 3;
                continue;
            }
            return false;
        }
        return false;
    }

    boolean tryGo(int z) {
        int rdir;
        for (int d = rdir = this.city.PRNG.nextInt(4); d < rdir + 4; ++d) {
            int realdir = d % 4;
            if (realdir == this.lastdir || !this.roadTest(this.mapX + DX[realdir], this.mapY + DY[realdir])) continue;
            this.mapX += DX[realdir];
            this.mapY += DY[realdir];
            this.lastdir = (realdir + 2) % 4;
            if (z % 2 == 1) {
                this.positions.push(new CityLocation(this.mapX, this.mapY));
            }
            return true;
        }
        return false;
    }

    boolean driveDone() {
        char tile;
        char high;
        char low;
        switch (this.sourceZone) {
            case RESIDENTIAL: {
                low = '\u01a7';
                high = '\u0330';
                break;
            }
            case COMMERCIAL: {
                low = '\u00f9';
                high = '\u02ba';
                break;
            }
            case INDUSTRIAL: {
                low = '\u00f9';
                high = '\u01a7';
                break;
            }
            default: {
                throw new Error("unreachable");
            }
        }
        if (this.mapY > 0 && (tile = this.city.getTile(this.mapX, this.mapY - 1)) >= low && tile <= high) {
            return true;
        }
        if (this.mapX + 1 < this.city.getWidth() && (tile = this.city.getTile(this.mapX + 1, this.mapY)) >= low && tile <= high) {
            return true;
        }
        if (this.mapY + 1 < this.city.getHeight() && (tile = this.city.getTile(this.mapX, this.mapY + 1)) >= low && tile <= high) {
            return true;
        }
        return this.mapX > 0 && (tile = this.city.getTile(this.mapX - 1, this.mapY)) >= low && tile <= high;
    }

    static enum ZoneType {
        RESIDENTIAL,
        COMMERCIAL,
        INDUSTRIAL;

    }
}

