/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import micropolisj.engine.BudgetNumbers;
import micropolisj.engine.Micropolis;
import micropolisj.engine.Speed;
import micropolisj.gui.MainWindow;

public class BudgetDialog
extends JDialog {
    Micropolis engine;
    JSpinner taxRateEntry;
    int origTaxRate;
    double origRoadPct;
    double origFirePct;
    double origPolicePct;
    JLabel roadFundRequest = new JLabel();
    JLabel roadFundAlloc = new JLabel();
    JSlider roadFundEntry;
    JLabel policeFundRequest = new JLabel();
    JLabel policeFundAlloc = new JLabel();
    JSlider policeFundEntry;
    JLabel fireFundRequest = new JLabel();
    JLabel fireFundAlloc = new JLabel();
    JSlider fireFundEntry;
    JLabel taxRevenueLbl = new JLabel();
    static ResourceBundle strings = MainWindow.strings;
    JCheckBox autoBudgetBtn = new JCheckBox(strings.getString("budgetdlg.auto_budget"));
    JCheckBox pauseBtn = new JCheckBox(strings.getString("budgetdlg.pause_game"));

    private void applyChange() {
        int newTaxRate = ((Number)this.taxRateEntry.getValue()).intValue();
        int newRoadPct = this.roadFundEntry.getValue();
        int newPolicePct = this.policeFundEntry.getValue();
        int newFirePct = this.fireFundEntry.getValue();
        this.engine.cityTax = newTaxRate;
        this.engine.roadPercent = (double)newRoadPct / 100.0;
        this.engine.policePercent = (double)newPolicePct / 100.0;
        this.engine.firePercent = (double)newFirePct / 100.0;
        this.loadBudgetNumbers(false);
    }

    private void loadBudgetNumbers(boolean updateEntries) {
        BudgetNumbers b = this.engine.generateBudget();
        if (updateEntries) {
            this.taxRateEntry.setValue(b.taxRate);
            this.roadFundEntry.setValue((int)Math.round(b.roadPercent * 100.0));
            this.policeFundEntry.setValue((int)Math.round(b.policePercent * 100.0));
            this.fireFundEntry.setValue((int)Math.round(b.firePercent * 100.0));
        }
        this.taxRevenueLbl.setText(MainWindow.formatFunds(b.taxIncome));
        this.roadFundRequest.setText(MainWindow.formatFunds(b.roadRequest));
        this.roadFundAlloc.setText(MainWindow.formatFunds(b.roadFunded));
        this.policeFundRequest.setText(MainWindow.formatFunds(b.policeRequest));
        this.policeFundAlloc.setText(MainWindow.formatFunds(b.policeFunded));
        this.fireFundRequest.setText(MainWindow.formatFunds(b.fireRequest));
        this.fireFundAlloc.setText(MainWindow.formatFunds(b.fireFunded));
    }

    static void adjustSliderSize(JSlider slider) {
        Dimension sz = slider.getPreferredSize();
        slider.setPreferredSize(new Dimension(80, sz.height));
    }

    public BudgetDialog(Window owner, Micropolis engine) {
        super(owner);
        this.setTitle(strings.getString("budgetdlg.title"));
        this.engine = engine;
        this.origTaxRate = engine.cityTax;
        this.origRoadPct = engine.roadPercent;
        this.origFirePct = engine.firePercent;
        this.origPolicePct = engine.policePercent;
        this.taxRateEntry = new JSpinner(new SpinnerNumberModel(7, 0, 20, 1));
        this.roadFundEntry = new JSlider(0, 0, 100, 100);
        BudgetDialog.adjustSliderSize(this.roadFundEntry);
        this.fireFundEntry = new JSlider(0, 0, 100, 100);
        BudgetDialog.adjustSliderSize(this.fireFundEntry);
        this.policeFundEntry = new JSlider(0, 0, 100, 100);
        BudgetDialog.adjustSliderSize(this.policeFundEntry);
        ChangeListener change = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent ev) {
                BudgetDialog.this.applyChange();
            }
        };
        this.taxRateEntry.addChangeListener(change);
        this.roadFundEntry.addChangeListener(change);
        this.fireFundEntry.addChangeListener(change);
        this.policeFundEntry.addChangeListener(change);
        Box mainBox = new Box(1);
        mainBox.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.add((Component)mainBox, "Center");
        mainBox.add(this.makeTaxPane());
        JSeparator sep = new JSeparator(0);
        mainBox.add(sep);
        mainBox.add(this.makeFundingRatesPane());
        JSeparator sep1 = new JSeparator(0);
        mainBox.add(sep1);
        mainBox.add(this.makeBalancePane());
        JSeparator sep2 = new JSeparator(0);
        mainBox.add(sep2);
        mainBox.add(this.makeOptionsPane());
        JPanel buttonPane = new JPanel();
        this.add((Component)buttonPane, "South");
        JButton continueBtn = new JButton(strings.getString("budgetdlg.continue"));
        continueBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BudgetDialog.this.onContinueClicked();
            }
        });
        buttonPane.add(continueBtn);
        JButton resetBtn = new JButton(strings.getString("budgetdlg.reset"));
        resetBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                BudgetDialog.this.onResetClicked();
            }
        });
        buttonPane.add(resetBtn);
        this.loadBudgetNumbers(true);
        this.setAutoRequestFocus_compat(false);
        this.pack();
        this.setDefaultCloseOperation(2);
        this.setLocationRelativeTo(owner);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BudgetDialog.this.dispose();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void setAutoRequestFocus_compat(boolean v) {
        try {
            if (super.getClass().getMethod("setAutoRequestFocus", Boolean.TYPE) != null) {
                super.setAutoRequestFocus(v);
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private JComponent makeFundingRatesPane() {
        JPanel fundingRatesPane = new JPanel(new GridBagLayout());
        fundingRatesPane.setBorder(BorderFactory.createEmptyBorder(8, 0, 8, 0));
        GridBagConstraints c0 = new GridBagConstraints();
        c0.gridx = 0;
        c0.weightx = 0.25;
        c0.anchor = 17;
        GridBagConstraints c1 = new GridBagConstraints();
        c1.gridx = 1;
        c1.weightx = 0.25;
        c1.anchor = 13;
        GridBagConstraints c2 = new GridBagConstraints();
        c2.gridx = 2;
        c2.weightx = 0.5;
        c2.anchor = 13;
        GridBagConstraints c3 = new GridBagConstraints();
        c3.gridx = 3;
        c3.weightx = 0.5;
        c3.anchor = 13;
        c3.gridy = 0;
        c2.gridy = 0;
        c1.gridy = 0;
        fundingRatesPane.add((Component)new JLabel(strings.getString("budgetdlg.funding_level_hdr")), c1);
        fundingRatesPane.add((Component)new JLabel(strings.getString("budgetdlg.requested_hdr")), c2);
        fundingRatesPane.add((Component)new JLabel(strings.getString("budgetdlg.allocation_hdr")), c3);
        c3.gridy = 1;
        c2.gridy = 1;
        c1.gridy = 1;
        c0.gridy = 1;
        fundingRatesPane.add((Component)new JLabel(strings.getString("budgetdlg.road_fund")), c0);
        fundingRatesPane.add((Component)this.roadFundEntry, c1);
        fundingRatesPane.add((Component)this.roadFundRequest, c2);
        fundingRatesPane.add((Component)this.roadFundAlloc, c3);
        c3.gridy = 2;
        c2.gridy = 2;
        c1.gridy = 2;
        c0.gridy = 2;
        fundingRatesPane.add((Component)new JLabel(strings.getString("budgetdlg.police_fund")), c0);
        fundingRatesPane.add((Component)this.policeFundEntry, c1);
        fundingRatesPane.add((Component)this.policeFundRequest, c2);
        fundingRatesPane.add((Component)this.policeFundAlloc, c3);
        c3.gridy = 3;
        c2.gridy = 3;
        c1.gridy = 3;
        c0.gridy = 3;
        fundingRatesPane.add((Component)new JLabel(strings.getString("budgetdlg.fire_fund")), c0);
        fundingRatesPane.add((Component)this.fireFundEntry, c1);
        fundingRatesPane.add((Component)this.fireFundRequest, c2);
        fundingRatesPane.add((Component)this.fireFundAlloc, c3);
        return fundingRatesPane;
    }

    private JComponent makeOptionsPane() {
        JPanel optionsPane = new JPanel(new GridBagLayout());
        optionsPane.setBorder(BorderFactory.createEmptyBorder(8, 0, 0, 0));
        GridBagConstraints c0 = new GridBagConstraints();
        GridBagConstraints c1 = new GridBagConstraints();
        c0.gridx = 0;
        c1.gridx = 1;
        c1.anchor = 17;
        c0.anchor = 17;
        c1.gridy = 0;
        c0.gridy = 0;
        c1.weightx = 0.5;
        c0.weightx = 0.5;
        optionsPane.add((Component)this.autoBudgetBtn, c0);
        optionsPane.add((Component)this.pauseBtn, c1);
        this.autoBudgetBtn.setSelected(this.engine.autoBudget);
        this.pauseBtn.setSelected(this.engine.simSpeed == Speed.PAUSED);
        return optionsPane;
    }

    private JComponent makeTaxPane() {
        JPanel pane = new JPanel(new GridBagLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
        GridBagConstraints c0 = new GridBagConstraints();
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();
        c0.gridx = 0;
        c0.anchor = 17;
        c0.weightx = 0.25;
        c1.gridx = 1;
        c1.anchor = 13;
        c1.weightx = 0.25;
        c2.gridx = 2;
        c2.anchor = 13;
        c2.weightx = 0.5;
        c2.gridy = 0;
        c1.gridy = 0;
        c0.gridy = 0;
        pane.add((Component)new JLabel(strings.getString("budgetdlg.tax_rate_hdr")), c1);
        pane.add((Component)new JLabel(strings.getString("budgetdlg.annual_receipts_hdr")), c2);
        c2.gridy = 1;
        c1.gridy = 1;
        c0.gridy = 1;
        pane.add((Component)new JLabel(strings.getString("budgetdlg.tax_revenue")), c0);
        pane.add((Component)this.taxRateEntry, c1);
        pane.add((Component)this.taxRevenueLbl, c2);
        return pane;
    }

    private void onContinueClicked() {
        if (this.autoBudgetBtn.isSelected() != this.engine.autoBudget) {
            this.engine.toggleAutoBudget();
        }
        if (this.pauseBtn.isSelected() && this.engine.simSpeed != Speed.PAUSED) {
            this.engine.setSpeed(Speed.PAUSED);
        } else if (!this.pauseBtn.isSelected() && this.engine.simSpeed == Speed.PAUSED) {
            this.engine.setSpeed(Speed.NORMAL);
        }
        this.dispose();
    }

    private void onResetClicked() {
        this.engine.cityTax = this.origTaxRate;
        this.engine.roadPercent = this.origRoadPct;
        this.engine.firePercent = this.origFirePct;
        this.engine.policePercent = this.origPolicePct;
        this.loadBudgetNumbers(true);
    }

    private JComponent makeBalancePane() {
        JPanel balancePane = new JPanel(new GridBagLayout());
        balancePane.setBorder(BorderFactory.createEmptyBorder(8, 24, 8, 24));
        GridBagConstraints c0 = new GridBagConstraints();
        GridBagConstraints c1 = new GridBagConstraints();
        c0.anchor = 17;
        c0.weightx = 0.5;
        c0.gridx = 0;
        c0.gridy = 0;
        JLabel thLbl = new JLabel(strings.getString("budgetdlg.period_ending"));
        Font origFont = thLbl.getFont();
        Font headFont = origFont.deriveFont(2);
        thLbl.setFont(headFont);
        thLbl.setForeground(Color.MAGENTA);
        balancePane.add((Component)thLbl, c0);
        ++c0.gridy;
        balancePane.add((Component)new JLabel(strings.getString("budgetdlg.cash_begin")), c0);
        ++c0.gridy;
        balancePane.add((Component)new JLabel(strings.getString("budgetdlg.taxes_collected")), c0);
        ++c0.gridy;
        balancePane.add((Component)new JLabel(strings.getString("budgetdlg.capital_expenses")), c0);
        ++c0.gridy;
        balancePane.add((Component)new JLabel(strings.getString("budgetdlg.operating_expenses")), c0);
        ++c0.gridy;
        balancePane.add((Component)new JLabel(strings.getString("budgetdlg.cash_end")), c0);
        c1.anchor = 13;
        c1.weightx = 0.25;
        c1.gridx = 0;
        for (int i = 0; i < 2 && i + 1 < this.engine.financialHistory.size(); ++i) {
            Micropolis.FinancialHistory f = this.engine.financialHistory.get(i);
            Micropolis.FinancialHistory fPrior = this.engine.financialHistory.get(i + 1);
            int cashFlow = f.totalFunds - fPrior.totalFunds;
            int capExpenses = -(cashFlow - f.taxIncome + f.operatingExpenses);
            ++c1.gridx;
            c1.gridy = 0;
            thLbl = new JLabel(MainWindow.formatGameDate(f.cityTime - 1));
            thLbl.setFont(headFont);
            thLbl.setForeground(Color.MAGENTA);
            balancePane.add((Component)thLbl, c1);
            ++c1.gridy;
            JLabel previousBalanceLbl = new JLabel();
            previousBalanceLbl.setText(MainWindow.formatFunds(fPrior.totalFunds));
            balancePane.add((Component)previousBalanceLbl, c1);
            ++c1.gridy;
            JLabel taxIncomeLbl = new JLabel();
            taxIncomeLbl.setText(MainWindow.formatFunds(f.taxIncome));
            balancePane.add((Component)taxIncomeLbl, c1);
            ++c1.gridy;
            JLabel capExpensesLbl = new JLabel();
            capExpensesLbl.setText(MainWindow.formatFunds(capExpenses));
            balancePane.add((Component)capExpensesLbl, c1);
            ++c1.gridy;
            JLabel opExpensesLbl = new JLabel();
            opExpensesLbl.setText(MainWindow.formatFunds(f.operatingExpenses));
            balancePane.add((Component)opExpensesLbl, c1);
            ++c1.gridy;
            JLabel newBalanceLbl = new JLabel();
            newBalanceLbl.setText(MainWindow.formatFunds(f.totalFunds));
            balancePane.add((Component)newBalanceLbl, c1);
        }
        return balancePane;
    }
}

