/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.gui;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import micropolisj.engine.SpriteKind;

public class TileImages {
    final int TILE_WIDTH;
    final int TILE_HEIGHT;
    Image[] images;
    Map<SpriteKind, Map<Integer, Image>> spriteImages;
    static Map<Integer, TileImages> savedInstances = new HashMap<Integer, TileImages>();

    private TileImages(int size) {
        this.TILE_WIDTH = size;
        this.TILE_HEIGHT = size;
        this.images = this.loadTileImages("/" + size + "x" + size + "/tiles.png", size);
        this.loadSpriteImages();
    }

    public static TileImages getInstance(int size) {
        if (!savedInstances.containsKey(size)) {
            savedInstances.put(size, new TileImages(size));
        }
        return savedInstances.get(size);
    }

    public Image getTileImage(int cell) {
        int tile = (cell & 0x3FF) % this.images.length;
        return this.images[tile];
    }

    private Image[] loadTileImages(String resourceName, int srcSize) {
        URL iconUrl = TileImages.class.getResource(resourceName);
        Image refImage = new ImageIcon(iconUrl).getImage();
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice dev = env.getDefaultScreenDevice();
        GraphicsConfiguration conf = dev.getDefaultConfiguration();
        Image[] images = new Image[refImage.getHeight(null) / srcSize];
        for (int i = 0; i < images.length; ++i) {
            BufferedImage bi = conf.createCompatibleImage(this.TILE_WIDTH, this.TILE_HEIGHT, 1);
            Graphics2D gr = bi.createGraphics();
            gr.drawImage(refImage, 0, 0, this.TILE_WIDTH, this.TILE_HEIGHT, 0, i * srcSize, 0 + srcSize, i * srcSize + srcSize, null);
            images[i] = bi;
        }
        return images;
    }

    public Image getSpriteImage(SpriteKind kind, int frameNumber) {
        return this.spriteImages.get((Object)kind).get(frameNumber);
    }

    private void loadSpriteImages() {
        this.spriteImages = new EnumMap<SpriteKind, Map<Integer, Image>>(SpriteKind.class);
        for (SpriteKind kind : SpriteKind.values()) {
            HashMap<Integer, Image> imgs = new HashMap<Integer, Image>();
            for (int i = 0; i < kind.numFrames; ++i) {
                Image img = this.loadSpriteImage(kind, i);
                if (img == null) continue;
                imgs.put(i, img);
            }
            this.spriteImages.put(kind, imgs);
        }
    }

    Image loadSpriteImage(SpriteKind kind, int frameNo) {
        String resourceName = "/obj" + kind.objectId + "-" + frameNo;
        URL iconUrl = TileImages.class.getResource(resourceName + "_" + this.TILE_WIDTH + "x" + this.TILE_HEIGHT + ".png");
        if (iconUrl != null) {
            return new ImageIcon(iconUrl).getImage();
        }
        iconUrl = TileImages.class.getResource(resourceName + ".png");
        if (iconUrl == null) {
            return null;
        }
        if (this.TILE_WIDTH == 16 && this.TILE_HEIGHT == 16) {
            return new ImageIcon(iconUrl).getImage();
        }
        ImageIcon ii = new ImageIcon(iconUrl);
        int destWidth = ii.getIconWidth() * this.TILE_WIDTH / 16;
        int destHeight = ii.getIconHeight() * this.TILE_HEIGHT / 16;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice dev = env.getDefaultScreenDevice();
        GraphicsConfiguration conf = dev.getDefaultConfiguration();
        BufferedImage bi = conf.createCompatibleImage(destWidth, destHeight, 3);
        Graphics2D gr = bi.createGraphics();
        gr.drawImage(ii.getImage(), 0, 0, destWidth, destHeight, 0, 0, ii.getIconWidth(), ii.getIconHeight(), null);
        return bi;
    }
}

