/*
 * Decompiled with CFR 0.152.
 */
package micropolisj.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import micropolisj.engine.Micropolis;
import micropolisj.util.StringsModel;
import micropolisj.util.TranslatedStringsTable;

public class TranslationTool
extends JFrame {
    JTable stringsTable;
    StringsModel stringsModel;
    JButton removeBtn;
    JButton testBtn;
    JButton submitBtn;

    public TranslationTool() {
        this.setTitle("MicropolisJ Translation Tool");
        try {
            this.stringsModel = new StringsModel();
            this.stringsModel.addLocale(null);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e, "Error", 0);
            System.exit(1);
        }
        this.stringsTable = new TranslatedStringsTable(this.stringsModel);
        JScrollPane scrollPane = new JScrollPane(this.stringsTable);
        this.stringsTable.setFillsViewportHeight(true);
        this.getContentPane().add((Component)scrollPane, "Center");
        JPanel buttonPane = new JPanel();
        this.getContentPane().add((Component)buttonPane, "South");
        JButton btn = new JButton("Add Locale...");
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TranslationTool.this.onAddLocaleClicked();
            }
        });
        buttonPane.add(btn);
        this.removeBtn = new JButton("Remove Locale");
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TranslationTool.this.onRemoveLocaleClicked();
            }
        });
        buttonPane.add(this.removeBtn);
        this.testBtn = new JButton("Test");
        this.testBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TranslationTool.this.onTestClicked();
            }
        });
        buttonPane.add(this.testBtn);
        this.submitBtn = new JButton("Submit");
        this.submitBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TranslationTool.this.onSubmitClicked();
            }
        });
        buttonPane.add(this.submitBtn);
        this.updateButtonsEnabled();
        this.pack();
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                TranslationTool.this.closeWindow();
            }
        });
    }

    private void closeWindow() {
        this.maybeSave();
        this.dispose();
    }

    private File getMicropolisJarFile() {
        try {
            Class<Micropolis> mclass = Micropolis.class;
            return new File(mclass.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
        }
        catch (URISyntaxException e) {
            throw new Error("unexpected: " + e, e);
        }
    }

    private void onTestClicked() {
        this.maybeSave();
        String code = this.pickLocale("Which locale do you want to test?", "Test Locale");
        if (code == null) {
            return;
        }
        String[] localeParts = code.split("_");
        String selLanguage = localeParts.length >= 1 ? localeParts[0] : "";
        String selCountry = localeParts.length >= 2 ? localeParts[1] : "";
        String selVariant = localeParts.length >= 3 ? localeParts[2] : "";
        File javaExe = new File(System.getProperty("java.home"));
        javaExe = new File(javaExe, "bin");
        javaExe = new File(javaExe, "java");
        try {
            String javaPath = javaExe.toString();
            String classPath = this.stringsModel.workingDirectory.toString() + System.getProperty("path.separator") + this.getMicropolisJarFile().toString();
            ProcessBuilder processBuilder = new ProcessBuilder(javaPath, "-Duser.language=" + selLanguage, "-Duser.country=" + selCountry, "-Duser.variant=" + selVariant, "-cp", classPath, "micropolisj.Main");
            processBuilder.start();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
    }

    private void maybeSave() {
        try {
            this.stringsModel.save();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
    }

    private void onAddLocaleClicked() {
        this.maybeSave();
        Locale L = Locale.getDefault();
        JTextField langEntry = new JTextField(L.getLanguage());
        JTextField countryEntry = new JTextField(L.getCountry());
        JTextField variantEntry = new JTextField(L.getVariant());
        JComponent[] inputs = new JComponent[]{new JLabel("Language"), langEntry, new JLabel("Country"), countryEntry, new JLabel("Variant (optional)"), variantEntry};
        int rv = JOptionPane.showOptionDialog(this, inputs, "Add Locale", 2, -1, null, null, null);
        if (rv != 0) {
            return;
        }
        try {
            String lastLanguage = langEntry.getText();
            String lastCountry = countryEntry.getText();
            String lastVariant = variantEntry.getText();
            if (lastLanguage.length() == 0) {
                throw new Exception("Language is required");
            }
            String code = lastLanguage;
            if (lastCountry.length() != 0) {
                code = code + "_" + lastCountry;
                if (lastVariant.length() != 0) {
                    code = code + "_" + lastVariant;
                }
            } else if (lastVariant.length() != 0) {
                throw new Exception("Cannot specify variant without a country code.");
            }
            this.stringsModel.addLocale(code);
            this.updateButtonsEnabled();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
        }
    }

    private void updateButtonsEnabled() {
        int count = this.stringsModel.getAllLocaleCodes().length;
        this.removeBtn.setEnabled(count > 1);
        this.testBtn.setEnabled(count > 1);
        this.submitBtn.setEnabled(count > 1);
    }

    String pickLocale(String message, String dlgTitle) {
        String[] locales = this.stringsModel.getAllLocaleCodes();
        JComboBox<String> localeCb = new JComboBox<String>();
        for (int i = 0; i < locales.length; ++i) {
            if (locales[i] == null) continue;
            localeCb.addItem(locales[i]);
        }
        if (localeCb.getItemCount() == 1) {
            return (String)localeCb.getItemAt(0);
        }
        if (localeCb.getItemCount() == 0) {
            return null;
        }
        localeCb.setSelectedIndex(localeCb.getItemCount() - 1);
        JComponent[] inputs = new JComponent[]{new JLabel(message), localeCb};
        int rv = JOptionPane.showOptionDialog(this, inputs, dlgTitle, 2, -1, null, null, null);
        if (rv != 0) {
            return null;
        }
        return (String)localeCb.getSelectedItem();
    }

    private void onRemoveLocaleClicked() {
        this.maybeSave();
        String code = this.pickLocale("Which locale do you want to remove?", "Remove Locale");
        if (code != null) {
            this.stringsModel.removeLocale(code);
            this.updateButtonsEnabled();
        }
    }

    private void onSubmitClicked() {
        this.maybeSave();
        String code = this.pickLocale("Which locale do you want to submit?", "Submit Locale");
        if (code == null) {
            return;
        }
        String msg = "";
        msg = msg + "Your translated strings have been saved to\n";
        msg = msg + new File(this.stringsModel.workingDirectory, "micropolisj").toString() + "\n";
        msg = msg + "as:\n";
        int i = 0;
        while (true) {
            if (i >= StringsModel.FILES.length) break;
            msg = msg + " * " + StringsModel.FILES[i] + "_" + code + ".properties\n";
            ++i;
        }
        msg = msg + "\n";
        msg = msg + "Submit these files to the Micropolis website\n";
        msg = msg + "https://code.google.com/p/micropolis\n";
        msg = msg + "(Open a new \"Issue\" and attach the files to the issue.)";
        JOptionPane.showMessageDialog(this, msg, "Submit Locale", 1);
    }

    public static void main(String[] args) throws Exception {
        new TranslationTool().setVisible(true);
    }
}

