/*
 * Decompiled with CFR 0.152.
 */
package rescue;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.KeyStroke;
import rescue.BrowserLauncher;
import rescue.IndicatorsListener;
import rescue.JukeBox;
import rescue.MissionLoader;
import rescue.RescueIO;
import rescue.RescueListener;
import rescue.gui.Keymap;
import rescue.panels.ShipInfoPanel;
import rescue.panels.ShipsPanel;
import rescue.spaceobjects.Base;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.MannedObject;
import rescue.spaceobjects.Planet;
import rescue.spaceobjects.Ship;
import rescue.spaceobjects.SpaceObject;

public class RunRescue
implements Runnable,
IndicatorsListener {
    public static final String DEFAULT_MISSION = "rescuemax.xml";
    public static final String VERSION = "1.0.0.3";
    public static final String NAME = "Rescue! Max";
    public static final String KEYMAP_FILENAME = "keys.ini";
    public static final int WIDTH = 1000000;
    public static final int HEIGHT = 1000000;
    public static int DELAY = 20;
    public static final int FAKE_SPEED_OF_LIGHT = 10;
    public static final int DISTANCE_TRACTOR = 250;
    public static final int DISTANCE_PHASERS = 250;
    public static final int DISTANCE_TORPEDO = 500;
    public static final int SELECT_ALL = 0;
    public static final int SELECT_ENEMIES = 1;
    public static final int SELECT_MANUAL = 2;
    public ImageObject[] SpaceObjects;
    public Vector torpedos;
    private RescueListener gui;
    private boolean pause;
    private boolean heads;
    private Ship playerShip;
    private Vector selectedObjects;
    private int select;
    private Point2D.Double[] sky;
    private double zoom = 1.0;
    private int windowWidth = 1000;
    private int windowHeight = 1000;
    private int panelWidth;
    private int panelHeight;
    private boolean loadgameonstartup;
    private MissionLoader currentMission;
    private double fps;
    private long oldtime;
    private double timetotal;
    private int counter;
    private ShipsPanel shiplist;
    private ShipsPanel baselist;
    private ShipInfoPanel shipinfo;
    private URL rooturl;
    private Keymap keymap;
    private final Vector selectListeners = new Vector();
    private final Vector evasiveListeners = new Vector();
    int shifts = 0;

    public RunRescue(URL rurl) throws Exception {
        this.rooturl = rurl;
        this.loadgameonstartup = false;
        this.pause = true;
        this.heads = true;
        List actions = this.makeActions();
        this.keymap = new Keymap(actions);
        try {
            Keymap.loadKeys(actions, RescueIO.getInputStream(new URL(this.rooturl, KEYMAP_FILENAME)));
        }
        catch (Exception ex) {
            System.out.println("unable to load keys: " + ex);
        }
        this.setMission(new MissionLoader(this, this.rooturl, DEFAULT_MISSION));
        this.fps = 1000.0 / (double)DELAY;
        this.oldtime = System.currentTimeMillis();
        this.timetotal = 0.0;
        this.counter = 0;
    }

    private List makeActions() {
        int value;
        Vector<AbstractAction> actions = new Vector<AbstractAction>();
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "impulse_auto");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 1));
            }

            public boolean isEnabled() {
                return !RunRescue.this.playerShip.getAutoImpulseOn();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setAutoImpulseOn(true);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "impulse_man");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, 1));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getAutoImpulseOn();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setAutoImpulseOn(false);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "impulse_up");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(44, 1));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getImpulseFactor() < RunRescue.this.playerShip.getMaxImpulseFactor();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setImpulseUpDown(true);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "impulse_down");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(46, 1));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getImpulseFactor() > 0.25;
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setImpulseUpDown(false);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "impulse_start");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 0));
            }

            public boolean isEnabled() {
                return !RunRescue.this.playerShip.getImpulseOn();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setImpulseOn(true);
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "warp_auto");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 0));
            }

            public boolean isEnabled() {
                return !RunRescue.this.playerShip.getAutoWarpOn();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setAutoWarpOn(true);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "warp_man");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, 0));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getAutoWarpOn();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setAutoWarpOn(false);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "warp_up");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(44, 0));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getWarpFactor() < RunRescue.this.playerShip.getMaxWarpFactor();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setWarpUpDown(true);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "warp_down");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(46, 0));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getWarpFactor() > 1;
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setWarpUpDown(false);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "warp_start");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(10, 0));
            }

            public boolean isEnabled() {
                return !RunRescue.this.playerShip.getWarpOn();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setWarpOn(true);
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "stop");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 0));
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.stop();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "phaser_up");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(91, 0));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getPhaserIntensityInt() < RunRescue.this.playerShip.getMaxPhaserIntensity();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setPhaserIntensityUpDown(true);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "phaser_down");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(93, 0));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getPhaserIntensityInt() > 1;
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setPhaserIntensityUpDown(false);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "phaser_fire");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 0));
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.shipFirePhaser();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "torpedo_up");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(91, 1));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getTorpedoSalvoInt() < RunRescue.this.playerShip.getMaxTorpedoSalvo();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setTorpedoSalvoUpDown(true);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "torpedo_down");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(93, 1));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getTorpedoSalvoInt() > 1;
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setTorpedoSalvoUpDown(false);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "torpedo_fire");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 0));
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.shipFireTorpedo();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "shields_up");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, 0));
            }

            public boolean isEnabled() {
                return !RunRescue.this.playerShip.getShieldsUp();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.changeShields();
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "shields_down");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(85, 0));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getShieldsUp();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.changeShields();
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "tractor");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(520, 0));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getTractoredShip() == null;
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.shipTractorShip();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "tractor_off");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(520, 0));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getTractoredShip() != null;
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.shipTractorShip();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "zoomin");
            }

            public boolean isEnabled() {
                return RunRescue.this.canZoom(true);
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.zoom(true);
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "zoomout");
            }

            public boolean isEnabled() {
                return RunRescue.this.canZoom(false);
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.zoom(false);
            }
        });
        actions.add(new SelectAction(0, "select_all", "All"));
        actions.add(new SelectAction(1, "select_enemies", "Enemies"));
        actions.add(new SelectAction(2, "select_manual", "Manual"));
        actions.add(new AbstractAction("Beam Team Down"){
            {
                this.putValue("ActionCommandKey", "beam_down");
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.shipBeamDown();
            }
        });
        actions.add(new AbstractAction("Beam Team Up"){
            {
                this.putValue("ActionCommandKey", "beam_up");
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.shipBeamUp();
            }
        });
        actions.add(new AbstractAction("Dock With Starbase"){
            {
                this.putValue("ActionCommandKey", "dock");
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.shipDock();
            }
        });
        actions.add(new AbstractAction("Board Ship"){
            {
                this.putValue("ActionCommandKey", "board");
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.shipBoard();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "scan_up");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(61, 0));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getSensorScan() < RunRescue.this.playerShip.getMaxScan();
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setScan(true);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "scan_down");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(45, 0));
            }

            public boolean isEnabled() {
                return RunRescue.this.playerShip.getSensorScan() > 0;
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.setScan(false);
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "ships_up");
            }

            public boolean isEnabled() {
                return RunRescue.this.canScrollShips(true, true);
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.scrollShips(true, true);
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "ships_down");
            }

            public boolean isEnabled() {
                return RunRescue.this.canScrollShips(true, false);
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.scrollShips(true, false);
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "base_up");
            }

            public boolean isEnabled() {
                return RunRescue.this.canScrollShips(false, true);
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.scrollShips(false, true);
            }
        });
        actions.add(new AbstractAction(){
            {
                this.putValue("ActionCommandKey", "base_down");
            }

            public boolean isEnabled() {
                return RunRescue.this.canScrollShips(false, false);
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.scrollShips(false, false);
            }
        });
        actions.add(new AbstractAction("Use Reserve Energy"){
            {
                this.putValue("ActionCommandKey", "reserve");
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.useReserve();
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction("Divert Phaser Energy"){
            {
                this.putValue("ActionCommandKey", "divert");
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.playerShip.divertPhaser();
                RunRescue.this.updateGUI();
            }
        });
        actions.add(new AbstractAction("Heads Up Display"){
            {
                this.putValue("ActionCommandKey", "headsup");
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.headsUpDisplay();
            }
        });
        actions.add(new AbstractAction("Pause"){
            {
                this.putValue("ActionCommandKey", "pause");
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.pause();
            }
        });
        actions.add(new AbstractAction("End"){
            {
                this.putValue("ActionCommandKey", "endgame");
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.closeCurrentMission();
            }
        });
        actions.add(new AbstractAction("Quit"){
            {
                this.putValue("ActionCommandKey", "quit");
            }

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        actions.add(new AbstractAction("Help"){
            {
                this.putValue("ActionCommandKey", "help");
                this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(112, 0));
            }

            public void actionPerformed(ActionEvent e) {
                RunRescue.this.help();
            }
        });
        actions.add(new EvasiveAction(1, "evasive 1", "Sequence Alpha 7"));
        actions.add(new EvasiveAction(2, "evasive 2", "Sequence Omega 8"));
        actions.add(new EvasiveAction(3, "evasive 3", "Sequence Delta 9"));
        int c = 0;
        while (c < 2) {
            value = c++;
            actions.add(new AbstractAction(){
                {
                    this.putValue("ActionCommandKey", "ships_sort " + value);
                }

                public boolean isEnabled() {
                    return RunRescue.this.getShipsSort() != value;
                }

                public void actionPerformed(ActionEvent e) {
                    RunRescue.this.setShipsSort(value);
                }
            });
        }
        c = 0;
        while (c < 2) {
            value = c++;
            actions.add(new AbstractAction(){
                {
                    this.putValue("ActionCommandKey", "base_sort " + value);
                }

                public boolean isEnabled() {
                    return RunRescue.this.getBaseSort() != value;
                }

                public void actionPerformed(ActionEvent e) {
                    RunRescue.this.setBaseSort(value);
                }
            });
        }
        c = 0;
        while (c < 4) {
            value = c++;
            actions.add(new AbstractAction(){
                {
                    this.putValue("ActionCommandKey", "ships_show " + value);
                }

                public boolean isEnabled() {
                    return RunRescue.this.getShipsShow() != value;
                }

                public void actionPerformed(ActionEvent e) {
                    RunRescue.this.setShipsShow(value);
                }
            });
        }
        c = 0;
        while (c < 4) {
            value = c++;
            actions.add(new AbstractAction(){
                {
                    this.putValue("ActionCommandKey", "base_show " + value);
                }

                public boolean isEnabled() {
                    return RunRescue.this.getBaseShow() != value;
                }

                public void actionPerformed(ActionEvent e) {
                    RunRescue.this.setBaseShow(value);
                }
            });
        }
        c = 0;
        while (c < 11) {
            value = c++;
            actions.add(new AbstractAction(){
                {
                    this.putValue("ActionCommandKey", "target " + value);
                }

                public boolean isEnabled() {
                    return RunRescue.this.playerShip.getTarget() != value;
                }

                public void actionPerformed(ActionEvent e) {
                    RunRescue.this.playerShip.setTarget(value);
                    RunRescue.this.updateGUI();
                }
            });
        }
        c = 0;
        while (c < 11) {
            value = c++;
            actions.add(new AbstractAction(){
                {
                    this.putValue("ActionCommandKey", "fix " + value);
                }

                public boolean isEnabled() {
                    return RunRescue.this.playerShip.getFixPriority() != value;
                }

                public void actionPerformed(ActionEvent e) {
                    RunRescue.this.playerShip.setFixPriority(value);
                    RunRescue.this.updateGUI();
                }
            });
        }
        for (c = 0; c < 9; ++c) {
            value = c + 1;
            actions.add(new AbstractAction(){
                {
                    this.putValue("ActionCommandKey", "warp_speed " + value);
                    this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(48 + value, 0));
                }

                public boolean isEnabled() {
                    return value != RunRescue.this.playerShip.getWarpFactor();
                }

                public void actionPerformed(ActionEvent e) {
                    RunRescue.this.playerShip.setWarpFactor(value);
                    RunRescue.this.updateGUI();
                }
            });
        }
        for (c = 0; c < 4; ++c) {
            value = c + 1;
            actions.add(new AbstractAction(){
                {
                    this.putValue("ActionCommandKey", "impulse_speed " + value);
                }

                public boolean isEnabled() {
                    return (int)(RunRescue.this.playerShip.getImpulseFactor() * 4.0) != value;
                }

                public void actionPerformed(ActionEvent e) {
                    RunRescue.this.playerShip.setImpulseFactor(value);
                    RunRescue.this.updateGUI();
                }
            });
        }
        for (c = 0; c < 3; ++c) {
            value = c + 1;
            actions.add(new AbstractAction(){
                {
                    this.putValue("ActionCommandKey", "phaser_intensity " + value);
                }

                public boolean isEnabled() {
                    return RunRescue.this.playerShip.getPhaserIntensityInt() != value;
                }

                public void actionPerformed(ActionEvent e) {
                    RunRescue.this.playerShip.setPhaserIntensity(value);
                    RunRescue.this.updateGUI();
                }
            });
        }
        for (c = 0; c < 3; ++c) {
            value = c + 1;
            actions.add(new AbstractAction(){
                {
                    this.putValue("ActionCommandKey", "torpedo_salvo " + value);
                }

                public boolean isEnabled() {
                    return RunRescue.this.playerShip.getTorpedoSalvoInt() != value;
                }

                public void actionPerformed(ActionEvent e) {
                    RunRescue.this.playerShip.setTorpedoSalvo(value);
                    RunRescue.this.updateGUI();
                }
            });
        }
        return actions;
    }

    public void updateEvasiveIndicators(int value) {
        for (int c = 0; c < this.evasiveListeners.size(); ++c) {
            EvasiveAction sl = (EvasiveAction)this.evasiveListeners.elementAt(c);
            sl.newEvasiveState(value);
        }
    }

    public URL getMissionsRootURL() {
        return this.rooturl;
    }

    public void setDelay(int d) {
        DELAY = d;
    }

    public int getDelay() {
        return DELAY;
    }

    public int getSelect() {
        return this.select;
    }

    public void addRescueListener(RescueListener g) {
        this.gui = g;
        if (this.loadgameonstartup) {
            this.loadCurrentMission();
            this.pause = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            if (!this.pause) {
                long startTime = System.currentTimeMillis();
                this.updateGame();
                this.gui.update();
                try {
                    int d = (int)Math.max(0L, (long)DELAY - (System.currentTimeMillis() - startTime));
                    Thread.sleep(d);
                }
                catch (InterruptedException e) {}
                continue;
            }
            try {
                RunRescue e = this;
                synchronized (e) {
                    this.wait();
                    this.pause = false;
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void updateGUI() {
        if (this.pause) {
            this.gui.update();
        }
    }

    public void setMission(MissionLoader ml) {
        ml.loadImagesForGame();
        this.currentMission = ml;
    }

    public MissionLoader getMission() {
        return this.currentMission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadCurrentMission() {
        try {
            this.torpedos = new Vector();
            this.SpaceObjects = this.currentMission.getSpaceObjects(this.torpedos);
            this.playerShip = (Ship)this.SpaceObjects[this.SpaceObjects.length - 1];
            this.playerShip.setPlayer(true, this);
            this.selectedObjects = new Vector();
            this.shiplist = this.currentMission.getShipList();
            this.baselist = this.currentMission.getBaseList();
            this.shipinfo = this.currentMission.getShipInfoPanel();
            this.shiplist.newGame();
            this.baselist.newGame();
            this.shipinfo.setSpaceObject(null);
            this.setSelect(1);
            this.gui.newGame(this.currentMission);
            RunRescue runRescue = this;
            synchronized (runRescue) {
                this.notify();
            }
            JukeBox.play("music");
            JukeBox.play("welcome");
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.keymap);
        }
        catch (Exception e) {
            System.out.print("error creating game\n");
            e.printStackTrace();
        }
    }

    public void closeCurrentMission() {
        this.pause = true;
        this.playerShip = null;
        this.SpaceObjects = null;
        this.gui.closeGame();
        JukeBox.stop("background");
        JukeBox.stop("music");
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.keymap);
    }

    public boolean getMode() {
        return this.currentMission.getExternal();
    }

    public void setMode(boolean a) {
        this.currentMission.setExternal(a);
    }

    public void setShipsSort(int a) {
        this.shiplist.setSort(a);
        this.updateGUI();
    }

    public void setBaseSort(int a) {
        this.baselist.setSort(a);
        this.updateGUI();
    }

    public void setShipsShow(int a) {
        this.shiplist.setShow(a);
        this.updateGUI();
    }

    public void setBaseShow(int a) {
        this.baselist.setShow(a);
        this.updateGUI();
    }

    public int getShipsSort() {
        return this.shiplist.getSort();
    }

    public int getBaseSort() {
        return this.baselist.getSort();
    }

    public int getShipsShow() {
        return this.shiplist.getShow();
    }

    public int getBaseShow() {
        return this.baselist.getShow();
    }

    public void scrollShips(boolean s, boolean up) {
        if (s) {
            this.shiplist.scroll(up);
        } else {
            this.baselist.scroll(up);
        }
        this.updateGUI();
    }

    public boolean canScrollShips(boolean s, boolean up) {
        if (s) {
            return this.shiplist.canScroll(up);
        }
        return this.baselist.canScroll(up);
    }

    public void headsUpDisplay() {
        this.heads = !this.heads;
        this.updateGUI();
    }

    public boolean mapUpdating() {
        long newtime = System.currentTimeMillis();
        this.timetotal += (double)(newtime - this.oldtime);
        ++this.counter;
        if ((long)this.counter >= Math.max(Math.round(this.fps), 1L)) {
            this.fps = (double)Math.round(1000.0 / (this.timetotal / (double)this.counter) * 100.0) / 100.0;
            if (this.fps > 100.0) {
                this.fps = 100.0;
            }
            this.timetotal = 0.0;
            this.counter = 0;
        }
        this.oldtime = newtime;
        return this.playerShip != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pause() {
        if (this.pause && this.SpaceObjects != null) {
            this.oldtime = System.currentTimeMillis();
            RunRescue runRescue = this;
            synchronized (runRescue) {
                this.notify();
            }
        } else {
            this.pause = true;
        }
        this.gui.update();
    }

    public boolean getPause() {
        return this.pause;
    }

    public void zoom(boolean in) {
        if (in && this.canZoom(true)) {
            this.zoom *= 2.0;
        } else if (!in && this.canZoom(false)) {
            this.zoom /= 2.0;
        } else {
            return;
        }
        this.makeSky();
        this.updateGUI();
    }

    public boolean canZoom(boolean in) {
        if (in) {
            return !(this.zoom >= 8.0);
        }
        return !(this.zoom <= 0.0625);
    }

    public void setPanelSize(int w, int h) {
        this.panelWidth = w;
        this.panelHeight = h;
        this.makeSky();
    }

    public void makeSky() {
        this.sky = new Point2D.Double[(int)Math.round(30.0 / this.zoom)];
        for (int i = 0; i < this.sky.length; ++i) {
            this.sky[i] = new Point2D.Double(Math.random() * (double)this.panelWidth, Math.random() * (double)this.panelHeight);
        }
    }

    public void drawStars(Graphics g) {
        Point shift = new Point(0, 0);
        if (this.sky == null) {
            this.makeSky();
        } else if (this.playerShip.getImpulseOn() || this.playerShip.getWarpOn()) {
            shift = this.playerShip.moveTo();
            shift.x = (int)((double)shift.x * ((double)this.panelWidth / ((double)this.windowHeight / this.zoom)));
            shift.y = (int)((double)shift.y * ((double)this.panelHeight / ((double)this.windowHeight / this.zoom)));
        }
        int newshifts = Math.abs(shift.x) + Math.abs(shift.y);
        if (this.shifts > this.panelWidth && newshifts < this.panelWidth) {
            this.makeSky();
        }
        this.shifts = newshifts;
        g.setColor(Color.WHITE);
        for (int i = 0; i < this.sky.length; ++i) {
            g.drawLine((int)this.sky[i].x - shift.x / 2, (int)this.sky[i].y - shift.y / 2, (int)(this.sky[i].x + (double)shift.x), (int)(this.sky[i].y + (double)shift.y));
        }
    }

    public void drawShipsBig(Graphics gi) {
        int i;
        Graphics2D g = (Graphics2D)gi.create();
        int mapWindowWidth = (int)((double)this.windowWidth / this.zoom);
        int mapWindowHeight = (int)((double)this.windowHeight / this.zoom);
        g.scale((double)this.panelWidth / (double)mapWindowWidth, (double)this.panelHeight / (double)mapWindowHeight);
        int x = (int)this.playerShip.getX() - mapWindowWidth / 2;
        int y = (int)this.playerShip.getY() - mapWindowHeight / 2;
        g.translate(-x, -y);
        Rectangle screen = new Rectangle(x - 1000, y - 1000, mapWindowWidth + 2000, mapWindowHeight + 2000);
        for (i = 0; i < this.SpaceObjects.length; ++i) {
            if (!screen.contains(this.SpaceObjects[i])) continue;
            if (this.selectedObjects.contains(this.SpaceObjects[i])) {
                this.SpaceObjects[i].drawBigShape(g, true);
                continue;
            }
            this.SpaceObjects[i].drawBigShape(g, false);
        }
        for (i = 0; i < this.torpedos.size(); ++i) {
            SpaceObject t = (SpaceObject)this.torpedos.elementAt(i);
            if (!screen.contains(t)) continue;
            t.drawBigShape(g, false);
        }
        g.setColor(Color.DARK_GRAY);
        g.drawOval(x + mapWindowWidth / 2 - 250, y + mapWindowHeight / 2 - 250, 500, 500);
        if (this.heads) {
            gi.setColor(Color.WHITE);
            gi.drawString("Zoom: x" + this.zoom, 10, 20);
            gi.drawString("Speed: " + this.playerShip.getSpeedMofC() + " x c", 10, 32);
            gi.drawString("Direction: " + (int)Math.toDegrees(this.playerShip.getDirection()), 10, 44);
            gi.drawString("Location: x=" + this.playerShip.x + " y=" + this.playerShip.y, 10, 56);
            if (this.playerShip.getEvasive() != 0) {
                gi.drawString("Evasive Maneuver: " + this.playerShip.getEvasive(), 10, 68);
            } else if (this.playerShip.getImpulseOn() && this.playerShip.getAutoImpulseOn()) {
                gi.drawString("Distance to impulse target: " + (int)this.playerShip.distance(this.playerShip.getAutoImpulse()), 10, 68);
            } else if (this.playerShip.getWarpOn() && this.playerShip.getAutoWarpOn()) {
                gi.drawString("Distance to warp target: " + (int)this.playerShip.distance(this.playerShip.getAutoWarp()), 10, 68);
            }
        }
        if (this.pause) {
            gi.drawString("Pause", this.panelWidth - 40, 20);
        } else {
            String fpsString = String.valueOf(this.fps);
            while (fpsString.length() < 5) {
                fpsString = fpsString + "0";
            }
            gi.drawString("fps: " + fpsString, this.panelWidth - 55, 20);
        }
    }

    public void drawShipsSmall(Graphics g, int w, int h) {
        int scan = 0;
        if (this.playerShip.getSystem(6) == 0) {
            scan = this.playerShip.getSensorScan();
        }
        for (int i = 0; i < this.SpaceObjects.length; ++i) {
            this.SpaceObjects[i].drawSmallShape(g, (double)w / 1000000.0, (double)h / 1000000.0, scan);
        }
    }

    public int getScan() {
        return this.playerShip.getSensorScan();
    }

    public void updateGame() {
        int i;
        boolean alivefirst = this.playerShip.isAlive();
        int z = this.SpaceObjects.length - 1;
        for (i = 0; i < this.SpaceObjects.length; ++i) {
            ImageObject a = this.SpaceObjects[i];
            a.advance();
            if (a.x < 0) {
                a.x = 1000000 + a.x;
            }
            if (a.y < 0) {
                a.y = 1000000 + a.y;
            }
            if (a.x > 1000000) {
                a.x -= 1000000;
            }
            if (a.y > 1000000) {
                a.y -= 1000000;
            }
            if (this.select != 1 || !(a instanceof MannedObject) || !((MannedObject)a).enemyOf(z) || this.selectedObjects.contains(a) || i == z) continue;
            this.selectedObjects.add(a);
        }
        for (i = 0; i < this.torpedos.size(); ++i) {
            ((SpaceObject)this.torpedos.elementAt(i)).advance();
        }
        for (i = 0; i < this.selectedObjects.size(); ++i) {
            if (!((MannedObject)this.selectedObjects.elementAt(i)).isAlive()) {
                this.selectedObjects.removeElementAt(i);
                --i;
                continue;
            }
            if (this.select != 1 || ((MannedObject)this.selectedObjects.elementAt(i)).enemyOf(z)) continue;
            this.selectedObjects.removeElementAt(i);
            --i;
        }
        Point ai = this.playerShip.getAutoImpulse();
        Point aw = this.playerShip.getAutoWarp();
        if (ai instanceof MannedObject && !((MannedObject)ai).isAlive()) {
            this.playerShip.setAutoImpulse(new Point(ai.x, ai.y));
        }
        if (aw instanceof MannedObject && !((MannedObject)aw).isAlive()) {
            this.playerShip.setAutoWarp(new Point(aw.x, aw.y));
        }
        if (this.sky != null && (this.playerShip.getImpulseOn() || this.playerShip.getWarpOn())) {
            Point shift = this.playerShip.moveTo();
            for (int i2 = 0; i2 < this.sky.length; ++i2) {
                Point2D.Double cp = this.sky[i2];
                try {
                    cp.x -= (double)shift.x * ((double)this.panelWidth / ((double)this.windowHeight / this.zoom));
                    cp.y -= (double)shift.y * ((double)this.panelHeight / ((double)this.windowHeight / this.zoom));
                    if (cp.x < 0.0 || cp.x > (double)this.panelWidth) {
                        cp.x = shift.x < 0 ? Math.random() * (double)shift.x : (double)this.panelWidth - Math.random() * (double)shift.x;
                        cp.y = Math.random() * (double)this.panelHeight;
                        continue;
                    }
                    if (!(cp.y < 0.0) && !(cp.y > (double)this.panelHeight)) continue;
                    cp.x = Math.random() * (double)this.panelWidth;
                    cp.y = shift.y < 0 ? Math.random() * (double)shift.y : (double)this.panelHeight - Math.random() * (double)shift.y;
                    continue;
                }
                catch (Exception e) {
                    System.out.print("A star is lost! This should not happen ever!\n");
                }
            }
        }
        if (alivefirst && !this.playerShip.isAlive()) {
            this.gui.dead();
        }
    }

    public Ship getShip() {
        return this.playerShip;
    }

    public ImageObject[] getSpaceObjects() {
        return this.SpaceObjects;
    }

    public int getShipNumbers(int a) {
        int num;
        block4: {
            block5: {
                int z;
                block3: {
                    num = 0;
                    z = this.SpaceObjects.length - 1;
                    if (a != 1) break block3;
                    for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                        if (!(this.SpaceObjects[i] instanceof Ship) || !((Ship)this.SpaceObjects[i]).isAlive() || !((Ship)this.SpaceObjects[i]).friendOf(z)) continue;
                        ++num;
                    }
                    break block4;
                }
                if (a != 2) break block5;
                for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                    if (!(this.SpaceObjects[i] instanceof Ship) || !((Ship)this.SpaceObjects[i]).isAlive() || !((Ship)this.SpaceObjects[i]).enemyOf(z)) continue;
                    ++num;
                }
                break block4;
            }
            if (a != 3) break block4;
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!(this.SpaceObjects[i] instanceof Ship) || ((Ship)this.SpaceObjects[i]).isAlive()) continue;
                ++num;
            }
        }
        return num;
    }

    public int getBaseNumbers(int a) {
        int num;
        block4: {
            block5: {
                block3: {
                    num = 0;
                    if (a != 1) break block3;
                    for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                        if (!(this.SpaceObjects[i] instanceof Base) || !((Base)this.SpaceObjects[i]).isAlive()) continue;
                        num += ((Base)this.SpaceObjects[i]).getPeople();
                    }
                    break block4;
                }
                if (a != 2) break block5;
                for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                    if (!(this.SpaceObjects[i] instanceof Planet) || ((Planet)this.SpaceObjects[i]).isAlive() || ((Planet)this.SpaceObjects[i]).getPeople() == 0) continue;
                    ++num;
                }
                break block4;
            }
            if (a != 3) break block4;
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!(this.SpaceObjects[i] instanceof Planet) || !((Planet)this.SpaceObjects[i]).isAlive() || ((Planet)this.SpaceObjects[i]).getPeople() == 0) continue;
                ++num;
            }
        }
        return num;
    }

    public void newSelection(int type, ImageObject so) {
        if (type == 1) {
            this.baselist.clearSelection();
        } else {
            this.shiplist.clearSelection();
        }
        this.playerShip.setAutoWarp(so);
        this.playerShip.setAutoImpulse(so);
        this.shipinfo.setSpaceObject(so);
        this.updateGUI();
    }

    public void shipDock() {
        if (!this.playerShip.getShieldsUp()) {
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!this.SpaceObjects[i].hasSelected(this.playerShip) || !(this.SpaceObjects[i] instanceof Base) && !(this.SpaceObjects[i] instanceof Ship) || !((MannedObject)this.SpaceObjects[i]).doYouLike(this.playerShip)) continue;
                this.playerShip.shipDockWith((MannedObject)this.SpaceObjects[i]);
                return;
            }
        }
    }

    public void shipBoard() {
        if (!this.playerShip.getShieldsUp()) {
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!this.SpaceObjects[i].hasSelected(this.playerShip) || !(this.SpaceObjects[i] instanceof Ship) || !((Ship)this.SpaceObjects[i]).doYouLike(this.playerShip)) continue;
                int a = this.playerShip.getNoAwayTeams();
                int b = ((Ship)this.SpaceObjects[i]).getNoAwayTeams();
                this.playerShip.TractorShip(null);
                int j = this.SpaceObjects.length - 1;
                Ship oldship = this.playerShip;
                this.playerShip.setPlayer(false, null);
                this.playerShip = (Ship)this.SpaceObjects[i];
                this.playerShip.setPlayer(true, this);
                oldship.sendPeople(this.playerShip);
                oldship.changeShields();
                this.SpaceObjects[i] = oldship;
                oldship.setNumber(i);
                this.SpaceObjects[j] = this.playerShip;
                this.playerShip.setNumber(j);
                this.selectedObjects.remove(this.playerShip);
                this.playerShip.TractorShip(oldship);
                this.playerShip.setNoAwayTeams(a);
                ((Ship)this.SpaceObjects[i]).setNoAwayTeams(b);
                this.shiplist.setShow(this.shiplist.getShow());
                this.shipinfo.setSpaceObject(null);
                return;
            }
        }
    }

    public void shipBeamDown() {
        if (!this.playerShip.getShieldsUp() && this.playerShip.getSystem(9) == 0) {
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).hasSelected(this.playerShip)) continue;
                ((MannedObject)this.SpaceObjects[i]).beamTeamFrom(this.playerShip);
                return;
            }
        }
    }

    public void shipBeamUp() {
        if (!this.playerShip.getShieldsUp() && this.playerShip.getSystem(9) == 0) {
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).hasSelected(this.playerShip)) continue;
                this.playerShip.beamTeamFrom((MannedObject)this.SpaceObjects[i]);
                return;
            }
        }
    }

    public void shipFireTorpedo() {
        MannedObject p = this.getClosestSelectedObject();
        if (p != null && this.playerShip.distance(p) <= 500.0) {
            this.playerShip.FireTorpedo(p);
        }
    }

    public void shipFirePhaser() {
        MannedObject p = this.getClosestSelectedObject();
        if (p != null && this.playerShip.distance(p) <= 250.0) {
            this.playerShip.FirePhaser(p);
        }
    }

    public void shipTractorShip() {
        if (this.playerShip.getTractoredShip() == null) {
            MannedObject p = this.getClosestSelectedObject();
            if (p != null && p instanceof Ship && this.playerShip.distance(p) <= 250.0) {
                this.playerShip.TractorShip((Ship)p);
            }
        } else {
            this.playerShip.TractorShip(null);
        }
    }

    public MannedObject getClosestSelectedObject() {
        int a = 0;
        int b = 1000000;
        MannedObject p = null;
        for (int i = 0; i < this.selectedObjects.size(); ++i) {
            a = (int)((MannedObject)this.selectedObjects.elementAt(i)).distance(this.playerShip) - ((MannedObject)this.selectedObjects.elementAt(i)).getSize();
            if (a >= b) continue;
            b = a;
            p = (MannedObject)this.selectedObjects.elementAt(i);
        }
        return p;
    }

    public void setSelect(int a) {
        block4: {
            block3: {
                this.select = a;
                for (int c = 0; c < this.selectListeners.size(); ++c) {
                    SelectAction sl = (SelectAction)this.selectListeners.elementAt(c);
                    sl.newSelectState(this.select);
                }
                this.selectedObjects.removeAllElements();
                if (this.select != 0) break block3;
                for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                    if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).isAlive()) continue;
                    this.selectedObjects.add(this.SpaceObjects[i]);
                }
                break block4;
            }
            if (this.select != 1) break block4;
            int z = this.SpaceObjects.length - 1;
            for (int i = 0; i < this.SpaceObjects.length - 1; ++i) {
                if (!(this.SpaceObjects[i] instanceof MannedObject) || !((MannedObject)this.SpaceObjects[i]).isAlive() || !((MannedObject)this.SpaceObjects[i]).enemyOf(z)) continue;
                this.selectedObjects.add(this.SpaceObjects[i]);
            }
        }
    }

    public void selectShips(int x, int y) {
        Point p = new Point(this.playerShip.x + (int)((double)(x - this.panelWidth / 2) * ((double)this.windowWidth / (double)this.panelWidth) / this.zoom), this.playerShip.y + (int)((double)(y - this.panelHeight / 2) * ((double)this.windowHeight / (double)this.panelHeight) / this.zoom));
        for (int i = this.SpaceObjects.length - 2; i >= 0; --i) {
            if (!this.SpaceObjects[i].hasSelected(p) || !(this.SpaceObjects[i] instanceof MannedObject)) continue;
            if (this.select != 2 || !this.selectedObjects.contains(this.SpaceObjects[i])) {
                this.selectedObjects.removeAllElements();
                this.selectedObjects.add(this.SpaceObjects[i]);
            } else {
                this.selectedObjects.removeAllElements();
            }
            this.select = 2;
            break;
        }
        this.updateGUI();
    }

    public void shipManImpulse(double angle) {
        this.playerShip.setAutoImpulseOn(false);
        this.playerShip.setManImpulse(angle);
        this.playerShip.setImpulseOn(true);
    }

    public void shipManWarp(double angle) {
        this.playerShip.setAutoWarpOn(false);
        this.playerShip.setManWarp(angle);
        this.playerShip.setWarpOn(true);
    }

    public void shipWarp(int x, int y, int w, int h) {
        this.playerShip.setAutoWarp(new Point((int)((double)x / (double)w * 1000000.0), (int)((double)y / (double)h * 1000000.0)));
        this.updateGUI();
    }

    public void shipImpulse(int x, int y) {
        Point p = new Point(this.playerShip.x + (int)((double)(x - this.panelWidth / 2) * ((double)this.windowWidth / (double)this.panelWidth) / this.zoom), this.playerShip.y + (int)((double)(y - this.panelHeight / 2) * ((double)this.windowHeight / (double)this.panelHeight) / this.zoom));
        this.playerShip.setAutoImpulse(p);
        this.updateGUI();
    }

    public void shipWarpOn() {
        this.playerShip.setWarpOn(true);
    }

    public void shipImpulseOn() {
        this.playerShip.setImpulseOn(true);
    }

    public void help() {
        try {
            File file = new File("help/index.htm");
            BrowserLauncher.openURL("file://" + file.getAbsolutePath());
        }
        catch (Exception e) {
            System.out.print("cant open help: " + e.getMessage() + "\n");
        }
    }

    public static double getTurn(double angle, double direction) {
        double tt = Math.abs(direction - angle) > Math.toRadians(180.0) ? (angle > direction ? -(Math.toRadians(360.0) - angle) : Math.toRadians(360.0) + angle) : angle;
        return tt - direction;
    }

    public List getActions() {
        return this.keymap.getActions();
    }

    public Keymap getKeymap() {
        return this.keymap;
    }

    public Action getAction(String name) {
        List actions = this.getActions();
        for (int i = 0; i < actions.size(); ++i) {
            Action action = (Action)actions.get(i);
            if (!name.equals((String)action.getValue("ActionCommandKey"))) continue;
            return action;
        }
        throw new RuntimeException("unknown command: \"" + name + "\"");
    }

    class EvasiveAction
    extends AbstractAction {
        private int type;

        public EvasiveAction(int type, String name, String label) {
            super(label);
            this.type = type;
            this.putValue("ActionCommandKey", name);
            RunRescue.this.evasiveListeners.add(this);
        }

        public void newEvasiveState(int state) {
            this.setEnabled(state != this.type);
        }

        public void actionPerformed(ActionEvent e) {
            RunRescue.this.playerShip.setEvasive(this.type);
            RunRescue.this.updateGUI();
        }
    }

    class SelectAction
    extends AbstractAction {
        private int type;

        public SelectAction(int type, String name, String label) {
            super(label);
            this.type = type;
            this.putValue("ActionCommandKey", name);
            RunRescue.this.selectListeners.add(this);
        }

        public void newSelectState(int state) {
            this.setEnabled(state != this.type);
        }

        public void actionPerformed(ActionEvent e) {
            RunRescue.this.setSelect(this.type);
            RunRescue.this.updateGUI();
        }
    }
}

