/*
 * Decompiled with CFR 0.152.
 */
package rescue.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JInternalFrame;
import javax.swing.RootPaneContainer;

public class AspectRatio
extends ComponentAdapter {
    private double ratio;

    public AspectRatio(int w, int h) {
        this.ratio = (double)w / (double)h;
    }

    public void componentResized(ComponentEvent e) {
        Component c = e.getComponent();
        if (c instanceof RootPaneContainer) {
            RootPaneContainer f = (RootPaneContainer)((Object)c);
            AspectRatio.fixSize(f.getContentPane(), this.ratio);
            if (c instanceof Window) {
                ((Window)((Object)f)).pack();
            } else if (c instanceof JInternalFrame) {
                ((JInternalFrame)f).pack();
            }
        }
    }

    public static void fixSize(Container cp, double r) {
        int w = cp.getWidth();
        int h = cp.getHeight();
        int dw = (int)Math.round((double)h * r);
        int dh = (int)Math.round((double)w / r);
        if (dw > w) {
            w = dw;
        }
        if (dh > h) {
            h = dh;
        }
        cp.setPreferredSize(new Dimension(w, h));
    }
}

