/*
 * Decompiled with CFR 0.152.
 */
package rescue.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import rescue.RunRescue;
import rescue.gui.Keymap;
import rescue.gui.RescueGUI;

public class PrefDialog
extends JDialog
implements ActionListener,
PropertyChangeListener {
    private static final String TEMP_ACCELERATOR_KEY = "TEMP_AcceleratorKey";
    private RunRescue rescue;
    private RescueGUI gui;
    private JCheckBox inout;
    private JSpinner delay;
    private Keymap keymap;
    private JTable table;

    public PrefDialog(Frame parent, boolean modal, RunRescue r, RescueGUI g, Keymap km) {
        super(parent, "Preferences", modal);
        this.rescue = r;
        this.gui = g;
        this.keymap = km;
        this.initGUI();
        this.pack();
    }

    private void initGUI() {
        JButton cancelButton = new JButton("Cancel");
        cancelButton.setActionCommand("cancel");
        cancelButton.addActionListener(this);
        JButton okButton = new JButton("OK");
        okButton.setActionCommand("ok");
        okButton.addActionListener(this);
        JButton changeButton = new JButton("Change");
        changeButton.setActionCommand("change");
        changeButton.addActionListener(this);
        JButton clearButton = new JButton("Clear");
        clearButton.setActionCommand("clear");
        clearButton.addActionListener(this);
        JPanel bottomPanel = new JPanel();
        bottomPanel.add(cancelButton);
        bottomPanel.add(changeButton);
        bottomPanel.add(clearButton);
        bottomPanel.add(okButton);
        this.inout = new JCheckBox("Use External Frames", this.rescue.getMode());
        JPanel optionsPanel = new JPanel();
        this.delay = new JSpinner();
        this.delay.setValue(new Integer(this.rescue.getDelay()));
        optionsPanel.add(new JLabel("Delay in milliseconds:"));
        optionsPanel.add(this.delay);
        JPanel options = new JPanel();
        options.add(this.inout);
        options.add(optionsPanel);
        JPanel keymaping = new JPanel(new BorderLayout());
        keymaping.add(this.makeKeyTable());
        this.getContentPane().add((Component)options, "North");
        this.getContentPane().add((Component)keymaping, "Center");
        this.getContentPane().add((Component)bottomPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                PrefDialog.this.closeDialog();
            }
        });
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok")) {
            this.rescue.setMode(this.inout.isSelected());
            this.rescue.setDelay((Integer)this.delay.getValue());
            List actions = this.rescue.getActions();
            for (int c = 0; c < actions.size(); ++c) {
                Action action = (Action)actions.get(c);
                action.putValue("AcceleratorKey", action.getValue(TEMP_ACCELERATOR_KEY));
            }
            try {
                Keymap.saveKeys(actions, new FileOutputStream(new File(new URL(this.rescue.getMissionsRootURL(), "keys.ini").getFile())));
            }
            catch (Exception ex) {
                System.out.println("unable to save keys: " + ex);
            }
            this.closeDialog();
        } else if (e.getActionCommand().equals("change")) {
            Action action = this.getCurrentAction();
            action.addPropertyChangeListener(this);
            this.keymap.setupKeyForAction(action, TEMP_ACCELERATOR_KEY);
        } else if (e.getActionCommand().equals("clear")) {
            Action action = this.getCurrentAction();
            action.putValue(TEMP_ACCELERATOR_KEY, null);
            this.repaint();
        } else if (e.getActionCommand().equals("cancel")) {
            this.closeDialog();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Action action = this.getCurrentAction();
        action.removePropertyChangeListener(this);
        Object keyStroke = action.getValue(TEMP_ACCELERATOR_KEY);
        List actions = this.rescue.getActions();
        for (int c = 0; c < actions.size(); ++c) {
            Action action2 = (Action)actions.get(c);
            if (action == action2 || !keyStroke.equals(action2.getValue(TEMP_ACCELERATOR_KEY))) continue;
            action2.putValue(TEMP_ACCELERATOR_KEY, null);
        }
        this.repaint();
    }

    private Action getCurrentAction() {
        return (Action)this.rescue.getActions().get(this.table.getSelectedRow());
    }

    private void closeDialog() {
        List actions = this.rescue.getActions();
        for (int c = 0; c < actions.size(); ++c) {
            ((Action)actions.get(c)).putValue(TEMP_ACCELERATOR_KEY, null);
        }
        this.setVisible(false);
        this.dispose();
    }

    private JScrollPane makeKeyTable() {
        List actions = this.rescue.getActions();
        for (int c = 0; c < actions.size(); ++c) {
            Action action = (Action)actions.get(c);
            action.putValue(TEMP_ACCELERATOR_KEY, action.getValue("AcceleratorKey"));
        }
        AbstractTableModel tableModel = new AbstractTableModel(){
            private final String[] columnNames = new String[]{"Action", "Command", "Key"};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public int getRowCount() {
                return PrefDialog.this.rescue.getActions().size();
            }

            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            public Object getValueAt(int row, int col) {
                Action action = (Action)PrefDialog.this.rescue.getActions().get(row);
                switch (col) {
                    case 0: {
                        return action.getValue("Name");
                    }
                    case 1: {
                        return action.getValue("ActionCommandKey");
                    }
                    case 2: {
                        return action.getValue(PrefDialog.TEMP_ACCELERATOR_KEY);
                    }
                }
                throw new RuntimeException();
            }
        };
        this.table = new JTable(tableModel);
        this.table.setSelectionMode(0);
        return new JScrollPane(this.table);
    }
}

