/*
 * Decompiled with CFR 0.152.
 */
package rescue.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import rescue.RunRescue;

public class BigMapPanel
extends JPanel
implements MouseListener,
MouseWheelListener {
    private RunRescue rescue;
    private int posX;
    private int posY;

    public BigMapPanel(RunRescue rr, int w, int h) {
        this.rescue = rr;
        this.addMouseListener(this);
        this.addMouseWheelListener(this);
        this.posX = 0;
        this.posY = 0;
        Dimension size1 = new Dimension(w, h);
        this.setPreferredSize(size1);
    }

    public void paintComponent(Graphics g) {
        if (this.rescue.mapUpdating()) {
            int w = this.getWidth();
            int h = this.getHeight();
            g.setColor(Color.BLACK);
            g.fillRect(0, 0, w, h);
            this.rescue.drawStars(g);
            this.rescue.drawShipsBig(g);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.rescue.setPanelSize(width, height);
    }

    public void mouseWheelMoved(MouseWheelEvent e) {
        if (e.getWheelRotation() < 0) {
            this.rescue.zoom(true);
        } else {
            this.rescue.zoom(false);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        boolean leftClick;
        boolean rightClick = e.getModifiers() == 16;
        boolean middleClick = e.getModifiers() == 8;
        boolean bl = leftClick = e.getModifiers() == 4;
        if (rightClick || leftClick) {
            this.rescue.shipImpulse(e.getX(), e.getY());
        }
        if (rightClick) {
            this.rescue.selectShips(e.getX(), e.getY());
        } else if (leftClick) {
            this.rescue.shipImpulseOn();
        } else if (middleClick) {
            double angle = Math.atan((double)(e.getX() - this.getWidth() / 2) / (double)(this.getHeight() / 2 - e.getY()));
            if (e.getY() > this.getHeight() / 2) {
                angle += Math.toRadians(180.0);
            }
            if (angle < 0.0) {
                angle += Math.toRadians(360.0);
            }
            this.rescue.shipManImpulse(angle);
        }
    }
}

