/*
 * Decompiled with CFR 0.152.
 */
package rescue.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPanel;
import rescue.RunRescue;
import rescue.spaceobjects.ImageObject;
import rescue.spaceobjects.MannedObject;
import rescue.spaceobjects.Planet;
import rescue.spaceobjects.Wormhole;

public class ShipInfoPanel
extends JPanel {
    private ImageObject mySO;
    private RunRescue rescue;

    public ShipInfoPanel(int w, int h, RunRescue r) {
        this.rescue = r;
        Dimension size = new Dimension(w, h);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
        this.setPreferredSize(size);
    }

    public void paintComponent(Graphics g) {
        g.setColor(Color.BLACK);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(Color.WHITE);
        int scan = this.rescue.getScan();
        if (this.mySO != null && (this.mySO instanceof Wormhole || scan >= ((MannedObject)this.mySO).getCloakPower()) && this.rescue.getShip().getSystem(5) == 0) {
            g.drawImage(this.mySO.getInfoImage(), this.getWidth() - 150, this.getHeight() - 150, this);
            g.drawString("Name: " + this.mySO.getName(), 4, 14);
            g.drawString("Location: " + this.mySO.x + " " + this.mySO.y, 4, 29);
            g.drawString("Distance: " + this.mySO.getDistanceToPlayer(), 4, 44);
            if (!(this.mySO instanceof Wormhole) && scan > 0) {
                int a = ((MannedObject)this.mySO).getTotalEnergy();
                int b = ((MannedObject)this.mySO).getShieldPower();
                g.drawRect(2, 48, 9, 124);
                g.drawRect(14, 48, 9, 124);
                g.drawString("Energy: " + a + " Shields: " + b, 27, 170);
                int acolor = (int)(123.0 * ((double)a / (double)((MannedObject)this.mySO).getMaxtotalenergy()));
                int bcolor = (int)(123.0 * ((double)b / (double)((MannedObject)this.mySO).getMaxshieldpower()));
                if (scan > 1) {
                    g.drawString("Tpdos: " + ((MannedObject)this.mySO).getTorpedosLeft() + " Phase: " + ((MannedObject)this.mySO).getPhaserBanks(), 27, 155);
                }
                g.setColor(Color.GREEN.darker());
                g.fillRect(3, 49 + (123 - acolor), 8, acolor);
                g.setColor(Color.YELLOW.darker());
                g.fillRect(15, 49 + (123 - bcolor), 8, bcolor);
            }
        } else {
            g.drawString("-- NO OBJECT --", this.getWidth() / 2 - 40, this.getHeight() / 2 + 3);
        }
    }

    public void setSpaceObject(ImageObject so) {
        this.mySO = so;
    }

    public void list() {
        if (!(this.mySO == null || this.mySO instanceof Wormhole || ((MannedObject)this.mySO).isAlive() || this.mySO instanceof Planet)) {
            this.mySO = null;
        }
        this.repaint();
    }
}

