/*
 * Decompiled with CFR 0.152.
 */
package solarex.ship;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import solarex.ship.Good;

public class Cargo {
    public double money;
    public int space;
    public Good[] goods = new Good[Good.Type.values().length];
    public boolean[] illegalGoods = new boolean[Good.Type.values().length];

    public Cargo() {
        for (int i = 0; i < this.goods.length; ++i) {
            this.goods[i] = new Good();
            this.goods[i].type = Good.Type.values()[i];
        }
    }

    public int availableSpace() {
        return this.space - this.totalSpaceUsedByGoods();
    }

    public int totalSpaceUsedByGoods() {
        int sum = 0;
        for (int i = 0; i < this.goods.length; ++i) {
            sum += this.goods[i].units * this.goods[i].type.massPerUnit;
        }
        return sum;
    }

    public void save(Writer writer) throws IOException {
        int i;
        writer.write("<Cargo>\n");
        writer.write("<version>2</version>\n");
        writer.write("<mony>" + this.money + "</mony>\n");
        for (i = 0; i < this.goods.length; ++i) {
            writer.write("<good>" + this.goods[i].units + "</good>\n");
        }
        for (i = 0; i < this.illegalGoods.length; ++i) {
            writer.write("<good>" + this.illegalGoods[i] + "</good>\n");
        }
        writer.write("</Cargo>\n");
    }

    public void load(BufferedReader reader) throws IOException {
        int i;
        reader.readLine();
        reader.readLine();
        String tmp = reader.readLine();
        this.money = Double.parseDouble(tmp.substring(6, tmp.length() - 7));
        for (i = 0; i < this.goods.length; ++i) {
            tmp = reader.readLine();
            this.goods[i].units = Integer.parseInt(tmp.substring(6, tmp.length() - 7));
        }
        for (i = 0; i < this.illegalGoods.length; ++i) {
            tmp = reader.readLine();
            this.illegalGoods[i] = Boolean.parseBoolean(tmp);
        }
        reader.readLine();
    }
}

