/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.components;

import java.awt.Color;
import java.awt.Font;
import java.text.NumberFormat;
import javax.swing.JLabel;
import solarex.system.Solar;
import solarex.util.FontFactory;

public class PlanetDetailLabel
extends JLabel {
    public PlanetDetailLabel() {
        this.setVerticalAlignment(1);
        this.setHorizontalAlignment(4);
        this.setOpaque(false);
        this.setForeground(Color.GREEN);
        Font font = FontFactory.getSmaller();
        this.setFont(font);
    }

    public void update(Solar body) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        double gravity = body.calcSurfaceGravity();
        Solar parent = body.getParent();
        double parentMass = parent.mass * 1000.0;
        double a = body.orbit * 1000.0;
        double G = 6.67384E-11;
        double time = Math.PI * 2 * Math.sqrt(a * a * a / (6.67384E-11 * (parentMass + body.mass * 1000.0)));
        double days = time / 86400.0;
        String orbitString = days < 300.0 ? nf.format(days) + " days" : nf.format(days / 365.0) + " years";
        String infoText = "<html><br><br>Gravity: <font color=white>" + nf.format(gravity / 9.81) + " g</font><br>" + "Orbital period: <font color=white>" + orbitString + "</font><br>" + "Rotation period: <font color=white>" + nf.format(body.rotationPeriod / 3600.0) + " hours</font><br>" + "<br><br></html>";
        this.setText(infoText);
    }
}

