/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.panels;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import solarex.galaxy.Galaxy;
import solarex.galaxy.SystemLocation;
import solarex.ship.Ship;
import solarex.system.Solar;
import solarex.ui.ImageCache;
import solarex.ui.interfaces.ShowSystemCallback;
import solarex.util.FontFactory;

public class GalaxyViewPanel
extends JPanel {
    private final ImageCache imageCache;
    private Ship ship;
    private Color gridColor = new Color(0, 128, 0);
    private Color mapBackgroundColor = new Color(0, 9, 17);
    private Color hyperRangeColor = new Color(0, 18, 43);
    private Color colorBrown = new Color(160, 80, 0);
    private int zoom;
    private ArrayList<SystemInfo> systemInfoList = new ArrayList();
    private int centerX = -300;
    private int centerY = 0;
    private int dragStartX;
    private int dragStartY;
    private int dragCenterX;
    private int dragCenterY;
    private ShowSystemCallback showSystemCallback;
    private Galaxy galaxy;
    private String systemDistance;

    public void setShowSystemCallback(ShowSystemCallback c) {
        this.showSystemCallback = c;
    }

    public GalaxyViewPanel(Galaxy galaxy, Ship ship, ImageCache imageCache) {
        this.galaxy = galaxy;
        this.ship = ship;
        this.imageCache = imageCache;
        this.zoom = 1;
        this.setBackground(Color.DARK_GRAY);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                GalaxyViewPanel.this.openSystem(e.getX(), e.getY(), e.getClickCount());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                GalaxyViewPanel.this.dragStartX = e.getX();
                GalaxyViewPanel.this.dragStartY = e.getY();
                GalaxyViewPanel.this.dragCenterX = GalaxyViewPanel.this.centerX;
                GalaxyViewPanel.this.dragCenterY = GalaxyViewPanel.this.centerY;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int x = e.getX();
                int y = e.getY();
                int dx = GalaxyViewPanel.this.dragStartX - x;
                int dy = GalaxyViewPanel.this.dragStartY - y;
                GalaxyViewPanel.this.centerX = GalaxyViewPanel.this.dragCenterX + dx * GalaxyViewPanel.this.zoom;
                GalaxyViewPanel.this.centerY = GalaxyViewPanel.this.dragCenterY + dy * GalaxyViewPanel.this.zoom;
                GalaxyViewPanel.this.repaint(50L);
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                int u = e.getWheelRotation();
                GalaxyViewPanel.this.zoom += u;
                if (GalaxyViewPanel.this.zoom < 1) {
                    GalaxyViewPanel.this.zoom = 1;
                }
                if (GalaxyViewPanel.this.zoom > 11) {
                    GalaxyViewPanel.this.zoom = 11;
                }
                GalaxyViewPanel.this.repaint();
            }
        });
    }

    private void showGalacticalSector(Graphics gr, int xpos, int ypos, int i, int j) {
        List<SystemLocation> list = this.galaxy.buildSector(i, j);
        if (this.zoom < 6) {
            gr.setColor(this.gridColor);
            gr.drawRect(xpos, ypos, 256 / this.zoom, 256 / this.zoom);
        }
        int anz = list.size();
        for (int n = 0; n < anz; ++n) {
            int margin;
            SystemLocation loca = list.get(n);
            int x = xpos + loca.ioff * 2 / this.zoom;
            int y = ypos + loca.joff * 2 / this.zoom;
            SystemInfo inf = new SystemInfo();
            inf.xpos = x;
            inf.ypos = y;
            inf.loca = loca;
            this.systemInfoList.add(inf);
            Solar system = new Solar(inf.loca, false);
            int size = 1 + Math.max((system.radius >> 19) / this.zoom, 3);
            switch (system.stype) {
                case S_YELLOW: {
                    gr.setColor(Color.YELLOW);
                    break;
                }
                case S_ORANGE: {
                    gr.setColor(Color.ORANGE);
                    break;
                }
                case S_WHITE_DWARF: {
                    gr.setColor(Color.WHITE);
                    break;
                }
                case S_BLUE_GIANT: {
                    gr.setColor(Color.CYAN);
                    break;
                }
                case S_RED_GIANT: {
                    gr.setColor(Color.RED);
                    break;
                }
                case S_NEUTRON: {
                    gr.setColor(Color.DARK_GRAY);
                    break;
                }
                case S_BLACK_HOLE: {
                    gr.setColor(Color.WHITE);
                    break;
                }
                case S_BROWN_DWARF: {
                    gr.setColor(this.colorBrown);
                    break;
                }
                default: {
                    gr.setColor(Color.YELLOW);
                }
            }
            if (this.zoom < 4) {
                this.drawSun(gr, x, y, size, system.stype);
                margin = Math.max(size / 2 + 4, 12);
                if (this.ship.loca.equals(loca)) {
                    gr.drawRoundRect(x - margin - 4, y - margin - 2, 80, margin * 2, 8, 8);
                }
                if (loca.equals(this.ship.hyperjumpDestination)) {
                    gr.setColor(Color.GREEN);
                    gr.drawRoundRect(x - margin - 4, y - margin - 2, 80, margin * 2, 8, 8);
                }
                gr.setColor(Color.WHITE);
                gr.drawString(system.name, x + size / 2 + 2, y + 2);
                continue;
            }
            this.drawSun(gr, x, y, size, system.stype);
            margin = 9;
            if (this.ship.loca.equals(loca)) {
                gr.drawRoundRect(x - 9, y - 9, 18, 18, 8, 8);
            }
            if (!loca.equals(this.ship.hyperjumpDestination)) continue;
            gr.setColor(Color.GREEN);
            gr.drawRoundRect(x - 9, y - 9, 18, 18, 8, 8);
        }
    }

    private void drawSun(Graphics gr, int x, int y, int size, Solar.SunType stype) {
        if (stype == Solar.SunType.S_BLACK_HOLE) {
            if (this.zoom < 0) {
                Image img = this.imageCache.suns[stype.ordinal()].getImage();
                gr.drawImage(img, x - size / 2, y - size / 2, size * 2, size, null);
            } else {
                gr.drawOval(x - size / 2, y - size / 2, size, size);
            }
        } else {
            if (this.zoom < 0) {
                Image img = this.imageCache.suns[stype.ordinal()].getImage();
                gr.drawImage(img, x - size / 2, y - size / 2, size, size, null);
            }
            if (this.zoom < 7) {
                gr.fillOval(x - size / 2, y - size / 2, size, size);
            } else {
                gr.fillRect(x, y, 2, 2);
            }
        }
    }

    @Override
    public void paint(Graphics gr) {
        super.paint(gr);
        int width = this.getWidth();
        int height = this.getHeight();
        gr.drawImage(this.imageCache.metalBand.getImage(), 0, 0, width, height, null);
        gr.setColor(Color.GRAY);
        gr.drawRect(10, 11, 410, 48);
        gr.setColor(Color.BLACK);
        gr.fillRect(11, 12, 408, 46);
        gr.setColor(Color.WHITE);
        gr.setFont(FontFactory.getPanelHeading());
        gr.drawString("Galactic Map", 136, 43);
        int left = width / 2;
        gr.setColor(Color.GRAY);
        gr.drawRect(left + 10, 11, 410, 48);
        gr.setColor(Color.BLACK);
        gr.fillRect(left + 11, 12, 408, 46);
        gr.setColor(Color.GRAY);
        gr.drawRect(10, height - 61, 410, 42);
        gr.setColor(Color.BLACK);
        gr.fillRect(11, height - 60, 408, 40);
        gr.setFont(FontFactory.getNormal());
        gr.setColor(Color.CYAN);
        gr.drawString("Drag map by mouse. Zoom with mouse wheel.", 18, height - 44);
        gr.drawString("Click system to set hyperjump destination. Double click to inspect.", 18, height - 28);
        gr.setFont(FontFactory.getLabelHeading());
        gr.setColor(Color.GREEN);
        gr.drawString("Map sector:", left + 18, 30);
        gr.drawString("Hyperjump dest.:", left + 18, 50);
        gr.setFont(FontFactory.getLarger());
        gr.setColor(Color.WHITE);
        gr.drawString(this.centerX / 128 + " ' " + (this.centerX & 0x7F) + " / " + this.centerY / 128 + " ' " + (this.centerY & 0x7F) + "", left + 133, 30);
        if (this.ship.hyperjumpDestination == null) {
            gr.drawString("Not set", left + 133, 50);
        } else {
            gr.drawString(this.systemDistance, left + 133, 50);
        }
        if (this.zoom <= 2) {
            gr.setFont(FontFactory.getNormal());
        } else if (this.zoom == 3) {
            gr.setFont(FontFactory.getSmaller());
        }
        this.systemInfoList.clear();
        gr.setColor(this.mapBackgroundColor);
        gr.fillRect(100, 75, width - 200, height - 150);
        gr.setColor(Color.GRAY);
        gr.drawRect(99, 74, width - 200 + 2, height - 150 + 2);
        gr.setClip(100, 75, width - 200, height - 150);
        this.drawHyperJumpRange(gr, width, height);
        for (int y = this.centerY / 128 - this.zoom * 2 - 1; y <= this.centerY / 128 + this.zoom * 2 + 1; ++y) {
            for (int x = this.centerX / 128 - this.zoom * 3 - 1; x <= this.centerX / 128 + this.zoom * 3 + 1; ++x) {
                this.showGalacticalSector(gr, width / 2 + (x * 128 - 64 - this.centerX) * 2 / this.zoom, height / 2 + (y * 128 - 64 - this.centerY) * 2 / this.zoom, x, y);
            }
        }
    }

    private void drawHyperJumpRange(Graphics gr, int width, int height) {
        int maxRange = this.ship.equipment.getHyperjumpRange() * 256 / (this.zoom * 5);
        int x = width / 2 + (this.ship.loca.galacticSectorI * 128 - 64 - this.centerX) * 2 / this.zoom;
        int y = height / 2 + (this.ship.loca.galacticSectorJ * 128 - 64 - this.centerY) * 2 / this.zoom;
        int shipX = x + this.ship.loca.ioff * 2 / this.zoom;
        int shipY = y + this.ship.loca.joff * 2 / this.zoom;
        gr.setColor(this.hyperRangeColor);
        gr.fillOval(shipX - maxRange / 2, shipY - maxRange / 2, maxRange, maxRange);
        gr.setColor(Color.GRAY);
        gr.drawOval(shipX - maxRange / 2, shipY - maxRange / 2, maxRange, maxRange);
    }

    private void openSystem(int x, int y, int clicks) {
        int n = this.systemInfoList.size();
        for (int i = 0; i < n; ++i) {
            SystemInfo inf = this.systemInfoList.get(i);
            int dx = inf.xpos - x;
            int dy = inf.ypos - y;
            if (Math.abs(dx) >= 10 || Math.abs(dy) >= 10) continue;
            if (inf.loca.equals(this.ship.loca)) {
                this.ship.hyperjumpDestination = null;
            } else {
                this.ship.hyperjumpDestination = inf.loca;
                int maxRange = this.ship.equipment.getHyperjumpRange();
                Solar system = new Solar(inf.loca, false);
                double d = this.ship.loca.distance(inf.loca);
                this.systemDistance = system.name + ", distance " + (double)((int)(d * 100.0)) / 100.0 + " ly, max drive range " + maxRange + " ly";
            }
            if (clicks == 2) {
                this.showSystemCallback.showSystem(inf.loca);
                break;
            }
            this.repaint();
            break;
        }
    }

    private class SystemInfo {
        SystemLocation loca;
        int xpos;
        int ypos;

        private SystemInfo() {
        }
    }
}

