/*
 * Decompiled with CFR 0.152.
 */
package solarex.ui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import solarex.ui.ApplicationFrame;
import solarex.util.ComponentFactory;

public class SetupPanel
extends JPanel {
    private ApplicationFrame appFrame;
    private JPanel contentPanel;
    private JButton createSystemButton;
    private JCheckBox explorerCheck;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JButton loadButton;
    private JButton randomSystemButton;
    private JButton saveButton;
    private JTextField seedField;

    public void setSeed(long seed) {
        this.seedField.setText("" + seed);
    }

    public SetupPanel(ApplicationFrame appFrame) {
        this.appFrame = appFrame;
        this.initComponents();
        ComponentFactory.customizeButton(this.createSystemButton);
        ComponentFactory.customizeButton(this.loadButton);
        ComponentFactory.customizeButton(this.randomSystemButton);
        ComponentFactory.customizeButton(this.saveButton);
        this.explorerCheck.setSelected(true);
    }

    private void initComponents() {
        this.contentPanel = new JPanel();
        this.loadButton = new JButton();
        this.saveButton = new JButton();
        this.randomSystemButton = new JButton();
        this.createSystemButton = new JButton();
        this.seedField = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.explorerCheck = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.setBackground(Color.black);
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.contentPanel.setBackground(new Color(50, 0, 38));
        this.contentPanel.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.contentPanel.setMinimumSize(new Dimension(800, 540));
        this.contentPanel.setPreferredSize(new Dimension(800, 540));
        this.contentPanel.setLayout(null);
        this.loadButton.setBackground(Color.gray);
        this.loadButton.setText("Load Game");
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.loadButtonActionPerformed(evt);
            }
        });
        this.contentPanel.add(this.loadButton);
        this.loadButton.setBounds(100, 160, 120, 30);
        this.saveButton.setBackground(Color.gray);
        this.saveButton.setText("Save Game");
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.saveButtonActionPerformed(evt);
            }
        });
        this.contentPanel.add(this.saveButton);
        this.saveButton.setBounds(100, 120, 120, 30);
        this.randomSystemButton.setBackground(Color.gray);
        this.randomSystemButton.setText("Create Random System");
        this.randomSystemButton.setMargin(new Insets(2, 2, 2, 2));
        this.randomSystemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.randomSystemButtonActionPerformed(evt);
            }
        });
        this.contentPanel.add(this.randomSystemButton);
        this.randomSystemButton.setBounds(370, 120, 170, 30);
        this.createSystemButton.setBackground(Color.gray);
        this.createSystemButton.setText("Create System by Seed");
        this.createSystemButton.setMargin(new Insets(2, 2, 2, 2));
        this.createSystemButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.createSystemButtonActionPerformed(evt);
            }
        });
        this.contentPanel.add(this.createSystemButton);
        this.createSystemButton.setBounds(370, 160, 170, 30);
        this.seedField.setBackground(Color.darkGray);
        this.seedField.setForeground(Color.lightGray);
        this.seedField.setText("jTextField1");
        this.seedField.setCaretColor(Color.orange);
        this.seedField.setMargin(new Insets(2, 4, 2, 2));
        this.seedField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.seedFieldActionPerformed(evt);
            }
        });
        this.contentPanel.add(this.seedField);
        this.seedField.setBounds(560, 160, 180, 30);
        this.jLabel1.setFont(new Font("SansSerif", 0, 11));
        this.jLabel1.setForeground(Color.cyan);
        this.jLabel1.setHorizontalAlignment(2);
        this.jLabel1.setText("<html>Uncheck this to access all system info.<br>\nIf checked, you can only inspect data<br>\nfor systems which you have explored<br>\nalready, or which are generally known.</html>");
        this.jLabel1.setVerticalAlignment(1);
        this.contentPanel.add(this.jLabel1);
        this.jLabel1.setBounds(500, 260, 250, 70);
        this.jLabel2.setFont(new Font("SansSerif", 1, 18));
        this.jLabel2.setForeground(Color.white);
        this.jLabel2.setText("Load And Save Games");
        this.contentPanel.add(this.jLabel2);
        this.jLabel2.setBounds(100, 64, 260, 30);
        this.jLabel3.setFont(new Font("SansSerif", 1, 18));
        this.jLabel3.setForeground(Color.white);
        this.jLabel3.setText("Create Stellar Systems By Seed");
        this.contentPanel.add(this.jLabel3);
        this.jLabel3.setBounds(370, 64, 360, 30);
        this.explorerCheck.setForeground(Color.green);
        this.explorerCheck.setText(" Explorer Mode");
        this.explorerCheck.setOpaque(false);
        this.explorerCheck.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetupPanel.this.explorerCheckActionPerformed(evt);
            }
        });
        this.contentPanel.add(this.explorerCheck);
        this.explorerCheck.setBounds(370, 280, 120, 25);
        this.jLabel4.setFont(new Font("SansSerif", 1, 18));
        this.jLabel4.setForeground(Color.white);
        this.jLabel4.setText("Game Mode");
        this.contentPanel.add(this.jLabel4);
        this.jLabel4.setBounds(370, 224, 270, 30);
        this.add((Component)this.contentPanel, new GridBagConstraints());
    }

    private void seedFieldActionPerformed(ActionEvent evt) {
        long seed = System.currentTimeMillis();
        try {
            seed = Long.parseLong(this.seedField.getText());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.appFrame.makeSystem(seed);
    }

    private void createSystemButtonActionPerformed(ActionEvent evt) {
        long seed = System.currentTimeMillis();
        try {
            seed = Long.parseLong(this.seedField.getText());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.appFrame.makeSystem(seed);
    }

    private void randomSystemButtonActionPerformed(ActionEvent evt) {
        long seed = System.currentTimeMillis();
        this.setSeed(seed);
        this.appFrame.makeSystem(seed);
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        boolean ok = this.appFrame.saveGame();
        if (ok) {
            JOptionPane.showMessageDialog(this, "Game saved sucessfully.");
        } else {
            JOptionPane.showMessageDialog(this, "Error while saving game.", "Error", 0);
        }
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        boolean ok = this.appFrame.loadGame();
        if (ok) {
            JOptionPane.showMessageDialog(this.appFrame, "Game loaded sucessfully.");
        } else {
            JOptionPane.showMessageDialog(this.appFrame, "Error while loading game.", "Error", 0);
        }
    }

    private void explorerCheckActionPerformed(ActionEvent evt) {
        this.appFrame.setExplorerMode(this.explorerCheck.isSelected());
    }
}

