/*
 * Decompiled with CFR 0.152.
 */
package solarex.util;

import java.util.ArrayList;
import solarex.util.ClockCallback;

public class ClockThread
extends Thread {
    private ArrayList<ClockCallback> callbacks = new ArrayList();
    boolean go = true;
    private static int gameTicks = 0;

    public static int gameTimeInMinutes() {
        return gameTicks >> 3;
    }

    public static int getMinuteOfHour() {
        return ClockThread.gameTimeInMinutes() % 60;
    }

    public static int getHourOfDay() {
        int time = ClockThread.gameTimeInMinutes();
        return (time /= 60) % 24;
    }

    public static int getDayOfGame() {
        int time = ClockThread.gameTimeInMinutes();
        time /= 60;
        return time /= 24;
    }

    public static int getDayOfMonth() {
        return ClockThread.getDayOfGame() % 30;
    }

    public static int getMonthOfYear() {
        int time = ClockThread.gameTimeInMinutes();
        time /= 60;
        time /= 24;
        return (time /= 30) % 12;
    }

    public static int getYear() {
        int time = ClockThread.gameTimeInMinutes();
        time /= 60;
        time /= 24;
        time /= 30;
        return (time /= 12) + 2160;
    }

    public synchronized void addCallback(ClockCallback cb) {
        this.callbacks.add(cb);
    }

    public synchronized void removeCallback(ClockCallback cb) {
        this.callbacks.remove(cb);
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        while (this.go) {
            try {
                ClockThread.sleep(100L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
            long newTime = System.currentTimeMillis();
            int delta = (int)(newTime - time);
            time = newTime;
            for (int i = 0; i < this.callbacks.size(); ++i) {
                ClockCallback cb = this.callbacks.get(i);
                try {
                    cb.ping100(delta);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++gameTicks;
        }
    }
}

