/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd;

import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import rb.httpd.HttpRequestServer;
import rb.util.SystemRB;

public class HttpServer {
    static String redirectAddress;
    static Date startTime;
    static final String ServerVersion = "1.0";
    static final int DefaultPort = 8081;

    static {
        startTime = new Date();
    }

    static String getRedirectAddress() {
        return redirectAddress;
    }

    public static void main(String[] stringArray) {
        int n = 8081;
        try {
            if (stringArray.length > 0) {
                n = Integer.parseInt(stringArray[0]);
            }
        }
        catch (Exception exception) {
            SystemRB.abort("", "Argument is not a port number: " + stringArray[0], exception, -1);
        }
        new HttpServer().startServer(n);
    }

    static void spawnRequestServer(Socket socket) {
        HttpRequestServer httpRequestServer = new HttpRequestServer(socket);
        Thread thread = new Thread(httpRequestServer){
            /* synthetic */ HttpRequestServer val$server;

            public void run() {
                this.val$server.processRequest();
            }
            {
                this.val$server = httpRequestServer;
            }
        };
        thread.start();
    }

    void startServer(int n) {
        boolean bl = SystemRB.getPropertyBoolean("rb.httpd.log.bind", true);
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(n);
        }
        catch (Exception exception) {
            if (!bl) {
                System.exit(0);
            }
            SystemRB.abort(this, "Could not create server socket on port: " + n, exception, 1);
        }
        try {
            redirectAddress = String.valueOf(InetAddress.getLocalHost().getHostName()) + "/" + InetAddress.getLocalHost().getHostAddress() + ":" + n;
            SystemRB.setProperty("rb.httpd.address", redirectAddress);
        }
        catch (Exception exception) {
            SystemRB.abort(this, "Could not determine server address", exception, 1);
        }
        while (true) {
            String string = "Error on wait for request at server socket";
            try {
                Socket socket = serverSocket.accept();
                string = "Error on spawning request server process";
                HttpServer.spawnRequestServer(socket);
                continue;
            }
            catch (Throwable throwable) {
                SystemRB.log(this, string, throwable);
                continue;
            }
            break;
        }
    }
}

