/*
 * Decompiled with CFR 0.152.
 */
package rb.httpd.address;

import com.sun.java.util.collections.TreeSet;
import java.io.File;
import rb.httpd.address.ABAddress;
import rb.httpd.address.ABAddressReader;
import rb.httpd.address.ABClass;
import rb.httpd.address.ABEntry;
import rb.httpd.address.ABPage;
import rb.httpd.address.ABPerson;
import rb.util.IDDictionary;
import rb.util.IDDictionaryClass;
import rb.util.IDDictionarySlave;

public class ABAddressBook
extends ABClass {
    IDDictionaryClass contents = new IDDictionary();
    TreeSet topPages = new TreeSet();
    TreeSet persons = new TreeSet();
    String name = "";
    int addressCount = 0;
    File logFile;

    public ABAddressBook(File file, String string) {
        new ABAddressReader().readBookFrom(this, file);
        this.logFile = file;
        this.name = string;
    }

    public synchronized int getAddressCount() {
        return this.addressCount;
    }

    public synchronized ABEntry getEntry(long l) {
        return (ABEntry)this.contents.get(l);
    }

    ABEntry getEntry(ABEntry aBEntry) {
        if (aBEntry != null && aBEntry == this.contents.get(aBEntry.getID())) {
            return aBEntry;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    ABEntry getOrAddEntry(long l, ABEntry aBEntry) {
        ABEntry aBEntry2 = this.getEntry(l);
        if (aBEntry2 == null) {
            if (aBEntry instanceof ABAddress) {
                ++this.addressCount;
            }
            aBEntry2 = aBEntry;
            aBEntry2.book = this;
            ((IDDictionarySlave)this.contents).put(l, aBEntry2);
        }
        return aBEntry2;
    }

    ABEntry getOrAddEntry(ABEntry aBEntry, ABEntry aBEntry2) {
        if ((aBEntry = this.getEntry(aBEntry)) == null) {
            if (aBEntry2 instanceof ABAddress) {
                ++this.addressCount;
            }
            aBEntry = aBEntry2;
            aBEntry.book = this;
            ((IDDictionary)this.contents).addElement(aBEntry);
        }
        return aBEntry;
    }

    public synchronized int getPersonCount() {
        return this.persons.size();
    }

    public synchronized ABPerson[] getPersons() {
        Object[] objectArray = new ABPerson[this.persons.size()];
        this.persons.toArray(objectArray);
        return objectArray;
    }

    public synchronized ABPage[] getTopPages() {
        Object[] objectArray = new ABPage[this.topPages.size()];
        this.topPages.toArray(objectArray);
        return objectArray;
    }

    void log(ABEntry aBEntry, String string, long[] lArray, String[] stringArray) {
        ABAddressReader.writeTo(this.logFile, string, aBEntry, lArray, stringArray);
    }

    public synchronized ABEntry removeEntry(ABEntry aBEntry) {
        ABEntry aBEntry2 = this.getEntry(aBEntry);
        this.log(aBEntry, "remove0", new long[0], new String[0]);
        if (aBEntry2 != null) {
            aBEntry2.remove();
        }
        return aBEntry2;
    }

    public synchronized ABAddress setAddress(ABAddress aBAddress, ABAddress aBAddress2, ABPerson aBPerson, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) {
        aBAddress = (ABAddress)this.getOrAddEntry(aBAddress, (ABEntry)new ABAddress());
        aBAddress.setData(string2, string, string3, string4, string5, string6, string7, string8, string9, string10, string11, string12, (ABAddress)this.getEntry(aBAddress2), (ABPerson)this.getEntry(aBPerson));
        return aBAddress;
    }

    public synchronized void setConnection(ABPage aBPage, ABEntry aBEntry, boolean bl) {
        aBPage = (ABPage)this.getEntry(aBPage);
        aBEntry = this.getEntry(aBEntry);
        aBPage.setEntry(aBEntry, bl);
    }

    public synchronized ABPage setPage(ABPage aBPage, String string, String string2) {
        aBPage = (ABPage)this.getOrAddEntry(aBPage, (ABEntry)new ABPage());
        aBPage.setData(string2, string, true);
        return aBPage;
    }

    public synchronized ABPerson setPerson(ABPerson aBPerson, String string, String string2, String string3, String string4) {
        aBPerson = (ABPerson)this.getOrAddEntry(aBPerson, (ABEntry)new ABPerson());
        aBPerson.setData(string4, string, string2, string3);
        return aBPerson;
    }
}

