/*
 * Decompiled with CFR 0.152.
 */
package rb.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import rb.util.StringUtil;
import sun.misc.Compare;
import sun.misc.Sort;

public class FileRB
extends File {
    static int BufferSize = 8192;
    public static final FilenameFilter FltFile = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return new File(file, string).isFile();
        }
    };
    public static final FilenameFilter FltDirectory = new FilenameFilter(){

        public boolean accept(File file, String string) {
            return new File(file, string).isDirectory();
        }
    };
    public static final Compare CmpCase = new Compare(){

        public int doCompare(Object object, Object object2) {
            return ((String)object).compareTo((String)object2);
        }
    };
    public static final Compare CmpNoCase = new Compare(){

        public int doCompare(Object object, Object object2) {
            return StringUtil.compareNoCase((String)object, (String)object2);
        }
    };

    public FileRB(File file) {
        this(file.getPath());
    }

    public FileRB(File file, String string) {
        super(file, string);
    }

    public FileRB(String string) {
        super(string);
    }

    public FileRB(String string, String string2) {
        super(string, string2);
    }

    public static void copy(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[BufferSize];
        while (fileInputStream.available() > 0) {
            int n = fileInputStream.read(byArray);
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
        if (file.length() != file2.length()) {
            throw new IOException("Differing sizes after file copy \"" + file.getName() + "\":" + file.length() + " -> \"" + file2.getName() + "\":" + file2.length());
        }
    }

    public void copyTo(File file) throws IOException {
        FileRB.copy(this, file);
    }

    public static File[] getFiles(File file, FilenameFilter filenameFilter, Compare compare) {
        Object[] objectArray;
        Object[] objectArray2 = objectArray = filenameFilter == null ? file.list() : file.list(filenameFilter);
        if (objectArray == null) {
            return new File[0];
        }
        if (compare != null && objectArray.length > 1) {
            Sort.quicksort((Object[])objectArray, (Compare)compare);
        }
        File[] fileArray = new File[objectArray.length];
        int n = 0;
        while (n < fileArray.length) {
            fileArray[n] = new FileRB(file, (String)objectArray[n]);
            ++n;
        }
        return fileArray;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return String.valueOf(string) + "[" + super.toString() + "]";
    }
}

