/*
 * Decompiled with CFR 0.152.
 */
package rb.util;

import java.util.NoSuchElementException;
import rb.util.LongEnumerationRB;
import rb.util.LongVectorEnumeratorRB;
import rb.util.PrimitiveVectorRB;

public class LongVectorRB
extends PrimitiveVectorRB {
    protected long[] elementData;

    public LongVectorRB() {
        this(10);
    }

    public LongVectorRB(int n) {
        super(n);
        this.elementData = new long[n];
    }

    public LongVectorRB(int n, int n2) {
        super(n, n2);
        this.elementData = new long[n];
    }

    public final synchronized void addElement(long l) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = l;
    }

    public void addElements(long[] lArray) {
        this.insertElements(lArray, this.elementCount, lArray.length);
    }

    public final int capacity() {
        return this.elementData.length;
    }

    public synchronized Object clone() {
        try {
            LongVectorRB longVectorRB = (LongVectorRB)super.clone();
            longVectorRB.elementData = new long[this.elementCount];
            System.arraycopy(this.elementData, 0, longVectorRB.elementData, 0, this.elementCount);
            return longVectorRB;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public final boolean contains(int n) {
        return this.indexOf(n, 0) >= 0;
    }

    public final synchronized void copyInto(long[] lArray) {
        int n = this.elementCount;
        while (n-- > 0) {
            lArray[n] = this.elementData[n];
        }
    }

    public final synchronized long elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        try {
            return this.elementData[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new ArrayIndexOutOfBoundsException(n + " < 0");
        }
    }

    public final synchronized LongEnumerationRB elements() {
        return new LongVectorEnumeratorRB(this);
    }

    public final synchronized void ensureCapacity(int n) {
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3;
            long[] lArray = this.elementData;
            int n4 = n3 = this.capacityIncrement > 0 ? n2 + this.capacityIncrement : n2 * 2;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = new long[n3];
            System.arraycopy(lArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    public final synchronized long firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public final int indexOf(long l) {
        return this.indexOf(l, 0);
    }

    public final synchronized int indexOf(long l, int n) {
        int n2 = n;
        while (n2 < this.elementCount) {
            if (l == this.elementData[n2]) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public final synchronized void insertElementAt(long l, int n) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + 1);
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        this.elementData[n] = l;
        ++this.elementCount;
    }

    public final synchronized void insertElements(long[] lArray, int n, int n2) {
        if (n >= this.elementCount + 1) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
        this.ensureCapacity(this.elementCount + n2);
        System.arraycopy(this.elementData, n, this.elementData, n + n2, this.elementCount - n);
        System.arraycopy(lArray, 0, this.elementData, n, n2);
        this.elementCount += n2;
    }

    public final synchronized long lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public final int lastIndexOf(long l) {
        return this.lastIndexOf(l, this.elementCount - 1);
    }

    public final synchronized int lastIndexOf(long l, int n) {
        int n2 = n;
        while (n2 >= 0) {
            if (l == this.elementData[n2]) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public final synchronized boolean removeElement(long l) {
        int n = this.indexOf(l);
        if (n >= 0) {
            this.removeElementAt(n);
            return true;
        }
        return false;
    }

    public final synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n2 = this.elementCount - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        --this.elementCount;
    }

    public final synchronized void setElementAt(long l, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
        this.elementData[n] = l;
    }

    public long[] toArray() {
        long[] lArray = new long[this.size()];
        this.copyInto(lArray);
        return lArray;
    }

    public final synchronized String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        LongEnumerationRB longEnumerationRB = this.elements();
        stringBuffer.append("LongVectorRB[");
        int n2 = 0;
        while (n2 <= n) {
            stringBuffer.append(longEnumerationRB.nextElement());
            if (n2 < n) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final synchronized void trimToSize() {
        int n = this.elementData.length;
        if (this.elementCount < n) {
            long[] lArray = this.elementData;
            this.elementData = new long[this.elementCount];
            System.arraycopy(lArray, 0, this.elementData, 0, this.elementCount);
        }
    }
}

