/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http;

import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.RequestFilter;
import org.w3c.www.protocol.http.ScopeNode;

class FilterEngine {
    ScopeNode root = new ScopeNode("_root_");

    private String[] urlParts(URL uRL) {
        Vector<Object> vector = new Vector<Object>(8);
        vector.addElement(uRL.getProtocol());
        if (uRL.getPort() == -1 || uRL.getPort() == 80) {
            vector.addElement(uRL.getHost());
        } else {
            vector.addElement(uRL.getHost() + ":" + uRL.getPort());
        }
        String string = uRL.getFile();
        if (string.length() == 0) {
            string = "/";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextElement());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    synchronized void setFilter(URL uRL, boolean bl, RequestFilter requestFilter) {
        String[] stringArray = this.urlParts(uRL);
        ScopeNode scopeNode = this.root;
        for (int i = 0; i < stringArray.length; ++i) {
            ScopeNode scopeNode2 = scopeNode.lookup(stringArray[i]);
            if (scopeNode2 == null) {
                scopeNode2 = scopeNode.create(stringArray[i]);
            }
            scopeNode = scopeNode2;
        }
        scopeNode.setFilter(bl, requestFilter);
    }

    synchronized void setFilter(RequestFilter requestFilter) {
        this.root.setFilter(true, requestFilter);
    }

    synchronized RequestFilter getGlobalFilter(Class clazz) {
        RequestFilter[] requestFilterArray = this.root.filters;
        for (int i = 0; i < requestFilterArray.length; ++i) {
            if (requestFilterArray[i] == null) continue;
            for (Class<?> clazz2 = requestFilterArray[i].getClass(); clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                if (clazz2 != clazz) continue;
                return requestFilterArray[i];
            }
        }
        return null;
    }

    synchronized void sync() {
        this.root.sync();
    }

    RequestFilter[] run(Request request) {
        String[] stringArray = this.urlParts(request.getURL());
        int n = 0;
        Vector vector = new Vector();
        for (ScopeNode scopeNode = this.root; scopeNode != null; scopeNode = scopeNode.lookup(stringArray[n++])) {
            scopeNode.resolve(vector);
            if (n >= stringArray.length) break;
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new RequestFilter[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    FilterEngine() {
    }
}

