/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.www.protocol.http.cache.push;

import java.net.URL;
import java.util.Enumeration;
import org.w3c.util.ArrayDictionary;
import org.w3c.www.protocol.http.HttpManager;
import org.w3c.www.protocol.http.Request;
import org.w3c.www.protocol.http.cache.CacheGeneration;
import org.w3c.www.protocol.http.cache.CachedResource;
import org.w3c.www.protocol.http.cache.push.PushCacheFilter;
import org.w3c.www.protocol.http.cache.push.PushCacheStore;
import org.w3c.www.protocol.http.cache.push.PushEntityCachedResource;
import org.w3c.www.protocol.http.cache.push.PushReply;

public class PushCacheManager {
    public static final String HEADER_FIELD = "tfc_from_push_stream";
    public static final String HEADER_VALUE = "yes";
    private static PushCacheManager _instance = null;
    private PushCacheFilter _filter = null;

    public static PushCacheManager instance() {
        if (_instance == null) {
            _instance = new PushCacheManager();
        }
        return _instance;
    }

    public boolean isPushResource(CachedResource cachedResource) {
        ArrayDictionary arrayDictionary;
        String string;
        return cachedResource != null && (string = (String)(arrayDictionary = cachedResource.getExtraHeaders()).get(HEADER_FIELD)) != null && string.equalsIgnoreCase(HEADER_VALUE);
    }

    public void storeReply(PushReply pushReply) {
        try {
            String string = pushReply.getUrl();
            Request request = HttpManager.getManager().createRequest();
            request.setMethod("GET");
            request.setURL(new URL(string));
            this.removeURL(string);
            PushEntityCachedResource pushEntityCachedResource = new PushEntityCachedResource(this._filter, request, pushReply);
            this.getStore().storeCachedResource(pushEntityCachedResource, pushEntityCachedResource.getContentLength());
            this._filter.sync();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void removeURL(String string) {
        try {
            this.deleteRes(this.getStore().getCachedResourceReference(string));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isPresent(String string) {
        try {
            CachedResource cachedResource = this.getStore().getCachedResourceReference(string);
            if (cachedResource == null) {
                return false;
            }
            return cachedResource.getFile() != null && cachedResource.getFile().exists();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    protected void deleteRes(CachedResource cachedResource) {
        if (cachedResource != null) {
            cachedResource.delete();
            this.getStore().getState().notifyResourceDeleted(cachedResource);
            this._filter.sync();
        }
    }

    public void cleanCache() {
        CacheGeneration cacheGeneration = this.getStore().getMRUGeneration();
        while (cacheGeneration != null) {
            Enumeration enumeration = cacheGeneration.getCachedResources();
            while (enumeration.hasMoreElements()) {
                this.deleteRes((CachedResource)enumeration.nextElement());
            }
            cacheGeneration = this.getStore().getNextGeneration(cacheGeneration);
        }
    }

    protected void registerFilter(PushCacheFilter pushCacheFilter) {
        this._filter = pushCacheFilter;
    }

    protected PushCacheManager() {
    }

    protected PushCacheStore getStore() {
        return this._filter.getPushCacheStore();
    }
}

