/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.jigadmin.editors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.w3c.jigadmin.PropertyManager;
import org.w3c.jigadmin.RemoteResourceWrapper;
import org.w3c.jigadmin.editors.AttributesHelper;
import org.w3c.jigadmin.editors.ServerHelperInterface;
import org.w3c.jigadmin.gui.Message;
import org.w3c.jigsaw.admin.RemoteAccessException;
import org.w3c.tools.sorter.Sorter;
import org.w3c.tools.widgets.Utilities;

public class RealmsServerHelper
extends JPanel
implements ServerHelperInterface {
    protected static final String ADD_USER_AC = "add_user";
    protected static final String DEL_USER_AC = "del_user";
    protected static final String DEL_REALM_AC = "del_realm";
    protected String name = null;
    protected String tooltip = null;
    protected RemoteResourceWrapper root = null;
    protected RemoteResourceWrapper realmrrw = null;
    protected RemoteResourceWrapper userrrw = null;
    protected Vector realms = null;
    protected Vector users = null;
    protected JComboBox combo = null;
    protected JPanel usersPanel = null;
    protected JPanel userPanel = null;
    protected JList usersList = null;
    protected JTextField userT = null;
    ActionListener al = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == RealmsServerHelper.this.combo) {
                String string = (String)RealmsServerHelper.this.combo.getSelectedItem();
                if (RealmsServerHelper.this.realms.contains(string)) {
                    RealmsServerHelper.this.selectRealm(string);
                } else if (string.length() > 0) {
                    RealmsServerHelper.this.addRealm(string);
                }
            } else if (actionEvent.getActionCommand().equals(RealmsServerHelper.ADD_USER_AC) || object == RealmsServerHelper.this.userT) {
                String string = RealmsServerHelper.this.userT.getText();
                if (string.length() > 0 && !RealmsServerHelper.this.users.contains(string)) {
                    RealmsServerHelper.this.addUser(string);
                }
            } else if (actionEvent.getActionCommand().equals(RealmsServerHelper.DEL_USER_AC)) {
                Thread thread = new Thread(){

                    public void run() {
                        RealmsServerHelper.this.deleteCurrentUser();
                    }
                };
                thread.start();
            } else if (actionEvent.getActionCommand().equals(RealmsServerHelper.DEL_REALM_AC)) {
                Thread thread = new Thread(){

                    public void run() {
                        RealmsServerHelper.this.deleteCurrentRealm();
                    }
                };
                thread.start();
            }
        }
    };
    ListSelectionListener lsl = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                int n = RealmsServerHelper.this.usersList.getSelectedIndex();
                RealmsServerHelper.this.selectUser((String)RealmsServerHelper.this.users.elementAt(n));
            }
        }
    };

    public void initialize(String string, RemoteResourceWrapper remoteResourceWrapper, Properties properties) {
        this.root = remoteResourceWrapper;
        this.name = string;
        this.tooltip = (String)properties.get("tooltip");
        this.build();
    }

    protected void build() {
        this.removeAll();
        String[] stringArray = null;
        try {
            stringArray = this.root.getResource().enumerateResourceIdentifiers();
        }
        catch (RemoteAccessException remoteAccessException) {
            RemoteAccessException remoteAccessException2;
            while (this.root.getServerBrowser().shouldRetry(remoteAccessException2)) {
                try {
                    stringArray = this.root.getResource().enumerateResourceIdentifiers();
                    break;
                }
                catch (RemoteAccessException remoteAccessException3) {
                    remoteAccessException2 = remoteAccessException3;
                }
            }
        }
        if (stringArray == null) {
            return;
        }
        Sorter.sortStringArray((String[])stringArray, (boolean)true);
        this.realms = new Vector(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.realms.addElement(stringArray[i]);
        }
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.combo = new JComboBox(this.realms);
        this.combo.setEditable(true);
        this.combo.addActionListener(this.al);
        JLabel jLabel = new JLabel("Enter the realm name or");
        JLabel jLabel2 = new JLabel("select one from the list:");
        jLabel.setAlignmentX(0.5f);
        jLabel2.setAlignmentX(0.5f);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jLabel);
        jPanel.add(jLabel2);
        jPanel.add(this.combo);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Realms");
        titledBorder.setTitleFont(Utilities.mediumBoldFont);
        jPanel.setBorder(titledBorder);
        this.usersPanel = new JPanel(new BorderLayout(4, 4));
        titledBorder = BorderFactory.createTitledBorder("Realm");
        titledBorder.setTitleFont(Utilities.mediumBoldFont);
        this.usersPanel.setBorder(titledBorder);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        jPanel2.add((Component)this.usersPanel, "Center");
        this.userPanel = new JPanel(new BorderLayout());
        this.initUserPanel();
        this.add((Component)jPanel2, "West");
        this.add((Component)this.userPanel, "Center");
    }

    protected void initUserPanel() {
        this.userPanel.removeAll();
        this.userPanel.invalidate();
        TitledBorder titledBorder = BorderFactory.createTitledBorder("User");
        titledBorder.setTitleFont(Utilities.mediumBoldFont);
        this.userPanel.setBorder(titledBorder);
        this.userPanel.validate();
    }

    protected void selectRealm(String string) {
        Object object;
        this.initUserPanel();
        this.usersPanel.removeAll();
        this.users = null;
        this.realmrrw = null;
        try {
            this.realmrrw = this.root.getChildResource(string);
        }
        catch (RemoteAccessException remoteAccessException) {
            while (this.root.getServerBrowser().shouldRetry((RemoteAccessException)((Object)object))) {
                try {
                    this.realmrrw = this.root.getChildResource(string);
                    break;
                }
                catch (RemoteAccessException object2) {
                    object = object2;
                }
            }
        }
        if (this.realmrrw == null) {
            return;
        }
        try {
            object = this.realmrrw.getResource().enumerateResourceIdentifiers();
            Sorter.sortStringArray((String[])object, (boolean)true);
            this.users = new Vector(((String[])object).length);
            for (int i = 0; i < ((String[])object).length; ++i) {
                this.users.addElement(object[i]);
            }
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
        if (this.users == null) {
            return;
        }
        this.usersPanel.invalidate();
        if (this.usersList != null) {
            this.usersList.removeListSelectionListener(this.lsl);
        }
        this.usersList = new JList(this.users);
        this.usersList.addListSelectionListener(this.lsl);
        this.usersList.setSelectionMode(0);
        this.usersList.setBorder(BorderFactory.createLoweredBevelBorder());
        object = new JButton("Add user");
        ((AbstractButton)object).setMargin(Utilities.insets0);
        ((AbstractButton)object).setActionCommand(ADD_USER_AC);
        ((AbstractButton)object).addActionListener(this.al);
        JButton jButton = new JButton("Delete " + string);
        jButton.setMargin(Utilities.insets0);
        jButton.setActionCommand(DEL_REALM_AC);
        jButton.addActionListener(this.al);
        this.userT = new JTextField(8);
        this.userT.addActionListener(this.al);
        JPanel jPanel = new JPanel(new BorderLayout(1, 4));
        jPanel.add((Component)this.userT, "West");
        jPanel.add((Component)object, "Center");
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.add(jPanel);
        jPanel2.add(jButton);
        TitledBorder titledBorder = BorderFactory.createTitledBorder("Realm: " + string);
        titledBorder.setTitleFont(Utilities.mediumBoldFont);
        this.usersPanel.setBorder(titledBorder);
        this.usersPanel.add((Component)new JScrollPane(this.usersList), "Center");
        this.usersPanel.add((Component)jPanel2, "South");
        this.usersPanel.validate();
    }

    protected void selectUser(String string) {
        try {
            if (this.realmrrw == null) {
                return;
            }
            this.root.getServerBrowser().setCursor(3);
            this.userrrw = this.realmrrw.getChildResource(string);
            this.userPanel.removeAll();
            this.userPanel.invalidate();
            TitledBorder titledBorder = BorderFactory.createTitledBorder("User: " + string);
            titledBorder.setTitleFont(Utilities.mediumBoldFont);
            this.userPanel.setBorder(titledBorder);
            AttributesHelper attributesHelper = new AttributesHelper();
            PropertyManager propertyManager = PropertyManager.getPropertyManager();
            Properties properties = propertyManager.getEditorProperties(this.userrrw);
            attributesHelper.initialize(this.userrrw, properties);
            JButton jButton = new JButton("Delete user " + string);
            jButton.setMargin(Utilities.insets0);
            jButton.setActionCommand(DEL_USER_AC);
            jButton.addActionListener(this.al);
            this.userPanel.add(attributesHelper.getComponent(), "Center");
            this.userPanel.add((Component)jButton, "South");
            this.userPanel.validate();
            this.root.getServerBrowser().setCursor(0);
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    protected void addUser(String string) {
        try {
            if (this.realmrrw == null) {
                return;
            }
            this.realmrrw.getResource().registerResource(string, "org.w3c.jigsaw.auth.AuthUser");
            this.selectRealm((String)this.combo.getSelectedItem());
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    protected void deleteCurrentUser() {
        if (this.userrrw == null) {
            return;
        }
        try {
            this.userrrw.getResource().delete();
            this.selectRealm((String)this.combo.getSelectedItem());
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    protected void addRealm(String string) {
        try {
            this.root.getResource().registerResource(string, "org.w3c.jigsaw.auth.AuthRealm");
            this.combo.invalidate();
            this.combo.addItem(string);
            this.combo.validate();
            this.selectRealm(string);
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    protected void deleteCurrentRealm() {
        if (this.realmrrw == null) {
            return;
        }
        try {
            this.realmrrw.getResource().delete();
            this.invalidate();
            this.build();
            this.validate();
        }
        catch (RemoteAccessException remoteAccessException) {
            Message.showErrorMessage((Component)this, remoteAccessException);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return this.tooltip;
    }

    public Component getComponent() {
        return this;
    }
}

