/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.awt;

import de.zwanzigeins.awt.SeparatorPanelProperties;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.SystemColor;

public class SeparatorPanel
extends Panel {
    static final long serialVersionUID = 134941921436505990L;
    private int intWidth = 0;
    private int intHeigth = 0;
    private int margine = 0;
    private int prefferedWidth = 0;
    private int prefferedHeigth = 0;
    private int intDummy = 0;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int orientation = 0;

    public int getMargine() {
        return this.margine;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public int getPrefferedHeigth() {
        return this.prefferedHeigth;
    }

    public int getPrefferedWidth() {
        return this.prefferedWidth;
    }

    public SeparatorPanelProperties getProperties() {
        SeparatorPanelProperties sepProp = new SeparatorPanelProperties();
        sepProp.intOrientation = this.orientation;
        sepProp.intMargine = this.margine;
        sepProp.intPrefferedHeigth = this.prefferedHeigth;
        sepProp.intPrefferedWidth = this.prefferedWidth;
        return sepProp;
    }

    public void paint(Graphics g) {
        if (g == null) {
            super.paint(g);
            return;
        }
        this.intWidth = super.getSize().width;
        this.intHeigth = super.getSize().height;
        if (this.intHeigth > 0 && this.intWidth > 0) {
            int lineY;
            int lineX;
            int lineHeight = 0;
            int shiftX = 0;
            int shiftY = 0;
            if (this.orientation == 1) {
                lineHeight = this.intHeigth - this.margine * 2;
                lineX = this.intWidth / 2;
                lineY = this.margine;
                shiftX = 1;
            } else {
                lineHeight = this.intWidth - this.margine * 2;
                lineX = this.margine;
                lineY = this.intHeigth / 2;
                shiftY = 1;
            }
            if (lineHeight > 0) {
                g.setColor(SystemColor.activeCaptionBorder);
                g.draw3DRect(lineX, lineY, shiftY * lineHeight + shiftX * 2, shiftX * lineHeight + shiftY * 2, false);
                return;
            }
        }
        super.paint(g);
    }

    public Dimension preferredSize() {
        Dimension d = new Dimension();
        d.width = this.prefferedWidth == 0 ? super.preferredSize().width : this.prefferedWidth;
        d.height = this.prefferedHeigth == 0 ? super.preferredSize().height : this.prefferedHeigth;
        return d;
    }

    public void setMargine(int marg) {
        this.margine = marg;
    }

    public void setOrientation(int ornt) {
        this.orientation = ornt;
    }

    public void setPreferredHeigth(int pH) {
        this.prefferedHeigth = pH;
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
    }

    public void setPreferredWidth(int pW) {
        this.prefferedWidth = pW;
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
    }

    public void setProperties(SeparatorPanelProperties sepProp) {
        this.orientation = sepProp.intOrientation;
        this.margine = sepProp.intMargine;
        this.prefferedHeigth = sepProp.intPrefferedHeigth;
        this.prefferedWidth = sepProp.intPrefferedWidth;
    }

    public void setSize(int width, int heigth) {
        this.intWidth = width;
        this.intHeigth = heigth;
        super.setSize(this.intWidth, this.intHeigth);
    }
}

