/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.email;

import de.zwanzigeins.email.EMail;
import de.zwanzigeins.email.MailSendException;
import de.zwanzigeins.util.HelperExtract;
import de.zwanzigeins.util.HelperIO;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Hashtable;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.MXRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.dns;

public class MailSend {
    private String strDNS = null;
    private OutputStream osSok = null;
    private PrintWriter pwOut = null;
    private BufferedReader brIn = null;
    private String strMXHostUsed = null;
    private String strLastSent = null;
    private String strLastRecv = null;
    private String strSM_Host = null;
    private String strSM_Auth = null;
    private String strSM_User = null;
    private String strSM_Pass = null;
    public static final String AUTH_SMTP_AFTER_POP3 = "AUTH_SMTP_AFTER_POP3";
    public static final String AUTH_PLAIN = "AUTH_PLAIN";
    public static final String AUTH_LOGIN = "AUTH_LOGIN";
    public static final String AUTH_CRAM_MD5 = "AUTH_CRAM_MD5";
    public static final String AUTH_NONE = "AUTH_NONE";

    public MailSend(String strDNS) {
        this.strDNS = strDNS;
    }

    private Socket getAuthConnection() {
        if (this.strSM_Auth.equals(AUTH_SMTP_AFTER_POP3)) {
            Socket sok = null;
            try {
                try {
                    String strBuffer = "";
                    sok = new Socket(this.strSM_Host, 110);
                    sok.setSoTimeout(5000);
                    PrintWriter pw = new PrintWriter(sok.getOutputStream(), true);
                    BufferedReader br = new BufferedReader(new InputStreamReader(sok.getInputStream()));
                    strBuffer = br.readLine();
                    if (!strBuffer.startsWith("+")) {
                        throw new MailSendException("AUTH_SMTP_AFTER_POP3 Server returned error on logon");
                    }
                    pw.println("User " + this.strSM_User);
                    strBuffer = br.readLine();
                    if (!strBuffer.startsWith("+")) {
                        throw new MailSendException("AUTH_SMTP_AFTER_POP3 Server returned error on USER [" + strBuffer + "]");
                    }
                    pw.println("Pass " + this.strSM_Pass);
                    strBuffer = br.readLine();
                    if (!strBuffer.startsWith("+")) {
                        throw new MailSendException("AUTH_SMTP_AFTER_POP3 Server returned error on PASS [" + strBuffer + "]");
                    }
                }
                catch (IOException e) {
                    throw new MailSendException("AUTH_SMTP_AFTER_POP3 Cannot connect to POP3 server " + this.strSM_Host + " Reason: " + e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var2_8 = null;
                HelperIO.close(sok);
                throw throwable;
            }
            Object var2_9 = null;
            HelperIO.close(sok);
            try {
                return new Socket(this.strSM_Host, 25);
            }
            catch (IOException e) {
                throw new MailSendException("AUTH_SMTP_AFTER_POP3 Cannot connect to SMTP server " + this.strSM_Host + " Reason: " + e.toString());
            }
        }
        if (this.strSM_Auth.equals(AUTH_NONE)) {
            try {
                return new Socket(this.strSM_Host, 25);
            }
            catch (IOException e) {
                throw new MailSendException("AUTH_NONE Cannot connect to SMTP server " + this.strSM_Host + " Reason: " + e.toString());
            }
        }
        throw new MailSendException("Unsupported smarthost auth " + this.strSM_Auth);
    }

    public String getLastReceived() {
        return this.strLastRecv;
    }

    public String getLastSent() {
        return this.strLastSent;
    }

    private Socket getMXConnection(String strDomain) {
        String[] strMX_Hosts = this.getMXHosts(strDomain);
        if (strMX_Hosts == null) {
            throw new MailSendException("Cannot find an MX server for " + strDomain);
        }
        InetAddress inaLocal = null;
        int i = 0;
        while (i < strMX_Hosts.length) {
            try {
                Socket sokMX = new Socket(strMX_Hosts[i], 25, inaLocal, 0);
                sokMX.setSoTimeout(30000);
                return sokMX;
            }
            catch (IOException iOException) {
                ++i;
            }
        }
        throw new MailSendException("Cannot connect to any MX server for domain " + strDomain);
    }

    private String[] getMXHosts(String strDomain) {
        ((Hashtable)System.getProperties()).put("dns.server", this.strDNS);
        Record[] records = null;
        int i = 0;
        while (i < 5) {
            records = dns.getRecords((String)strDomain, (short)15);
            if (records == null) {
                records = dns.getRecords((String)strDomain, (short)1);
            }
            if (records != null) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
            ++i;
        }
        if (records == null) {
            return null;
        }
        if (records[0] instanceof MXRecord && records.length > 0) {
            boolean blnNotSorted;
            do {
                blnNotSorted = false;
                int j = 0;
                while (j < records.length - 1) {
                    MXRecord mxrecord = (MXRecord)records[j];
                    MXRecord mxrecord2 = (MXRecord)records[j + 1];
                    if (mxrecord.getPriority() > mxrecord2.getPriority()) {
                        records[j] = mxrecord2;
                        records[j + 1] = mxrecord;
                        blnNotSorted = true;
                    }
                    ++j;
                }
            } while (blnNotSorted);
        }
        String[] strMX_Hosts = new String[records.length];
        int i2 = 0;
        while (i2 < records.length) {
            String strTmp = records[i2] instanceof MXRecord ? ((MXRecord)records[i2]).getTarget().toString() : ((ARecord)records[i2]).getName().toString();
            if (strTmp.endsWith(".")) {
                strTmp = strTmp.substring(0, strTmp.length() - 1);
            }
            strMX_Hosts[i2] = strTmp;
            ++i2;
        }
        return strMX_Hosts;
    }

    public static void main(String[] args) throws IOException {
        EMail em = new EMail();
        em.setMailFrom("hohmann@harddiskcafe.de");
        em.addRecipient("hohmann@harddiskcafe.de");
        em.addRecipient("bernd.hohmann@zwanzigeins.de");
        em.setSubject("Testmail mit Umlauten \u00e4\u00f6\u00fc \u00c4\u00d6\u00dc \u00df");
        em.addContent("Das ist eine Testmail \u00e4\u00f6\u00fc \u00c4\u00d6\u00dc \u00df");
        MailSend ms = new MailSend("80.242.134.170");
        ms.setSmartHost("daisy.harddiskcafe.de", AUTH_SMTP_AFTER_POP3, "hohmann@harddiskcafe.de", "bernd");
        ms.send(em);
        System.out.println("Sent");
    }

    public void send(EMail em) throws IOException {
        String[] strRecipients = em.getSmtpRecipients();
        int i = 0;
        while (i < strRecipients.length) {
            Object var6_6;
            String strDomain = HelperExtract.splitUserName_getDomain(strRecipients[i]);
            Socket sok = null;
            sok = this.strSM_Host == null ? this.getMXConnection(strDomain) : this.getAuthConnection();
            try {
                this.send0(sok, em.getSmtpSender(), strRecipients[i], em.getMailAsByteArray());
            }
            catch (Throwable throwable) {
                var6_6 = null;
                HelperIO.close(sok);
                HelperIO.close(this.brIn);
                HelperIO.close(this.pwOut);
                throw throwable;
            }
            var6_6 = null;
            HelperIO.close(sok);
            HelperIO.close(this.brIn);
            HelperIO.close(this.pwOut);
            ++i;
        }
    }

    private boolean send0(Socket sok, String strSender, String strRecipient, byte[] bytMsg) throws IOException {
        this.osSok = sok.getOutputStream();
        this.pwOut = new PrintWriter(this.osSok, true);
        this.brIn = new BufferedReader(new InputStreamReader(sok.getInputStream()));
        if (!this.waitFor("220")) {
            return false;
        }
        if (!this.sendLine("HELO WORLD")) {
            return false;
        }
        if (!this.sendLine("MAIL FROM: <" + strSender + ">")) {
            return false;
        }
        if (!this.sendLine("RCPT TO: <" + strRecipient + ">")) {
            return false;
        }
        if (!this.sendLine("DATA")) {
            return false;
        }
        if (!this.sendLine(bytMsg)) {
            return false;
        }
        this.sendLine("QUIT");
        return true;
    }

    private boolean sendLine(String string) {
        try {
            String strCmd;
            this.strLastSent = string;
            this.strLastRecv = "";
            this.pwOut.println(string);
            this.pwOut.flush();
            do {
                this.strLastRecv = strCmd = this.brIn.readLine();
            } while (strCmd.substring(3, 4).equals("-"));
            return strCmd.startsWith("2") || strCmd.startsWith("3");
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean sendLine(byte[] b) {
        String strCmd = null;
        try {
            this.strLastSent = "<message>";
            this.strLastRecv = "";
            this.osSok.write(b);
            this.osSok.flush();
            do {
                this.strLastRecv = strCmd = this.brIn.readLine();
            } while (strCmd.substring(3, 4).equals("-"));
            return strCmd.startsWith("2") || strCmd.startsWith("3");
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void setSmartHost(String strHost, String strAuth, String strUser, String strPass) {
        this.strSM_Host = strHost;
        this.strSM_Auth = strAuth;
        this.strSM_User = strUser;
        this.strSM_Pass = strPass;
    }

    private boolean waitFor(String strCmd) {
        try {
            String strResult;
            this.strLastSent = "";
            do {
                this.strLastRecv = strResult = this.brIn.readLine();
            } while (strResult.substring(3, 4).equals("-"));
            return strResult.startsWith(strCmd);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

