/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.gfx;

import de.zwanzigeins.gfx.ImagePanelWithText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.io.File;
import java.io.InputStream;
import java.net.URL;

public class SplashPanelGFX
implements Runnable {
    public static final int CENTER = 0;
    public static final int NORTH_WEST = 1;
    public static final int NORTH = 2;
    public static final int NORTH_EAST = 3;
    public static final int EAST = 4;
    public static final int SOUTH_EAST = 5;
    public static final int SOUTH = 6;
    public static final int SOUTH_WEST = 7;
    public static final int WEST = 8;
    private boolean blnIsRunning;
    private long lngRes = 0L;
    private Frame frm = null;
    private boolean blnOwnFrame = false;
    private Window win = null;
    private Thread thrd = null;
    private Object objLock = null;
    private ImagePanelWithText ip = null;
    private long lngDelay = 0L;

    public SplashPanelGFX() {
        this.init();
    }

    public SplashPanelGFX(Frame f) {
        this.frm = f;
        this.init();
    }

    public void dispose() {
        if (this.win != null) {
            ((Component)this.win).setVisible(false);
            this.win.dispose();
            this.win = null;
        }
        if (this.blnOwnFrame && this.frm != null) {
            ((Component)this.frm).setVisible(false);
            this.frm.dispose();
            this.frm = null;
        }
        if (this.thrd != null) {
            this.blnIsRunning = false;
            Object object = this.objLock;
            synchronized (object) {
                this.objLock.notify();
            }
            this.thrd = null;
        }
    }

    private void init() {
        if (this.frm == null) {
            this.frm = new Frame();
            this.blnOwnFrame = true;
        }
        this.win = new Window(this.frm);
        this.ip = new ImagePanelWithText();
        this.ip.setDrawFrame(true);
        this.objLock = new Object();
        this.thrd = new Thread((Runnable)this, "SplashPanelGFX");
        this.lngDelay = 0L;
        this.lngRes = 500L;
    }

    public void run() {
        long lngCnt = 0L;
        this.blnIsRunning = true;
        while (this.blnIsRunning && (this.lngDelay == 0L || lngCnt < this.lngDelay)) {
            if (this.win != null && this.win.isVisible()) {
                this.win.toFront();
            }
            try {
                Object object = this.objLock;
                synchronized (object) {
                    this.objLock.wait(this.lngRes);
                }
            }
            catch (InterruptedException interruptedException) {}
            lngCnt += this.lngRes;
        }
        this.dispose();
    }

    public void setDelay(long l) {
        this.lngDelay = l;
    }

    public void setInfoMessage(String strMsg, int intOrientation) {
        this.ip.setInfoMessage(strMsg, intOrientation);
    }

    public void setInfoMessage(String strMsg, int intOrientation, Font fnt) {
        this.ip.setInfoMessage(strMsg, intOrientation, fnt);
    }

    public void setInfoMessage(String strMsg, int intOrientation, Font fnt, Color col) {
        this.ip.setInfoMessage(strMsg, intOrientation, fnt, col);
    }

    public void setPicture(File fl) {
        this.ip.setPicture(fl);
    }

    public void setPicture(InputStream in) {
        this.ip.setPicture(in);
    }

    public void setPicture(String strFile) {
        this.ip.setPicture(strFile);
    }

    public void setPicture(URL url) {
        this.ip.setPicture(url);
    }

    public void start() {
        ((Component)this.win).setVisible(true);
        Dimension d = this.ip.getPictureSize();
        if (d.width == 0 && d.height == 0) {
            this.dispose();
            return;
        }
        if (!this.blnOwnFrame) {
            int scrnW = this.frm.getSize().width;
            int scrnH = this.frm.getSize().height;
            ((Component)this.win).setLocation(scrnW / 2 - d.width / 2 + this.frm.getLocationOnScreen().x, scrnH / 2 - d.height / 2 + this.frm.getLocationOnScreen().y);
        } else {
            int scrnW = Toolkit.getDefaultToolkit().getScreenSize().width;
            int scrnH = Toolkit.getDefaultToolkit().getScreenSize().height;
            ((Component)this.win).setLocation(scrnW / 2 - d.width / 2, scrnH / 2 - d.height / 2);
        }
        this.win.add(this.ip);
        this.ip.setSize(d);
        ((Component)this.win).setSize(d);
        this.win.toFront();
        this.thrd.start();
    }
}

