/*
 * Decompiled with CFR 0.152.
 */
package de.zwanzigeins.util;

import java.awt.FontMetrics;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;

public final class ByteString
implements Serializable,
Cloneable {
    private static final int CASEDIFF = 32;
    private static final int LOWER_BIT = 32;
    private static final int UPPER_BIT = -33;
    private static final byte[] NULL = "null".getBytes();
    private static final byte[] TRUE = "true".getBytes();
    private static final byte[] FALSE = "false".getBytes();
    private static final byte[] DIGITS = "0123456789ABCDEF".getBytes();
    public static final int[] CHAR_VALUES = new int[23];
    private static final byte[] UNITS;
    private static final byte[] TENTH_UNITS;
    private static final byte[] INTEGER_MIN;
    private static final byte[] LONG_MIN;
    private static final byte MINUS = 45;
    private byte[] bytValue = null;
    private int intLength = 0;
    private int intNextLineStart = 0;
    private byte[] bytLineBreak = new byte[]{13, 10};

    static {
        int i = 23;
        while (i-- > 0) {
            int bt = i + 48;
            bt = bt > 64 ? (bt -= 65) : (bt > 57 ? -1 : i);
            ByteString.CHAR_VALUES[i] = bt;
        }
        UNITS = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".getBytes();
        TENTH_UNITS = "0000000000111111111122222222223333333333444444444455555555556666666666777777777788888888889999999999".getBytes();
        INTEGER_MIN = "-2147483648".getBytes();
        LONG_MIN = "-9223372036854775808".getBytes();
    }

    public ByteString() {
        this(16);
    }

    public ByteString(int length) {
        this.bytValue = new byte[length];
    }

    public ByteString(ByteString str) {
        this(str.bytValue, 0, str.intLength);
    }

    public ByteString(ByteString str, int off, int len) {
        this(str.bytValue, off, len);
    }

    public ByteString(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    public ByteString(byte[] chars) {
        this(chars, 0, chars.length);
    }

    public ByteString(byte[] chars, int off, int len) {
        this(chars.length + 16);
        this.append(chars, off, len);
    }

    public ByteString(char[] chars) {
        this(chars, 0, chars.length);
    }

    public ByteString(char[] chars, int off, int len) {
        this(chars.length + 16);
        this.append(chars, off, len);
    }

    public final ByteString append(byte b) {
        int newcount = this.intLength + 1;
        if (newcount > this.bytValue.length) {
            this.ensureCapacity(newcount);
        }
        this.bytValue[this.intLength++] = b;
        return this;
    }

    public final ByteString append(char c) {
        int newcount = this.intLength + 1;
        if (newcount > this.bytValue.length) {
            this.ensureCapacity(newcount);
        }
        this.bytValue[this.intLength++] = (byte)c;
        return this;
    }

    public final ByteString append(double d) {
        return this.append(String.valueOf(d));
    }

    public final ByteString append(float f) {
        return this.append(String.valueOf(f));
    }

    public final ByteString append(int n) {
        int i;
        if (n == Integer.MIN_VALUE) {
            return this.append(INTEGER_MIN, 0, INTEGER_MIN.length);
        }
        byte[] buf = new byte[12];
        boolean negative = n < 0;
        int charPos = 12;
        if (negative) {
            i = -n;
            this.append((byte)45);
        }
        if (i < 10) {
            this.append((byte)(i + 48));
            return this;
        }
        byte[] units = UNITS;
        byte[] tenthUnits = TENTH_UNITS;
        do {
            int digit = i % 100;
            buf[--charPos] = units[digit];
            buf[--charPos] = tenthUnits[digit];
        } while ((i /= 100) != 0);
        if (buf[charPos] == 48) {
            ++charPos;
        }
        this.append(buf, charPos, 12 - charPos);
        return this;
    }

    public final ByteString append(long l) {
        long l2;
        if (l == Long.MIN_VALUE) {
            return this.append(LONG_MIN, 0, LONG_MIN.length);
        }
        byte[] buf = new byte[20];
        boolean negative = l < 0L;
        int charPos = 20;
        if (negative) {
            l2 = -l;
            this.append((byte)45);
        }
        if (l2 < 10L) {
            return this.append((byte)(l2 + 48L));
        }
        byte[] units = UNITS;
        byte[] tenth = TENTH_UNITS;
        do {
            int digit = (int)(l2 % 100L);
            buf[--charPos] = units[digit];
            buf[--charPos] = tenth[digit];
        } while ((l2 /= 100L) != 0L);
        if (buf[charPos] == 48) {
            ++charPos;
        }
        return this.append(buf, charPos, 20 - charPos);
    }

    public final ByteString append(ByteString str) {
        if (str == null) {
            return this.append(NULL, 0, 4);
        }
        int len = str.intLength;
        int newcount = this.intLength + len;
        if (newcount > this.bytValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(str.bytValue, 0, this.bytValue, this.intLength, len);
        this.intLength = newcount;
        return this;
    }

    public final ByteString append(Object obj) {
        return this.append(String.valueOf(obj));
    }

    public final ByteString append(String str) {
        if (str == null) {
            return this.append(NULL, 0, 4);
        }
        int len = str.length();
        int newcount = this.intLength + len;
        if (newcount > this.bytValue.length) {
            this.ensureCapacity(newcount);
        }
        byte[] b = ByteString.getASCII(str);
        System.arraycopy(b, 0, this.bytValue, this.intLength, len);
        this.intLength = newcount;
        return this;
    }

    public final ByteString append(String str, String strEncoding) throws UnsupportedEncodingException {
        if (str == null) {
            return this.append(NULL, 0, 4);
        }
        return this.append(str.getBytes(strEncoding));
    }

    public final ByteString append(boolean b) {
        if (b) {
            return this.append(TRUE, 0, 4);
        }
        return this.append(FALSE, 0, 5);
    }

    public final ByteString append(byte[] b) {
        return this.append(b, 0, b.length);
    }

    public final ByteString append(byte[] b, int offset, int len) {
        int newcount = this.intLength + len;
        if (newcount > this.bytValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(b, offset, this.bytValue, this.intLength, len);
        this.intLength = newcount;
        return this;
    }

    public final ByteString append(char[] chars) {
        return this.append(chars, 0, chars.length);
    }

    public final ByteString append(char[] chars, int offset, int len) {
        int newcount = this.intLength + len;
        if (newcount > this.bytValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(ByteString.getASCII(chars), offset, this.bytValue, this.intLength, len);
        this.intLength = newcount;
        return this;
    }

    public ByteString appendLineBreak() {
        this.append(this.bytLineBreak, 0, this.bytLineBreak.length);
        return this;
    }

    public final void clear() {
        this.intLength = 0;
    }

    public final Object clone() {
        try {
            ByteString sbe = (ByteString)super.clone();
            sbe.bytValue = (byte[])this.bytValue.clone();
            return sbe;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("clone failed on StringBufferExtended");
        }
    }

    public final int compareTo(ByteString comp) {
        return this.compareTo(comp.bytValue, 0, comp.intLength, false);
    }

    public final int compareTo(byte[] chars, int off, int len, boolean ignoreCase) {
        if (off < 0 || len < 0 || len + off > chars.length) {
            throw new IllegalArgumentException();
        }
        int shorter = Math.min(this.intLength, len);
        byte[] source = this.bytValue;
        int sourceIndex = 0;
        int argIndex = off;
        while (shorter-- != 0) {
            int upper;
            int argChar;
            int sourceChar;
            if ((sourceChar = source[sourceIndex++] & 0xFF) == (argChar = chars[argIndex++] & 0xFF) || ignoreCase && (upper = sourceChar & 0xFFFFFFDF) > 64 && upper < 91 && upper == (argChar & 0xFFFFFFDF)) continue;
            return sourceChar - argChar;
        }
        return this.intLength - len;
    }

    public final int compareToIgnoreCase(ByteString comp) {
        return this.compareTo(comp.bytValue, 0, comp.intLength, true);
    }

    public final ByteString convertToLowerCase() {
        int len = this.intLength;
        byte[] val = this.bytValue;
        int i = 0;
        while (i < len) {
            int ch = val[i] & 0xFF;
            if (ch > 64 && ch < 91) {
                int n = i;
                val[n] = (byte)(val[n] | 0x20);
            }
            ++i;
        }
        return this;
    }

    public final ByteString convertToUpperCase() {
        int len = this.intLength;
        byte[] val = this.bytValue;
        int i = 0;
        while (i < len) {
            int ch = val[i] & 0xFF;
            if (ch > 96 && ch < 123) {
                int n = i;
                val[n] = (byte)(val[n] & 0x20);
            }
            ++i;
        }
        return this;
    }

    public final ByteString decLength() {
        if (--this.intLength < 0) {
            this.intLength = 0;
        }
        return this;
    }

    public final ByteString delete(int off) {
        return this.delete(off, Integer.MAX_VALUE);
    }

    public final ByteString delete(int off, int len) {
        if (off < 0 || off >= this.intLength) {
            throw new StringIndexOutOfBoundsException("offset out of bounds: " + off);
        }
        if (len < 0) {
            throw new StringIndexOutOfBoundsException("len must be >= 0: " + len);
        }
        if (len == 0) {
            return this;
        }
        int overflowCheck = off + len;
        if (overflowCheck >= this.intLength || overflowCheck < 0) {
            this.setLength(off);
            return this;
        }
        System.arraycopy(this.bytValue, off + len, this.bytValue, off, this.intLength - (off + len));
        this.intLength -= len;
        return this;
    }

    private int digit(byte b) {
        int bt = b;
        if (bt > 97) {
            bt -= 32;
        }
        if ((bt -= 48) > 23 || bt < 0) {
            throw new NumberFormatException("b=" + b);
        }
        bt = CHAR_VALUES[bt];
        if (b < 0) {
            throw new NumberFormatException("b=" + b);
        }
        return bt;
    }

    public void dispose() {
        this.bytValue = null;
        this.intLength = 0;
        this.intNextLineStart = 0;
    }

    public final boolean endsWith(ByteString str) {
        int len = str.intLength;
        if (this.intLength < len) {
            return false;
        }
        return this.isMatchingRegion(str.bytValue, 0, len, this.intLength - len, false);
    }

    public final boolean endsWith(String str) {
        int len = str.length();
        if (this.intLength < len) {
            return false;
        }
        return this.isMatchingRegion(ByteString.getASCII(str), 0, len, this.intLength - len, false);
    }

    public final void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.bytValue.length) {
            int newCapacity = (this.bytValue.length + 1) * 2;
            if (minimumCapacity > newCapacity) {
                newCapacity = minimumCapacity;
            }
            byte[] newValue = new byte[newCapacity];
            System.arraycopy(this.bytValue, 0, newValue, 0, this.intLength);
            this.bytValue = newValue;
        }
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null && o.getClass() == this.getClass()) {
            ByteString anotherString = (ByteString)o;
            int n = this.intLength;
            if (n == anotherString.intLength) {
                int i = 0;
                int j = n - 1;
                n = (n + 1) / 2;
                byte[] v1 = this.bytValue;
                byte[] v2 = anotherString.bytValue;
                while (n-- > 0) {
                    if (v1[i] == v2[i++] && v1[j] == v2[j--]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public final ByteString erase(int start, int end) {
        return this.overwrite(' ', start, end);
    }

    public static final byte[] getASCII(String s) {
        char[] source = s.toCharArray();
        return ByteString.getASCII(source, 0, source.length);
    }

    public static final byte[] getASCII(char[] c) {
        return ByteString.getASCII(c, 0, c.length);
    }

    public static final byte[] getASCII(char[] c, int off, int len) {
        byte[] result = new byte[len];
        int i = len;
        while (i-- > 0) {
            result[i] = (byte)c[i + off];
        }
        return result;
    }

    public final byte getByteAt(int index) {
        if (index >= this.intLength) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return this.bytValue[index];
    }

    public final void getBytes(int begin, int end, byte[] dst, int start) {
        if (begin < end) {
            System.arraycopy(this.bytValue, begin, dst, start, end - begin);
        }
    }

    public final int getCapacity() {
        return this.bytValue.length;
    }

    public static final char[] getCharArray(byte[] b, int off, int len) {
        char[] result = new char[len];
        int i = len;
        while (i-- > 0) {
            result[i] = (char)(b[i + off] & 0xFF);
        }
        return result;
    }

    public final char getCharAt(int index) {
        if (index >= this.intLength) {
            throw new StringIndexOutOfBoundsException(index);
        }
        return (char)(this.bytValue[index] & 0xFF);
    }

    public final int getCharCount(byte ch, int off, int len) {
        if (this.intLength == 0) {
            return 0;
        }
        byte[] value = this.bytValue;
        int count = 0;
        int i = this.intLength;
        while (i-- > 0) {
            if (value[i] != ch) continue;
            ++count;
        }
        return count;
    }

    public final int getIndexOf(byte ch) {
        return this.getIndexOf(ch, 0);
    }

    public final int getIndexOf(byte ch, int n) {
        int fromIndex;
        int max = this.intLength;
        byte[] v = this.bytValue;
        if (n < 0) {
            fromIndex = 0;
        } else if (fromIndex >= this.intLength) {
            return -1;
        }
        int i = fromIndex;
        while (i < max) {
            if (v[i] == ch) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public final int getIndexOf(ByteString str) {
        return this.getIndexOf(str, 0);
    }

    public final int getIndexOf(ByteString str, int from) {
        return this.getIndexOf(str.bytValue, 0, str.intLength, from);
    }

    public final int getIndexOf(String str) {
        return this.getIndexOf(str, 0);
    }

    public final int getIndexOf(String str, int from) {
        return this.getIndexOf(ByteString.getASCII(str), 0, str.length(), from);
    }

    private final int getIndexOf(byte[] comp, int off, int len, int n) {
        int fromIndex;
        byte[] charsThis = this.bytValue;
        int lenThis = this.intLength;
        int lastIndexToCompare = lenThis - len;
        if (n >= lenThis) {
            return -1;
        }
        if (n < 0) {
            fromIndex = 0;
        }
        if (len == 0) {
            return fromIndex;
        }
        byte first = comp[off];
        block0: while (true) {
            if (fromIndex <= lastIndexToCompare && charsThis[fromIndex] != first) {
                ++fromIndex;
                continue;
            }
            if (fromIndex > lastIndexToCompare) {
                return -1;
            }
            int innerIndex = fromIndex + 1;
            int end = innerIndex + len - 1;
            int compIndex = off + 1;
            while (innerIndex < end) {
                if (charsThis[innerIndex++] == comp[compIndex++]) continue;
                ++fromIndex;
                continue block0;
            }
            break;
        }
        return fromIndex;
    }

    public final int getIndexOfIgnoreCase(ByteString str) {
        return this.getIndexOfIgnoreCase(str.bytValue, 0, str.intLength, 0);
    }

    public final int getIndexOfIgnoreCase(ByteString str, int fromIndex) {
        return this.getIndexOfIgnoreCase(str.bytValue, 0, str.intLength, fromIndex);
    }

    public final int getIndexOfIgnoreCase(String str) {
        return this.getIndexOfIgnoreCase(str, 0);
    }

    public final int getIndexOfIgnoreCase(String str, int fromIndex) {
        int len = str.length();
        return this.getIndexOfIgnoreCase(ByteString.getASCII(str), 0, len, fromIndex);
    }

    private final int getIndexOfIgnoreCase(byte[] comp, int off, int len, int n) {
        int fromIndex;
        byte[] charsThis = this.bytValue;
        int lenThis = this.intLength;
        int lastIndexToCompare = lenThis - len;
        if (n >= lenThis) {
            return -1;
        }
        if (n < 0) {
            fromIndex = 0;
        }
        if (len == 0) {
            return fromIndex;
        }
        byte first = comp[off];
        byte firstUpper = (byte)(first & 0xFFFFFFDF);
        byte firstLower = (byte)(first | 0x20);
        block0: while (true) {
            if (fromIndex <= lastIndexToCompare) {
                byte loop = charsThis[fromIndex];
                if (loop != first && (loop & 0xFFFFFFDF) != firstUpper && (loop | 0x20) != firstLower) {
                    ++fromIndex;
                    continue;
                }
            }
            if (fromIndex > lastIndexToCompare) {
                return -1;
            }
            int innerIndex = fromIndex + 1;
            int end = innerIndex + len - 1;
            int compIndex = off + 1;
            while (innerIndex < end) {
                byte loop;
                byte c = charsThis[innerIndex++];
                byte cUpper = (byte)(c & 0xFFFFFFDF);
                byte cLower = (byte)(c | 0x20);
                if ((loop = comp[compIndex++]) == c || cUpper == (loop & 0xFFFFFFDF) || cLower == (loop | 0x20)) continue;
                ++fromIndex;
                continue block0;
            }
            break;
        }
        return fromIndex;
    }

    public final byte[] getInternalByteArray() {
        return this.bytValue;
    }

    public final int getLastIndexOf(byte ch) {
        return this.getLastIndexOf(ch, this.intLength - 1);
    }

    public final int getLastIndexOf(byte ch, int fromIndex) {
        byte[] v = this.bytValue;
        int i = fromIndex >= this.intLength ? this.intLength - 1 : fromIndex;
        while (i >= 0) {
            if (v[i] == ch) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public final int getLastIndexOf(ByteString str) {
        return this.getLastIndexOf(str, 0);
    }

    public final int getLastIndexOf(ByteString str, int fromIndex) {
        return this.getLastIndexOf(str.bytValue, 0, str.intLength, fromIndex);
    }

    public final int getLastIndexOf(String str) {
        str.length();
        return this.getLastIndexOf(str, this.intLength - 1);
    }

    public final int getLastIndexOf(String str, int fromIndex) {
        int len = str.length();
        return this.getLastIndexOf(ByteString.getASCII(str), 0, len, fromIndex);
    }

    private final int getLastIndexOf(byte[] chars, int off, int len, int n) {
        int start;
        int fromIndex;
        if (n < 0) {
            return -1;
        }
        int t = this.intLength - len;
        if (n > t) {
            fromIndex = t;
        }
        if (len == 0) {
            return fromIndex;
        }
        byte[] val = this.bytValue;
        int strLastIndex = off + len - 1;
        byte strLastChar = chars[strLastIndex];
        int lastCharPos = len - 1;
        int lastCharIndex = lastCharPos + fromIndex;
        block0: while (true) {
            if (lastCharIndex >= lastCharPos && val[lastCharIndex] != strLastChar) {
                --lastCharIndex;
                continue;
            }
            if (lastCharIndex < lastCharPos) {
                return -1;
            }
            int thisIndex = lastCharIndex - 1;
            start = thisIndex - (len - 1);
            int paramIndex = strLastIndex - 1;
            while (thisIndex > start) {
                if (val[thisIndex--] == chars[paramIndex--]) continue;
                --lastCharIndex;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public final int getLastIndexOfIgnoreCase(ByteString str) {
        return this.getLastIndexOfIgnoreCase(str, 0);
    }

    public final int getLastIndexOfIgnoreCase(ByteString str, int fromIndex) {
        return this.getLastIndexOfIgnoreCase(str.bytValue, 0, str.intLength, fromIndex);
    }

    public final int getLastIndexOfIgnoreCase(String str) {
        str.length();
        return this.getLastIndexOfIgnoreCase(str, this.intLength - 1);
    }

    public final int getLastIndexOfIgnoreCase(String str, int fromIndex) {
        int len = str.length();
        return this.getLastIndexOfIgnoreCase(ByteString.getASCII(str), 0, len, fromIndex);
    }

    private final int getLastIndexOfIgnoreCase(byte[] chars, int off, int len, int n) {
        int start;
        int fromIndex;
        if (n < 0) {
            return -1;
        }
        int t = this.intLength - len;
        if (n > t) {
            fromIndex = t;
        }
        if (len == 0) {
            return fromIndex;
        }
        byte[] val = this.bytValue;
        int lastIndex = off + len - 1;
        byte last = chars[lastIndex];
        byte lastUpper = (byte)(last & 0xFFFFFFDF);
        byte lastLower = (byte)(last | 0x20);
        int lastSearchPos = len - 1;
        int lastSearchIndex = lastSearchPos + fromIndex;
        block0: while (true) {
            if (lastSearchIndex >= lastSearchPos) {
                byte loop = val[lastSearchIndex];
                if (loop != last && (loop & 0xFFFFFFDF) != lastUpper && (loop | 0x20) != lastLower) {
                    --lastSearchIndex;
                    continue;
                }
            }
            if (lastSearchIndex < lastSearchPos) {
                return -1;
            }
            int thisIndex = lastSearchIndex - 1;
            start = thisIndex - (len - 1);
            int paramIndex = lastIndex - 1;
            while (thisIndex > start) {
                byte loop;
                byte c = val[thisIndex--];
                byte cUpper = (byte)(c & 0xFFFFFFDF);
                byte cLower = (byte)(c | 0x20);
                if ((loop = chars[paramIndex--]) == c || (loop & 0xFFFFFFDF) == cUpper || (loop | 0x20) == cLower) continue;
                --lastSearchIndex;
                continue block0;
            }
            break;
        }
        return start + 1;
    }

    public final int getLength() {
        return this.intLength;
    }

    public String getLineBreak() {
        return new String(this.bytLineBreak);
    }

    public final int getLineCount() {
        if (this.intLength == 0) {
            return 0;
        }
        byte lb = this.bytLineBreak[0];
        int count = this.getCharCount(lb, 0, this.intLength - 1);
        int lbLen = this.bytLineBreak.length;
        if (this.bytValue[this.intLength - lbLen] != lb) {
            ++count;
        }
        return count;
    }

    public final ByteString getLineHardBreak(int offset) {
        if (offset < 0 || offset > this.intLength) {
            throw new StringIndexOutOfBoundsException("offset: " + offset);
        }
        byte[] source = this.bytValue;
        int len = this.intLength;
        int lineEnd = this.getIndexOf(this.bytLineBreak[0], offset);
        if (lineEnd == -1) {
            lineEnd = len;
        }
        int lineLength = lineEnd - offset;
        this.intNextLineStart = offset + lineLength + this.bytLineBreak.length;
        return new ByteString(source, offset, lineLength);
    }

    public final Enumeration getLineHardBreakEnumeration() {
        return new LineEnumeration(this);
    }

    public final int getNextLineStart() {
        return this.intNextLineStart;
    }

    public static final String getString(byte[] b) {
        return ByteString.getString(b, 0, b.length);
    }

    public static final String getString(byte[] b, int off, int len) {
        char[] result = new char[len];
        int i = len;
        while (i-- > 0) {
            result[i] = (char)(b[i + off] & 0xFF);
        }
        return new String(result);
    }

    public final ByteString getSubstring(int begin) {
        return this.getSubstring(begin, this.intLength);
    }

    public final ByteString getSubstring(int n, int n2) {
        int begin;
        int end;
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        if (n2 > this.intLength) {
            end = this.intLength;
        }
        if (n > this.intLength) {
            begin = this.intLength;
        }
        return new ByteString(this.bytValue, begin, end - begin);
    }

    public final int hashCode() {
        int h = 0;
        int off = 0;
        byte[] val = this.bytValue;
        int len = this.intLength;
        if (len < 16) {
            int i = len;
            while (i > 0) {
                h = h * 37 + val[off++];
                --i;
            }
        } else {
            int skip = len / 8;
            int i = len;
            while (i > 0) {
                h = h * 39 + val[off];
                i -= skip;
                off += skip;
            }
        }
        return h;
    }

    public void init(int size) {
        if (this.bytValue == null) {
            this.bytValue = new byte[size + 16];
        } else {
            this.ensureCapacity(size);
        }
    }

    public final ByteString insert(int offset, byte c) {
        int newcount = this.intLength + 1;
        if (newcount > this.bytValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(this.bytValue, offset, this.bytValue, offset + 1, this.intLength - offset);
        this.bytValue[offset] = c;
        this.intLength = newcount;
        return this;
    }

    public final ByteString insert(int offset, char c) {
        int newcount = this.intLength + 1;
        if (newcount > this.bytValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(this.bytValue, offset, this.bytValue, offset + 1, this.intLength - offset);
        this.bytValue[offset] = (byte)c;
        this.intLength = newcount;
        return this;
    }

    public final ByteString insert(int offset, double d) {
        return this.insert(offset, String.valueOf(d));
    }

    public final ByteString insert(int offset, float f) {
        return this.insert(offset, String.valueOf(f));
    }

    public final ByteString insert(int offset, int n) {
        int i;
        if (n == Integer.MIN_VALUE) {
            return this.insert(offset, INTEGER_MIN, 0, INTEGER_MIN.length);
        }
        byte[] buf = new byte[12];
        boolean negative = n < 0;
        int charPos = 12;
        if (negative) {
            i = -n;
        }
        if (i < 10 && !negative) {
            return this.insert(offset, (byte)(i + 48));
        }
        do {
            int digit = i % 100;
            buf[--charPos] = UNITS[digit];
            buf[--charPos] = TENTH_UNITS[digit];
        } while ((i /= 100) != 0);
        if (buf[charPos] == 48) {
            ++charPos;
        }
        if (negative) {
            buf[--charPos] = 45;
        }
        return this.insert(offset, buf, charPos, 12 - charPos);
    }

    public final ByteString insert(int offset, long l) {
        long l2;
        if (l == Long.MIN_VALUE) {
            return this.insert(offset, LONG_MIN, 0, LONG_MIN.length);
        }
        byte[] buf = new byte[20];
        boolean negative = l < 0L;
        int charPos = 20;
        if (negative) {
            l2 = -l;
        }
        if (l2 < 10L && !negative) {
            return this.insert(offset, (byte)(l2 + 48L));
        }
        do {
            int digit = (int)(l2 % 100L);
            buf[--charPos] = UNITS[digit];
            buf[--charPos] = TENTH_UNITS[digit];
        } while ((l2 /= 100L) != 0L);
        if (buf[charPos] == 48) {
            ++charPos;
        }
        if (negative) {
            buf[--charPos] = 45;
        }
        return this.insert(offset, buf, charPos, 20 - charPos);
    }

    public final ByteString insert(int offset, Object obj) {
        return this.insert(offset, String.valueOf(obj));
    }

    public final ByteString insert(int offset, String str) {
        int len = str.length();
        int newcount = this.intLength + len;
        if (newcount > this.bytValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(this.bytValue, offset, this.bytValue, offset + len, this.intLength - offset);
        System.arraycopy(ByteString.getASCII(str), 0, this.bytValue, offset, len);
        this.intLength = newcount;
        return this;
    }

    public final ByteString insert(int offset, boolean b) {
        return this.insert(offset, String.valueOf(b));
    }

    public final ByteString insert(int start, byte[] str, int off, int len) {
        int newcount = this.intLength + len;
        if (newcount > this.bytValue.length) {
            this.ensureCapacity(newcount);
        }
        System.arraycopy(this.bytValue, start, this.bytValue, start + len, this.intLength - start);
        System.arraycopy(str, off, this.bytValue, start, len);
        this.intLength = newcount;
        return this;
    }

    public final ByteString insert(int offset, char[] str) {
        return this.insert(offset, str, 0, str.length);
    }

    public final ByteString insert(int start, char[] str, int off, int len) {
        return this.insert(start, ByteString.getASCII(str), off, len);
    }

    public final boolean isEmpty() {
        return this.intLength == 0;
    }

    public final boolean isMatchingRegion(ByteString str, int start, boolean ignoreCase) {
        return this.isMatchingRegion(str.bytValue, 0, str.intLength, start, ignoreCase);
    }

    public final boolean isMatchingRegion(String str, int start, boolean ignoreCase) {
        return this.isMatchingRegion(ByteString.getASCII(str), 0, str.length(), start, ignoreCase);
    }

    private final boolean isMatchingRegion(byte[] chars, int off, int len, int start, boolean ignoreCase) {
        if (off < 0 || off > chars.length || len < 0 || len + off > chars.length || start > this.intLength) {
            throw new IllegalArgumentException();
        }
        if (this.intLength - start < len) {
            return false;
        }
        byte[] thisChars = this.bytValue;
        int indexThis = start;
        int indexThat = off;
        while (len-- != 0) {
            byte cthat;
            byte cthis;
            if ((cthis = thisChars[indexThis++]) == (cthat = chars[indexThat++]) || ignoreCase && (cthis & 0xFFFFFFDF) == (cthat & 0xFFFFFFDF)) continue;
            return false;
        }
        return true;
    }

    public final ByteString overwrite(byte ch, int n, int n2) {
        int end;
        int start;
        if (n < 0) {
            start = 0;
        }
        if (n2 < 0) {
            return this;
        }
        if (start >= this.intLength) {
            return this;
        }
        if (n2 >= this.intLength) {
            end = this.intLength - 1;
        }
        byte[] chars = this.bytValue;
        int i = start;
        while (i <= end) {
            chars[i] = ch;
            ++i;
        }
        return this;
    }

    public final ByteString overwrite(char ch, int start, int end) {
        return this.overwrite((byte)ch, start, end);
    }

    public long parseLong(int start, int end) throws NumberFormatException {
        return this.parseLong(start, end, 10);
    }

    private long parseLong(int start, int end, int radix) throws NumberFormatException {
        if (end <= start) {
            return 0L;
        }
        long result = 0L;
        boolean negative = false;
        boolean hexNegative = false;
        int i = start;
        int max = end - start;
        byte[] buffer = this.bytValue;
        if (max > 0) {
            int digit;
            long limit;
            if (buffer[i] == 45) {
                negative = true;
                limit = Long.MIN_VALUE;
                ++i;
            } else {
                limit = -9223372036854775807L;
            }
            if (radix == 16 && max == 16 && this.digit(buffer[i]) > 7) {
                negative = true;
                hexNegative = true;
                limit = Long.MIN_VALUE;
            } else {
                limit = -9223372036854775807L;
            }
            long multmin = limit / (long)radix;
            if (i < end) {
                digit = this.digit(buffer[i++]);
                if (hexNegative) {
                    digit ^= 0xF;
                }
                if (digit < 0) {
                    throw new NumberFormatException(new String(buffer, start, end));
                }
                result = -digit;
            }
            while (i < end) {
                digit = this.digit(buffer[i++]);
                if (hexNegative) {
                    digit ^= 0xF;
                }
                if (digit < 0) {
                    return 0L;
                }
                if (result < multmin) {
                    return 0L;
                }
                if ((result *= (long)radix) < limit + (long)digit) {
                    return 0L;
                }
                result -= (long)digit;
            }
        } else {
            return 0L;
        }
        if (hexNegative) {
            --result;
        }
        if (negative) {
            if (i > 1) {
                return result;
            }
            return 0L;
        }
        return -result;
    }

    public final ByteString reduceSpaces() {
        int oldLen = this.intLength;
        int oldPointer = 0;
        int newPointer = 0;
        byte[] values = this.bytValue;
        boolean inWord = false;
        while (oldPointer < oldLen) {
            int ch;
            if ((ch = values[oldPointer++] & 0xFF) > 32) {
                values[newPointer++] = (byte)ch;
                inWord = true;
                continue;
            }
            if (!inWord) continue;
            values[newPointer++] = 32;
            inWord = false;
        }
        this.intLength = newPointer;
        return this;
    }

    public final ByteString reduceSpaces(boolean keepLineBreaks) {
        int oldLen = this.intLength;
        int oldPointer = 0;
        int newPointer = 0;
        byte[] values = this.bytValue;
        boolean inWord = false;
        while (oldPointer < oldLen) {
            int ch;
            if ((ch = values[oldPointer++] & 0xFF) > 32 || keepLineBreaks && (ch == 13 || ch == 10)) {
                values[newPointer++] = (byte)ch;
                if (ch == 13 || ch == 10) continue;
                inWord = true;
                continue;
            }
            if (!inWord) continue;
            values[newPointer++] = 32;
            inWord = false;
        }
        this.intLength = newPointer;
        return this;
    }

    public final ByteString replace(byte oldChar, byte newChar) {
        if (oldChar != newChar) {
            int len = this.intLength;
            byte[] val = this.bytValue;
            int i = len;
            while (i-- > 0) {
                if (val[i] != oldChar) continue;
                val[i] = newChar;
            }
        }
        return this;
    }

    public final ByteString replace(ByteString oldStr, ByteString newStr, boolean ignoreCase) {
        return this.replace(oldStr.bytValue, 0, oldStr.intLength, newStr.bytValue, 0, newStr.intLength, ignoreCase);
    }

    public final ByteString replace(String oldStr, String newStr, boolean ignoreCase) {
        int oldLen = oldStr.length();
        int newLen = newStr.length();
        return this.replace(ByteString.getASCII(oldStr), 0, oldLen, ByteString.getASCII(newStr), 0, newLen, ignoreCase);
    }

    private final ByteString replace(byte[] oldStr, int oldOff, int oldLen, byte[] newStr, int newOff, int newLen, boolean ignoreCase) {
        if (oldStr == null || newStr == null) {
            throw new NullPointerException();
        }
        if (oldOff < 0 || oldLen < 0 || newOff < 0 || newLen < 0 || oldOff + oldLen > oldStr.length || newOff + newLen > newStr.length) {
            throw new StringIndexOutOfBoundsException();
        }
        if (oldLen == 0) {
            return this;
        }
        int pos = 0;
        while ((pos = ignoreCase ? this.getIndexOfIgnoreCase(oldStr, oldOff, oldLen, pos) : this.getIndexOf(oldStr, oldOff, oldLen, pos)) != -1) {
            if (oldLen == newLen) {
                System.arraycopy(newStr, newOff, this.bytValue, pos, newLen);
            } else if (oldLen > newLen) {
                if (newLen > 0) {
                    System.arraycopy(newStr, newOff, this.bytValue, pos, newLen);
                }
                this.delete(pos + newLen, oldLen - newLen);
            } else {
                System.arraycopy(newStr, newOff, this.bytValue, pos, oldLen);
                this.insert(pos + oldLen, newStr, newOff + oldLen, newLen - oldLen);
            }
            pos += newLen;
        }
        return this;
    }

    public final ByteString reverse() {
        int lastChar = this.intLength - 1;
        int i = lastChar - 1 >> 1;
        while (i >= 0) {
            byte temp = this.bytValue[i];
            this.bytValue[i] = this.bytValue[lastChar - i];
            this.bytValue[lastChar - i] = temp;
            --i;
        }
        return this;
    }

    public final void setByteArray(byte[] chars, int len) {
        if (chars == null) {
            throw new NullPointerException();
        }
        if (len > chars.length || len < 0) {
            throw new StringIndexOutOfBoundsException(len);
        }
        this.bytValue = chars;
        this.intLength = len;
    }

    public final void setCharAt(int index, byte ch) {
        if (index < 0 || index >= this.intLength) {
            throw new StringIndexOutOfBoundsException(index);
        }
        this.bytValue[index] = ch;
    }

    public final void setCharAt(int index, char ch) {
        this.setCharAt(index, (byte)ch);
    }

    public final void setLength(int newLength) {
        if (newLength < 0) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        if (newLength > this.bytValue.length) {
            this.ensureCapacity(newLength);
        }
        if (this.intLength < newLength) {
            while (this.intLength < newLength) {
                this.bytValue[this.intLength] = 0;
                ++this.intLength;
            }
        } else {
            this.intLength = newLength;
        }
    }

    public final void setLengthIndex(int newLength) {
        if (newLength < 0 || newLength > this.bytValue.length) {
            throw new StringIndexOutOfBoundsException(newLength);
        }
        this.intLength = newLength;
    }

    public void setLineBreak(String lb) {
        this.bytLineBreak = lb.getBytes();
    }

    public final void setNextLineStart(int lineNo) {
        this.intNextLineStart = lineNo;
    }

    public final boolean startsWith(String str) {
        int len = str.length();
        if (this.intLength < len) {
            return false;
        }
        return this.isMatchingRegion(ByteString.getASCII(str), 0, len, 0, false);
    }

    public final ByteString stripSpaces() {
        int oldLen = this.intLength;
        int oldPointer = 0;
        int newPointer = 0;
        byte[] values = this.bytValue;
        while (oldPointer < oldLen) {
            byte ch;
            if (((ch = values[oldPointer++]) & 0xFF) <= 32) continue;
            values[newPointer++] = ch;
        }
        this.intLength = newPointer;
        return this;
    }

    public final byte[] toByteArray() {
        return this.toByteArray(0, this.intLength);
    }

    public final byte[] toByteArray(int n, int n2) {
        int len;
        int off;
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            off = this.intLength;
        }
        if (off + n2 > this.intLength) {
            len = this.intLength - off;
        }
        byte[] result = new byte[len];
        System.arraycopy(this.bytValue, off, result, 0, len);
        return result;
    }

    public final char[] toCharArray() {
        return this.toCharArray(0, this.intLength);
    }

    public final char[] toCharArray(int n, int n2) {
        int len;
        int off;
        if (n < 0 || n2 < 0) {
            throw new StringIndexOutOfBoundsException(n + "," + n2);
        }
        if (n >= this.intLength) {
            off = this.intLength;
        }
        if (off + n2 > this.intLength) {
            len = this.intLength - off;
        }
        return ByteString.getCharArray(this.bytValue, off, len);
    }

    public String toString() {
        return ByteString.getString(this.bytValue, 0, this.intLength);
    }

    public final ByteString trim() {
        int len = this.intLength;
        int start = 0;
        byte[] val = this.bytValue;
        while (start < len && (val[start] & 0xFF) <= 32) {
            ++start;
        }
        while (start < len && (val[len - 1] & 0xFF) <= 32) {
            --len;
        }
        this.intLength = len - start;
        System.arraycopy(val, start, val, 0, this.intLength);
        return this;
    }

    public final ByteString trimLeft() {
        int len = this.intLength;
        int start = 0;
        byte[] val = this.bytValue;
        while (start < len && (val[start] & 0xFF) <= 32) {
            ++start;
        }
        this.intLength = len - start;
        System.arraycopy(val, start, val, 0, this.intLength);
        return this;
    }

    public final ByteString trimRight() {
        int len = this.intLength;
        byte[] val = this.bytValue;
        while (len > 0 && (val[len - 1] & 0xFF) < 33) {
            --len;
        }
        this.intLength = len;
        return this;
    }

    static int access$intNextLineStart(ByteString byteString) {
        return byteString.intNextLineStart;
    }

    static int access$intLength(ByteString byteString) {
        return byteString.intLength;
    }

    private class LineEnumeration
    implements Enumeration {
        /* synthetic */ ByteString this$0;
        private int intLineCounter = 0;
        private int intType = 0;
        private int intWidth = 0;
        private FontMetrics fmMetrics = null;

        LineEnumeration(ByteString this$0) {
            this.this$0 = this$0;
        }

        LineEnumeration(ByteString this$0, int width) {
            this.this$0 = this$0;
            this.intType = 1;
            this.intWidth = width;
        }

        LineEnumeration(ByteString this$0, int width, FontMetrics fm, boolean skipSpaces) {
            this.this$0 = this$0;
            this.intType = skipSpaces ? 2 : 3;
            this.intWidth = width;
            this.fmMetrics = fm;
        }

        public Object nextElement() {
            ByteString line;
            switch (this.intType) {
                case 0: {
                    line = this.this$0.getLineHardBreak(this.intLineCounter);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    line = new ByteString();
                }
            }
            this.intLineCounter = ByteString.access$intNextLineStart(this.this$0);
            return line;
        }

        public boolean hasMoreElements() {
            return this.intLineCounter < ByteString.access$intLength(this.this$0);
        }
    }
}

