/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.mods;

import de.zwanzigeins.io.CRLFInputStream;
import de.zwanzigeins.util.ByteString;
import de.zwanzigeins.util.ByteTokenizer;
import de.zwanzigeins.util.HelperPath;
import de.zwanzigeins.util.LockObject;
import de.zwanzigeins.util.LogContext;
import de.zwanzigeins.util.StrTool;
import de.zwanzigeins.util.TimeFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import net.zerotoaster.httpd.config.Configuration;
import net.zerotoaster.httpd.mods.IntermediateModuleData;
import net.zerotoaster.httpd.mods.Mod_CGI;
import net.zerotoaster.httpd.request.Http_Request;
import net.zerotoaster.httpd.response.Http_Response;
import net.zerotoaster.httpd.util.Helper;

public class Mod_LRWP
extends Mod_CGI
implements Runnable {
    private static final int HEADERSIZE = 9;
    private static final byte DELIMITER = -1;
    private static Vector vecLRWPClients = null;
    private static Thread thrd = null;
    private static ServerSocket ssok = null;
    private static boolean blnIsRunning = false;
    private static long lngBusyTimeout = -1L;
    private LRWP_Client lrwpCl = null;

    public Mod_LRWP(Configuration cnfConfig, LogContext logContext) {
        super(cnfConfig, logContext);
        this.init();
    }

    private void close_clients() {
        if (vecLRWPClients == null) {
            return;
        }
        int i = 0;
        while (i < vecLRWPClients.size()) {
            LRWP_Client lrwpCl = (LRWP_Client)vecLRWPClients.elementAt(i);
            Helper.close(lrwpCl.isClient);
            Helper.close(lrwpCl.osClient);
            Helper.close(lrwpCl.sokClient);
            vecLRWPClients.setElementAt(null, i);
            ++i;
        }
        vecLRWPClients = null;
    }

    public static void disposeLRWP() {
        blnIsRunning = false;
        Helper.close(ssok);
    }

    private void init() {
        if (!this.cnfConfig.blnLRWP_allowed) {
            blnIsRunning = false;
            Helper.close(ssok);
            ssok = null;
            this.close_clients();
            return;
        }
        if (ssok == null) {
            this.logContext.write("C Opening LRWP Server Socket on " + this.cnfConfig.strLRWP_listen_ip + ":" + this.cnfConfig.intLRWP_listen_port);
            try {
                InetAddress ina = null;
                if (!this.cnfConfig.strLRWP_listen_ip.equals("*")) {
                    ina = InetAddress.getByName(this.cnfConfig.strLRWP_listen_ip);
                }
                ssok = new ServerSocket(this.cnfConfig.intLRWP_listen_port, 10, ina);
                this.logContext.write("D LRWP Server Socket opened (" + ssok.getInetAddress() + ")");
            }
            catch (Throwable t) {
                this.logContext.write("? Error creating LRWP server socket, service is disabled now", t);
                this.cnfConfig.blnLRWP_allowed = false;
                return;
            }
        }
        if (thrd == null) {
            this.logContext.write("C Create LRWP dispatcher thread");
            thrd = new Thread((Runnable)this, "LRWP");
            thrd.setDaemon(true);
            thrd.start();
        }
        this.close_clients();
        vecLRWPClients = new Vector();
    }

    private void login(LRWP_Client lrwpCl) throws IOException {
        byte[] buf = new byte[255];
        lrwpCl.isClient.read(buf);
        ByteTokenizer bytt = new ByteTokenizer(buf, -1);
        if (buf[0] == -1) {
            this.login_2x(lrwpCl, bytt);
        } else {
            this.login_1x(lrwpCl, bytt);
        }
    }

    private void login_1x(LRWP_Client lrwpCl, ByteTokenizer bytt) throws IOException {
        lrwpCl.intVersionMajor = 1;
        lrwpCl.intVersionMinor = 0;
        this.logContext.write("# Incoming LRWP/1.0 connection");
        if (!bytt.hasMoreTokens()) {
            this.login_response(lrwpCl, "Missing application name");
            return;
        }
        lrwpCl.strApplication = bytt.nextToken().trim().toLowerCase();
        lrwpCl.strApplication = HelperPath.pathFixup((String)lrwpCl.strApplication, (String)"/");
        if (!lrwpCl.strApplication.startsWith("/")) {
            lrwpCl.strApplication = "/" + lrwpCl.strApplication;
        }
        if (!bytt.hasMoreTokens()) {
            this.login_response(lrwpCl, "No virtual hostname was sent");
            return;
        }
        lrwpCl.strVirtualHost = bytt.nextToken().trim().toLowerCase();
        this.login_response(lrwpCl, "OK");
        this.logContext.write("# Client " + lrwpCl.toString() + " connected");
        Vector vector = vecLRWPClients;
        synchronized (vector) {
            vecLRWPClients.addElement(lrwpCl);
        }
    }

    private void login_2x(LRWP_Client lrwpCl, ByteTokenizer bytt) throws IOException {
        lrwpCl.intVersionMajor = 2;
        lrwpCl.intVersionMinor = 0;
        this.logContext.write("# Incoming LRWP/2.0 connection");
        bytt.nextToken();
        if (!bytt.hasMoreTokens()) {
            this.login_response(lrwpCl, "REJECTED No version string was sent");
            return;
        }
        String strVersion = bytt.nextToken().trim();
        StringTokenizer strt = new StringTokenizer(strVersion, ".");
        try {
            lrwpCl.intVersionMajor = Integer.parseInt(strt.nextToken());
            lrwpCl.intVersionMinor = Integer.parseInt(strt.nextToken());
        }
        catch (Throwable throwable) {
            this.login_response(lrwpCl, "REJECTED Malformed version string: '" + strVersion + "'");
            return;
        }
        if (!bytt.hasMoreTokens()) {
            this.login_response(lrwpCl, "REJECTED No alias/appname was sent");
            return;
        }
        lrwpCl.strApplication = bytt.nextToken().trim().toLowerCase();
        lrwpCl.strApplication = HelperPath.pathFixup((String)lrwpCl.strApplication, (String)"/");
        if (!lrwpCl.strApplication.startsWith("/")) {
            lrwpCl.strApplication = "/" + lrwpCl.strApplication;
        }
        if (!bytt.hasMoreTokens()) {
            this.login_response(lrwpCl, "REJECTED No virtual hostname was sent");
            return;
        }
        lrwpCl.strVirtualHost = bytt.nextToken().trim().toLowerCase();
        this.login_response(lrwpCl, "OK");
        this.logContext.write("# Client " + lrwpCl.toString() + " connected");
        Vector vector = vecLRWPClients;
        synchronized (vector) {
            vecLRWPClients.addElement(lrwpCl);
        }
    }

    private void login_response(LRWP_Client lrwpCl, String strMsg) throws IOException {
        if (!strMsg.startsWith("OK")) {
            this.logContext.write("? " + strMsg);
        }
        ByteString bytt = new ByteString(strMsg);
        if (lrwpCl.intVersionMajor == 2) {
            bytt.append((byte)-1);
        }
        lrwpCl.osClient.write(bytt.toByteArray());
        lrwpCl.osClient.flush();
    }

    public boolean processREQ(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        this.lrwpCl = null;
        if (!this.cnfConfig.blnLRWP_allowed || vecLRWPClients.size() == 0) {
            return false;
        }
        this.validateLRWPClients();
        int ww = 0;
        while (ww < 20) {
            boolean blnInstanceFound = false;
            Vector vector = vecLRWPClients;
            synchronized (vector) {
                int i = 0;
                while (i < vecLRWPClients.size()) {
                    LRWP_Client lrwpClTmp = (LRWP_Client)vecLRWPClients.elementAt(i);
                    if ((lrwpClTmp.strVirtualHost.length() == 0 || httpREQ.strVHost.equals(lrwpClTmp.strVirtualHost)) && Mod_CGI.url_match(httpREQ.strURL, lrwpClTmp.strApplication)) {
                        blnInstanceFound = true;
                        if (lrwpClTmp.lngBusyTimeStamp == 0L) {
                            this.lrwpCl = lrwpClTmp;
                            break;
                        }
                    }
                    ++i;
                }
                if (this.lrwpCl != null) {
                    this.lrwpCl.lngBusyTimeStamp = TimeFactory.getTime();
                    break;
                }
            }
            if (!blnInstanceFound) {
                return false;
            }
            this.logContext.write("! LRWP wait #" + String.valueOf(ww + 1) + " for free client instance on URL " + httpREQ.strURL);
            LockObject loWait = new LockObject();
            loWait.lo_wait(100L);
            loWait.dispose();
            ++ww;
        }
        if (this.lrwpCl == null) {
            this.logContext.write("! Didn't found a free LRWP peer for " + httpREQ.strURL);
            httpRES.intStatusCode = 408;
            return true;
        }
        imd.strCgiScript = httpREQ.strURL;
        ByteString bsSend = new ByteString();
        Hashtable hshEnv = this.createEnvironment(httpREQ, imd, httpRES);
        Enumeration e = hshEnv.keys();
        while (e.hasMoreElements()) {
            String strKey = (String)e.nextElement();
            bsSend.append(strKey);
            bsSend.append("=");
            bsSend.append((String)hshEnv.get(strKey));
            bsSend.append(new byte[]{0});
        }
        bsSend.insert(0, StrTool.rset((int)bsSend.getLength(), (int)9, (char)'0'));
        if (httpREQ.strAction.equalsIgnoreCase("POST")) {
            try {
                long lngPostLen = httpREQ.lngContentLength;
                ByteString bsPOST = new ByteString((int)lngPostLen);
                byte[] buf = new byte[Math.min(this.cnfConfig.intStreamBufferSize, (int)lngPostLen)];
                int i = 0;
                while (lngPostLen > 0L) {
                    i = lngPostLen >= (long)buf.length ? httpREQ.crlfisRequest.read(buf, 0, buf.length) : httpREQ.crlfisRequest.read(buf, 0, (int)lngPostLen);
                    if (i == -1) break;
                    bsPOST.append(buf, 0, i);
                    lngPostLen -= (long)i;
                }
                bsSend.append(StrTool.rset((int)bsPOST.getLength(), (int)9, (char)'0'));
                bsSend.append(bsPOST);
            }
            catch (IOException iOException) {
                this.lrwpCl.lngBusyTimeStamp = 0L;
                this.logContext.write("? Failed to retrieve POST data");
                return false;
            }
        } else {
            bsSend.append(StrTool.rset((int)0, (int)9, (char)'0'));
        }
        try {
            this.lrwpCl.osClient.write(bsSend.toByteArray());
            this.lrwpCl.osClient.flush();
        }
        catch (IOException e2) {
            this.logContext.write("? Client " + this.lrwpCl.toString() + ": " + e2.toString());
            Helper.close(this.lrwpCl.sokClient);
            Vector vector = vecLRWPClients;
            synchronized (vector) {
                vecLRWPClients.removeElement(this.lrwpCl);
            }
            return false;
        }
        this.blnIsRequestForUs = true;
        return true;
    }

    public boolean processRES(Http_Request httpREQ, IntermediateModuleData imd, Http_Response httpRES) {
        if (!this.blnIsRequestForUs) {
            return false;
        }
        byte[] buffer = new byte[9];
        try {
            int i = this.lrwpCl.isClient.read(buffer);
            if (i != 9) {
                this.logContext.write("? " + this.lrwpCl.toString() + " returned invalid headersize [" + i + "]");
                return true;
            }
        }
        catch (IOException e) {
            this.logContext.write("? " + this.lrwpCl.toString() + " error while reading header from client: " + e.toString());
            return true;
        }
        int intDataLength = 0;
        int i = 0;
        while (i < 9) {
            intDataLength *= 10;
            intDataLength += buffer[i] - 48;
            ++i;
        }
        this.logContext.write("C Expecting " + String.valueOf(intDataLength) + " bytes from LRWP client");
        this.lrwpCl.isClient.resetBytesRead();
        try {
            this.handleStreamResponse(this.lrwpCl.isClient, intDataLength, httpREQ, imd, httpRES);
            this.lrwpCl.osClient.flush();
            this.lrwpCl.lngBusyTimeStamp = 0L;
            return true;
        }
        catch (IOException iOException) {
            this.lrwpCl.lngBusyTimeStamp = 0L;
            this.logContext.write("? Failed to retrieve response data");
            return false;
        }
    }

    public void run() {
        blnIsRunning = true;
        this.logContext.write("# Ready for clients on " + ssok.getInetAddress().toString());
        while (blnIsRunning) {
            Socket sok = null;
            try {
                sok = ssok.accept();
                sok.setTcpNoDelay(true);
                sok.setSoTimeout(0);
            }
            catch (IOException e) {
                if (!blnIsRunning) {
                    this.logContext.write("# Shut down");
                } else {
                    this.logContext.write("? Error socket#accept: " + e.toString());
                }
                Helper.close(ssok);
                ssok = null;
                this.close_clients();
                break;
            }
            LRWP_Client lrwpCl = new LRWP_Client(this);
            try {
                lrwpCl.sokClient = sok;
                lrwpCl.isClient = new CRLFInputStream(sok.getInputStream());
                lrwpCl.osClient = sok.getOutputStream();
            }
            catch (IOException e) {
                this.logContext.write("? Error on getstreams: " + e.toString());
                Helper.close(sok);
                continue;
            }
            try {
                this.login(lrwpCl);
            }
            catch (IOException e) {
                this.logContext.write("? Cannot handle login: " + e.toString());
                Helper.close(sok);
            }
        }
    }

    private void validateLRWPClients() {
        long lngNow = TimeFactory.getTime();
        Vector vector = vecLRWPClients;
        synchronized (vector) {
            int i = 0;
            while (i < vecLRWPClients.size()) {
                LRWP_Client lrwpClTmp = (LRWP_Client)vecLRWPClients.elementAt(i);
                if (lrwpClTmp.lngBusyTimeStamp != 0L && lngNow - lrwpClTmp.lngBusyTimeStamp >= this.cnfConfig.lngLRWP_client_timeout) {
                    this.logContext.write("C Removed dead LRWP client " + lrwpClTmp.toString());
                    Helper.close(lrwpClTmp.sokClient);
                    vecLRWPClients.removeElementAt(i);
                    if (vecLRWPClients.size() == 0) break;
                    --i;
                    i = Math.min(0, i);
                }
                ++i;
            }
        }
    }

    class LRWP_Client {
        /* synthetic */ Mod_LRWP this$0;
        Socket sokClient = null;
        CRLFInputStream isClient = null;
        OutputStream osClient = null;
        int intVersionMajor = 0;
        int intVersionMinor = 0;
        String strApplication = null;
        String strVirtualHost = null;
        long lngBusyTimeStamp = 0L;

        public String toString() {
            return String.valueOf(this.strVirtualHost) + this.strApplication;
        }

        LRWP_Client(Mod_LRWP this$0) {
            this.this$0 = this$0;
        }
    }
}

