/*
 * Decompiled with CFR 0.152.
 */
package net.zerotoaster.httpd.util;

import de.zwanzigeins.util.LockObject;
import java.util.Enumeration;
import java.util.Hashtable;
import net.zerotoaster.httpd.util.AlarmCallback;
import net.zerotoaster.httpd.util.AlarmData;

public final class Alarm
implements Runnable {
    private static long lngResolution = 0L;
    private static Hashtable hshTimers = null;
    private static volatile boolean blnRunning = false;
    private static LockObject loNotify = new LockObject();
    private static Thread thrd = null;
    private static LockObject loThreadUp = new LockObject();

    public Alarm() {
        if (blnRunning) {
            thrd = new Thread((Runnable)this, "Alarm");
            thrd.setPriority(1);
            thrd.setDaemon(true);
            thrd.start();
        }
    }

    public static final void deregister(AlarmCallback ac) {
        if (hshTimers == null) {
            return;
        }
        hshTimers.remove(ac);
    }

    public static final void dispose() {
        blnRunning = false;
        if (loNotify != null) {
            loNotify.lo_notify();
            loNotify.dispose();
        }
        if (loThreadUp != null) {
            loThreadUp.dispose();
        }
    }

    public static final void register(AlarmCallback ac, long lngInterval, boolean blnOneShot) {
        if (lngInterval <= 0L) {
            return;
        }
        if (thrd == null) {
            blnRunning = true;
            lngResolution = 1000L;
            hshTimers = new Hashtable();
            new Alarm();
            loThreadUp.lo_wait();
        }
        AlarmData ad = new AlarmData();
        ad.lngInterval = lngInterval;
        ad.lngIntervalSaved = lngInterval;
        ad.blnOneShot = blnOneShot;
        ad.blnRemoved = false;
        hshTimers.put(ac, ad);
    }

    public static final void restart(AlarmCallback ac) {
        if (thrd == null || hshTimers == null) {
            return;
        }
        AlarmData ad = (AlarmData)hshTimers.get(ac);
        if (ad == null) {
            return;
        }
        ad.lngInterval = ad.lngIntervalSaved;
        ad.blnRemoved = false;
    }

    public void run() {
        loThreadUp.lo_notify();
        while (blnRunning) {
            loNotify.lo_wait(lngResolution);
            if (!blnRunning) break;
            Enumeration e = hshTimers.keys();
            while (e.hasMoreElements()) {
                AlarmCallback ac = (AlarmCallback)e.nextElement();
                AlarmData ad = (AlarmData)hshTimers.get(ac);
                if (ad.blnRemoved) {
                    hshTimers.remove(ac);
                    continue;
                }
                ad.lngInterval -= lngResolution;
                if (ad.lngInterval > 0L) continue;
                ac.alarmCallback();
                if (!ad.blnOneShot) {
                    ad.lngInterval = ad.lngIntervalSaved;
                    continue;
                }
                hshTimers.remove(ac);
            }
        }
        loNotify.dispose();
        loThreadUp.dispose();
    }

    public static final void setResolution(long lngRes) {
        lngResolution = lngRes;
    }
}

