/*
 * Decompiled with CFR 0.152.
 */
package simtools.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SocketHandler;

public class LogConfigurator {
    private static final String ROOT_LOGGER_PREFIX = "ROOT";
    Properties properties;
    protected String propertyPrefix;
    protected ArrayList outHandlerList = null;
    protected ArrayList levels = new ArrayList();
    protected ArrayList prefixes = new ArrayList();
    private static ArrayList configurators = new ArrayList();
    private static Object configuratorsLock = new Object();
    private static Level defaultLowestLevel = Level.SEVERE;
    protected Level lowestLevel = null;
    static /* synthetic */ Class class$java$util$logging$Formatter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogConfigurator(Properties properties, String string) {
        this.properties = properties;
        this.propertyPrefix = string;
        this.lowestLevel = defaultLowestLevel;
        this.configure();
        Object object = configuratorsLock;
        synchronized (object) {
            configurators.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Logger getLogger(String string) {
        Logger logger = Logger.getLogger(string);
        Object object = configuratorsLock;
        synchronized (object) {
            for (int i = 0; i < configurators.size(); ++i) {
                ((LogConfigurator)configurators.get(i)).apply(logger);
            }
        }
        return logger;
    }

    public void apply() {
        Object object;
        Object object2;
        LogManager logManager = LogManager.getLogManager();
        if (this.lowestLevel != null) {
            object2 = this.outHandlerList.iterator();
            while (object2.hasNext()) {
                object = (Handler)object2.next();
                ((Handler)object).setLevel(this.lowestLevel);
            }
        }
        object2 = logManager.getLoggerNames();
        while (object2.hasMoreElements()) {
            object = logManager.getLogger((String)object2.nextElement());
            this.apply((Logger)object);
        }
    }

    void apply(Logger logger) {
        for (int i = 0; i < this.prefixes.size(); ++i) {
            if (!logger.getName().startsWith((String)this.prefixes.get(i)) && (!logger.getName().equals("") || !this.prefixes.get(i).equals(ROOT_LOGGER_PREFIX))) continue;
            Iterator iterator = this.outHandlerList.iterator();
            while (iterator.hasNext()) {
                Handler handler = (Handler)iterator.next();
                logger.removeHandler(handler);
                logger.addHandler(handler);
            }
            logger.setUseParentHandlers(false);
            logger.setLevel((Level)this.levels.get(i));
        }
    }

    protected void configure() {
        Object object;
        Object object2;
        block18: {
            String string = this.getString("loggings.out", this.getDefaultFileHandlerPattern());
            this.outHandlerList = new ArrayList();
            try {
                int n = Integer.parseInt(string);
                object2 = this.getString("loggings.host", "localhost");
                try {
                    this.outHandlerList.add(new SocketHandler((String)object2, n));
                }
                catch (IOException iOException) {
                    System.err.println("Logging can not connect with " + (String)object2 + ":" + n);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (string.length() == 0) break block18;
                try {
                    this.outHandlerList.add(new FileHandler(string, 0, this.getInt("loggings.out.number", 1)));
                }
                catch (SecurityException securityException) {
                    System.err.println("Security prevents logging into files");
                }
                catch (IOException iOException) {
                    System.err.println("Can not log in " + string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Invalid paremeters to log in " + string);
                }
            }
        }
        if (this.outHandlerList.size() == 0) {
            this.outHandlerList.add(new ConsoleHandler());
        }
        String string = this.getString("loggings.format", "java.util.logging.XMLFormatter");
        object2 = null;
        try {
            object = Class.forName(string);
            if ((class$java$util$logging$Formatter == null ? (class$java$util$logging$Formatter = LogConfigurator.class$("java.util.logging.Formatter")) : class$java$util$logging$Formatter).isAssignableFrom((Class<?>)object)) {
                try {
                    object2 = (Formatter)((Class)object).newInstance();
                }
                catch (InstantiationException instantiationException) {
                    System.err.println("Can not instantiate logging format class : " + string);
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("Can not construct logging format class : " + string);
                }
            } else {
                System.err.println("Invalid logging format class : " + string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Unknown logging format class : " + string);
        }
        if (object2 != null) {
            object = this.outHandlerList.iterator();
            while (object.hasNext()) {
                Handler handler = (Handler)object.next();
                handler.setFormatter((Formatter)object2);
            }
        }
        this.configureLevels();
    }

    protected void configureLevels() {
        int n = this.getInt("loggings.number", 0);
        for (int i = 0; i < n; ++i) {
            String string = this.getString("loggings.logging" + i, "");
            try {
                int n2 = string.indexOf(32);
                if (n2 < 0) {
                    throw new IllegalArgumentException();
                }
                Level level = Level.parse(string.substring(0, n2));
                String string2 = string.substring(level.getName().length() + 1).trim();
                if (this.lowestLevel.intValue() > level.intValue()) {
                    this.lowestLevel = level;
                }
                this.levels.add(level);
                this.prefixes.add(string2);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                System.err.println("Invalid logging level in : " + string);
            }
        }
        if (this.prefixes.size() == 0) {
            this.prefixes.add(this.propertyPrefix);
            this.levels.add(defaultLowestLevel);
            this.prefixes.add(ROOT_LOGGER_PREFIX);
            this.levels.add(defaultLowestLevel);
        }
    }

    protected String getDefaultFileHandlerPattern() {
        return "%h" + this.propertyPrefix + ".log";
    }

    protected String getPropertyName(String string) {
        return this.propertyPrefix + "." + string;
    }

    protected String getString(String string, String string2) {
        return this.properties.getProperty(this.getPropertyName(string), string2);
    }

    protected int getInt(String string, int n) {
        String string2 = this.properties.getProperty(this.getPropertyName(string));
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.properties.getProperty(this.getPropertyName(string), bl ? "TRUE" : "FALSE");
        return string2.toUpperCase().equals("TRUE");
    }

    public static void setDefaultLowestLevel(Level level) {
        if (level != null) {
            defaultLowestLevel = level;
        }
    }

    public void addOutHandler(Handler handler) {
        if (this.outHandlerList != null && !this.outHandlerList.contains(handler)) {
            this.outHandlerList.add(handler);
        }
    }

    public boolean removeOutHandler(Handler handler) {
        boolean bl = false;
        if (this.outHandlerList != null) {
            bl = this.outHandlerList.remove(handler);
        }
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

